/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.utils.PluginUtils;
import com.ibm.wsspi.websvcs.Axis2ServiceConfigPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentException;

public class Axis2ServiceConfigPluginManager
implements Constants {
    private static final TraceComponent _tc = Tr.register(Axis2ServiceConfigPluginManager.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private List<Axis2ServiceConfigPlugin> implementationList = new ArrayList<Axis2ServiceConfigPlugin>();
    private boolean forServerSide = false;

    public void discoverAxis2ServiceConfigPlugins(boolean bl) {
        this.forServerSide = bl;
        PluginUtils.discoverExtensions(Axis2ServiceConfigPlugin.class.getName(), "com.ibm.wsfp.main.ibmaxis2-service-config-plugin", this.implementationList);
        if (!bl) {
            PluginUtils.discoverExtensions(Axis2ServiceConfigPlugin.class.getName(), "com.ibm.wsfp.thinclient.ibmaxis2-service-config-plugin", this.implementationList);
        }
    }

    public void runConfig(HashMap hashMap) throws DeploymentException {
        for (Axis2ServiceConfigPlugin axis2ServiceConfigPlugin : this.implementationList) {
            Object[] objectArray;
            try {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Running config plugin: " + axis2ServiceConfigPlugin);
                }
                axis2ServiceConfigPlugin.config(hashMap);
            }
            catch (DeploymentException deploymentException) {
                FFDCFilter.processException((Throwable)deploymentException, "com.ibm.ws.websvcs.deployment.Axis2ServiceConfigPluginManager.runConfig", "165", this);
                objectArray = new Object[]{axis2ServiceConfigPlugin.getClass().getName(), deploymentException};
                Tr.error(_tc, "runConfigPluginFail00", objectArray);
                throw deploymentException;
            }
            catch (AxisFault axisFault) {
                FFDCFilter.processException((Throwable)axisFault, "com.ibm.ws.websvcs.deployment.Axis2ServiceConfigPluginManager.runConfig", "171", this);
                objectArray = new Object[]{axis2ServiceConfigPlugin.getClass().getName(), axisFault};
                Tr.error(_tc, "runConfigPluginFail00", objectArray);
            }
        }
    }

    public boolean isServerSide() {
        return this.forServerSide;
    }
}

