/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.ws.metadata.ClassDataObject;
import com.ibm.ws.metadata.ClassDataObjectFields;
import com.ibm.ws.metadata.FileLocator;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.annotations.collector.WASAnnotationCollector;
import com.ibm.ws.websvcs.annotations.generator.WASAnnotationInputBuilder;
import com.ibm.ws.websvcs.deploy.CacheRootDirectoryTLS;
import com.ibm.ws.websvcs.deployment.ArchiveFileLocator;
import com.ibm.ws.websvcs.deployment.FileExplorerFactory;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.websvcs.utils.WSAnnotatedClassCacheBean;
import com.ibm.ws.websvcs.utils.WebServicesModuleCache;
import com.ibm.ws.websvcs.utils.WebServicesModuleCacheMgr;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSCacheWriter
implements Constants {
    private static final TraceComponent _tc = Tr.register(WSCacheWriter.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private EARFile earFile;
    private String appName;
    private String earLocation;
    private WebServicesModuleCache cache;
    private HashMap<String, ArchiveFileLocator> archiveFileLocatorMap;

    public WSCacheWriter(String string, String string2) throws Exception {
        this.earLocation = string;
        this.appName = string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeClassCache(boolean bl) throws Exception {
        ArrayList<String> arrayList;
        block25: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "writeClassCache");
            }
            Archive archive = null;
            arrayList = new ArrayList<String>();
            try {
                try {
                    CommonarchiveFactory commonarchiveFactory = (CommonarchiveFactory)EPackage.Registry.INSTANCE.getEPackage("http:///com/ibm/etools/commonarchive.ecore").getEFactoryInstance();
                    ArchiveOptions archiveOptions = new ArchiveOptions();
                    archiveOptions.setIsReadOnly(true);
                    archiveOptions.setUseJavaReflection(true);
                    archive = commonarchiveFactory.openEARFile(archiveOptions, this.earLocation);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Opened EARFile...");
                    }
                    List list = archive.getWARFiles();
                    list.addAll(archive.getEJBJarFiles());
                    String string = null;
                    if (CacheRootDirectoryTLS.get() != null) {
                        string = CacheRootDirectoryTLS.get();
                    }
                    for (ModuleFile moduleFile : list) {
                        Object object;
                        String string2 = "";
                        if (string != null) {
                            object = string + this.appName + File.separator + moduleFile.getName();
                            CacheRootDirectoryTLS.set((String)object);
                            arrayList.add(moduleFile.getName());
                        } else {
                            string2 = this.appName + File.separator + moduleFile.getName();
                        }
                        object = FileExplorerFactory.getFileExplorer(moduleFile);
                        List<FileLocator> list2 = object.explore();
                        this.buildMap(list2);
                        WASAnnotationCollector wASAnnotationCollector = new WASAnnotationCollector();
                        wASAnnotationCollector.setClassLoader(moduleFile.getArchiveClassLoader());
                        ArrayList<ClassDataObject> arrayList2 = wASAnnotationCollector.collect(list2);
                        String string3 = this.appName + File.separator + moduleFile.getName();
                        this.cache = WebServicesModuleCacheMgr.getModuleCache(string2);
                        if (!this.cache.exists()) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Creating web services cache at following location: " + string3);
                            }
                            if (bl) {
                                try {
                                    WASAnnotationInputBuilder wASAnnotationInputBuilder = new WASAnnotationInputBuilder(arrayList2, moduleFile.getArchiveClassLoader(), moduleFile);
                                    HashMap<String, DescriptionBuilderComposite> hashMap = wASAnnotationInputBuilder.buildInputs();
                                    DescriptionFactory.createServiceDescriptionFromDBCMap(hashMap);
                                }
                                catch (Throwable throwable) {
                                    Tr.info(_tc, "Cache not fully generated for " + moduleFile.getName() + " module");
                                }
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Attempting to cache file name list of size: " + arrayList2.size());
                            }
                            this.writeCache(arrayList2, moduleFile.getArchiveClassLoader());
                            continue;
                        }
                        if (!_tc.isDebugEnabled()) continue;
                        Tr.debug(_tc, "Web services cache already exists at the following location: " + string3);
                    }
                    Object var19_20 = null;
                    if (archive == null) break block25;
                }
                catch (Exception exception) {
                    Tr.info(_tc, "Cache could not be generated for " + archive.getName());
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                Object var19_21 = null;
                if (archive != null && archive.isOpen()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Closing EARFile");
                    }
                    archive.close();
                }
                if (!arrayList.isEmpty()) {
                    for (String string : arrayList) {
                        Axis2Utils.deleteExtractedApp(this.appName, string);
                    }
                }
                if (!_tc.isEntryEnabled()) throw throwable;
                Tr.exit(_tc, "writeClassCache");
                throw throwable;
            }
            if (archive.isOpen()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Closing EARFile");
                }
                archive.close();
            }
        }
        if (!arrayList.isEmpty()) {
            for (String string : arrayList) {
                Axis2Utils.deleteExtractedApp(this.appName, string);
            }
        }
        if (!_tc.isEntryEnabled()) return;
        Tr.exit(_tc, "writeClassCache");
    }

    private void buildMap(List<FileLocator> list) {
        if (!list.isEmpty()) {
            this.archiveFileLocatorMap = new HashMap();
            for (FileLocator fileLocator : list) {
                if (!(fileLocator instanceof ArchiveFileLocator)) continue;
                this.archiveFileLocatorMap.put(fileLocator.getName(), (ArchiveFileLocator)fileLocator);
            }
        }
    }

    private void writeCache(List<ClassDataObject> list, ClassLoader classLoader) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "writeCache");
        }
        List<WSAnnotatedClassCacheBean> list2 = this.cache.getAnnotatedClassList();
        for (ClassDataObject classDataObject : list) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Attempting to cache the following file name: " + (String)classDataObject.getEntry(ClassDataObjectFields.CLASS_NAME));
            }
            if (this.archiveFileLocatorMap == null) continue;
            ArchiveFileLocator archiveFileLocator = this.archiveFileLocatorMap.get((String)classDataObject.getEntry(ClassDataObjectFields.CLASS_NAME) + ".class");
            if (archiveFileLocator == null) {
                archiveFileLocator = this.archiveFileLocatorMap.get((String)classDataObject.getEntry(ClassDataObjectFields.SHORT_CLASS_NAME) + ".class");
            }
            WSAnnotatedClassCacheBean wSAnnotatedClassCacheBean = null;
            if (archiveFileLocator != null) {
                wSAnnotatedClassCacheBean = new WSAnnotatedClassCacheBean(archiveFileLocator.getName(), archiveFileLocator.getContainerPath());
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Adding class file to cached list: " + archiveFileLocator.getName() + " with container path: " + archiveFileLocator.getContainerPath());
                }
            } else {
                URL uRL = null;
                String string = (String)classDataObject.getEntry(ClassDataObjectFields.CLASS_NAME) + ".class";
                String string2 = null;
                try {
                    uRL = classLoader.getResource(string);
                    string2 = uRL.toString();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Adding out of module class file to cached list: " + string + " with container path: " + string2);
                }
                wSAnnotatedClassCacheBean = new WSAnnotatedClassCacheBean(string, string2);
            }
            list2.add(wSAnnotatedClassCacheBean);
        }
        this.cache.save();
    }
}

