/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.deploy.CacheDeployUtils;
import com.ibm.ws.websvcs.deploy.CacheRootDirectoryTLS;
import com.ibm.ws.websvcs.deploy.WSCacheWriter;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;

public class PersistentStorageInstallSaveTask
extends AbstractAppSyncTask
implements Constants {
    private static final TraceComponent tc = Tr.register(PersistentStorageInstallSaveTask.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public boolean performTask(AppData appData, AppData appData2, Hashtable hashtable) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        if (appData2.getEAR() != null && (appData2.getEAR().containsFile("META-INF/ibm-application-sa.props") || appData2.getEAR().containsFile("META-INF/ibm-application-sa2.props"))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not writing cache for applicaiton " + appData2.getAppName() + " because it is a system application");
            }
            return true;
        }
        WSCacheWriter wSCacheWriter = null;
        if (this.appIsDeployedOnNode(appData2.getAppName())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "App deployed on  node, using this EAR location: " + appData2.getBinURL());
            }
            wSCacheWriter = new WSCacheWriter(appData2.getBinURL(), appData2.getAppName());
        } else {
            String string = null;
            if (appData2.getEAR() != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting binaries path from ear file");
                }
                string = appData2.getEAR().getBinariesPath();
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting binaries path from app data");
                }
                string = appData2.getBinURL();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "App not deployed on  node, using this EAR location: " + string);
            }
            wSCacheWriter = new WSCacheWriter(string, appData2.getAppName());
        }
        try {
            if (this.appIsDeployedOnNode(appData2.getAppName())) {
                this.checkForAsyncRspApp(appData, appData2);
            }
            CacheRootDirectoryTLS.set(Axis2Utils.getCacheDirectory() + File.separator);
            wSCacheWriter.writeClassCache(true);
        }
        catch (Throwable throwable) {
            CacheDeployUtils.removeCacheDirectory(appData, appData2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask");
        }
        return true;
    }

    void checkForAsyncRspApp(AppData appData, AppData appData2) {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkForAsyncRspApp");
            }
            if (appData.getAppName().equals("ibmasyncrsp") && appData2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Old application data is from the ARS app");
                }
                String string = appData2.getBinURL();
                string = string.replace("\\", File.separator);
                string = string.replace("/", File.separator);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Parsed bin URL: " + string);
                }
                if (ASYNC_RSP_SYS_APP_PATH_EXTRACTED.equals(string) && !ASYNC_RSP_SYS_APP_PATH_EXTRACTED.equals(appData.getBinURL())) {
                    try {
                        File file = new File(appData.getBinURL());
                        if (!file.exists() || !file.isDirectory()) break block12;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found old binaries URL for ibmasyncrsp application: " + file.getAbsolutePath());
                        }
                        CacheDeployUtils.removeDirectory(file.listFiles());
                        boolean bl = file.delete();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Result of deleting old directory: " + String.valueOf(bl));
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        StringWriter stringWriter = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(stringWriter);
                        exception.printStackTrace(printWriter);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Could not delete old ibmasyncrsp application artifacts because of the following error\n: " + stringWriter.toString());
                        }
                        break block12;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The new binary URL: " + string + " did not match the extracted ARS location");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForAsyncRspApp");
        }
    }
}

