/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.models.config.host.HostAlias;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.admin.sysmgmt.SysMgmtHelper;
import com.ibm.ws.webservices.admin.sysmgmt.SysMgmtHelperFactory;
import com.ibm.ws.webservices.deploy.ModuleData;
import com.ibm.ws.webservices.deploy.WebserviceDescriptionInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JAXWSModuleDataImpl
implements ModuleData {
    private static TraceComponent tc = Tr.register(JAXWSModuleDataImpl.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private String name;
    private String node;
    private String host;
    private String defaultPrefix;
    private String virtualHostName;
    private String contextRoot;
    private String applicationName;
    private String defaultJMSPrefix;
    private boolean hasHTTPRouter = false;
    private boolean hasJMSRouter = false;
    private String defaultEJBPrefix;
    private HashMap<String, String> urlPrefixMap = new HashMap();
    private SysMgmtHelper smh = null;
    private File fileObj = null;
    private String dAppName = null;
    private List modulesWsdlFiles;
    private List modulesWsdlDefinitions;
    private String server;
    private List prefixList = new LinkedList();
    private Set virtualHostPorts = new HashSet();
    private boolean isWebModule;
    private List webservicesDescriptions = new ArrayList();

    public void setVirtualHost(VirtualHost virtualHost) {
        Object object;
        if (virtualHost != null) {
            this.virtualHostName = virtualHost.getName();
            object = virtualHost.getAliases();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object object2 = (HostAlias)iterator.next();
                this.virtualHostPorts.add(object2.getPort());
            }
        } else {
            this.virtualHostName = "";
        }
        if (tc.isDebugEnabled()) {
            object = "null";
            if (virtualHost != null) {
                object = virtualHost.getName();
            }
            Tr.debug(tc, "setVirtualHost: for module \"" + this.name + "\" the virtualHost is \"" + (String)object + "\" and its ports are:");
            for (Object object2 : this.virtualHostPorts) {
                Tr.debug(tc, (String)object2);
            }
            Tr.debug(tc, "\n");
        }
    }

    public boolean addPrefix(String string, String string2) {
        if (this.virtualHostPorts.contains(string2)) {
            return this.prefixList.add(new Prefix(string, this.host, string2));
        }
        return false;
    }

    public boolean addPrefix(String string, String string2, String string3) {
        return this.prefixList.add(new Prefix(string, string2, string3));
    }

    public List getPrefixList() {
        if (this.prefixList.size() == 0) {
            this.prefixList.add(new Prefix("", "", ""));
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator iterator = this.prefixList.iterator();
        while (iterator.hasNext()) {
            linkedList.add(((Prefix)iterator.next()).toString());
        }
        return linkedList;
    }

    public String getDefaultPrefix() {
        if (this.defaultPrefix == null) {
            this.defaultPrefix = "";
            if (this.prefixList != null) {
                for (Prefix prefix : this.prefixList) {
                    this.defaultPrefix = prefix.toString();
                    if (!prefix.protocol.equals("http")) continue;
                    break;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "default http prefix is: " + this.defaultPrefix);
        }
        return this.defaultPrefix;
    }

    public void setDefaultPrefix(String string) {
        this.defaultPrefix = string;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String string) {
        this.contextRoot = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String string) {
        this.node = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getVirtualHostName() {
        return this.virtualHostName;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String string) {
        this.server = string;
    }

    public void addWebservicesDescription(WebserviceDescriptionInfo webserviceDescriptionInfo) {
        this.webservicesDescriptions.add(webserviceDescriptionInfo);
    }

    public List getWebservicesDescritions() {
        return this.webservicesDescriptions;
    }

    public Map getMergedQNameToUrlPatternMap(String string) {
        HashMap hashMap = new HashMap();
        Map map = null;
        for (WebserviceDescriptionInfo webserviceDescriptionInfo : this.webservicesDescriptions) {
            Map map2 = webserviceDescriptionInfo.getQNameToUrlPatternMap();
            if (string != null && webserviceDescriptionInfo.getWebserviceDescriptionName().equals(string)) {
                map = map2;
            }
            hashMap.putAll(map2);
        }
        if (map != null) {
            hashMap.putAll(map);
        }
        return hashMap;
    }

    public Map getMergedQNameToPortComponentNameMap(String string) {
        HashMap hashMap = new HashMap();
        Map map = null;
        for (WebserviceDescriptionInfo webserviceDescriptionInfo : this.webservicesDescriptions) {
            Map map2 = webserviceDescriptionInfo.getQnameToPortComponentNameMap();
            if (string != null && webserviceDescriptionInfo.getWebserviceDescriptionName().equals(string)) {
                map = map2;
            }
            hashMap.putAll(map2);
        }
        if (map != null) {
            hashMap.putAll(map);
        }
        return hashMap;
    }

    public Map getMergedQNameToEJBUrlPrefixMap(String string) {
        HashMap hashMap = new HashMap();
        Map map = null;
        for (WebserviceDescriptionInfo webserviceDescriptionInfo : this.webservicesDescriptions) {
            Map map2 = webserviceDescriptionInfo.getQNameToEJBUrlPrefixMap();
            if (string != null && webserviceDescriptionInfo.getWebserviceDescriptionName().equals(string)) {
                map = map2;
            }
            hashMap.putAll(map2);
        }
        if (map != null) {
            hashMap.putAll(map);
        }
        return hashMap;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\n");
        stringBuffer.append(this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + "\n");
        stringBuffer.append("applicationName=").append(this.applicationName).append("\n");
        stringBuffer.append("name=").append(this.name).append("\n");
        stringBuffer.append("node=").append(this.node).append("\n");
        stringBuffer.append("host=").append(this.host).append("\n");
        stringBuffer.append("defaultPrefix=").append(this.defaultPrefix).append("\n");
        stringBuffer.append("virtuaHostName=").append(this.virtualHostName).append("\n");
        stringBuffer.append("server=").append(this.server).append("\n");
        stringBuffer.append("contextRoot=").append(this.contextRoot).append("\n");
        stringBuffer.append("prefixList contains:\n");
        Iterator iterator = this.prefixList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\t").append(iterator.next()).append("\n");
        }
        stringBuffer.append("webServicesDescriptions contains:\n");
        for (WebserviceDescriptionInfo webserviceDescriptionInfo : this.webservicesDescriptions) {
            stringBuffer.append(webserviceDescriptionInfo.toString());
        }
        stringBuffer.append("virtualHostPorts contains:\n");
        iterator = this.virtualHostPorts.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next()).append("\n");
        }
        stringBuffer.append("modulesWsdlFiles contains:\n");
        iterator = this.modulesWsdlFiles.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next()).append("\n");
        }
        return stringBuffer.toString();
    }

    public void setIsWebModule(boolean bl) {
        this.isWebModule = bl;
    }

    public boolean isWebModule() {
        return this.isWebModule;
    }

    public List getModulesWsdlFiles() {
        return this.modulesWsdlFiles;
    }

    public void setModulesWsdlFiles(List list) {
        this.modulesWsdlFiles = list;
    }

    public List getModulesWsdlDefinitions() {
        return this.modulesWsdlDefinitions;
    }

    public void setModulesWsdlDefinitions(List list) {
        this.modulesWsdlDefinitions = list;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String string) {
        this.applicationName = string;
    }

    public String getDefaultJMSPrefix() {
        return this.defaultJMSPrefix;
    }

    public void setDefaultJMSPrefix(String string) {
        this.defaultJMSPrefix = string;
    }

    public boolean hasHTTPRouter() {
        return this.hasHTTPRouter;
    }

    public void setHasHTTPRouter(boolean bl) {
        this.hasHTTPRouter = bl;
    }

    public boolean hasJMSRouter() {
        return this.hasJMSRouter;
    }

    public void setHasJMSRouter(boolean bl) {
        this.hasJMSRouter = bl;
    }

    public String getDefaultEJBPrefix() {
        return this.defaultEJBPrefix;
    }

    public void setDefaultEJBPrefix(String string) {
        this.defaultEJBPrefix = string;
    }

    public HashMap getPersistentPrefixHashMap(Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPersistentPrefixHashMap");
        }
        try {
            this.smh = SysMgmtHelperFactory.createHelper(session);
            if (this.dAppName == null) {
                this.dAppName = this.applicationName;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getPersistentPrefixHashMap() dAppName is " + this.dAppName);
            }
            String string = this.smh.getFilePath(this.dAppName, this.name, "URLPrefixMap", false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getPersistentPrefixHashMap() used filename URLPrefixMap app " + this.dAppName + " module " + this.name + " to get filepath " + string);
            }
            if (string != null) {
                this.fileObj = new File(string);
                if (this.fileObj.exists()) {
                    try {
                        FileInputStream fileInputStream = new FileInputStream(this.fileObj);
                        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                        this.urlPrefixMap = (HashMap)objectInputStream.readObject();
                        fileInputStream.close();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.deploy.JAXWSModuleDataImpl.getPersistentPrefixHashMap", "582", this);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getPersistentPrefixHashMap() fileObj does not exist.");
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.deploy.JAXWSModuleDataImpl.getPersistentPrefixHashMap", "592", this);
            exception.printStackTrace();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPersistentPrefixHashMap() returning " + this.urlPrefixMap.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPersistentPrefixHashMap");
        }
        return this.urlPrefixMap;
    }

    public void savePersistentPrefixHashMap() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "savePersistentPrefixHashMap");
        }
        if (!this.urlPrefixMap.isEmpty() && this.smh != null) {
            try {
                Object object;
                if (this.fileObj == null) {
                    object = this.smh.getFilePath(this.dAppName, this.name, "URLPrefixMap", true);
                    this.fileObj = new File((String)object);
                }
                if (this.fileObj != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating workspace url prefix file: " + this.fileObj.getAbsolutePath());
                }
                if (this.fileObj != null) {
                    object = new FileOutputStream(this.fileObj);
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object);
                    objectOutputStream.writeObject(this.urlPrefixMap);
                    ((FileOutputStream)object).close();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "savePersistentPrefixHashMap() saved " + this.urlPrefixMap.toString());
                    }
                    this.smh.updateFilePath(this.dAppName, this.name, "URLPrefixMap");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "savePersistentPrefixHashMap() saved filename URLPrefixMap to app " + this.dAppName + " module " + this.name);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.deploy.JAXWSModuleDataImpl.savePersistentPrefixHashMap", "631", this);
                exception.printStackTrace();
            }
            this.smh = null;
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "savePersistentPrefixHashMap() map empty " + this.urlPrefixMap.isEmpty());
            Tr.debug(tc, "savePersistentPrefixHashMap() null fileObj " + (this.fileObj == null));
            Tr.debug(tc, "savePersistentPrefixHashMap() null smh " + (this.smh == null));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "savePersistentPrefixHashMap");
        }
    }

    public String getDisplayApplicationName() {
        return this.dAppName;
    }

    public void setDisplayApplicationName(String string) {
        this.dAppName = string;
    }

    private class Prefix {
        String protocol;
        String host;
        String port;

        Prefix(String string, String string2, String string3) {
            this.protocol = string;
            this.host = string2;
            this.port = string3;
        }

        public String toString() {
            return this.protocol + "://" + this.host + ":" + this.port;
        }
    }
}

