/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deploy;

import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.MessageDrivenBeanBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.webservice.wsbnd.DefaultEndpointURIPrefix;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.EJBContainer;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.messagelistener.ListenerPort;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.messagelistener.MessageListenerService;
import com.ibm.websphere.models.config.applicationserver.webcontainer.HTTPTransport;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.webservices.WebModels;
import com.ibm.ws.webservices.admin.sysmgmt.SysMgmtHelperFactory;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.ws.webservices.deploy.JAXRPCModuleDataImpl;
import com.ibm.ws.webservices.deploy.MetaDataChannelHelper;
import com.ibm.ws.webservices.deploy.MetaDataLoader;
import com.ibm.ws.webservices.deploy.ModuleData;
import com.ibm.ws.webservices.deploy.WebserviceDescriptionInfo;
import com.ibm.ws.websvcs.deploy.JAXWSModuleDataImpl;
import com.ibm.ws.websvcs.desc.WSDescriptionBuilderFactory;
import com.ibm.wsspi.webservices.models.WSModels;
import com.ibm.wsspi.websvcs.desc.WSDescriptionBuilder;
import com.ibm.wsspi.websvcs.desc.WSEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSModuleDescriptor;
import com.ibm.wsspi.websvcs.desc.WSServiceDescriptor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.EjbModule;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ReadOnlyDirectory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsdd.EJBLink;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;

public class DualMetaDataLoaderImpl
implements MetaDataLoader {
    private static TraceComponent tc = Tr.register(DualMetaDataLoaderImpl.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.deploy.resources.deployMessages");
    private static final String SERVLET_URL_PATTERN_ROOT = "services/";
    private static final String SEARCH_FOR_APP_SERVER_KEY = "com.ibm.ws.webservices.searchForAppServer";
    private Map nodeHostNames;
    private RepositoryContext appDeployCtx;
    private RepositoryContext applicationContext;
    private RepositoryContext cellContext;
    private List moduleDataList;
    private List whirlModuleDataList;
    WSDescriptionBuilder WSDescBuilder = null;
    private String earFileLocation;
    private EARFile earFile;
    private ApplicationDeployment appDeployment = null;
    private WebModels webModels = null;
    private List deployedModules;
    private static final String uriPathSeparator = "/";

    public DualMetaDataLoaderImpl(RepositoryContext repositoryContext, String string) {
        this.appDeployCtx = repositoryContext;
        this.earFileLocation = string;
        this.nodeHostNames = new HashMap();
        this.moduleDataList = new LinkedList();
        this.whirlModuleDataList = new LinkedList();
    }

    public DualMetaDataLoaderImpl() {
        this.appDeployCtx = null;
        this.earFileLocation = null;
        this.nodeHostNames = new HashMap();
        this.moduleDataList = new LinkedList();
        this.whirlModuleDataList = new LinkedList();
    }

    public List getModuleDataList() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getModuleDataList returning " + this.moduleDataList.size() + " moduleDataList members");
            Tr.debug(tc, "                        and " + this.whirlModuleDataList.size() + " whirlModuleDataList members");
        }
        if (this.whirlModuleDataList.isEmpty()) {
            return this.moduleDataList;
        }
        if (this.moduleDataList.isEmpty()) {
            return this.whirlModuleDataList;
        }
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.moduleDataList);
        linkedList.addAll(this.whirlModuleDataList);
        return linkedList;
    }

    public List getWhirlModuleDataList() {
        return this.whirlModuleDataList;
    }

    public List getMaelstromModuleDataList() {
        return this.moduleDataList;
    }

    public void setRepositoryContext(RepositoryContext repositoryContext) {
        this.appDeployCtx = repositoryContext;
    }

    public void setEARFileLocation(String string) {
        this.earFileLocation = string;
    }

    public boolean isWebServiceEnabled() {
        if (tc.isDebugEnabled()) {
            String string = this.appDeployCtx != null ? this.appDeployCtx.getURI() : "unknown";
            Tr.debug(tc, "isWebServiceEnabled for application URI: " + string);
        }
        boolean bl = false;
        EARFile eARFile = this.getEAR(this.getApplicationContext());
        Application application = null;
        if (eARFile != null) {
            application = eARFile.getDeploymentDescriptor();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isWebServiceEnabled on app: " + (application != null ? application.getDisplayName() : "unknown"));
            }
            List list = this.getDeployedModules();
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                Module module;
                ModuleDeployment moduleDeployment = (ModuleDeployment)list.get(i);
                Module module2 = module = moduleDeployment.getAltDD() != null ? application.getModuleHavingAltDD(moduleDeployment.getAltDD()) : application.getModule(moduleDeployment.getUri(), null);
                if (module == null) continue;
                String string = module.isWebModule() ? "WEB-INF/webservices.xml" : "META-INF/webservices.xml";
                ModuleFile moduleFile = eARFile.getModuleRef(module).getModuleFile();
                try {
                    object = moduleFile.getLoadStrategy();
                    bl = object.getContainer().containsFile(string);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.webservices.deploy.DualMetaDataLoaderImpl.isWebServiceEnabled", "229");
                }
                if (!bl) {
                    if (this.WSDescBuilder == null) {
                        this.WSDescBuilder = WSDescriptionBuilderFactory.getBuilder();
                    }
                    object = this.WSDescBuilder.getModuleDescriptor(moduleFile);
                    bl = object.containsWebServices();
                }
                if (bl) break;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isWebServiceEnabled:  Application " + (application != null ? application.getDisplayName() : "unknown") + " is " + (bl ? "enabled." : "not enabled."));
        }
        return bl;
    }

    public boolean isModuleEnabled(ModuleDeployment moduleDeployment, boolean bl) {
        if (tc.isDebugEnabled()) {
            String string = moduleDeployment != null ? moduleDeployment.getUri() : "Module Is Null.";
            Tr.debug(tc, "isModuleEnabled for module URI " + string);
        }
        boolean bl2 = false;
        String string = moduleDeployment.getUri();
        EARFile eARFile = this.getEAR(this.getApplicationContext());
        if (eARFile != null) {
            Application application = eARFile.getDeploymentDescriptor();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isModuleEnabled on app: " + (application != null ? application.getDisplayName() : "unknown"));
            }
            List list = this.getDeployedModules();
            if (tc.isDebugEnabled()) {
                if (moduleDeployment != null) {
                    Tr.debug(tc, "isModuleEnabled on app: " + application.getDisplayName() + " for module " + moduleDeployment.getUri());
                } else {
                    Tr.debug(tc, "isModuleEnabled on app: " + application.getDisplayName());
                }
            }
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                Module module;
                ModuleDeployment moduleDeployment2 = (ModuleDeployment)list.get(i);
                String string2 = moduleDeployment2.getUri();
                if (!string2.equals(string)) continue;
                Module module2 = module = moduleDeployment2.getAltDD() != null ? application.getModuleHavingAltDD(moduleDeployment2.getAltDD()) : application.getModule(moduleDeployment2.getUri(), null);
                if (module == null) continue;
                String string3 = null;
                string3 = bl ? (module.isWebModule() ? "WEB-INF/ibm-webservicesclient-bnd.xmi" : "META-INF/ibm-webservicesclient-bnd.xmi") : (module.isWebModule() ? "WEB-INF/ibm-webservices-bnd.xmi" : "META-INF/ibm-webservices-bnd.xmi");
                ModuleFile moduleFile = eARFile.getModuleRef(module).getModuleFile();
                try {
                    object = moduleFile.getLoadStrategy();
                    bl2 = object.getContainer().containsFile(string3);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.webservices.deploy.DualMetaDataLoaderImpl.isModuleEnabled", "320");
                }
                if (bl2) break;
                if (this.WSDescBuilder == null) {
                    this.WSDescBuilder = WSDescriptionBuilderFactory.getBuilder();
                }
                object = this.WSDescBuilder.getModuleDescriptor(moduleFile);
                bl2 = object.containsWebServices();
                break;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isModuleEnabled:  Module " + string + (bl2 ? " is enabled" : " is not enabled."));
        }
        return bl2;
    }

    public void cleanup() {
        this.nodeHostNames.clear();
        this.moduleDataList.clear();
        this.whirlModuleDataList.clear();
        this.deployedModules = null;
        this.appDeployCtx = null;
        this.applicationContext = null;
        this.appDeployment = null;
        this.cellContext = null;
        if (this.earFile != null) {
            this.earFile.close();
        }
    }

    public void load() throws Exception {
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ObjectName objectName = (ObjectName)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    DualMetaDataLoaderImpl.this._load();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.webservices.deploy.DualMetaDataLoaderImpl.load", "402", this);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.deploy.DualMetaDataLoaderImpl.load", "408", this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _load() throws Exception {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "load");
        }
        if (!(bl = this.isWebServiceEnabled())) {
            if (!tc.isDebugEnabled()) return;
            Tr.debug(tc, "load: no webservices information found");
            return;
        }
        RepositoryContext repositoryContext = this.getCellContext();
        List list = this.getDeployedModules();
        EARFile eARFile = this.getEAR(this.applicationContext);
        if (eARFile == null) {
            if (!tc.isDebugEnabled()) return;
            Tr.debug(tc, "load: no EARFile found");
            return;
        }
        Application application = eARFile.getDeploymentDescriptor();
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            WSBinding wSBinding;
            WSModuleDescriptor wSModuleDescriptor;
            ModuleFile moduleFile;
            Module module;
            String string = null;
            boolean bl2 = false;
            ModuleDeployment moduleDeployment = (ModuleDeployment)list.get(i);
            Module module2 = module = moduleDeployment.getAltDD() != null ? application.getModuleHavingAltDD(moduleDeployment.getAltDD()) : application.getModule(moduleDeployment.getUri(), null);
            if (module == null) continue;
            ModuleData moduleData = null;
            ModuleData moduleData2 = null;
            if (module.isWebModule()) {
                moduleFile = eARFile.getModuleRef(module).getModuleFile();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "load: starting to process WEB module " + moduleFile.getName());
                }
                if (this.WSDescBuilder == null) {
                    this.WSDescBuilder = WSDescriptionBuilderFactory.getBuilder();
                }
                if ((wSModuleDescriptor = this.WSDescBuilder.getModuleDescriptor(moduleFile)).containsJAXWSWebServices()) {
                    moduleData2 = this.loadWhirlModuleData(repositoryContext, eARFile, moduleFile, moduleDeployment, (WebModule)module, wSModuleDescriptor, false);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "load: adding whirlModuleData to list.");
                    }
                    this.whirlModuleDataList.add(moduleData2);
                }
                if ((wSBinding = WSModels.getWebServices(moduleFile.getLoadStrategy(), "WEB-INF/webservices.xml")) == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "load: loadWebServicesXML returned null");
                    continue;
                }
                object = (WebModule)module;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "load: calling loadModuleData for module " + moduleFile.getName());
                }
                moduleData = this.loadModuleData(repositoryContext, eARFile, moduleFile, moduleDeployment, (WebModule)object, (WebServices)wSBinding, false);
            } else if (module.isEjbModule()) {
                String string2;
                moduleFile = eARFile.getModuleRef(module).getModuleFile();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "load: starting to process EJB module " + moduleFile.getName());
                }
                if ((wSModuleDescriptor = WSModels.getWebServices(moduleFile.getLoadStrategy(), "META-INF/webservices.xml")) == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "load: loadWebServicesXML returned null");
                    continue;
                }
                wSBinding = WSModels.getWSBinding(moduleFile.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
                if (wSBinding != null) {
                    for (RouterModule routerModule : wSBinding.getRouterModules()) {
                        string2 = routerModule.getTransport();
                        if (string2 == null || !string2.equals("http")) continue;
                        string = routerModule.getName();
                        bl2 = true;
                        break;
                    }
                }
                if (string != null) {
                    RouterModule routerModule;
                    object = null;
                    for (int j = 0; j < list.size(); ++j) {
                        string2 = (ModuleDeployment)list.get(j);
                        if (!string2.getUri().equals(string)) continue;
                        object = string2;
                        break;
                    }
                    if (object == null) {
                        throw new Exception(nls.getFormattedMessage("WSWS0043E", new Object[]{moduleDeployment.getUri()}, "WSWS0043E: The EJB module {0} does not have an associated router module"));
                    }
                    routerModule = application.getModule(string, null);
                    if (routerModule == null) {
                        throw new Exception(nls.getFormattedMessage("WSWS0043E", new Object[]{moduleDeployment.getUri()}, "WSWS0043E: The EJB module {0} does not have an associated router module"));
                    }
                    if (!routerModule.isWebModule()) throw new Exception(nls.getFormattedMessage("WSWS0043E", new Object[]{moduleDeployment.getUri()}, "WSWS0043E: The EJB module {0} does not have an associated router module"));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "load: calling loadModuleData for module " + moduleFile.getName());
                    }
                    moduleData = this.loadModuleData(repositoryContext, eARFile, moduleFile, moduleDeployment, (WebModule)routerModule, (WebServices)wSModuleDescriptor, bl2);
                } else {
                    moduleData = this.loadModuleData(repositoryContext, eARFile, moduleFile, moduleDeployment, null, (WebServices)wSModuleDescriptor, bl2);
                }
            }
            if (moduleData == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "load: adding moduleData to list.");
            }
            this.moduleDataList.add(moduleData);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "load");
    }

    private RepositoryContext getApplicationContext() {
        if (this.applicationContext == null) {
            this.applicationContext = this.appDeployCtx.getParent();
        }
        return this.applicationContext;
    }

    private RepositoryContext getCellContext() {
        if (this.cellContext == null) {
            this.cellContext = this.getApplicationContext().getParent();
        }
        return this.cellContext;
    }

    private ApplicationDeployment getApplicationDeploymentFromContext() {
        block4: {
            if (this.appDeployment == null) {
                try {
                    Deployment deployment;
                    Resource resource;
                    ResourceSet resourceSet;
                    if (this.appDeployCtx != null && (resourceSet = this.appDeployCtx.getResourceSet()) != null && (resource = resourceSet.getResource(URI.createURI("deployment.xml"), true)) != null && (deployment = (Deployment)resource.getContents().get(0)) != null) {
                        this.appDeployment = (ApplicationDeployment)deployment.getDeployedObject();
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.webservices.deploy.DualMetaDataLoaderImpl.getApplicationDeploymentFromContext", "689");
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "getApplicationDeploymentFromContext: caught exception ", exception);
                }
            }
        }
        return this.appDeployment;
    }

    private List getDeployedModules() {
        if (this.deployedModules == null) {
            block6: {
                try {
                    ApplicationDeployment applicationDeployment = this.getApplicationDeploymentFromContext();
                    if (applicationDeployment != null) {
                        this.deployedModules = applicationDeployment.getModules();
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.webservices.deploy.DualMetaDataLoaderImpl.getDeployedModules", "649");
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "getDeploymentModules: caught exception ", exception);
                }
            }
            if (this.deployedModules == null) {
                this.deployedModules = new ArrayList();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getDeploymentModules: no modules found");
                }
            }
        }
        return this.deployedModules;
    }

    private EARFile getEAR(RepositoryContext repositoryContext) {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getEAR");
            }
            if (this.earFile == null) {
                ApplicationDeployment applicationDeployment = this.getApplicationDeploymentFromContext();
                if (applicationDeployment == null) {
                    return this.earFile;
                }
                boolean bl = applicationDeployment.isZeroBinaryCopy();
                boolean bl2 = applicationDeployment.isZeroEarCopy();
                if (bl || bl2) {
                    return this.earFile;
                }
                if (this.earFileLocation == null) {
                    String string = repositoryContext.getName();
                    String string2 = repositoryContext.getURI();
                    Properties properties = ConfigRepositoryFactory.getConfigRepository().getConfig();
                    String string3 = (String)properties.get("was.repository.root");
                    this.earFileLocation = string3 + java.io.File.separator + string2 + java.io.File.separator + string;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ear file location: ", this.earFileLocation);
                }
                try {
                    CommonarchiveFactory commonarchiveFactory = (CommonarchiveFactory)EPackage.Registry.INSTANCE.getEPackage("http:///com/ibm/etools/commonarchive.ecore").getEFactoryInstance();
                    ArchiveOptions archiveOptions = new ArchiveOptions();
                    archiveOptions.setIsReadOnly(true);
                    archiveOptions.setUseJavaReflection(true);
                    this.earFile = commonarchiveFactory.openEARFile(archiveOptions, this.earFileLocation);
                    this.earFile.getDeploymentDescriptor();
                    this.earFile.getBindings();
                    this.earFile.getExtensions();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.webservices.deploy.DualMetaDataLoaderImpl.getEAR", "534");
                    if (this.earFile == null) break block9;
                    this.earFile.close();
                    this.earFile = null;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEAR");
        }
        return this.earFile;
    }

    private String findServletUrl(WebApp webApp, String string) {
        String string2 = null;
        Servlet servlet = webApp.getServletNamed(string);
        ServletMapping servletMapping = webApp.getServletMapping(servlet);
        if (servletMapping != null) {
            string2 = servletMapping.getUrlPattern();
        }
        return string2;
    }

    private static String getHostName(RepositoryContext repositoryContext) {
        String string = null;
        try {
            ResourceSet resourceSet = repositoryContext.getResourceSet();
            Resource resource = resourceSet.getResource(URI.createURI("serverindex.xml"), true);
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            string = serverIndex.getHostName();
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.webservices.deploy.DualMetaDataLoaderImpl.getHostName", "586");
            Tr.error(tc, "internal.error", exception);
        }
        return string;
    }

    private static String getServerType(RepositoryContext repositoryContext) {
        Object var1_1 = null;
        ServerEntry serverEntry = null;
        String string = null;
        try {
            ResourceSet resourceSet = repositoryContext.getResourceSet();
            Resource resource = resourceSet.getResource(URI.createURI("serverindex.xml"), true);
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext() && (string = (serverEntry = (ServerEntry)iterator.next()).getServerType()) == null) {
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.webservices.deploy.DefaultMetaDataLoaderImpl.getServerType", "841");
            Tr.error(tc, "internal.error", exception);
        }
        return string;
    }

    private ModuleData loadWhirlModuleData(RepositoryContext repositoryContext, EARFile eARFile, ModuleFile moduleFile, ModuleDeployment moduleDeployment, WebModule webModule, WSModuleDescriptor wSModuleDescriptor, boolean bl) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        String string;
        Object object7;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadWhirlModuleData for ", moduleDeployment.getUri() + ", application: " + eARFile.getName());
        }
        JAXWSModuleDataImpl jAXWSModuleDataImpl = new JAXWSModuleDataImpl();
        jAXWSModuleDataImpl = this.loadCommonModuleData(jAXWSModuleDataImpl, repositoryContext, eARFile, moduleFile, moduleDeployment, webModule, bl);
        boolean bl2 = moduleFile.isWARFile();
        WebApp webApp = null;
        if (webModule != null) {
            webApp = eARFile.getDeploymentDescriptor(webModule);
        }
        Iterator iterator = wSModuleDescriptor.getServices();
        LinkedList linkedList = new LinkedList();
        while (iterator.hasNext()) {
            object7 = (WSServiceDescriptor)iterator.next();
            string = object7.getName();
            object6 = object7.getWSDLLocationBaseName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadWhirlModuleData: webServicesDescriptionName=" + string);
            }
            if (!object7.deployedWithWSDL()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "loadWhirlModuleData: looking for generated WSDL files.");
                }
                if ((object5 = this.getGeneratedWSDLFile(object7.getWSDLDefinition())) != null) {
                    linkedList.addAll(object5);
                    object6 = this.getGeneratedWsdlFileName(object7.getWSDLDefinition());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "loadWhirlModuleData: generated WSDL file name: " + (String)object6);
                    }
                }
            }
            object5 = new WebserviceDescriptionInfo((String)object6, string);
            object4 = object7.getEndpoints();
            while (object4.hasNext()) {
                String string2;
                object3 = (WSEndpointDescriptor)object4.next();
                object2 = object3.getQName();
                object = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "loadWhirlModuleData: endpoint qname " + ((QName)object2).toString());
                }
                if (webApp != null) {
                    object = object3.getURLPattern();
                }
                if (object != null) {
                    object = DeployUtils.trimSlash((String)object);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "loadWhirlModuleData: url is " + (String)object);
                    }
                }
                if (bl2) {
                    if (object != null) {
                        object5.addQnameToUrlPattern((QName)object2, (String)object);
                    } else {
                        string2 = SERVLET_URL_PATTERN_ROOT + object3.getName();
                        object5.addQnameToUrlPattern((QName)object2, string2);
                    }
                } else if (object != null) {
                    object5.addQnameToUrlPattern((QName)object2, (String)object);
                } else {
                    string2 = "null";
                    if (webModule != null) {
                        string2 = webModule.getUri();
                    }
                    Tr.error(tc, "WSWS0045E", new Object[]{moduleDeployment.getUri(), string2, object3.getName()});
                }
                object5.addQnameToPortComponentName((QName)object2, object3.getName());
            }
            jAXWSModuleDataImpl.addWebservicesDescription((WebserviceDescriptionInfo)object5);
        }
        if (bl2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadWhirlModuleData: isWebModule, getting war WSDL files.");
            }
            linkedList.addAll(moduleFile.getLoadStrategy().getFiles("WEB-INF/wsdl"));
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadWhirlModuleData: notWebModule, getting ejb WSDL files.");
            }
            linkedList.addAll(moduleFile.getLoadStrategy().getFiles("META-INF/wsdl"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadWhirlModuleData: saving " + (linkedList != null ? Integer.valueOf(linkedList.size()) : "zero") + " WSDL files to the moduleData.");
        }
        jAXWSModuleDataImpl.setModulesWsdlFiles(linkedList);
        jAXWSModuleDataImpl.setDefaultJMSPrefix("");
        jAXWSModuleDataImpl.setDefaultEJBPrefix("");
        jAXWSModuleDataImpl.setHasJMSRouter(false);
        object7 = null;
        string = repositoryContext.getWorkSpace().getUserName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadWhirlModuleData: creating Session for userName " + string);
        }
        object6 = new Session(string, false);
        object5 = null;
        object5 = SysMgmtHelperFactory.createHelper((Session)object6);
        object4 = object5.getFilePath(jAXWSModuleDataImpl.getDisplayApplicationName(), jAXWSModuleDataImpl.getName(), "URLPrefixMap", false);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadWhirlModuleData: used filename URLPrefixMap app " + jAXWSModuleDataImpl.getDisplayApplicationName() + " module " + jAXWSModuleDataImpl.getName() + " to get filepath " + (String)object4);
        }
        if (object4 != null && ((java.io.File)(object3 = new java.io.File((String)object4))).exists()) {
            try {
                object2 = new FileInputStream((java.io.File)object3);
                object = new ObjectInputStream((InputStream)object2);
                object7 = (HashMap)object.readObject();
                ((FileInputStream)object2).close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.deploy.DualMetaDataLoaderImpl.loadWhirlModuleData", "1137", this);
            }
        }
        if (object7 != null && !((HashMap)object7).isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadWhirlModuleData: found persistent prefix " + ((AbstractMap)object7).toString());
            }
            object3 = null;
            object3 = (String)((HashMap)object7).get("http");
            if (object3 != null && object3 != "") {
                jAXWSModuleDataImpl.setDefaultPrefix((String)object3);
            }
            if ((object3 = (String)((HashMap)object7).get("https")) != null && object3 != "") {
                jAXWSModuleDataImpl.setDefaultPrefix((String)object3);
            }
            if ((object3 = (String)((HashMap)object7).get("jms")) != null && object3 != "") {
                jAXWSModuleDataImpl.setDefaultJMSPrefix((String)object3);
            }
            if ((object3 = (String)((HashMap)object7).get("ejb")) != null && object3 != "") {
                jAXWSModuleDataImpl.setDefaultEJBPrefix((String)object3);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadWhirlModuleData: found no persistent prefix store.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadModuleData");
        }
        return jAXWSModuleDataImpl;
    }

    private ModuleData loadModuleData(RepositoryContext repositoryContext, EARFile eARFile, ModuleFile moduleFile, ModuleDeployment moduleDeployment, WebModule webModule, WebServices webServices, boolean bl) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string;
        Object object6;
        Object object7;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadModuleData for ", moduleDeployment.getUri() + ", application: " + eARFile.getName());
        }
        JAXRPCModuleDataImpl jAXRPCModuleDataImpl = new JAXRPCModuleDataImpl();
        jAXRPCModuleDataImpl = this.loadCommonModuleData((ModuleData)jAXRPCModuleDataImpl, repositoryContext, eARFile, moduleFile, moduleDeployment, webModule, bl);
        boolean bl2 = moduleFile.isWARFile();
        WebApp webApp = null;
        if (webModule != null) {
            webApp = eARFile.getDeploymentDescriptor(webModule);
        }
        int n = webServices.getWebServiceDescriptions().size();
        for (int i = 0; i < n; ++i) {
            object7 = (WebServiceDescription)webServices.getWebServiceDescriptions().get(i);
            object6 = object7.getWebServiceDescriptionName();
            string = object6;
            object5 = object7.getWsdlFile();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadModuleData: webServicesDescriptionName=" + string);
                Tr.debug(tc, "loadModuleData: theWSDLFileName=" + (String)object5);
            }
            object4 = new WebserviceDescriptionInfo((String)object5, string);
            int n2 = object7.getPortComponents().size();
            for (int j = 0; j < n2; ++j) {
                EJBJarBinding eJBJarBinding2;
                Module module;
                EJBJarFile eJBJarFile2;
                String string2;
                object3 = (PortComponent)object7.getPortComponents().get(j);
                object2 = object3.getWsdlPort();
                Object object8 = new QName(object2.getNamespaceURI(), object2.getLocalPart());
                object = object3.getServiceImplBean().getEServletLink();
                String string3 = object != null ? object.getServletLink() : object3.getPortComponentName();
                String string4 = null;
                if (webApp != null) {
                    string4 = this.findServletUrl(webApp, string3);
                }
                if (string4 != null) {
                    string4 = DeployUtils.trimSlash(string4);
                }
                if (bl2) {
                    if (string4 != null) {
                        object4.addQnameToUrlPattern((QName)object8, string4);
                    } else {
                        string2 = SERVLET_URL_PATTERN_ROOT + object3.getPortComponentName();
                        object4.addQnameToUrlPattern((QName)object8, string2);
                    }
                } else if (webModule != null) {
                    if (string4 != null) {
                        object4.addQnameToUrlPattern((QName)object8, string4);
                    } else {
                        string2 = "null";
                        string2 = webModule.getUri();
                        Tr.error(tc, "WSWS0045E", new Object[]{moduleDeployment.getUri(), string2, object3.getPortComponentName()});
                    }
                }
                object4.addQnameToPortComponentName((QName)object8, object3.getPortComponentName());
                if (bl2) continue;
                string2 = object3.getServiceImplBean();
                EJBLink eJBLink = string2.getEEJBLink();
                String string5 = eJBLink.getEjbLink();
                String string6 = null;
                List list = eARFile.getEJBJarFiles();
                for (EJBJarFile eJBJarFile2 : list) {
                    module = null;
                    if (eJBJarFile2.getName().equals(jAXRPCModuleDataImpl.getName())) {
                        module = eJBJarFile2.getDeploymentDescriptor();
                    }
                    if (module == null) continue;
                    for (EJBJarBinding eJBJarBinding2 : module.getEnterpriseBeans()) {
                        if (!eJBJarBinding2.getName().equals(string5)) continue;
                        string6 = eJBJarBinding2.getHomeInterfaceName();
                    }
                }
                Object object9 = null;
                eJBJarFile2 = eARFile.getDeploymentDescriptor();
                module = moduleDeployment.getAltDD() != null ? eJBJarFile2.getModuleHavingAltDD(moduleDeployment.getAltDD()) : eJBJarFile2.getModule(moduleDeployment.getUri(), null);
                EjbModule ejbModule = (EjbModule)module;
                eJBJarBinding2 = eARFile.getBindings(ejbModule);
                EList eList = eJBJarBinding2.getEjbBindings();
                for (EnterpriseBeanBinding enterpriseBeanBinding : eList) {
                    String string7;
                    EnterpriseBean enterpriseBean;
                    if (enterpriseBeanBinding == null || (enterpriseBean = enterpriseBeanBinding.getEnterpriseBean()) == null || (string7 = enterpriseBean.getName()) == null || !string7.equals(string5)) continue;
                    object9 = enterpriseBeanBinding.getJndiName();
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("wsejb:/");
                stringBuffer.append(string6);
                stringBuffer.append('?');
                stringBuffer.append("jndiName=").append((String)object9);
                object4.addQNameToEJBUrlPrefix((QName)object8, stringBuffer.toString());
            }
            jAXRPCModuleDataImpl.addWebservicesDescription((WebserviceDescriptionInfo)object4);
        }
        List list = bl2 ? moduleFile.getLoadStrategy().getFiles("WEB-INF/wsdl") : moduleFile.getLoadStrategy().getFiles("META-INF/wsdl");
        jAXRPCModuleDataImpl.setModulesWsdlFiles(list);
        jAXRPCModuleDataImpl.setDefaultJMSPrefix("");
        jAXRPCModuleDataImpl.setDefaultEJBPrefix("");
        jAXRPCModuleDataImpl.setHasJMSRouter(false);
        object7 = new StringBuffer(jAXRPCModuleDataImpl.getName());
        ((StringBuffer)object7).append(uriPathSeparator);
        if (bl2) {
            ((StringBuffer)object7).append("WEB-INF/ibm-webservices-bnd.xmi");
        } else {
            ((StringBuffer)object7).append("META-INF/ibm-webservices-bnd.xmi");
        }
        object6 = WSModels.getWSBindingFromResourceSet(this.appDeployCtx.getResourceSet(), ((StringBuffer)object7).toString());
        if (object6 == null) {
            string = null;
            string = bl2 ? "WEB-INF/ibm-webservices-bnd.xmi" : "META-INF/ibm-webservices-bnd.xmi";
            object6 = WSModels.getWSBinding(moduleFile.getLoadStrategy(), string);
        }
        if (object6 != null) {
            boolean bl3 = false;
            object5 = object6.getWsdescBindings();
            if (object5.size() > 0) {
                DefaultEndpointURIPrefix defaultEndpointURIPrefix;
                DefaultEndpointURIPrefix defaultEndpointURIPrefix2;
                object4 = (WSDescBinding)object5.get(0);
                EList eList = object4.getDefaultEndpointURIPrefixes();
                if (eList.size() >= 3) {
                    DefaultEndpointURIPrefix defaultEndpointURIPrefix3 = (DefaultEndpointURIPrefix)eList.get(2);
                    object3 = defaultEndpointURIPrefix3.getText();
                    if (object3 == null) {
                        object3 = "";
                    }
                    jAXRPCModuleDataImpl.setDefaultEJBPrefix((String)object3);
                }
                if (eList.size() >= 2 && (object3 = (defaultEndpointURIPrefix2 = (DefaultEndpointURIPrefix)eList.get(1)).getText()) != null && ((String)object3).length() != 0) {
                    bl3 = true;
                    jAXRPCModuleDataImpl.setDefaultJMSPrefix((String)object3);
                }
                if (eList.size() >= 1 && (object3 = (defaultEndpointURIPrefix = (DefaultEndpointURIPrefix)eList.get(0)).getText()) != null && ((String)object3).length() != 0) {
                    jAXRPCModuleDataImpl.setDefaultPrefix((String)object3);
                }
                EList eList2 = object6.getRouterModules();
                object3 = null;
                for (Object object8 : eList2) {
                    object = object8.getTransport();
                    if (!((String)object).equals("jms")) continue;
                    object3 = object8.getName();
                    break;
                }
                if (object3 != null) {
                    jAXRPCModuleDataImpl.setHasJMSRouter(true);
                    if (!bl3) {
                        object2 = this.buildDefaultJMSUrlFromconfig(repositoryContext, eARFile, moduleDeployment.getTargetMappings(), (String)object3);
                        jAXRPCModuleDataImpl.setDefaultJMSPrefix((String)object2);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "loadModuleData: did not find a JMS router module name from the bindings file of module " + moduleDeployment.getUri());
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadModuleData: The module " + moduleFile.getName() + " contains a  Web Services bindings file, but the bindings file " + "contains no WSDescBindings");
            }
        } else if (!bl2) {
            Tr.error(tc, "WSWS0018E", new Object[]{moduleFile.getName(), "ibm-webservices-bnd.xmi"});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadModuleData");
        }
        return jAXRPCModuleDataImpl;
    }

    private ModuleData loadCommonModuleData(ModuleData moduleData, RepositoryContext repositoryContext, EARFile eARFile, ModuleFile moduleFile, ModuleDeployment moduleDeployment, WebModule webModule, boolean bl) throws Exception {
        DeploymentTarget deploymentTarget;
        Object object;
        Object object2;
        Object object3;
        String string;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadCommonModuleData for ", moduleDeployment.getUri() + ", application: " + eARFile.getName());
        }
        moduleData.setApplicationName(eARFile.getName());
        moduleData.setIsWebModule(moduleFile.isWARFile());
        moduleData.setHasHTTPRouter(bl);
        moduleData.setName(moduleDeployment.getUri());
        boolean bl2 = false;
        String string2 = System.getProperty(SEARCH_FOR_APP_SERVER_KEY);
        if (string2 != null && string2.length() > 0) {
            boolean bl3 = bl2 = string2.equalsIgnoreCase("true") || string2.equals("1") || string2.equalsIgnoreCase("yes");
        }
        if (this.appDeployCtx != null) {
            string = this.appDeployCtx.getPath();
            int n = string.lastIndexOf(java.io.File.separatorChar);
            object3 = string.substring(n + 1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadCommonModuleData: Display app name from appDeployCtx is " + (String)object3);
            }
            moduleData.setDisplayApplicationName((String)object3);
        } else if (eARFile != null && (string = eARFile.getDeploymentDescriptor()) != null) {
            String string3 = string.getDisplayName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadCommonModuleData: Display app name is " + string3);
            }
            moduleData.setDisplayApplicationName(string3);
        }
        if (webModule == null) {
            moduleData.setVirtualHost(null);
        } else {
            if (this.webModels == null) {
                this.webModels = new WebModels();
            }
            string = this.webModels.getWebAppBinding(this.appDeployCtx, eARFile, webModule);
            String string4 = string.getVirtualHostName();
            object3 = repositoryContext.getResourceSet().getResource(URI.createURI("virtualhosts.xml"), true);
            object2 = object3.getContents();
            object = object2.iterator();
            while (object.hasNext()) {
                deploymentTarget = (VirtualHost)object.next();
                if (!deploymentTarget.getName().equals(string4)) continue;
                moduleData.setVirtualHost((VirtualHost)deploymentTarget);
                break;
            }
        }
        object3 = moduleDeployment.getTargetMappings();
        if (object3.isEmpty()) {
            throw new Exception(nls.getFormattedMessage("WSWS0044E", new Object[]{moduleDeployment.getUri()}, "WSWS0044E: Can not locate the deploy target for module: {0}"));
        }
        object2 = object3.iterator();
        while (object2.hasNext()) {
            block30: {
                String string5;
                Object object4;
                Resource resource;
                Object object5;
                ServerTarget serverTarget;
                object = (DeploymentTargetMapping)object2.next();
                deploymentTarget = object.getTarget();
                if (deploymentTarget instanceof ServerTarget) {
                    serverTarget = (ServerTarget)deploymentTarget;
                    string = serverTarget.getNodeName();
                    String string6 = serverTarget.getName();
                    object5 = (String)this.nodeHostNames.get(string);
                    resource = repositoryContext.findContext("nodes/" + string);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "com.ibm.ws.webservices.searchForAppServer: " + bl2);
                    }
                    if (bl2 && !((String)(object4 = DualMetaDataLoaderImpl.getServerType((RepositoryContext)resource))).equals("APPLICATION_SERVER")) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, string6 + " is not an application server so will skip reading this server's configuration");
                        continue;
                    }
                    if (object5 == null) {
                        object5 = DualMetaDataLoaderImpl.getHostName((RepositoryContext)resource);
                        this.nodeHostNames.put(string, object5);
                    }
                    object4 = resource.findContext("servers/" + string6);
                    Map map = DualMetaDataLoaderImpl.loadWebContainerPorts((RepositoryContext)resource, (RepositoryContext)object4);
                    moduleData.setNode(string);
                    moduleData.setHost((String)object5);
                    moduleData.setServer(string6);
                    for (String string7 : map.keySet()) {
                        string5 = (String)map.get(string7);
                        moduleData.addPrefix(string5, string7);
                    }
                    if (bl2) continue;
                    break;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Deployment Target (server)" + deploymentTarget.getName() + " is a cluster");
                }
                try {
                    serverTarget = repositoryContext.findContext("clusters/" + deploymentTarget.getName());
                    object5 = serverTarget.getResourceSet();
                    resource = object5.getResource(URI.createURI("cluster.xml"), true);
                    object4 = (ServerCluster)resource.getContents().get(0);
                    for (Object object6 : object4.getMembers()) {
                        String string7;
                        string7 = object6.getNodeName();
                        string5 = object6.getMemberName();
                        String string8 = (String)this.nodeHostNames.get(string7);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "find nodeContext for nodes/" + string7);
                        }
                        RepositoryContext repositoryContext2 = repositoryContext.findContext("nodes/" + string7);
                        if (string8 == null) {
                            string8 = DualMetaDataLoaderImpl.getHostName(repositoryContext2);
                            this.nodeHostNames.put(string7, string8);
                        }
                        RepositoryContext repositoryContext3 = null;
                        if (repositoryContext2 != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "find serverContext for servers/" + string5);
                            }
                            repositoryContext3 = repositoryContext2.findContext("servers/" + string5);
                        }
                        Map map = DualMetaDataLoaderImpl.loadWebContainerPorts(repositoryContext2, repositoryContext3);
                        moduleData.setNode(string7);
                        moduleData.setHost(string8);
                        moduleData.setServer(string5);
                        for (String string9 : map.keySet()) {
                            String string10 = (String)map.get(string9);
                            moduleData.addPrefix(string10, string8, string9);
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.deploy.DualMetaDataLoaderImpl.loadCommonModuleData", "1835", this);
                    if (!tc.isDebugEnabled()) break block30;
                    Tr.debug(tc, "Failed to load cluster context while determining application status: {0}", exception);
                }
            }
            moduleData.setServer("MODULE_ASSIGNED_TO_CLUSTER_TAG");
        }
        if (webModule == null) {
            moduleData.setContextRoot("");
        } else {
            object2 = webModule.getContextRoot();
            moduleData.setContextRoot((String)object2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadCommonModuleData");
        }
        return moduleData;
    }

    private String buildDefaultJMSUrlFromconfig(RepositoryContext repositoryContext, EARFile eARFile, List list, String string) {
        Object object;
        EJBJarBinding eJBJarBinding;
        EJBJarFile eJBJarFile2;
        String string2 = null;
        String string3 = null;
        String string4 = "";
        String string5 = null;
        String string6 = null;
        String string7 = null;
        ListenerPort listenerPort = null;
        List list2 = eARFile.getEJBJarFiles();
        String string8 = null;
        for (EJBJarFile eJBJarFile2 : list2) {
            if (!eJBJarFile2.getName().equals(string)) continue;
            eJBJarBinding = eJBJarFile2.getBindings();
            object = eJBJarBinding.getEjbBindings();
            if (object.size() > 0 && object.get(0) instanceof MessageDrivenBeanBinding) {
                MessageDrivenBeanBinding messageDrivenBeanBinding = (MessageDrivenBeanBinding)object.get(0);
                string5 = messageDrivenBeanBinding.getActivationSpecJndiName();
                if (string5 != null) continue;
                string8 = messageDrivenBeanBinding.getListenerInputPortName();
                continue;
            }
            Tr.error(tc, "WSWS0046E", string);
        }
        DeploymentTargetMapping deploymentTargetMapping = (DeploymentTargetMapping)list.get(0);
        eJBJarFile2 = deploymentTargetMapping.getTarget();
        if (eJBJarFile2 instanceof ServerTarget) {
            eJBJarBinding = (ServerTarget)eJBJarFile2;
            String string9 = eJBJarBinding.getNodeName();
            String string10 = eJBJarBinding.getName();
            if (string5 != null) {
                object = this.getActivationSpecFromCellConfig(string5, repositoryContext, string9);
                string6 = object[0];
                string7 = object[1];
            } else {
                listenerPort = this.getListenerPortFromCellConfig(string8, repositoryContext, string9, string10);
            }
            if (string5 != null) {
                string2 = string6;
            } else if (listenerPort != null) {
                string2 = listenerPort.getDestinationJNDIName();
                string3 = listenerPort.getConnectionFactoryJNDIName();
            }
            if (string2 == null) {
                string2 = "??undefinedDestinationJndiName??";
            }
            if (string3 == null) {
                string3 = "??connectionFactoryJndiName??";
            }
            object = new StringBuffer();
            ((StringBuffer)object).append("jms");
            ((StringBuffer)object).append(':');
            ((StringBuffer)object).append(uriPathSeparator);
            if (string7 == null) {
                ((StringBuffer)object).append("??undefinedDestinationType??");
            } else if (string7.equalsIgnoreCase("queue")) {
                ((StringBuffer)object).append("queue");
            } else {
                ((StringBuffer)object).append("topic");
            }
            ((StringBuffer)object).append('?');
            ((StringBuffer)object).append("destination");
            ((StringBuffer)object).append("=");
            ((StringBuffer)object).append(string2);
            ((StringBuffer)object).append('&');
            ((StringBuffer)object).append("connectionFactory");
            ((StringBuffer)object).append("=");
            ((StringBuffer)object).append(string3);
            string4 = ((StringBuffer)object).toString();
        }
        return string4;
    }

    private String[] getActivationSpecFromCellConfig(String string, RepositoryContext repositoryContext, String string2) {
        String[] stringArray;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getActivationSpecFromCellConfig");
            }
            Object var4_4 = null;
            String string3 = null;
            stringArray = new String[3];
            try {
                ConfigService configService = ConfigServiceFactory.getConfigService();
                Session session = new Session();
                ObjectName objectName = configService.resolve(session, "Node=" + string2)[0];
                ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "J2CResourceAdapter", "SIB JMS Resource Adapter");
                ObjectName objectName3 = configService.queryConfigObjects(session, objectName, objectName2, null)[0];
                if (objectName3 != null) {
                    ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, "J2CActivationSpec");
                    ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName3, objectName4, null);
                    for (int i = 0; i < objectNameArray.length; ++i) {
                        ObjectName objectName5 = objectNameArray[i];
                        string3 = (String)configService.getAttribute(session, objectName5, "jndiName");
                        if (!string3.equals(string)) continue;
                        stringArray[0] = (String)configService.getAttribute(session, objectName5, "destinationJndiName");
                        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, "J2EEResourceProperty", "destinationType");
                        ObjectName objectName7 = configService.queryConfigObjects(session, objectName5, objectName6, null)[0];
                        if (objectName7 == null) break;
                        String string4 = (String)configService.getAttribute(session, objectName7, "value");
                        int n = string4.lastIndexOf(".");
                        stringArray[1] = string4.substring(n + 1);
                        break;
                    }
                }
                configService.discard(session);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.webservices.deploy.DualMetaDataLoaderImpl.getActivationSpecFromCellConfig", "1271");
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "loadModuleData caught while trying to create the default JMS  URL prefix from activationSpec", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActivationSpecFromCellConfig");
        }
        return stringArray;
    }

    private ListenerPort getListenerPortFromCellConfig(String string, RepositoryContext repositoryContext, String string2, String string3) {
        ListenerPort listenerPort;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getListenerPortFromCellConfig");
            }
            listenerPort = null;
            try {
                RepositoryContext repositoryContext2 = repositoryContext.findContext("nodes/" + string2 + "/servers/" + string3);
                ResourceSet resourceSet = repositoryContext2.getResourceSet();
                Resource resource = resourceSet.getResource(URI.createURI("server.xml"), true);
                Server server = (Server)resource.getContents().get(0);
                EList eList = server.getComponents();
                for (Component component : eList) {
                    if (!(component instanceof ApplicationServer)) continue;
                    ApplicationServer applicationServer = (ApplicationServer)component;
                    EList eList2 = applicationServer.getComponents();
                    for (Component component2 : eList2) {
                        if (!(component2 instanceof EJBContainer)) continue;
                        EJBContainer eJBContainer = (EJBContainer)component2;
                        EList eList3 = eJBContainer.getServices();
                        for (Object e : eList3) {
                            if (!(e instanceof MessageListenerService)) continue;
                            MessageListenerService messageListenerService = (MessageListenerService)e;
                            EList eList4 = messageListenerService.getListenerPorts();
                            for (ListenerPort listenerPort2 : eList4) {
                                String string4 = listenerPort2.getName();
                                if (!string4.equals(string)) continue;
                                listenerPort = listenerPort2;
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "found listenerInputPortName: " + string);
                            }
                        }
                    }
                }
            }
            catch (WorkSpaceException workSpaceException) {
                FFDCFilter.processException(workSpaceException, "com.ibm.ws.webservices.deploy.DualMetaDataLoaderImpl.getListenerPortFromCellConfig", "1345");
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "loadModuleData caught while trying to create the default JMS  URL prefix", (Object)workSpaceException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getListenerPortFromCellConfig");
        }
        return listenerPort;
    }

    private static Map loadWebContainerPorts(RepositoryContext repositoryContext, RepositoryContext repositoryContext2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadWebContainerPorts");
        }
        Map map = new HashMap();
        if (repositoryContext2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadWebContainerPorts: no ports mapped");
            }
        } else {
            try {
                Service service;
                ResourceSet resourceSet = repositoryContext2.getResourceSet();
                Resource resource = resourceSet.getResource(URI.createURI("server.xml"), true);
                Server server = (Server)resource.getContents().get(0);
                String string = server.getName();
                EList eList = server.getServices();
                TransportChannelService transportChannelService = null;
                Object var9_10 = null;
                HashMap hashMap = new HashMap();
                boolean bl = false;
                Object object = eList.iterator();
                while (object.hasNext() && !bl) {
                    service = (Service)object.next();
                    if (!(service instanceof TransportChannelService)) continue;
                    transportChannelService = (TransportChannelService)service;
                    EList eList2 = transportChannelService.getTransportChannels();
                    if (eList2.isEmpty()) break;
                    bl = true;
                    break;
                }
                object = server.getComponents();
                service = null;
                boolean bl2 = false;
                Iterator iterator = object.iterator();
                block3: while (iterator.hasNext() && !bl2) {
                    Component component = (Component)iterator.next();
                    if (!(component instanceof ApplicationServer)) continue;
                    ApplicationServer applicationServer = (ApplicationServer)component;
                    EList eList3 = applicationServer.getComponents();
                    for (Component component2 : eList3) {
                        if (!(component2 instanceof WebContainer)) continue;
                        service = (WebContainer)component2;
                        bl2 = true;
                        continue block3;
                    }
                }
                if (service != null && bl2) {
                    map = DualMetaDataLoaderImpl.loadHTTPPortsFromV5Template(server, (List)object, (WebContainer)service, map);
                }
                if (transportChannelService != null && bl) {
                    map = DualMetaDataLoaderImpl.loadHTTPPortsFromV6Template(transportChannelService, repositoryContext, server, string, map);
                } else {
                    Tr.error(tc, "loadWebContainerPorts could not find any http or https ports");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.webservices.deploy.DualMetaDataLoaderImpl.loadWebContainerPorts", "1523");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadWebContainerPorts");
        }
        return map;
    }

    private static Map loadHTTPPortsFromV6Template(TransportChannelService transportChannelService, RepositoryContext repositoryContext, Server server, String string, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadHTTPPortsFromV6Template");
        }
        MetaDataChannelHelper metaDataChannelHelper = new MetaDataChannelHelper(transportChannelService);
        Map map2 = metaDataChannelHelper.getEndPointMap();
        map = DualMetaDataLoaderImpl.mapV6EndPoints2Ports(map2, repositoryContext, server, string, map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadHTTPPortsFromV6Template");
        }
        return map;
    }

    private static Map mapV6EndPoints2Ports(Map map, RepositoryContext repositoryContext, Server server, String string, Map map2) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "mapV6EndPoints2Ports");
            }
            try {
                String string2;
                ResourceSet resourceSet = repositoryContext.getResourceSet();
                Resource resource = resourceSet.getResource(URI.createURI("serverindex.xml"), true);
                ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                EList eList = serverIndex.getServerEntries();
                boolean bl = false;
                ServerEntry serverEntry2 = null;
                for (ServerEntry serverEntry2 : eList) {
                    string2 = serverEntry2.getServerName();
                    if (string2 == null || !(serverEntry2 instanceof ServerEntry) || !string2.equals(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    EList eList2 = serverEntry2.getSpecialEndpoints();
                    string2 = null;
                    String string3 = null;
                    Iterator iterator = eList2.iterator();
                    while (iterator.hasNext()) {
                        string2 = (NamedEndPoint)iterator.next();
                        string3 = string2.getEndPointName();
                        EndPoint endPoint = null;
                        String string4 = null;
                        String string5 = (String)map.get(string3);
                        if (string5 == null || string5.length() <= 0) continue;
                        endPoint = string2.getEndPoint();
                        string4 = new Integer(endPoint.getPort()).toString();
                        map2.put(string4, string5);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.webservices.deploy.DualMetaDataLoaderImpl.mapV6EndPoints2Ports", "1866");
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "mapV6EndPoints2Ports caught exeption ", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapV6EndPoints2Ports");
        }
        return map2;
    }

    private static Map loadHTTPPortsFromV5Template(Server server, List list, WebContainer webContainer, Map map) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "loadHTTPPortsFromV5Template");
            }
            try {
                Object object;
                EList eList = webContainer.getTransports();
                for (Object object2 : eList) {
                    EndPoint endPoint;
                    if (!(object2 instanceof HTTPTransport) || (endPoint = (object = (HTTPTransport)object2).getAddress()) == null) continue;
                    String string = new Integer(endPoint.getPort()).toString();
                    String string2 = object.isSslEnabled() ? "https" : "http";
                    map.put(string, string2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "loadHTTPPortsFromV5Template: for server \"" + server.getName() + "\" the container is [" + webContainer.toString() + "} and the portMap being returned has " + map.size() + " elements, which are:\n");
                    for (Object object2 : map.keySet()) {
                        object = (String)map.get(object2);
                        Tr.debug(tc, "\tport=" + (String)object2 + " protocol=" + (String)object);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.webservices.deploy.DualMetaDataLoaderImpl.loadHTTPPortsFromV5Template", "1694");
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "loadHTTPPortsFromV5Template caught exeption ", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadHTTPPortsfromV5Template");
        }
        return map;
    }

    private List getGeneratedWSDLFile(Definition definition) throws Exception {
        if (definition != null) {
            String string = definition.getDocumentBaseURI();
            if (string != null) {
                java.net.URI uRI = new java.net.URI(string);
                string = uRI.getPath();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found WSDL location for generated WSDL: " + string);
                }
                if (string != null && string.indexOf(uriPathSeparator) != -1) {
                    String string2 = this.getGeneratedWsdlXsdDirectory(definition);
                    if (string2 != null) {
                        CommonarchiveFactory commonarchiveFactory = (CommonarchiveFactory)EPackage.Registry.INSTANCE.getEPackage("http:///com/ibm/etools/commonarchive.ecore").getEFactoryInstance();
                        ReadOnlyDirectory readOnlyDirectory = commonarchiveFactory.openReadOnlyDirectory(string2);
                        EList eList = readOnlyDirectory.getFiles();
                        if (eList != null && !eList.isEmpty()) {
                            LinkedList<File> linkedList = new LinkedList<File>();
                            for (Object e : eList) {
                                File file = (File)e;
                                if (!file.getName().endsWith(".xsd") && !file.getName().endsWith(".wsdl")) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "loadWhirlModuleData: Adding genereated WSLD/XSD file: " + file.getName());
                                }
                                linkedList.add(file);
                            }
                            return linkedList;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Could not determine path to generated WSDL/XSD files");
                        }
                        return null;
                    }
                    return null;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not determine path to generated WSDL/XSD files");
                }
                return null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not determine path to generated WSDL/XSD files");
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Generated WSDL definition is not available");
        }
        return null;
    }

    private String getGeneratedWsdlXsdDirectory(Definition definition) throws Exception {
        String string = definition.getDocumentBaseURI();
        if (string != null) {
            java.net.URI uRI = new java.net.URI(string);
            if ((string = uRI.getPath()) != null) {
                return string.substring(0, string.lastIndexOf(uriPathSeparator) + 1);
            }
            return null;
        }
        return null;
    }

    private String getGeneratedWsdlFileName(Definition definition) throws Exception {
        String string = definition.getDocumentBaseURI();
        if (string != null) {
            java.net.URI uRI = new java.net.URI(string);
            if ((string = uRI.getPath()) != null) {
                return string.substring(string.lastIndexOf(uriPathSeparator) + 1, string.length());
            }
            return null;
        }
        return null;
    }
}

