/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.channelservice.channels.HTTPInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.SSLInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.TCPInboundChannel;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataEvent;
import com.ibm.ws.runtime.metadata.MetaDataListener;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.MetaDataService;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webcontainer.WebContainerService;
import com.ibm.ws.webcontainer.webapp.collaborator.WebAppCollaborator;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.binding.WSClassFinder;
import com.ibm.ws.websvcs.client.ClientConfigurationContextStore;
import com.ibm.ws.websvcs.collaborators.WebCollaborator;
import com.ibm.ws.websvcs.deployment.Axis2ServiceConfigPluginManager;
import com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder;
import com.ibm.ws.websvcs.deployment.WASAxis2MetaDataProcessor;
import com.ibm.ws.websvcs.deployment.WASAxis2PolicySetConfigurator;
import com.ibm.ws.websvcs.deployment.WASAxis2URISecurityConstrainer;
import com.ibm.ws.websvcs.exception.DeploymentException;
import com.ibm.ws.websvcs.extension.AsyncServletExtensionFactory;
import com.ibm.ws.websvcs.extension.WASAxis2ExtensionFactory;
import com.ibm.ws.websvcs.metadata.ServerModuleMetaData;
import com.ibm.ws.websvcs.metadata.WASAxis2MetaDataImpl;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.channel.WSChannelManager;
import com.ibm.ws.websvcs.transport.http.AsyncResponseServlet;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.websvcs.utils.WASAxis2ExecutorFactory;
import com.ibm.ws.websvcs.utils.WSResourceFinder;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.webcontainer.WebContainer;
import com.ibm.wsspi.websvcs.WASAxis2Service;
import com.ibm.wsspi.websvcs.runtime.JAXWSMetaDataListener;
import java.io.InputStream;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.message.factory.ClassFinderFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.utility.ExecutorFactory;
import org.apache.axis2.metadata.factory.ResourceFinderFactory;
import org.apache.axis2.metadata.registry.MetadataFactoryRegistry;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASAxis2ComponentImpl
extends WsComponentImpl
implements MetaDataListener,
Constants,
WASAxis2Service {
    private static final TraceComponent _tc = Tr.register(WASAxis2ComponentImpl.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private WASAxis2MetaDataImpl metadata = null;
    private Object compImplServiceKey = null;
    private ArrayList serverModuleFiles = new ArrayList();
    private ArrayList clientModuleFiles = new ArrayList();
    private ArrayList serverTCMPlugins = new ArrayList();
    private ArrayList clientTCMPlugins = new ArrayList();
    private ArrayList clientACMPlugins = new ArrayList();
    private ArrayList serverACMPlugins = new ArrayList();
    private ArrayList JAXWSMetaDataListeners = new ArrayList();
    private Axis2ServiceConfigPluginManager configManager;
    private VariableMap vmap = null;
    private Repository repository = null;
    private ClientConfigurationContextStore clientCCStore;
    private boolean initialized = false;
    private static Class transportChannelServicetype = TransportChannelService.class;
    private static Class type_sslChannel = SSLInboundChannel.class;
    private static Class type_httpChannel = HTTPInboundChannel.class;
    private static Class type_tcpChannel = TCPInboundChannel.class;

    public WASAxis2ComponentImpl() {
        this.setName("WASAxis2ComponentImpl");
    }

    @Override
    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        super.initialize(object);
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initialize");
        }
        try {
            this.compImplServiceKey = WsServiceRegistry.addService(this, WASAxis2Service.class);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Registered WASAxis2Service object.");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.initialize", "161", this);
            Object[] objectArray = new Object[]{this.getName(), exception};
            String string = NLSProvider.getNLS().getFormattedMessage("compInitFail00", objectArray, "Error occurred while attempting to initialize component {0}: {1}");
            Tr.error(_tc, "compInitFail00", objectArray);
            throw new ComponentDisabledException(string, exception);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "initialize");
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "destroy");
        }
        WsServiceRegistry.unregisterService(this.compImplServiceKey);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Unregistered WASAxis2Service object.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "destroy");
        }
    }

    private TransportChannelService getTransportChannelService(Server server) {
        EList eList = server.getServices();
        Object var3_32 = null;
        if (eList != null && eList.size() > 0) {
            for (Object var3_32 : eList) {
                if (!transportChannelServicetype.isInstance(var3_32)) continue;
                return var3_32;
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "TransportChannelService not found in server: " + server);
        }
        return null;
    }

    private Server getServer() {
        Server server;
        block2: {
            server = null;
            try {
                Repository repository = (Repository)WsServiceRegistry.getService(this, Repository.class);
                Resource resource = repository.getConfigRoot().getResource(4, "server.xml");
                Server server2 = (Server)resource.getContents().get(0);
                EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
                server = (Server)etoolsCopyUtility.copy((EObject)server2);
            }
            catch (Exception exception) {
                if (!_tc.isDebugEnabled()) break block2;
                Tr.debug(_tc, "Failed to load resource server.xml from process: " + exception.toString());
            }
        }
        return server;
    }

    private void listChannelTransports() {
        Hashtable hashtable;
        Hashtable hashtable2;
        Server server;
        block28: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "listChannelTransports");
            }
            server = this.getServer();
            hashtable2 = new Hashtable();
            hashtable = new Hashtable();
            TransportChannelService transportChannelService = this.getTransportChannelService(server);
            if (transportChannelService == null) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "listChannelTransports", "TransportChannelService is null");
                }
                return;
            }
            EndPointMgr endPointMgr = null;
            try {
                endPointMgr = (EndPointMgr)WsServiceRegistry.getService(this, EndPointMgr.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (endPointMgr == null) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "listChannelTransports", "EndPointMgr is null");
                }
                return;
            }
            try {
                EList eList = transportChannelService.getChains();
                if (eList != null && eList.size() > 0) {
                    for (Chain chain : eList) {
                        Object object;
                        EList eList2;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Looking at chain: " + chain.getName());
                        }
                        if ((eList2 = chain.getTransportChannels()) == null || eList2.size() <= 0) continue;
                        SSLInboundChannel sSLInboundChannel = null;
                        HTTPInboundChannel hTTPInboundChannel = null;
                        TCPInboundChannel tCPInboundChannel = null;
                        Object object2 = eList2.iterator();
                        while (object2.hasNext()) {
                            object = object2.next();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Looking at channel: " + ((TransportChannel)object).getName());
                            }
                            if (type_sslChannel.isInstance(object)) {
                                sSLInboundChannel = (SSLInboundChannel)object;
                            }
                            if (type_httpChannel.isInstance(object)) {
                                hTTPInboundChannel = (HTTPInboundChannel)object;
                            }
                            if (!type_tcpChannel.isInstance(object)) continue;
                            tCPInboundChannel = (TCPInboundChannel)object;
                        }
                        if (hTTPInboundChannel == null || tCPInboundChannel == null) continue;
                        if (sSLInboundChannel != null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Found SSL endpoint: " + tCPInboundChannel.getEndPointName());
                            }
                            if ((object2 = endPointMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPoint(tCPInboundChannel.getEndPointName())) == null) continue;
                            object = new Integer(object2.getPort());
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Found SSL port: " + object + " for host: " + object2.getHost());
                            }
                            hashtable2.put(object2.getHost(), object);
                            continue;
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Found HTTP endpoint: " + tCPInboundChannel.getEndPointName());
                        }
                        if ((object2 = endPointMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPoint(tCPInboundChannel.getEndPointName())) == null) continue;
                        object = new Integer(object2.getPort());
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Found HTTP port: " + object + " for host: " + object2.getHost());
                        }
                        hashtable.put(object2.getHost(), object);
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "No chains found in TransportChannelService in server.xml.");
                }
            }
            catch (Exception exception) {
                if (!_tc.isDebugEnabled()) break block28;
                Tr.debug(_tc, "Exception getting channel framework transports: ", new Object[]{exception.toString()});
            }
        }
        if (hashtable != null && !hashtable.isEmpty()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "httpPortsList: " + hashtable);
            }
            Tr.debug(_tc, "httpPortsList.size(): " + hashtable.size());
            AsyncResponseServlet.setHttpHostandPorts(hashtable);
        }
        if (hashtable2 != null && !hashtable2.isEmpty()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "sslPortsList: " + hashtable2);
            }
            AsyncResponseServlet.setHttpsHostandPorts(hashtable2);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "listChannelTransports", server);
        }
    }

    @Override
    public void start() throws RuntimeError, RuntimeWarning {
        super.start();
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "start");
        }
        try {
            WebContainerService webContainerService = this.getWebContainerService();
            if (webContainerService == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Web Container service not present, bypassing initialization...");
                }
                return;
            }
            MetaDataService metaDataService = this.getMetaDataService();
            this.metadata = new WASAxis2MetaDataImpl(metaDataService);
            metaDataService.addMetaDataListener(this);
            this.getWebContainerService().addWebAppCollaborator((WebAppCollaborator)new WebCollaborator());
            WASAxis2ExtensionFactory wASAxis2ExtensionFactory = new WASAxis2ExtensionFactory();
            WebContainer.registerExtensionFactory(wASAxis2ExtensionFactory);
            AsyncServletExtensionFactory asyncServletExtensionFactory = new AsyncServletExtensionFactory();
            WebContainer.registerExtensionFactory(asyncServletExtensionFactory);
            Tr.info(_tc, "wasAxis2ServiceStarted");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.start", "232", this);
            throw new RuntimeWarning(exception);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "start");
            }
        }
    }

    private void initComponent() {
        if (!this.initialized) {
            this.initialized = true;
            this.configManager = new Axis2ServiceConfigPluginManager();
            this.configManager.discoverAxis2ServiceConfigPlugins(true);
            WSChannelManager.getInstance().setManagedRuntime(true);
            this.clientCCStore = new ClientConfigurationContextStore();
            this.displaySVNInfo();
            this.listChannelTransports();
            ClassFinderFactory classFinderFactory = new ClassFinderFactory();
            classFinderFactory.setClassFinder(new WSClassFinder());
            FactoryRegistry.setFactory(ClassFinderFactory.class, classFinderFactory);
            ResourceFinderFactory resourceFinderFactory = new ResourceFinderFactory();
            resourceFinderFactory.setResourceFinder(new WSResourceFinder());
            MetadataFactoryRegistry.setFactory(ResourceFinderFactory.class, resourceFinderFactory);
            WASAxis2ExecutorFactory wASAxis2ExecutorFactory = WASAxis2ExecutorFactory.newInstance();
            FactoryRegistry.setFactory(ExecutorFactory.class, wASAxis2ExecutorFactory);
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stop");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stop");
        }
    }

    @Override
    public void metaDataCreated(MetaDataEvent metaDataEvent) throws RuntimeWarning, RuntimeError {
        if (metaDataEvent.getMetaData() instanceof ModuleMetaData) {
            DeployedObject deployedObject = metaDataEvent.getDeployedObject();
            ModuleFile moduleFile = deployedObject.getModuleFile();
            EARFile eARFile = moduleFile.getEARFile();
            if (eARFile != null) {
                if (eARFile.containsFile("META-INF/ibm-application-sa.props") || eARFile.containsFile("META-INF/ibm-application-sa2.props")) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Annotation metadata for module " + moduleFile.getName() + " in application " + eARFile.getName() + " will not be" + " processed because the application is a system application");
                    }
                } else if (moduleFile.isWARFile()) {
                    try {
                        this.warMetaDataCreated(metaDataEvent);
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeWarning(throwable);
                    }
                }
            } else if (moduleFile.isWARFile()) {
                try {
                    this.warMetaDataCreated(metaDataEvent);
                }
                catch (Throwable throwable) {
                    throw new RuntimeWarning(throwable);
                }
            }
        }
    }

    @Override
    public void metaDataDestroyed(MetaDataEvent metaDataEvent) {
        Object[] objectArray;
        Object object;
        Object object2;
        if (metaDataEvent.getMetaData() instanceof ModuleMetaData && (object2 = (object = metaDataEvent.getDeployedObject()).getModuleFile()).isWARFile()) {
            try {
                this.warMetaDataDestroyed(metaDataEvent);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.metaDataDestroyed", "293", this);
                objectArray = new Object[]{object.getName(), throwable};
                Tr.error(_tc, "unloadModuleFail00", objectArray);
            }
        }
        if ((object = metaDataEvent.getDeployedObject().getModuleFile()).isWARFile() || object.isEJBJarFile()) {
            object2 = object.getName();
            String string = this.getApplicationName((ModuleFile)object);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Looking for client ConfigurationContext objects for module: " + (String)object2 + " and app name: " + string);
            }
            if ((objectArray = this.getClientConfigurationContexts(string, (String)object2)) != null && !objectArray.isEmpty()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "For module: " + (String)object2 + " and application: " + string + ", " + objectArray.size() + " client ConfigurationContext objects " + "were found.");
                }
                this.terminateClientConfigurationContexts((List<ConfigurationContext>)objectArray);
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "No client ConfigurationContext objects found for module: " + (String)object2 + " and app name: " + string);
            }
        }
    }

    @Override
    public ConfigurationContext loadAxis2ConfigurationContext(String string, String string2) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadAxisConfigTemplate");
        }
        AxisConfiguration axisConfiguration = null;
        ConfigurationContext configurationContext = null;
        WASAxis2ConfigurationBuilder wASAxis2ConfigurationBuilder = new WASAxis2ConfigurationBuilder(this.serverModuleFiles, this.clientModuleFiles, this.serverTCMPlugins, this.clientTCMPlugins, this.serverACMPlugins, this.clientACMPlugins);
        try {
            axisConfiguration = wASAxis2ConfigurationBuilder.loadAxisServerConfiguration();
            configurationContext = ConfigurationContextFactory.createEmptyConfigurationContext();
            configurationContext.setAxisConfiguration(axisConfiguration);
            this.setConfigParams(axisConfiguration, string, string2);
            if (axisConfiguration == null) {
                Object[] objectArray = new Object[]{string2};
                String string3 = NLSProvider.getNLS().getFormattedMessage("axisCfgNull00", objectArray, "''Axis Configuration'' for the application module {0} is null.");
                throw new Exception(string3);
            }
            wASAxis2ConfigurationBuilder.loadAxisServerModules(axisConfiguration, configurationContext);
            wASAxis2ConfigurationBuilder.loadAxisServerTCMPlugins(configurationContext);
            wASAxis2ConfigurationBuilder.loadAxisServerACMPlugins(configurationContext);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.loadAxis2ConfigurationContext", "329", this);
            Object[] objectArray = new Object[]{string2, throwable};
            String string4 = NLSProvider.getNLS().getFormattedMessage("axisConfFail00", objectArray, "Error occurred while attempting to create the ''AxisConfiguration'' for application module {0}: {1}");
            Tr.error(_tc, "axisConfFail00", objectArray);
            throw new Exception(string4, throwable);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "loadAxisConfigTemplate");
            }
        }
        return configurationContext;
    }

    private void warMetaDataCreated(MetaDataEvent metaDataEvent) throws Exception {
        block11: {
            DeployedObject deployedObject = metaDataEvent.getDeployedObject();
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "warMetaDataCreated, module = " + deployedObject.getModuleFile().getName());
            }
            this.initComponent();
            WASAxis2MetaDataProcessor wASAxis2MetaDataProcessor = new WASAxis2MetaDataProcessor(metaDataEvent.getDeployedObject());
            try {
                ConfigurationContext configurationContext = wASAxis2MetaDataProcessor.processApplicationMetaData();
                if (configurationContext != null) {
                    try {
                        this.completeAxis2Configuration(configurationContext, metaDataEvent);
                        WebApp webApp = (WebApp)metaDataEvent.getDeployedObject().getDeploymentDescriptor();
                        WASAxis2URISecurityConstrainer wASAxis2URISecurityConstrainer = new WASAxis2URISecurityConstrainer(configurationContext, webApp);
                        wASAxis2URISecurityConstrainer.constrainURIs();
                        this.driveJAXWSMetaDataListeners(true, metaDataEvent, configurationContext);
                        break block11;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.warMetaDataCreated", "379", this);
                        Object[] objectArray = new Object[]{deployedObject.getName(), exception};
                        Tr.error(_tc, "loadAppMetaFail00", objectArray);
                        throw exception;
                    }
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "No ibmservices.xml or @WebService annotations were found within the module: " + deployedObject.getName());
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.warMetaDataCreated", "397", this);
                Object[] objectArray = new Object[]{deployedObject.getName(), exception};
                Tr.error(_tc, "loadModuleFail00", objectArray);
                throw exception;
            }
            finally {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "warMetadataCreated");
                }
            }
        }
    }

    private void warMetaDataDestroyed(MetaDataEvent metaDataEvent) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "warMetaDataDestroyed");
        }
        Object object = this.getModuleMetaData(metaDataEvent);
        ServerModuleMetaData serverModuleMetaData = null;
        if (object != null && object instanceof ServerModuleMetaData) {
            serverModuleMetaData = (ServerModuleMetaData)object;
        }
        if (serverModuleMetaData != null) {
            if (_tc.isDebugEnabled() && metaDataEvent.getDeployedObject() != null) {
                Tr.debug(_tc, "Shutting down module metadata for module " + metaDataEvent.getDeployedObject().getName());
            }
            ConfigurationContext configurationContext = serverModuleMetaData.getConfigurationContext();
            this.shutdownModules(configurationContext);
            this.driveJAXWSMetaDataListeners(false, metaDataEvent, configurationContext);
            serverModuleMetaData.setConfigurationContext(null);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "warMetaDataDestroyed");
        }
    }

    private MetaDataService getMetaDataService() {
        try {
            return (MetaDataService)WsServiceRegistry.getService(this, MetaDataService.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.getMetaDataService", "471", this);
            Object[] objectArray = new Object[]{this.getName(), exception};
            Tr.error(_tc, "metaDataSvcFail00", objectArray);
            return null;
        }
    }

    @Override
    public Object getModuleMetaData() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getModuleMetaData");
        }
        Object object = this.metadata.getServerModuleMetaData();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getModuleMetaData");
        }
        return object;
    }

    public Object getModuleMetaData(MetaDataEvent metaDataEvent) {
        MetaData metaData;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getModuleMetaData");
        }
        Object object = null;
        if (metaDataEvent.getDeployedObject() != null && (metaData = metaDataEvent.getDeployedObject().getMetaData()) != null && metaData instanceof ModuleMetaData) {
            ModuleMetaData moduleMetaData = (ModuleMetaData)metaData;
            object = moduleMetaData.getMetaData(this.metadata.getMetaDataSlot());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getModuleMetaData");
        }
        return object;
    }

    @Override
    public Object getModuleMetaDataSlot() {
        return this.metadata.getMetaDataSlot();
    }

    public WebContainerService getWebContainerService() {
        try {
            return (WebContainerService)WsServiceRegistry.getService(this, WebContainerService.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.getWebContainerService", "514", this);
            Object[] objectArray = new Object[]{this.getName()};
            Tr.error(_tc, "noWebCntrSvc00", objectArray);
            return null;
        }
    }

    public VariableMap getVariableMapService() {
        try {
            if (this.vmap == null) {
                this.vmap = (VariableMap)WsServiceRegistry.getService(this, VariableMap.class);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.getVariableMapService", "534", this);
            Object[] objectArray = new Object[]{this.getName()};
            Tr.error(_tc, "noVarMapSvc00", objectArray);
        }
        return this.vmap;
    }

    public Repository getRepositoryService() {
        try {
            if (this.repository == null) {
                this.repository = (Repository)WsServiceRegistry.getService(this, Repository.class);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.getRepositoryService", "554", this);
            Object[] objectArray = new Object[]{this.getName()};
            Tr.error(_tc, "noRepoSvc00", objectArray);
        }
        return this.repository;
    }

    private void setConfigParams(AxisConfiguration axisConfiguration, String string, String string2) throws AxisFault {
        Axis2Utils.setApplicationName(axisConfiguration, string);
        Axis2Utils.setModuleName(axisConfiguration, string2);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Application name parameter added to AxisConfiguration: " + string);
            Tr.debug(_tc, "Module name parameter added to AxisConfiguration: " + string2);
        }
    }

    @Override
    public ConfigurationContext loadAxis2ConfigurationContext(MetaDataEvent metaDataEvent) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadAxis2ConfigurationContext");
        }
        DeployedObject deployedObject = metaDataEvent.getDeployedObject();
        ModuleMetaData moduleMetaData = (ModuleMetaData)deployedObject.getMetaData();
        String string = moduleMetaData.getApplicationMetaData().getName();
        String string2 = deployedObject.getName();
        ConfigurationContext configurationContext = this.loadAxis2ConfigurationContext(string, string2);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadAxis2ConfigurationContext");
        }
        return configurationContext;
    }

    @Override
    public void completeAxis2Configuration(ConfigurationContext configurationContext, MetaDataEvent metaDataEvent) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "completeAxis2ConfigurationContext");
        }
        DeployedObject deployedObject = metaDataEvent.getDeployedObject();
        ModuleMetaData moduleMetaData = (ModuleMetaData)deployedObject.getMetaData();
        String string = moduleMetaData.getApplicationMetaData().getName();
        String string2 = deployedObject.getName();
        ClassLoader classLoader = deployedObject.getClassLoader();
        deployedObject.getClassLoader();
        WASAxis2PolicySetConfigurator wASAxis2PolicySetConfigurator = new WASAxis2PolicySetConfigurator(classLoader, ClassLoader.getSystemClassLoader());
        wASAxis2PolicySetConfigurator.associatePolicySets(configurationContext, this.configManager);
        ServerModuleMetaData serverModuleMetaData = new ServerModuleMetaData(string, string2);
        serverModuleMetaData.setConfigurationContext(configurationContext);
        this.metadata.setServerModuleMetaData(moduleMetaData, serverModuleMetaData);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "completeAxis2ConfigurationContext");
        }
    }

    private void driveJAXWSMetaDataListeners(boolean bl, MetaDataEvent metaDataEvent, ConfigurationContext configurationContext) throws DeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "driveJAXWSMetaDataListeners");
        }
        for (int i = 0; i < this.JAXWSMetaDataListeners.size(); ++i) {
            JAXWSMetaDataListener jAXWSMetaDataListener = (JAXWSMetaDataListener)this.JAXWSMetaDataListeners.get(i);
            if (bl) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Metadata created for JAXWSMetaDataListener: " + jAXWSMetaDataListener.toString());
                }
                jAXWSMetaDataListener.metaDataCreated(metaDataEvent, configurationContext);
                continue;
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Metadata destroyed for JAXWSMetaDataListener: " + jAXWSMetaDataListener.toString());
            }
            jAXWSMetaDataListener.metaDataDestroyed(metaDataEvent, configurationContext);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "driveJAXWSMetaDataListeners");
        }
    }

    @Override
    public void addJAXWSMetaDataListener(JAXWSMetaDataListener jAXWSMetaDataListener) {
        int n;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addJAXWSMetaDataListener");
        }
        if ((n = this.getJAXWSMDLIndex(jAXWSMetaDataListener)) == -1) {
            this.JAXWSMetaDataListeners.add(jAXWSMetaDataListener);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "JAXWSMetaDataListener already exists. This listener will not be registered.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addJAXWSMetaDataListener");
        }
    }

    @Override
    public void removeJAXWSMetaDataListener(JAXWSMetaDataListener jAXWSMetaDataListener) {
        int n;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "removeJAXWSMetaDataListener");
        }
        if ((n = this.getJAXWSMDLIndex(jAXWSMetaDataListener)) >= 0) {
            this.JAXWSMetaDataListeners.remove(n);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "JAXWSMetaDataListener does not exist. No listener was unregistered.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "removeJAXWSMetaDataListener");
        }
    }

    private int getJAXWSMDLIndex(JAXWSMetaDataListener jAXWSMetaDataListener) {
        for (int i = 0; i < this.JAXWSMetaDataListeners.size(); ++i) {
            JAXWSMetaDataListener jAXWSMetaDataListener2 = (JAXWSMetaDataListener)this.JAXWSMetaDataListeners.get(i);
            if (jAXWSMetaDataListener != jAXWSMetaDataListener2) continue;
            return i;
        }
        return -1;
    }

    private void shutdownModules(ConfigurationContext configurationContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "shutdownModules");
        }
        if (configurationContext != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Trying to stop Axis2 modules");
            }
            try {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Configuration Context: " + configurationContext.toString());
                }
                configurationContext.terminate();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Successfully stopped Axis2 modules");
                }
            }
            catch (AxisFault axisFault) {
                FFDCFilter.processException((Throwable)axisFault, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.shutdownModules", "790", this);
                Tr.warning(_tc, "Error occurred during shutdown of Axis2 modules: " + axisFault.toString());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "shutdownModules");
        }
    }

    private void displaySVNInfo() {
        try {
            if (_tc.isDebugEnabled()) {
                String string;
                byte[] byArray;
                ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                InputStream inputStream = classLoader.getResourceAsStream("info/axis2_apache_svn_info.txt");
                if (inputStream != null) {
                    byArray = new byte[inputStream.available()];
                    inputStream.read(byArray);
                    string = new String(byArray);
                    Tr.debug(_tc, "*** Begin contents of axis2_apache_svn_info ***");
                    Tr.debug(_tc, string);
                    Tr.debug(_tc, "*** End contents of axis2_apache_svn_info ***");
                    inputStream.close();
                }
                if ((inputStream = classLoader.getResourceAsStream("info/axis2_svn_info.txt")) != null) {
                    byArray = new byte[inputStream.available()];
                    inputStream.read(byArray);
                    string = new String(byArray);
                    Tr.debug(_tc, "*** Begin contents of axis2_svn_info ***");
                    Tr.debug(_tc, string);
                    Tr.debug(_tc, "*** End contents of axis2_svn_info ***");
                    inputStream.close();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    public void addClientConfigurationContext(ConfigurationContext configurationContext) {
        if (this.clientCCStore == null) {
            this.clientCCStore = new ClientConfigurationContextStore();
        }
        this.clientCCStore.addConfigurationContext(configurationContext);
    }

    @Override
    public List<ConfigurationContext> getClientConfigurationContexts(String string, String string2) {
        if (this.clientCCStore == null) {
            return null;
        }
        return this.clientCCStore.getConfigurationContexts(string, string2);
    }

    private void terminateClientConfigurationContexts(List<ConfigurationContext> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            try {
                ConfigurationContext configurationContext = list.get(i);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Configuration Context: " + configurationContext.toString());
                    Tr.debug(_tc, "Removing configContext from async servlet's rsp context...");
                }
                AsyncResponseServlet.getInstance().removeCCFromRspMap(configurationContext);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Shutting down client ConfigurationContext: " + configurationContext.toString());
                }
                configurationContext.terminate();
                list.remove(i);
                continue;
            }
            catch (AxisFault axisFault) {
                Tr.warning(_tc, "A problem occurred shutting down a client ConfigurationContext instance: " + axisFault.toString());
            }
        }
    }

    private String getApplicationName(ModuleFile moduleFile) {
        return moduleFile.getContainer() != null ? moduleFile.getContainer().getName() : null;
    }
}

