/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.command;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.command.WSCommandUtils;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.util.Hashtable;
import javax.management.ObjectName;

public class WSUpdateARSTask
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(WSUpdateARSTask.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public WSUpdateARSTask(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public WSUpdateARSTask(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        this.setCommandResult(commandResultImpl);
        commandResultImpl.reset();
        try {
            String string = Axis2Utils.getCellName();
            String string2 = (String)this.getParameter("nodeName");
            ConfigService configService = this.getConfigService();
            Session session = this.getConfigSession();
            if (string2 == null || "".equals(string2)) {
                ObjectName objectName;
                ObjectName[] objectNameArray;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Node name not specified to upgradeARSConfig, so the entire configuration for the " + string + " will be inspected");
                }
                if ((objectNameArray = configService.queryConfigObjects(session, null, objectName = ConfigServiceHelper.createObjectName(null, "Node"), null)) != null) {
                    for (ObjectName objectName2 : objectNameArray) {
                        this.processNode(string, objectName2, configService, session);
                    }
                }
            } else {
                ObjectName objectName = configService.resolve(session, "Node=" + string2)[0];
                if (objectName != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The " + string2 + " node in the " + string + " cell will be examined " + "by the updateARSConfig command");
                    }
                    this.processNode(string, objectName, configService, session);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The " + string2 + " node in the " + string + " cell will not be " + "examined because an ObjectName could not be found");
                }
            }
            commandResultImpl.setResult("IBM Asynchronous Response Servlet properly configured");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.commandWSUpdateARSTask.execute", "119", this);
            commandResultImpl.setException(throwable);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute");
            }
        }
    }

    void processNode(String string, ObjectName objectName, ConfigService configService, Session session) throws Exception {
        ObjectName objectName2;
        ObjectName[] objectNameArray;
        WSCommandUtils wSCommandUtils = new WSCommandUtils();
        String string2 = (String)configService.getAttribute(session, objectName, "name");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing node: " + string2 + " in cell: " + string);
        }
        if ((objectNameArray = configService.queryConfigObjects(session, objectName, objectName2 = ConfigServiceHelper.createObjectName(null, "Server"), null)) != null) {
            for (ObjectName objectName3 : objectNameArray) {
                String string3 = (String)configService.getAttribute(session, objectName3, "name");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing server: " + string3);
                }
                String string4 = (String)configService.getAttribute(session, objectName3, "clusterName");
                boolean bl = this.isNodeAgentOrDmgr(configService, objectName3, session);
                if (bl) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The " + string3 + " is not a DeploymentManager or " + "NodeAgent server");
                }
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("server.name", string3);
                hashtable.put("node.name", string2);
                hashtable.put("cell.name", string);
                if (string4 != null) {
                    if (!wSCommandUtils.installARSToCluster(string4, configService, session, null)) continue;
                    AppManagement appManagement = wSCommandUtils.getAppMgmtObject(configService);
                    if (appManagement.checkIfAppExists("ibmasyncrsp", hashtable, session.toString())) {
                        wSCommandUtils.removeInvalidTarget(configService, session, hashtable);
                    }
                    hashtable.put("cluster.name", string4);
                    wSCommandUtils.installApplication(hashtable, configService, session, this.isLocalMode());
                    continue;
                }
                wSCommandUtils.installApplication(hashtable, configService, session, this.isLocalMode());
            }
        }
    }

    boolean isNodeAgentOrDmgr(ConfigService configService, ObjectName objectName, Session session) throws Exception {
        ObjectName objectName2;
        ObjectName[] objectNameArray;
        boolean bl = false;
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, "NodeAgent");
        ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectName, objectName3, null);
        if (objectNameArray2 != null && objectNameArray2.length > 0) {
            bl = true;
        }
        if (!bl && (objectNameArray = configService.queryConfigObjects(session, objectName, objectName2 = ConfigServiceHelper.createObjectName(null, "CellManager"), null)) != null && objectNameArray.length > 0) {
            bl = true;
        }
        return bl;
    }
}

