/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.command;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.websvcs.command.WSCommandUtils;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.wsspi.configarchive.ConfigArchiveCommand;
import com.ibm.wsspi.configarchive.ImportStep;
import java.util.Hashtable;
import java.util.SortedMap;
import javax.management.ObjectName;

public class WSImportCommandExt
extends ImportStep {
    private static final TraceComponent _tc = Tr.register(WSImportCommandExt.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public WSImportCommandExt(AbstractTaskCommand abstractTaskCommand, CommandData commandData) throws CommandNotFoundException {
        super(abstractTaskCommand, commandData);
    }

    public WSImportCommandExt(AbstractTaskCommand abstractTaskCommand, CommandMetadata commandMetadata) {
        super(abstractTaskCommand, commandMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeStep() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "executeStep");
        }
        try {
            String string = (String)this.taskCmd.getParameter("nodeName");
            ManagedObjectMetadataHelper managedObjectMetadataHelper = ((ConfigArchiveCommand)this.taskCmd).getConfigArchiveMetadataHelper();
            SortedMap sortedMap = managedObjectMetadataHelper.getNodeProductVersions(string);
            String string2 = managedObjectMetadataHelper.getNodeBaseProductVersion(string);
            if (sortedMap != null && sortedMap.get("WS FEP") != null) {
                ObjectName[] objectNameArray;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found feature pack enabled node: " + string + " at version: " + string2);
                }
                Session session = this.getConfigSession();
                ConfigService configService = ConfigServiceFactory.getConfigService();
                ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Node", string);
                ObjectName objectName2 = configService.queryConfigObjects(session, null, objectName, null)[0];
                objectName = ConfigServiceHelper.createObjectName(null, "Server");
                for (ObjectName objectName3 : objectNameArray = configService.queryConfigObjects(session, objectName2, objectName, null)) {
                    String string3;
                    String string4 = ConfigServiceHelper.getDisplayName(objectName3);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "serverName", new Object[]{string, objectName3, string4});
                    }
                    CommandMgr commandMgr = CommandMgr.getCommandMgr();
                    AdminCommand adminCommand = commandMgr.createCommand("getServerType");
                    adminCommand.setConfigSession(session);
                    adminCommand.setParameter("serverName", string4);
                    adminCommand.setParameter("nodeName", string);
                    adminCommand.execute();
                    CommandResult commandResult = adminCommand.getCommandResult();
                    if (!commandResult.isSuccessful() || !(string3 = (String)commandResult.getResult()).equals("APPLICATION_SERVER")) continue;
                    String string5 = ConfigServiceHelper.getObjectLocation(objectName3).getProperty("cell");
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Found app server: " + string4 + " on cell: " + string5 + " node: " + string);
                    }
                    Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                    if (WSCommandUtils.useOldARSConfig(string2)) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "The ARS application will use the WSFP binaries location");
                        }
                        hashtable.put("ASYNC_USE_OLD_CONFIG", Boolean.TRUE);
                    }
                    hashtable.put("cell.name", string5);
                    hashtable.put("node.name", string);
                    hashtable.put("server.name", string4);
                    hashtable.put("server", string4);
                    hashtable.put("META-INF/ibm-application-ha.props", true);
                    hashtable.put("target", string4);
                    hashtable.put("META-INF/ibm-application-sa.props", false);
                    WSCommandUtils wSCommandUtils = new WSCommandUtils();
                    wSCommandUtils.installApplication(hashtable, this.getConfigService(), session, this.isLocalMode());
                }
            }
        }
        catch (Throwable throwable) {
            String string = NLSProvider.getNLS().getFormattedMessage("sysappinstallfail00", new Object[]{throwable}, "The ibmasyncrsp.ear system application could not be installed due to the following error: {0}");
            Tr.error(_tc, string);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "executeStep");
            }
        }
    }
}

