/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.command;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.websvcs.command.WSCommandUtils;
import com.ibm.ws.websvcs.resources.NLSProvider;
import java.util.Hashtable;
import java.util.Properties;
import java.util.SortedMap;
import javax.management.ObjectName;

public class WSDeleteClusterMemberExt
extends AbstractCommandStep {
    private static final TraceComponent _tc = Tr.register(WSDeleteClusterMemberExt.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public WSDeleteClusterMemberExt(AbstractTaskCommand abstractTaskCommand, CommandMetadata commandMetadata) {
        super(abstractTaskCommand, commandMetadata);
    }

    public WSDeleteClusterMemberExt(AbstractTaskCommand abstractTaskCommand, CommandData commandData) throws CommandNotFoundException {
        super(abstractTaskCommand, commandData);
    }

    protected void executeStep() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "executeStep");
        }
        try {
            Session session = this.getConfigSession();
            ConfigService configService = this.getConfigService();
            String string = (String)this.taskCmd.getParameter("clusterName");
            if (string != null) {
                String string2 = (String)this.taskCmd.getParameter("memberName");
                String string3 = null;
                String string4 = null;
                WSCommandUtils wSCommandUtils = new WSCommandUtils();
                ObjectName objectName = this.getServerON(wSCommandUtils.getClusterMemberObjs(string, configService, session), string2);
                if (objectName != null) {
                    string3 = (String)this.taskCmd.getParameter("memberNode");
                    string4 = ConfigServiceHelper.getObjectLocation(objectName).getProperty("cell");
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Server: " + string2 + ", on node: " + string3 + " is being removed " + "from cluster: " + string);
                    }
                    Properties properties = new Properties();
                    ManagedObjectMetadataAccessor managedObjectMetadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(properties);
                    ManagedObjectMetadataHelper managedObjectMetadataHelper = new ManagedObjectMetadataHelper(managedObjectMetadataAccessor);
                    SortedMap sortedMap = managedObjectMetadataHelper.getNodeProductVersions(string3);
                    String string5 = managedObjectMetadataHelper.getNodeBaseProductVersion(string3);
                    if (sortedMap != null && sortedMap.get("WS FEP") == null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "The server: " + string2 + " is a non-WSFP server");
                        }
                        if (wSCommandUtils.installARSToCluster(string, configService, session, string2)) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "After removing server: " + string2 + " from cluster: " + string + " the IBM asynchronous response servlet application " + "will be installed");
                            }
                            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                            if (WSCommandUtils.useOldARSConfig(string5)) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "The ARS application will use the WSFP binaries location");
                                }
                                hashtable.put("ASYNC_USE_OLD_CONFIG", Boolean.TRUE);
                            }
                            hashtable.put("cell.name", string4);
                            hashtable.put("node.name", string3);
                            hashtable.put("META-INF/ibm-application-ha.props", true);
                            hashtable.put("target", string);
                            hashtable.put("META-INF/ibm-application-sa.props", false);
                            hashtable.put("cluster.name", string);
                            wSCommandUtils.installApplication(hashtable, configService, session, this.isLocalMode());
                        }
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "No action needed in WSDeleteServerExt");
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Could not find ObjectName instance for member being removed. The member being removed is not a server.");
                }
            }
        }
        catch (Throwable throwable) {
            String string = NLSProvider.getNLS().getFormattedMessage("sysappinstallfail00", new Object[]{throwable}, "The ibmasyncrsp.ear system application could not be installed due to the following error: {0}");
            Tr.error(_tc, string);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "executeStep");
        }
    }

    private ObjectName getServerON(ObjectName[] objectNameArray, String string) throws Exception {
        if (objectNameArray != null && objectNameArray.length > 0) {
            for (ObjectName objectName : objectNameArray) {
                String string2 = ConfigServiceHelper.getDisplayName(objectName);
                if (!string.equals(string2)) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found ObjectName for server: " + string2 + " being removed from the cluster");
                }
                return objectName;
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "No server members were found in the cluster");
        }
        return null;
    }
}

