/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.command;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.websvcs.command.WSCommandUtils;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.wsspi.websvcs.Constants;
import java.util.Hashtable;
import java.util.Properties;
import java.util.SortedMap;
import javax.management.ObjectName;

public class WSCreateServerExt
extends AbstractCommandStep {
    private static final TraceComponent _tc = Tr.register(WSCreateServerExt.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public WSCreateServerExt(AbstractTaskCommand abstractTaskCommand, CommandMetadata commandMetadata) {
        super(abstractTaskCommand, commandMetadata);
    }

    public WSCreateServerExt(AbstractTaskCommand abstractTaskCommand, CommandData commandData) throws CommandNotFoundException {
        super(abstractTaskCommand, commandData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeStep() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "executeStep");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Attempting to install ibmasyncrsp.ear from the following location: " + Constants.ASYNC_RSP_SYS_APP_PATH_EXTRACTED);
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            String string4;
            ObjectName objectName = (ObjectName)this.taskCmd.getCommandResult().getResult();
            string2 = ConfigServiceHelper.getObjectLocation(objectName).getProperty("node");
            string3 = ConfigServiceHelper.getObjectLocation(objectName).getProperty("cell");
            string = ConfigServiceHelper.getDisplayName(objectName);
            Session session = this.getConfigSession();
            ConfigService configService = this.getConfigService();
            Properties properties = new Properties();
            ManagedObjectMetadataAccessor managedObjectMetadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(properties);
            ManagedObjectMetadataHelper managedObjectMetadataHelper = new ManagedObjectMetadataHelper(managedObjectMetadataAccessor);
            String string5 = managedObjectMetadataHelper.getNodeBaseProductVersion(string2);
            SortedMap sortedMap = managedObjectMetadataHelper.getNodeProductVersions(string2);
            if (sortedMap != null && sortedMap.get("WS FEP") != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Node: " + string2 + " is a feature pack enabled node");
                }
                String string6 = (String)this.taskCmd.getParameter("clusterName");
                WSCommandUtils wSCommandUtils = new WSCommandUtils();
                if (string6 != null && !wSCommandUtils.installARSToCluster(string6, configService, session, null)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "The IBM asynchronous response servlet will not be installed to the cluster: " + string6);
                    }
                } else {
                    Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                    if (WSCommandUtils.useOldARSConfig(string5)) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "The ARS application will use the WSFP binaries location");
                        }
                        hashtable.put("ASYNC_USE_OLD_CONFIG", Boolean.TRUE);
                    }
                    hashtable.put("cell.name", string3);
                    hashtable.put("node.name", string2);
                    hashtable.put("server.name", string);
                    hashtable.put("server", string);
                    hashtable.put("META-INF/ibm-application-ha.props", true);
                    hashtable.put("target", string);
                    hashtable.put("META-INF/ibm-application-sa.props", false);
                    if (string6 != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Server: " + string + " is part of cluster: " + string6);
                        }
                        hashtable.put("cluster.name", string6);
                    }
                    wSCommandUtils.installApplication(hashtable, configService, session, this.isLocalMode());
                }
            } else if (sortedMap != null && (string4 = (String)this.taskCmd.getParameter("clusterName")) != null) {
                WSCommandUtils wSCommandUtils = new WSCommandUtils();
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put("cell.name", string3);
                hashtable.put("node.name", string2);
                hashtable.put("server.name", string);
                hashtable.put("server", string);
                hashtable.put("META-INF/ibm-application-ha.props", true);
                hashtable.put("target", string);
                hashtable.put("META-INF/ibm-application-sa.props", false);
                hashtable.put("cluster.name", string4);
                if (wSCommandUtils.uninstallARSFromCluster(configService, session, hashtable)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Uninstalling the asynchronous response servlet application from the cluster: " + string4);
                    }
                    wSCommandUtils.uninstallApplication(hashtable, configService, session, this.isLocalMode());
                }
            }
        }
        catch (Throwable throwable) {
            String string7 = NLSProvider.getNLS().getFormattedMessage("sysappinstallfail00", new Object[]{throwable}, "The ibmasyncrsp.ear system application could not be installed due to the following error: {0}");
            Tr.error(_tc, string7);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "executeStep");
            }
        }
    }
}

