/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.command;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.management.application.client.MapModulesToServers;
import com.ibm.ws.management.util.Utils;
import com.ibm.wsspi.websvcs.Constants;
import java.util.Hashtable;
import java.util.Set;
import java.util.SortedMap;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class WSCommandUtils {
    private static final TraceComponent _tc = Tr.register(WSCommandUtils.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public int getMappingIndex(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.get(i);
            if (!(e instanceof MapModulesToServers)) continue;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found application mapping object");
            }
            return i;
        }
        return -1;
    }

    public static boolean useOldARSConfig(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "useOldARSConfig");
        }
        boolean bl = false;
        if (Utils.compareVersions((String)string, (String)"6.1.0.19") < 0) {
            bl = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "useOldARSConfig= " + String.valueOf(bl));
        }
        return bl;
    }

    public void addNewTarget(MapModulesToServers mapModulesToServers, String string, String string2, String string3, String string4) throws AppDeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addNewTarget");
        }
        String[][] stringArray = mapModulesToServers.getTaskData();
        String[] stringArray2 = stringArray[stringArray.length - 1];
        String string5 = "";
        if (string4 == null) {
            string5 = "WebSphere:cell=" + string + ",node=" + string2 + ",server=" + string3;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Added new server target: " + string5);
            }
        } else {
            string5 = "WebSphere:cell=" + string + ",cluster=" + string4;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Added new cluster target: " + string5);
            }
        }
        if (stringArray2[2] != null && !"".equals(stringArray2[2])) {
            if (!this.targetExists(string5, stringArray2[2])) {
                stringArray2[2] = stringArray2[2] + "+" + string5;
            }
        } else {
            stringArray2[2] = string5;
        }
        stringArray[stringArray.length - 1] = stringArray2;
        mapModulesToServers.setTaskData(stringArray);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addNewTarget= " + stringArray2[2]);
        }
    }

    void removeInvalidTarget(ConfigService configService, Session session, Hashtable hashtable) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "removeInvalidTarget");
        }
        AppManagement appManagement = this.getAppMgmtObject(configService);
        Vector vector = appManagement.getApplicationInfo("ibmasyncrsp", hashtable, session.toString());
        String string = (String)hashtable.get("server.name");
        String string2 = (String)hashtable.get("node.name");
        String string3 = (String)hashtable.get("cell.name");
        int n = this.getMappingIndex(vector);
        MapModulesToServers mapModulesToServers = (MapModulesToServers)vector.get(n);
        String[][] stringArray = mapModulesToServers.getTaskData();
        String[] stringArray2 = stringArray[stringArray.length - 1];
        String string4 = stringArray2[2];
        String string5 = "WebSphere:cell=" + string3 + ",node=" + string2 + ",server=" + string;
        if (this.targetExists(string5, stringArray2[2])) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Removing invalid target for ARS application: " + string5);
            }
            stringArray2[2] = this.removeTarget(string5, stringArray2[2]);
            stringArray[stringArray.length - 1] = stringArray2;
            mapModulesToServers.setTaskData(stringArray);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "removeInvalidTarget, invalidTarget= " + string5 + ", previousTargets= " + string4 + ", newTargets= " + stringArray2[2]);
        }
    }

    String removeTarget(String string, String string2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "removeTarget, targetToRemove= " + string + ", appTargets= " + string2);
        }
        String string3 = string2;
        String string4 = string + "+";
        if (string2.indexOf(string4) != -1) {
            string3 = string2.replace(string4, "");
        } else {
            int n = string2.lastIndexOf(string);
            int n2 = string2.length() - string.length();
            if (n != -1 && n2 == n) {
                if (n2 == 0 && string.length() < string2.length()) {
                    string3 = string2.substring(n2, string2.length());
                } else {
                    if (n2 == 0) {
                        n2 = 1;
                    }
                    string3 = string2.substring(0, n2 - 1);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "removeTarget, targetToRemove= " + string + ", appTargets= " + string3);
        }
        return string3;
    }

    boolean targetExists(String string, String string2) {
        String string3 = string + "+";
        if (string2.indexOf(string3) != -1) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Not adding target because the target already exists: " + string + " existing target: " + string2);
            }
            return true;
        }
        int n = string2.lastIndexOf(string);
        int n2 = string2.length() - string.length();
        if (n != -1 && n2 == n) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Not adding target because the target already exists: " + string + " existing target: " + string2);
            }
            return true;
        }
        return false;
    }

    public void updateAppInfo(Vector vector, int n, String string, String string2, String string3, String string4) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateAppInfo");
        }
        MapModulesToServers mapModulesToServers = (MapModulesToServers)vector.get(n);
        this.addNewTarget(mapModulesToServers, string, string2, string3, string4);
        vector.add(n, mapModulesToServers);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateAppInfo");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installApplication(Hashtable hashtable, ConfigService configService, Session session, boolean bl) throws Exception {
        Vector vector;
        int n;
        String string;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "installApplication");
        }
        String string2 = (String)hashtable.get("server.name");
        String string3 = (String)hashtable.get("node.name");
        String string4 = (String)hashtable.get("cell.name");
        String string5 = (String)hashtable.get("cluster.name");
        hashtable.put("zeroEarCopy", true);
        Boolean bl2 = (Boolean)hashtable.get("ASYNC_USE_OLD_CONFIG");
        if (bl2 == null) {
            bl2 = false;
        }
        String string6 = string = bl2 != false ? "${APP_INSTALL_ROOT}/${CELL}/ibmasyncrsp.ear" : "${WAS_INSTALL_ROOT}/systemApps/ibmARS.ear";
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Installing ARS application with binary path: " + string);
        }
        hashtable.put("installed.ear.destination.final", string);
        AppManagement appManagement = this.getAppMgmtObject(configService);
        if (!appManagement.checkIfAppExists("ibmasyncrsp", hashtable, session.toString())) {
            WSCommandListener wSCommandListener;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Installing ibmasyncrsp application to new server");
            }
            WSCommandListener wSCommandListener2 = wSCommandListener = new WSCommandListener("ibmasyncrsp", "InstallApplication");
            synchronized (wSCommandListener2) {
                block25: {
                    if (bl) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Installing ibmasyncrsp in local mode");
                        }
                        appManagement.installApplicationLocal(Constants.ASYNC_RSP_SYS_APP_PATH_EXTRACTED, "ibmasyncrsp", hashtable, wSCommandListener, session.toString());
                    } else {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Installing ibmasyncrsp in non-local mode");
                        }
                        appManagement.installApplication(Constants.ASYNC_RSP_SYS_APP_PATH_EXTRACTED, "ibmasyncrsp", hashtable, session.toString());
                    }
                    if (!wSCommandListener.isComplete()) {
                        try {
                            wSCommandListener.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Tr.debug(_tc, "Interrupted.  Continue...");
                        }
                    }
                    if (!wSCommandListener.isSuccess()) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "App install completed but was not successful");
                        }
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "App install completed and was successful");
                    }
                    try {
                        AdminServiceFactory.getAdminService().removeNotificationListener(wSCommandListener.getAppMgmt(), wSCommandListener);
                    }
                    catch (Throwable throwable) {
                        if (!_tc.isDebugEnabled()) break block25;
                        Tr.debug(_tc, "Could not remove app notification listener: " + throwable.toString());
                    }
                }
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "ibmasyncrsp application already targetted for federated node. Updating target mappings");
        }
        if ((n = this.getMappingIndex(vector = appManagement.getApplicationInfo("ibmasyncrsp", hashtable, session.toString()))) != -1) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found application target mapping object");
            }
            this.updateAppInfo(vector, n, string4, string3, string2, string5);
            appManagement.setApplicationInfo("ibmasyncrsp", hashtable, session.toString(), vector);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "installApplication");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstallApplication(Hashtable hashtable, ConfigService configService, Session session, boolean bl) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "uninstallApplication");
        }
        String string = (String)hashtable.get("server.name");
        String string2 = (String)hashtable.get("node.name");
        String string3 = (String)hashtable.get("cell.name");
        String string4 = (String)hashtable.get("cluster.name");
        AppManagement appManagement = this.getAppMgmtObject(configService);
        if (appManagement.checkIfAppExists("ibmasyncrsp", hashtable, session.toString())) {
            WSCommandListener wSCommandListener;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Uninstalling ibmasyncrsp application from cluster: " + string4);
            }
            WSCommandListener wSCommandListener2 = wSCommandListener = new WSCommandListener("ibmasyncrsp", "UninstallApplication");
            synchronized (wSCommandListener2) {
                block21: {
                    if (bl) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Uninstalling ibmasyncrsp in local mode");
                        }
                        appManagement.uninstallApplicationLocal("ibmasyncrsp", hashtable, wSCommandListener, session.toString());
                    } else {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Uninstalling ibmasyncrsp in non-local mode");
                        }
                        appManagement.uninstallApplication("ibmasyncrsp", hashtable, session.toString());
                    }
                    if (!wSCommandListener.isComplete()) {
                        try {
                            wSCommandListener.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Tr.debug(_tc, "Interrupted.  Continue...");
                        }
                    }
                    if (!wSCommandListener.isSuccess()) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "App uninstall completed but was not successful");
                        }
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "App uninstall completed and was successful");
                    }
                    try {
                        AdminServiceFactory.getAdminService().removeNotificationListener(wSCommandListener.getAppMgmt(), wSCommandListener);
                    }
                    catch (Throwable throwable) {
                        if (!_tc.isDebugEnabled()) break block21;
                        Tr.debug(_tc, "Could not remove app notification listener: " + throwable.toString());
                    }
                }
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "The asynchronous response servlet could not be uninstalled because it does not exist on the cluster: " + string4);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "uninstallApplication");
        }
    }

    AppManagement getAppMgmtObject(ConfigService configService) throws Exception {
        AppManagement appManagement = null;
        if (configService instanceof ConfigServiceProxy) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Retrieving app management bean for client");
            }
            appManagement = AppManagementProxy.getJMXProxyForClient(((ConfigServiceProxy)configService).getAdminClient());
        } else if (AdminServiceFactory.getAdminService() == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Retrieving app management bean for local");
            }
            appManagement = AppManagementProxy.getLocalProxy();
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Retrieving app management bean for server");
            }
            appManagement = AppManagementProxy.getJMXProxyForServer();
        }
        return appManagement;
    }

    public boolean installARSToCluster(String string, ConfigService configService, Session session, String string2) throws Exception {
        ObjectName[] objectNameArray;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "installARSToCluster= " + string);
        }
        boolean bl = true;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Checking to see if asynchronous response servlet application should be installed to the cluster: " + string);
        }
        if ((objectNameArray = this.getClusterMemberObjs(string, configService, session)) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found " + objectNameArray.length + " existing cluster " + "member(s) for cluster: " + string);
            }
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string3 = (String)configService.getAttribute(session, objectNameArray[i], "memberName");
                if (string2 != null && string2.equals(string3)) continue;
                String string4 = (String)configService.getAttribute(session, objectNameArray[i], "nodeName");
                ManagedObjectMetadataHelper managedObjectMetadataHelper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(null));
                SortedMap sortedMap = managedObjectMetadataHelper.getNodeProductVersions(string4);
                if (sortedMap.get("WS FEP") != null) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "For the cluster: " + string + " a non-WSFP " + "server member was found. The asynchronous response " + "servlet application will not be targetted for this cluster.");
                }
                bl = false;
                break;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "installARSToCluster= " + String.valueOf(bl));
        }
        return bl;
    }

    public boolean uninstallARSFromCluster(ConfigService configService, Session session, Hashtable hashtable) throws Exception {
        AppManagement appManagement;
        String string;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "uninstallARSFromCluster");
        }
        if ((string = (String)hashtable.get("cluster.name")) == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The uninstallARSFromCluster method was called but no cluster name was available. No action will be taken");
            }
            return false;
        }
        boolean bl = false;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Checking to see if asynchronous response servlet application should be uninstalled from cluster: " + string);
        }
        if ((appManagement = this.getAppMgmtObject(configService)) != null && appManagement.checkIfAppExists("ibmasyncrsp", hashtable, session.toString())) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The asynchronous response servlet application needs to be uninstalled from the cluster: " + string);
            }
            bl = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "uninstallARSFromCluster= " + String.valueOf(bl));
        }
        return bl;
    }

    public boolean reinstallARSToCluster(String string, ConfigService configService, Session session) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "resintallARSToCluster= " + string);
        }
        boolean bl = false;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "reinstallARSToCluster= " + String.valueOf(bl));
        }
        return bl;
    }

    public ObjectName[] getClusterMemberObjs(String string, ConfigService configService, Session session) throws Exception {
        ObjectName objectName = configService.resolve(session, "ServerCluster=" + string)[0];
        ObjectName[] objectNameArray = null;
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "ClusterMember");
        objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        return objectNameArray;
    }

    private static class WSCommandListener
    implements AppNotification.Listener,
    NotificationListener {
        private boolean complete = false;
        private boolean success = false;
        private String appName;
        private ObjectName appmgmtMBean = null;
        private String appNotifierKey = null;

        public WSCommandListener(String string, String string2) throws Exception {
            this.appName = string;
            this.appNotifierKey = string2;
            AdminService adminService = AdminServiceFactory.getAdminService();
            if (adminService != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Adding notification listener to application management bean");
                }
                String string3 = adminService.getProcessName();
                String string4 = adminService.getNodeName();
                String string5 = "WebSphere:type=AppManagement,node=" + string4 + ",process=" + string3 + ",*";
                Set set = adminService.queryNames(new ObjectName(string5), null);
                if (set.size() >= 1) {
                    this.appmgmtMBean = (ObjectName)set.iterator().next();
                    NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                    notificationFilterSupport.enableType("websphere.admin.appmgmt");
                    adminService.addNotificationListener(this.appmgmtMBean, this, (NotificationFilter)notificationFilterSupport, null);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Succesfully added notification listener to application management bean");
                    }
                }
            }
        }

        public void handleNotification(Notification notification, Object object) {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "handleNotification");
            }
            if (notification == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Notification is null handback: " + object);
                }
                return;
            }
            Object object2 = notification.getUserData();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Notification not null userData: " + object2);
            }
            if (object2 instanceof AppNotification) {
                this.appEventReceived((AppNotification)object2);
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "handleNotification");
            }
        }

        public synchronized void appEventReceived(AppNotification appNotification) {
            String string;
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "appEventReceived");
            }
            if (this.appName.equals(string = appNotification.props.getProperty("appname"))) {
                if (appNotification.taskStatus.equals("Completed") && appNotification.taskName.equals(this.appNotifierKey)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Received notification ibmasyncrsp.ear action completed and was successful");
                    }
                    this.complete = true;
                    this.success = true;
                    this.notifyAll();
                } else if (appNotification.taskStatus.equals("Failed") && appNotification.taskName.equals(this.appNotifierKey)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Received notification ibmasyncrsp.ear action completed but was not successful");
                    }
                    this.complete = true;
                    this.success = false;
                    this.notifyAll();
                }
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "appEventReceived");
            }
        }

        public boolean isComplete() {
            return this.complete;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public ObjectName getAppMgmt() {
            return this.appmgmtMBean;
        }
    }
}

