/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.command;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandStepData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.ws.websvcs.command.WSCreateServerExt;
import com.ibm.ws.websvcs.command.WSDeleteClusterMemberExt;
import com.ibm.ws.websvcs.command.WSImportCommandExt;
import com.ibm.ws.websvcs.command.WSUpdateARSTask;

public class WSCommandExtProvider
extends SimpleCommandProvider {
    private static final TraceComponent _tc = Tr.register(WSCommandExtProvider.class, null, null);

    public AbstractAdminCommand createCommand(CommandMetadata commandMetadata) throws CommandNotFoundException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createCommand");
        }
        try {
            String string = commandMetadata.getName();
            if (string.equals("updateARSConfig")) {
                WSUpdateARSTask wSUpdateARSTask = new WSUpdateARSTask((TaskCommandMetadata)commandMetadata);
                return wSUpdateARSTask;
            }
            throw new CommandNotFoundException(string);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "createCommand");
            }
        }
    }

    public AbstractAdminCommand loadCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadCommand");
        }
        try {
            String string = commandData.getName();
            if (string.equals("updateARSConfig")) {
                WSUpdateARSTask wSUpdateARSTask = new WSUpdateARSTask(commandData);
                return wSUpdateARSTask;
            }
            throw new CommandNotFoundException(string);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "loadCommand");
            }
        }
    }

    public AbstractCommandStep createCommandStep(AbstractTaskCommand abstractTaskCommand, String string) throws CommandNotFoundException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createCommandStep");
        }
        if (abstractTaskCommand.getName().equals("createApplicationServer") && string.equals("WebsvcsConfigCoreGroup")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found integration extension for createApplicationServer command.");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "createCommandStep");
            }
            return new WSCreateServerExt(abstractTaskCommand, this.getStepMetadata(abstractTaskCommand, string));
        }
        if (abstractTaskCommand.getName().equals("importNode") && string.equals("WebsvcsConfigCoreGroup")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found integration extension for importNode command.");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "createCommandStep");
            }
            return new WSImportCommandExt(abstractTaskCommand, this.getStepMetadata(abstractTaskCommand, string));
        }
        if (abstractTaskCommand.getName().equals("deleteClusterMember") && string.equals("WebsvcsConfigCoreGroup")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found integration extension for deleteClusterMember command.");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "createCommandStep");
            }
            return new WSDeleteClusterMemberExt(abstractTaskCommand, this.getStepMetadata(abstractTaskCommand, string));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createCommandStep");
        }
        throw new CommandNotFoundException(abstractTaskCommand.getName(), string);
    }

    public AbstractCommandStep loadCommandStep(AbstractTaskCommand abstractTaskCommand, CommandStepData commandStepData) throws CommandNotFoundException, CommandLoadException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadCommandStep");
        }
        if (abstractTaskCommand.getName().equals("createApplicationServer") && commandStepData.getName().equals("WebsvcsConfigCoreGroup")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found integration extension for createApplicationServer command.");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "loadCommandStep");
            }
            return new WSCreateServerExt(abstractTaskCommand, commandStepData);
        }
        if (abstractTaskCommand.getName().equals("importNode") && commandStepData.getName().equals("WebsvcsConfigCoreGroup")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found integration extension for importNode command.");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "createCommandStep");
            }
            return new WSImportCommandExt(abstractTaskCommand, commandStepData);
        }
        if (abstractTaskCommand.getName().equals("deleteClusterMember") && commandStepData.getName().equals("WebsvcsConfigCoreGroup")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found integration extension for deleteClusterMember command.");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "createCommandStep");
            }
            return new WSDeleteClusterMemberExt(abstractTaskCommand, commandStepData);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadCommandStep");
        }
        throw new CommandNotFoundException(abstractTaskCommand.getName(), commandStepData.getName());
    }
}

