/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.collaborators;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.WebServicesPerf;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.server.PmiFactory;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.collaborator.WebAppCollaboratorConfig;
import com.ibm.ws.webcontainer.webapp.collaborator.WebAppInitializationCollaborator;
import com.ibm.ws.websvcs.metadata.ServerModuleMetaData;
import com.ibm.ws.websvcs.transport.common.JavaUtils;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.websvcs.WASAxis2Service;
import com.ibm.wsspi.wswebcontainer.metadata.WebModuleMetaData;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;

public class WebCollaborator
implements WebAppInitializationCollaborator {
    private static TraceComponent _tc = Tr.register(WebCollaborator.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static long waitInterval = 5000L;
    private static long waitTimeout = 300000L;

    public void starting(WebAppCollaboratorConfig webAppCollaboratorConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void started(WebAppCollaboratorConfig webAppCollaboratorConfig) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "started, module=" + webAppCollaboratorConfig.getWebApp().getWebAppConfig().getModuleName());
        }
        try {
            ServerModuleMetaData serverModuleMetaData = this.getServerModuleMetaData(webAppCollaboratorConfig);
            if (serverModuleMetaData != null) {
                WebServicesPerf webServicesPerf = PmiFactory.createWebServicesPerf((String)serverModuleMetaData.getApplicationName(), (String)serverModuleMetaData.getModuleName());
                if (webServicesPerf != null) {
                    if (serverModuleMetaData.getConfigurationContext() == null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "ConfigurationContext is null! This needs to exist to start PMI services.");
                        }
                        return;
                    }
                    AxisConfiguration axisConfiguration = serverModuleMetaData.getConfigurationContext().getAxisConfiguration();
                    Iterator iterator = axisConfiguration.getServiceGroups();
                    while (iterator.hasNext()) {
                        AxisServiceGroup axisServiceGroup = (AxisServiceGroup)iterator.next();
                        Iterator iterator2 = axisServiceGroup.getServices();
                        while (iterator2.hasNext()) {
                            AxisService axisService = (AxisService)iterator2.next();
                            String string = Axis2Utils.getPortComponentName(axisService);
                            if (string == null) continue;
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Calling PMI onServiceLoad for: " + string);
                            }
                            webServicesPerf.onServiceLoad(string);
                        }
                    }
                    serverModuleMetaData.setPMIServicesModule(webServicesPerf);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "The services above were loaded onto PMI module.");
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "PMI is disabled, not adding services to PMI module.");
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Server Module Metadata is null. This is not a JAX-WS App.");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.collaborators.WebCollaborator.started", "135", this);
            Tr.error(_tc, "loadPMIFail00", exception);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "started");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopping(WebAppCollaboratorConfig webAppCollaboratorConfig) {
        block13: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "WebCollaborator.stopping()...");
            }
            try {
                ServerModuleMetaData serverModuleMetaData = Axis2Utils.getServerModuleMetaData();
                if (serverModuleMetaData != null) {
                    ConfigurationContext configurationContext = serverModuleMetaData.getConfigurationContext();
                    if (configurationContext != null) {
                        List list = Axis2Utils.getAsyncBeansList(configurationContext);
                        boolean bl = true;
                        long l = System.currentTimeMillis();
                        while (bl) {
                            List list2 = list;
                            synchronized (list2) {
                                bl = !list.isEmpty();
                            }
                            if (!bl) continue;
                            Thread.sleep(waitInterval);
                            long l2 = System.currentTimeMillis();
                            if (l2 - l <= waitTimeout) continue;
                            Tr.warning(_tc, "Wait timeout reached. Continuing shutdown...");
                            bl = false;
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "No outstanding async beans processing, continuing shutdown...");
                        }
                        break block13;
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Could not retrieve configuration context for module. Continuing shutdown...");
                    }
                    break block13;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Could not retrieve server module metadata for module, continuing shutdown...");
                }
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{exception};
                Tr.error(_tc, "caughtException", objectArray);
                if (!_tc.isDebugEnabled()) break block13;
                Tr.debug(_tc, "Exception occurred trying to check async bean list, continuing shutdown...");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WebCollaborator.stopping()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped(WebAppCollaboratorConfig webAppCollaboratorConfig) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stopped, module=" + webAppCollaboratorConfig.getWebApp().getWebAppConfig().getModuleName());
        }
        try {
            ServerModuleMetaData serverModuleMetaData = this.getServerModuleMetaData(webAppCollaboratorConfig);
            if (serverModuleMetaData != null) {
                WebServicesPerf webServicesPerf = serverModuleMetaData.getPMIServicesModule();
                if (serverModuleMetaData.getConfigurationContext() != null && webServicesPerf != null) {
                    AxisConfiguration axisConfiguration = serverModuleMetaData.getConfigurationContext().getAxisConfiguration();
                    Iterator iterator = axisConfiguration.getServiceGroups();
                    while (iterator.hasNext()) {
                        AxisServiceGroup axisServiceGroup = (AxisServiceGroup)iterator.next();
                        Iterator iterator2 = axisServiceGroup.getServices();
                        while (iterator2.hasNext()) {
                            AxisService axisService = (AxisService)iterator2.next();
                            String string = Axis2Utils.getPortComponentName(axisService);
                            if (string == null) continue;
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Calling PMI onServiceUnload() for: " + string);
                            }
                            webServicesPerf.onServiceUnload(string);
                        }
                    }
                    PmiFactory.removePmiModule((Object)webServicesPerf);
                    serverModuleMetaData.setPMIServicesModule(null);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "PMI services unloaded from module.");
                    }
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException((Throwable)nullPointerException, "com.ibm.ws.websvcs.collaborators.WebCollaborator.stopped", "222", this);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Exiting. PMI object has already been removed.");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.collaborators.WebCollaborator.stopped", "228", this);
            Tr.error(_tc, "unloadPMIFail00", exception);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "stopped");
            }
        }
    }

    private ServerModuleMetaData getServerModuleMetaData(WebAppCollaboratorConfig webAppCollaboratorConfig) throws Exception {
        WebApp webApp = webAppCollaboratorConfig.getWebApp();
        WASAxis2Service wASAxis2Service = (WASAxis2Service)WsServiceRegistry.getService(this, WASAxis2Service.class);
        WebModuleMetaData webModuleMetaData = (WebModuleMetaData)webApp.getConfiguration().getMetaData();
        MetaDataSlot metaDataSlot = (MetaDataSlot)wASAxis2Service.getModuleMetaDataSlot();
        return (ServerModuleMetaData)webModuleMetaData.getMetaData(metaDataSlot);
    }

    static {
        String string = System.getProperty("com.ibm.websphere.webservices.moduleShutdownWaitInterval");
        if (JavaUtils.hasValue(string) && Integer.parseInt(string) > 0) {
            waitInterval = Integer.parseInt(string);
        }
        if (JavaUtils.hasValue(string = System.getProperty("com.ibm.websphere.webservices.moduleShutdownTimeout")) && Integer.parseInt(string) > 0) {
            waitTimeout = Integer.parseInt(string);
        }
    }
}

