/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.collaborators;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.metadata.ServerModuleMetaData;
import com.ibm.ws.websvcs.transport.common.JavaUtils;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.webcontainer.collaborator.WebAppCollaboratorConfig;
import com.ibm.wsspi.webcontainer.collaborator.WebAppInitializationCollaborator;
import java.util.List;
import org.apache.axis2.context.ConfigurationContext;

public class AsyncBeansCollaborator
implements WebAppInitializationCollaborator {
    private static final TraceComponent _tc = Tr.register(AsyncBeansCollaborator.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static long waitInterval = 5000L;
    private static long waitTimeout = 300000L;

    public void starting(WebAppCollaboratorConfig webAppCollaboratorConfig) {
    }

    public void started(WebAppCollaboratorConfig webAppCollaboratorConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopping(WebAppCollaboratorConfig webAppCollaboratorConfig) {
        block14: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "AsyncBeansCollaborator.stopping()...");
            }
            try {
                ServerModuleMetaData serverModuleMetaData = Axis2Utils.getServerModuleMetaData();
                if (serverModuleMetaData != null) {
                    ConfigurationContext configurationContext = serverModuleMetaData.getConfigurationContext();
                    if (configurationContext != null) {
                        List list = Axis2Utils.getAsyncBeansList(configurationContext);
                        boolean bl = true;
                        long l = System.currentTimeMillis();
                        while (bl) {
                            List list2 = list;
                            synchronized (list2) {
                                bl = !list.isEmpty();
                            }
                            if (!bl) continue;
                            Thread.sleep(waitInterval);
                            long l2 = System.currentTimeMillis();
                            if (l2 - l <= waitTimeout) continue;
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Wait timeout reached. Continuing shutdown...");
                            }
                            bl = false;
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "No outstanding async beans processing, continuing shutdown...");
                        }
                        break block14;
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Could not retrieve configuration context for module. Continuing shutdown...");
                    }
                    break block14;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Could not retrieve server module metadata for module, continuing shutdown...");
                }
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{exception};
                Tr.error(_tc, "caughtException", objectArray);
                if (!_tc.isDebugEnabled()) break block14;
                Tr.debug(_tc, "Exception occurred trying to check async bean list, continuing shutdown...");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncBeansCollaborator.stopping()");
        }
    }

    public void stopped(WebAppCollaboratorConfig webAppCollaboratorConfig) {
    }

    static {
        String string = System.getProperty("com.ibm.websphere.webservices.moduleShutdownWaitInterval");
        if (JavaUtils.hasValue(string) && Integer.parseInt(string) > 0) {
            waitInterval = Integer.parseInt(string);
        }
        if (JavaUtils.hasValue(string = System.getProperty("com.ibm.websphere.webservices.moduleShutdownTimeout")) && Integer.parseInt(string) > 0) {
            waitTimeout = Integer.parseInt(string);
        }
    }
}

