/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.async;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.Work;
import com.ibm.websphere.asynchbeans.WorkListener;
import com.ibm.websphere.asynchbeans.WorkManager;
import com.ibm.websphere.webservices.jaxws.Constants;
import com.ibm.ws.asynchbeans.AsynchBeansService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.async.AsyncWorkItem;
import com.ibm.ws.websvcs.async.AsyncWorkListener;
import com.ibm.ws.websvcs.metadata.ServerModuleMetaData;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.asynchbeans.WorkManagerConfiguration;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.axis2.context.ConfigurationContext;

public class AsyncBeansExecutor
implements Executor {
    private static final TraceComponent _tc = Tr.register(AsyncBeansExecutor.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    public static final String WORK_MANAGER_NAME = "WebServicesAsyncEndpointWorkManager";
    public static final String WORK_MANAGER_JNDI_NAME = "webservices/AsyncEndpointWorkManager";
    public static int WORK_MANAGER_MAX_THREADS = Constants.DEFAULT_MAX_THREADS;
    private boolean switchThreads = true;
    private WorkManager wm;

    public AsyncBeansExecutor() {
        int n = this.getMaxThreadsProperty();
        if (n > 0) {
            WORK_MANAGER_MAX_THREADS = n;
        }
        this.wm = this.createWorkManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable runnable) throws RuntimeException {
        block14: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "execute");
            }
            if (this.wm == null) {
                Tr.debug(_tc, "The WorkManager was null.  No work can be submitted.");
                throw new RuntimeException("No WorkManager found for asynch bean invocation.");
            }
            try {
                if (this.switchThreads) {
                    ServerModuleMetaData serverModuleMetaData;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Switching threads for work call...");
                    }
                    if ((serverModuleMetaData = Axis2Utils.getServerModuleMetaData()) != null) {
                        ConfigurationContext configurationContext = serverModuleMetaData.getConfigurationContext();
                        if (configurationContext != null) {
                            List list = Axis2Utils.getAsyncBeansList(configurationContext);
                            AsyncWorkItem asyncWorkItem = new AsyncWorkItem(runnable, configurationContext);
                            List list2 = list;
                            synchronized (list2) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Adding AsyncWorkItem to list: " + asyncWorkItem);
                                }
                                list.add(asyncWorkItem);
                            }
                            this.wm.startWork((Work)asyncWorkItem, Long.MAX_VALUE, (WorkListener)new AsyncWorkListener());
                            break block14;
                        }
                        String string = NLSProvider.getNLS().getFormattedMessage("getMetadataFail00", new Object[0], "Could not retrieve required metadata to process asynchronous request.");
                        Tr.error(_tc, "getMetadataFail00");
                        throw new RuntimeException(string);
                    }
                    String string = NLSProvider.getNLS().getFormattedMessage("getMetadataFail00", new Object[0], "Could not retrieve required metadata to process asynchronous request.");
                    Tr.error(_tc, "getMetadataFail00");
                    throw new RuntimeException(string);
                }
                this.wm.doWork((Work)new AsyncWorkItem(runnable));
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.websvcs.async.AsyncBeansExecutor", "123", this);
                throw runtimeException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.async.AsyncBeansExecutor", "129", this);
                Tr.error(_tc, "An error occured while submitting a Work item to the WorkManager.");
                throw new RuntimeException(exception);
            }
        }
        if (_tc.isExitEnabled()) {
            Tr.exit(_tc, "execute");
        }
    }

    private WorkManager createWorkManager() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getWorkManager");
        }
        WorkManager workManager = null;
        try {
            AsynchBeansService asynchBeansService = (AsynchBeansService)WsServiceRegistry.getService(this, AsynchBeansService.class);
            WorkManagerConfiguration workManagerConfiguration = asynchBeansService.createWorkManagerConfiguration();
            workManagerConfiguration.setName(WORK_MANAGER_NAME);
            workManagerConfiguration.setJNDIName(WORK_MANAGER_JNDI_NAME);
            workManagerConfiguration.setMaxThreads(WORK_MANAGER_MAX_THREADS);
            if (asynchBeansService != null) {
                workManager = asynchBeansService.getWorkManager(workManagerConfiguration);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.async.AsyncBeansExecutor", "126", this);
            Tr.error(_tc, "An error occured while configuring the WorkManager.");
        }
        if (_tc.isExitEnabled()) {
            Tr.exit(_tc, "getWorkManager");
        }
        return workManager;
    }

    private int getMaxThreadsProperty() {
        int n = 0;
        String string = System.getProperty(Constants.MAX_THREADS_PROPERTY);
        if (string != null) {
            try {
                n = Integer.parseInt(string);
                if (n > 0) {
                    WORK_MANAGER_MAX_THREADS = n;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Using max threads property value: " + string);
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Invalid value for max threads property:" + string + ". Will use default value of: " + WORK_MANAGER_MAX_THREADS);
                }
            }
            catch (NumberFormatException numberFormatException) {
                Exception exception = new Exception("An error occurred while parsing the value of property '" + Constants.MAX_THREADS_PROPERTY + "': " + string, numberFormatException);
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.utils.WASAxis2Executor.ctor", "94", this);
            }
        }
        return n;
    }
}

