/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.utils;

import com.ibm.ws.metadata.ClassDataObject;
import com.ibm.ws.metadata.ClassDataObjectFields;
import com.ibm.ws.metadata.MetaDataSubObject;
import com.ibm.ws.metadata.WebMethodRefObject;
import com.ibm.ws.metadata.WebServiceProviderRefObject;
import com.ibm.ws.metadata.WebServiceRefObject;
import com.ibm.ws.metadata.annotations.MethodRefObject;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static void setImplWSDefaults(WebServiceRefObject webServiceRefObject, ClassDataObject classDataObject) {
        String string;
        if (webServiceRefObject.getName() == null || webServiceRefObject.getName().equals("")) {
            string = Utils.deriveSimpleClassName((String)classDataObject.getEntry(ClassDataObjectFields.CLASS_NAME));
            webServiceRefObject.setName(string);
        }
        if (webServiceRefObject.getServiceName() == null || webServiceRefObject.getServiceName().equals("")) {
            webServiceRefObject.setServiceName(webServiceRefObject.getName() + "Service");
        }
        if (webServiceRefObject.getPortName() == null || webServiceRefObject.getPortName().equals("")) {
            webServiceRefObject.setPortName(webServiceRefObject.getName() + "Port");
        }
        if (webServiceRefObject.getTargetNamespace() == null || webServiceRefObject.getTargetNamespace().equals("")) {
            string = Utils.deriveNamespace((String)classDataObject.getEntry(ClassDataObjectFields.CLASS_NAME));
            webServiceRefObject.setTargetNamespace(string);
        }
    }

    public static void setSEIWSDefaults(WebServiceRefObject webServiceRefObject, ClassDataObject classDataObject) {
        String string;
        if (webServiceRefObject.getName() == null || webServiceRefObject.getName().equals("")) {
            string = Utils.deriveSimpleClassName((String)classDataObject.getEntry(ClassDataObjectFields.CLASS_NAME));
            webServiceRefObject.setName(string);
        }
        if (webServiceRefObject.getTargetNamespace() == null || webServiceRefObject.getTargetNamespace().equals("")) {
            string = Utils.deriveNamespace((String)classDataObject.getEntry(ClassDataObjectFields.CLASS_NAME));
            webServiceRefObject.setTargetNamespace(string);
        }
    }

    public static String deriveNamespace(String string) {
        String[] stringArray = string.split("/");
        string = "";
        for (int i = stringArray.length - 2; i > -1; --i) {
            string = string.equals("") ? stringArray[i] : string + "." + stringArray[i];
        }
        string = "http://" + string + "/";
        return string;
    }

    public static String deriveSimpleClassName(String string) {
        String[] stringArray = string.split("/");
        return stringArray[stringArray.length - 1];
    }

    public static void setImplWMDefaults(WebMethodRefObject webMethodRefObject, MetaDataSubObject metaDataSubObject) {
        if (webMethodRefObject.getOperationName() == null || webMethodRefObject.getOperationName().equals("")) {
            webMethodRefObject.setOperationName(metaDataSubObject.getName());
        }
        if (webMethodRefObject.getAction() == null) {
            webMethodRefObject.setAction("");
        }
        if (webMethodRefObject.getExclude() == null) {
            webMethodRefObject.setExclude("false");
        }
    }

    public static void setSEIWMDefaults(WebMethodRefObject webMethodRefObject, MetaDataSubObject metaDataSubObject) {
        if (webMethodRefObject.getOperationName() == null || webMethodRefObject.getOperationName().equals("")) {
            webMethodRefObject.setOperationName(metaDataSubObject.getName());
        }
        if (webMethodRefObject.getAction() == null) {
            webMethodRefObject.setAction("");
        }
    }

    public static String javifyQualifiedClassName(String string) {
        if (string.contains("/")) {
            string = string.replace("/", ".");
        }
        return string;
    }

    public static ClassDataObject getEndpointInterface(String string, ArrayList<ClassDataObject> arrayList) {
        for (ClassDataObject classDataObject : arrayList) {
            String string2 = Utils.javifyQualifiedClassName((String)classDataObject.getEntry(ClassDataObjectFields.CLASS_NAME));
            if (!string2.equals(string)) continue;
            return classDataObject;
        }
        return null;
    }

    public static boolean isSEI(String string, ArrayList<ClassDataObject> arrayList) {
        for (ClassDataObject classDataObject : arrayList) {
            WebServiceRefObject webServiceRefObject = (WebServiceRefObject)classDataObject.getEntry(ClassDataObjectFields.WEBSERVICE);
            if (webServiceRefObject == null) {
                return false;
            }
            String string2 = webServiceRefObject.getEndpointInterface();
            if (string2 == null || string2.equals("") || !(string2 = Utils.javifyQualifiedClassName(string2)).equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPublic(MethodRefObject methodRefObject) {
        return methodRefObject.getAccess() == 1 || methodRefObject.getAccess() == 1025;
    }

    public static boolean isAnnotated(MethodRefObject methodRefObject, ArrayList<String> arrayList) {
        return !arrayList.isEmpty() && arrayList.contains(methodRefObject.getName());
    }

    public static boolean isControlOperation(MethodRefObject methodRefObject) {
        return methodRefObject.getName().contains("<");
    }

    public static boolean implementsMethod(String string, ArrayList<MethodRefObject> arrayList) {
        for (MethodRefObject methodRefObject : arrayList) {
            if (!string.equals(methodRefObject.getName())) continue;
            return true;
        }
        return false;
    }

    public static MethodRefObject getMRef(String string, ArrayList<MethodRefObject> arrayList) {
        for (MethodRefObject methodRefObject : arrayList) {
            if (!string.equals(methodRefObject.getName())) continue;
            return methodRefObject;
        }
        return null;
    }

    public static boolean isPublicClass(ClassDataObject classDataObject) {
        Integer n = (Integer)classDataObject.getEntry(ClassDataObjectFields.CLASS_ACCESS);
        int n2 = n;
        return n2 == 1 || n2 == 33;
    }

    public static AxisOperation getAxisOperation(String string, AxisService axisService) {
        Iterator iterator = axisService.getOperations();
        while (iterator.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)iterator.next();
            String string2 = axisOperation.getName().getLocalPart();
            String string3 = string2.substring(0, 1);
            String string4 = string2.substring(1, string2.length());
            String string5 = string3.toUpperCase() + string4;
            String string6 = string3.toLowerCase() + string4;
            if (string5.equals(string)) {
                return axisOperation;
            }
            if (!string6.equals(string)) continue;
            return axisOperation;
        }
        return null;
    }

    public static void setProviderWSDefaults(WebServiceProviderRefObject webServiceProviderRefObject, ClassDataObject classDataObject) {
        String string = Utils.deriveSimpleClassName((String)classDataObject.getEntry(ClassDataObjectFields.CLASS_NAME));
        if (webServiceProviderRefObject.getServiceName() == null || webServiceProviderRefObject.getServiceName().equals("")) {
            webServiceProviderRefObject.setServiceName(string + "Service");
        }
        if (webServiceProviderRefObject.getPortName() == null || webServiceProviderRefObject.getPortName().equals("")) {
            webServiceProviderRefObject.setPortName(string + "Port");
        }
        if (webServiceProviderRefObject.getTargetNamespace() == null || webServiceProviderRefObject.getTargetNamespace().equals("")) {
            String string2 = Utils.deriveNamespace((String)classDataObject.getEntry(ClassDataObjectFields.CLASS_NAME));
            webServiceProviderRefObject.setTargetNamespace(string2);
        }
    }

    public static ArrayList<String> getAnnotatedMethods(ArrayList<MetaDataSubObject> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (arrayList != null && !arrayList.isEmpty()) {
            for (MetaDataSubObject metaDataSubObject : arrayList) {
                arrayList2.add(metaDataSubObject.getName());
            }
        }
        return arrayList2;
    }

    public static boolean isPublicType(int n) {
        return n == 33 || n == 1537;
    }

    public static boolean isPublicMethod(int n) {
        return n == 1 || n == 9 || n == 17 || n == 25 || n == 1025;
    }
}

