/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.generator;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.ClassDataObject;
import com.ibm.ws.metadata.ClassDataObjectFields;
import com.ibm.ws.metadata.ClassRefObject;
import com.ibm.ws.metadata.MetaDataSubObject;
import com.ibm.ws.metadata.WebMethodRefObject;
import com.ibm.ws.metadata.WebServiceProviderRefObject;
import com.ibm.ws.metadata.WebServiceRefObject;
import com.ibm.ws.metadata.annotations.MethodRefObject;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.annotations.utils.Utils;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.schema.resolver.WASURIResolver;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.websvcs.wsdl.ModuleWSDLLocator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.wsdl.xml.WSDLLocator;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.jaxws.server.JAXWSMessageReceiver;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASAnnotationServiceGenerator
implements Constants {
    private static final TraceComponent _tc = Tr.register(WASAnnotationServiceGenerator.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private ArrayList<ClassDataObject> cdoList;
    private ClassLoader classLoader;
    private LoadStrategy loadStrategy;
    private ArrayList<String> serviceNames;
    private ArrayList<String> errorMsgs;

    public WASAnnotationServiceGenerator(ArrayList<ClassDataObject> arrayList, ClassLoader classLoader, LoadStrategy loadStrategy) {
        this.cdoList = arrayList;
        this.classLoader = classLoader;
        this.loadStrategy = loadStrategy;
        this.errorMsgs = new ArrayList();
    }

    public AxisServiceGroup generate() throws DeploymentException {
        Object object;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "generate");
        }
        this.serviceNames = new ArrayList();
        AxisServiceGroup axisServiceGroup = new AxisServiceGroup();
        for (ClassDataObject object2 : this.cdoList) {
            String string = Utils.javifyQualifiedClassName((String)object2.getEntry(ClassDataObjectFields.CLASS_NAME));
            object = object2.getEntry(ClassDataObjectFields.WEBSERVICECLIENT);
            if (!Utils.isPublicClass(object2) || Utils.isSEI(string, this.cdoList) || object != null) continue;
            AxisService axisService = this.processCDO(object2);
            try {
                if (axisService == null) continue;
                axisServiceGroup.addService(axisService);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.annotations.generator.WASAnnotationServiceGenerator.generate", "139", this);
                Object[] objectArray = new Object[]{axisService.getName(), throwable};
                String string2 = NLSProvider.getNLS().getFormattedMessage("addSrvcFail00", objectArray, "Error occurred while attempting to add service {0} to the service group: {1}");
                Tr.error(_tc, "addSrvcFail00", objectArray);
                this.errorMsgs.add(string2);
            }
        }
        if (!this.errorMsgs.isEmpty()) {
            for (String string : this.errorMsgs) {
                Tr.error(_tc, string);
            }
            Object[] objectArray = new Object[]{};
            object = NLSProvider.getNLS().getFormattedMessage("deployFail00", objectArray, "Error(s) occurred while attempting to process annotations within an application module. Please see the previously logged messages for details.");
            throw new DeploymentException((String)object);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "generate");
        }
        return axisServiceGroup;
    }

    private AxisService processCDO(ClassDataObject classDataObject) {
        Object object;
        Object object2;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "processCDO");
        }
        boolean bl = false;
        String string = Utils.javifyQualifiedClassName((String)classDataObject.getEntry(ClassDataObjectFields.CLASS_NAME));
        AxisService axisService = null;
        ClassDataObject classDataObject2 = null;
        WebServiceRefObject webServiceRefObject = (WebServiceRefObject)classDataObject.getEntry(ClassDataObjectFields.WEBSERVICE);
        if (webServiceRefObject == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Processing Provider based WebService");
            }
            if ((object2 = (WebServiceProviderRefObject)classDataObject.getEntry(ClassDataObjectFields.WEBSERVICEPROVIDER)) != null) {
                Utils.setProviderWSDefaults((WebServiceProviderRefObject)object2, classDataObject);
                this.validateProviderEndpoint(classDataObject, string);
                axisService = this.processProvider(classDataObject, (WebServiceProviderRefObject)object2, string);
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Processing SEI or Implementation Bean based WebService");
            }
            Utils.setImplWSDefaults(webServiceRefObject, classDataObject);
            if (webServiceRefObject.getEndpointInterface() != null && !webServiceRefObject.getEndpointInterface().equals("")) {
                classDataObject2 = Utils.getEndpointInterface(webServiceRefObject.getEndpointInterface(), this.cdoList);
                if (classDataObject2 == null) {
                    Object[] objectArray = new Object[]{webServiceRefObject.getServiceName(), string, webServiceRefObject.getEndpointInterface()};
                    String string2 = NLSProvider.getNLS().getFormattedMessage("annotations00", objectArray, "The Web service {0} associated with the class {1} will not be loaded. The Service Endpoint Interface {2} specified in the @WebService annotation of class {1} was not found.");
                    this.errorMsgs.add(string2);
                    return null;
                }
                axisService = this.processSEI(classDataObject2, string, webServiceRefObject.getServiceName(), webServiceRefObject.getPortName(), webServiceRefObject.getWSDLLocation(), webServiceRefObject.getTargetNamespace());
                bl = true;
            } else {
                axisService = this.processImplBean(classDataObject, webServiceRefObject, string);
            }
            if (axisService != null) {
                object2 = (ArrayList)classDataObject.getEntry(ClassDataObjectFields.WEBMETHOD);
                if (object2 != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "@WebMethod annotation found in class: " + string);
                    }
                    if (bl) {
                        Object[] objectArray = new Object[]{webServiceRefObject.getServiceName(), string};
                        String string3 = NLSProvider.getNLS().getFormattedMessage("annotations01", objectArray, "The Web service {0} associated with the class {1} will not be loaded. An @WebMethod annotation was found in the class {1}, but the @WebService annotation of this class also specifies the [endpointInterface] attribute.");
                        this.errorMsgs.add(string3);
                        return null;
                    }
                    object = object2.iterator();
                    this.checkImplWebMethodAnnotations(axisService, classDataObject, (Iterator<MetaDataSubObject>)object, string);
                    this.addImplPublicMethods(classDataObject, axisService, string);
                    this.validateOperations(axisService, string);
                } else if (object2 == null && !bl) {
                    this.addImplPublicMethods(classDataObject, axisService, string);
                    this.validateOperations(axisService, string);
                } else if (bl) {
                    object = (ArrayList)classDataObject2.getEntry(ClassDataObjectFields.WEBMETHOD);
                    String string4 = Utils.javifyQualifiedClassName((String)classDataObject2.getEntry(ClassDataObjectFields.CLASS_NAME));
                    if (object != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "@WebMethod annotation found in endpoint interface: " + string4);
                        }
                        Iterator<MetaDataSubObject> iterator = ((ArrayList)object).iterator();
                        this.checkSEIWebMethodAnnotations(axisService, classDataObject2, iterator, string4);
                    }
                    this.addSEIPublicMethods(classDataObject2, axisService, string);
                    this.validateOperations(axisService, string);
                    this.validateImplementation(classDataObject, classDataObject2, string, string4);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "processCDO");
        }
        if (axisService != null && !axisService.getOperations().hasNext()) {
            object2 = new Object[]{axisService.getName(), string};
            object = NLSProvider.getNLS().getFormattedMessage("noOperation00", (Object[])object2, "The Web service {0} for class {1} has no exposed operations.");
            this.errorMsgs.add((String)object);
        }
        if (_tc.isDebugEnabled() && axisService != null && axisService.getOperations().hasNext()) {
            Tr.debug(_tc, "AxisService built from annotations and wsdl: " + axisService.getName());
        }
        return axisService;
    }

    private void setOperationMessageReceivers(Iterator iterator) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setOperationMessageReceivers");
        }
        while (iterator.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)iterator.next();
            axisOperation.setMessageReceiver(new JAXWSMessageReceiver());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setOperationMessageReceivers");
        }
    }

    private void addServiceParams(AxisService axisService, String string, String string2, QName qName, String string3) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addServiceParams");
        }
        if (string2.contains("/")) {
            string2 = string2.replace("/", ".");
        }
        try {
            Axis2Utils.setWSDLLocation(axisService, string);
            Axis2Utils.setServiceImplClass(axisService, string2);
            Axis2Utils.setServiceQName(axisService, qName);
            Axis2Utils.setPortName(axisService, string3);
        }
        catch (AxisFault axisFault) {
            FFDCFilter.processException((Throwable)axisFault, "com.ibm.ws.websvcs.annotations.generator.WASAnnotationServiceGenerator.addServiceParams", "329", this);
            Object[] objectArray = new Object[]{string2, axisFault};
            String string4 = NLSProvider.getNLS().getFormattedMessage("bldWebSrvsFail00", objectArray, "Internal error occurred while attempting to build a Web service for class {0}: {1}");
            Tr.error(_tc, string4, objectArray);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addServiceParams");
        }
    }

    private void checkImplWebMethodAnnotations(AxisService axisService, ClassDataObject classDataObject, Iterator<MetaDataSubObject> iterator, String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "checkImplWebMethodAnnotations");
        }
        boolean bl = false;
        while (iterator.hasNext()) {
            Object[] objectArray;
            MetaDataSubObject metaDataSubObject = iterator.next();
            WebMethodRefObject webMethodRefObject = (WebMethodRefObject)metaDataSubObject.getValue();
            if (webMethodRefObject == null) continue;
            Utils.setImplWMDefaults(webMethodRefObject, metaDataSubObject);
            String string2 = webMethodRefObject.getOperationName();
            AxisOperation axisOperation = Utils.getAxisOperation(string2, axisService);
            if (axisOperation == null) {
                Object[] objectArray2 = new Object[]{axisService.getName(), string, string2};
                objectArray = NLSProvider.getNLS().getFormattedMessage("noWsdlOperMatch00", objectArray2, "The Web service {0} associated with the class {1} will not be loaded. The class {1} contains an @WebMethod annotation with the attribute [operationName]={2}, but the corresponding WSDL file does not contain this operation.");
                this.errorMsgs.add((String)objectArray);
                return;
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The operation: " + string2 + " was found in both" + " wsdl and annotation data.");
            }
            if (webMethodRefObject.getExclude().equals("true")) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "The exclude attribute for operation: " + string2 + " was true. It will be removed from the service.");
                }
                axisService.removeOperation(axisOperation.getName());
                continue;
            }
            try {
                Axis2Utils.setOperationValidated(axisOperation);
                bl = true;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.annotations.generator.WASAnnotationServiceGenerator.checkImplWebMethodAnnotations", "440", this);
                objectArray = new Object[]{string, throwable};
                String string3 = NLSProvider.getNLS().getFormattedMessage("bldWebSrvsFail00", objectArray, "Internal error occurred while attempting to build a Web service for class {0}: {1}");
                Tr.error(_tc, "bldWebSrvsFail00", objectArray);
                this.errorMsgs.add(string3);
            }
        }
        if (bl) {
            this.validateOperations(axisService, string);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "checkImplWebMethodAnnotations");
        }
    }

    private void checkSEIWebMethodAnnotations(AxisService axisService, ClassDataObject classDataObject, Iterator<MetaDataSubObject> iterator, String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "checkSEIWebMethodAnnotations");
        }
        while (iterator.hasNext()) {
            Object[] objectArray;
            Object object;
            Object[] objectArray2;
            MetaDataSubObject metaDataSubObject = iterator.next();
            WebMethodRefObject webMethodRefObject = (WebMethodRefObject)metaDataSubObject.getValue();
            Utils.setSEIWMDefaults(webMethodRefObject, metaDataSubObject);
            if (webMethodRefObject.getExclude() != null) {
                objectArray2 = new Object[]{string, axisService.getName()};
                object = NLSProvider.getNLS().getFormattedMessage("annotations02", objectArray2, "An @WebMethod annotation on the Service Endpoint Interface {0} specified the [exclude] attribute for Web service {1}. This is not allowed on Service Endpoint Interfaces.");
                this.errorMsgs.add((String)object);
            }
            if ((object = Utils.getAxisOperation((String)(objectArray2 = webMethodRefObject.getOperationName()), axisService)) == null) {
                Object[] objectArray3 = new Object[]{string, axisService.getName(), objectArray2};
                objectArray = NLSProvider.getNLS().getFormattedMessage("annotations03", objectArray3, "The Service Endpoint Interface {0} for Web service {1} contains an @WebMethod annotation with the attribute [operationName]={2}, but the corresponding WSDL file does not contain this operation.");
                this.errorMsgs.add((String)objectArray);
                return;
            }
            try {
                Axis2Utils.setOperationValidated((AxisOperation)object);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.annotations.generator.WASAnnotationServiceGenerator.checkSEIWebMethodAnnotations", "515", this);
                objectArray = new Object[]{string, throwable};
                String string2 = NLSProvider.getNLS().getFormattedMessage("bldWebSrvsFail00", objectArray, "Internal error occurred while attempting to build a Web service for class {0}: {1}");
                Tr.error(_tc, "bldWebSrvsFail00", objectArray);
                this.errorMsgs.add(string2);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "checkSEIWebMethodAnnotations");
        }
    }

    private void validateOperations(AxisService axisService, String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "removeAxisOperations");
        }
        Iterator iterator = axisService.getOperations();
        while (iterator.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)iterator.next();
            Parameter parameter = Axis2Utils.getOperationValidated(axisOperation);
            if (parameter != null) continue;
            Object[] objectArray = new Object[]{axisOperation.getName().getLocalPart(), string};
            String string2 = NLSProvider.getNLS().getFormattedMessage("noOperInClass00", objectArray, "The operation {0} was found in the WSDL file but the corresponding method was not found in class {1}.");
            this.errorMsgs.add(string2);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "removeAxisOperations");
        }
    }

    private AxisService processSEI(ClassDataObject classDataObject, String string, String string2, String string3, String string4, String string5) {
        Object object;
        Object[] objectArray;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "processSEI");
        }
        WebServiceRefObject webServiceRefObject = (WebServiceRefObject)classDataObject.getEntry(ClassDataObjectFields.WEBSERVICE);
        String string6 = Utils.javifyQualifiedClassName((String)classDataObject.getEntry(ClassDataObjectFields.CLASS_NAME));
        String string7 = webServiceRefObject.getWSDLLocation();
        if (string7 == null) {
            string7 = string4;
            objectArray = new Object[]{string6, string};
            object = NLSProvider.getNLS().getFormattedMessage("noWsdlLocAttr00", objectArray, "The [wsdlLocation] attribute was not found in the Service Endpoint Interface {0} but was found in the implementation class {1}.");
            Tr.warning(_tc, (String)object);
        }
        objectArray = null;
        if (string7 == null || string7.equals("")) {
            object = new Object[]{string, string6};
            String string8 = NLSProvider.getNLS().getFormattedMessage("noWsdlLocAttr01", (Object[])object, "The Web service associated with the class {0} will not be loaded. The [wsdlLocation] attribute was not specified in the @WebService annotation of the Service Endpoint Interface {1}.");
            this.errorMsgs.add(string8);
            return null;
        }
        try {
            objectArray = this.loadStrategy.getInputStream(string7);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.annotations.generator.WASAnnotationServiceGenerator.processSEI", "555", this);
            Object[] objectArray2 = new Object[]{string7, string, exception};
            String string9 = NLSProvider.getNLS().getFormattedMessage("loadWsdlFail00", objectArray2, "Error occurred while attempting to load the WSDL file {0} specified by the @WebService annotation of the class {1}: {2}");
            Tr.error(_tc, "loadWsdlFail00", objectArray2);
            this.errorMsgs.add(string9);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "processSEI");
        }
        return this.buildAxisService((InputStream)objectArray, string7, string, string2, string3, string5, webServiceRefObject.getName());
    }

    private AxisService processImplBean(ClassDataObject classDataObject, WebServiceRefObject webServiceRefObject, String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "processImplBean");
        }
        String string2 = webServiceRefObject.getWSDLLocation();
        InputStream inputStream = null;
        if (string2 == null || string2.equals("")) {
            Object[] objectArray = new Object[]{webServiceRefObject.getServiceName(), string};
            String string3 = NLSProvider.getNLS().getFormattedMessage("noWsdlLocAttr02", objectArray, "The Web service {0} associated with the class {1} will not be loaded. The [wsdlLocation] attribute was not specified by the @WebService annotation within the class.");
            this.errorMsgs.add(string3);
            return null;
        }
        try {
            inputStream = this.loadStrategy.getInputStream(string2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.annotations.generator.WASAnnotationServiceGenerator.processImplBean", "596", this);
            Object[] objectArray = new Object[]{string2, string, exception};
            String string4 = NLSProvider.getNLS().getFormattedMessage("loadWsdlFail00", objectArray, "Error occurred while attempting to load the WSDL file {0} specified by the @WebService annotation of the class {1}: {2}");
            Tr.error(_tc, "loadWsdlFail00", objectArray);
            this.errorMsgs.add(string4);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "processImplBean");
        }
        return this.buildAxisService(inputStream, string2, string, webServiceRefObject.getServiceName(), webServiceRefObject.getPortName(), webServiceRefObject.getTargetNamespace(), webServiceRefObject.getName());
    }

    private AxisService processProvider(ClassDataObject classDataObject, WebServiceProviderRefObject webServiceProviderRefObject, String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "processProvider");
        }
        String string2 = webServiceProviderRefObject.getWSDLLocation();
        InputStream inputStream = null;
        if (string2 == null || string2.equals("")) {
            Object[] objectArray = new Object[]{webServiceProviderRefObject.getServiceName(), string};
            String string3 = NLSProvider.getNLS().getFormattedMessage("noWsdlLocAttr03", objectArray, "The Web service {0} associated with the class {1} will not be loaded. The [wsdlLocation] attribute was not specified by the @WebServiceProvider annotation within the class.");
            this.errorMsgs.add(string3);
            return null;
        }
        try {
            inputStream = this.loadStrategy.getInputStream(string2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.annotations.generator.WASAnnotationServiceGenerator.processProvider", "639", this);
            Object[] objectArray = new Object[]{string2, string, exception};
            String string4 = NLSProvider.getNLS().getFormattedMessage("loadWsdlFail01", objectArray, "Error occurred while attempting to load the WSDL file {0} specified by the @WebServiceProvider annotation of the class {1}: {2}");
            Tr.error(_tc, "loadWsdlFail01", objectArray);
            this.errorMsgs.add(string4);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "processProvider");
        }
        String string5 = "";
        string5 = string.indexOf(".") != 0 ? string.substring(string.lastIndexOf(".") + 1, string.length()) : string;
        return this.buildAxisService(inputStream, string2, string, webServiceProviderRefObject.getServiceName(), webServiceProviderRefObject.getPortName(), webServiceProviderRefObject.getTargetNamespace(), string5);
    }

    private AxisService buildAxisService(InputStream inputStream, String string, String string2, String string3, String string4, String string5, String string6) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "buildAxisService");
        }
        AxisService axisService = new AxisService();
        String string7 = "";
        try {
            Object object;
            Object[] objectArray;
            QName qName = new QName(string5, string3);
            if (string6 == null || this.serviceNames.contains(string6)) {
                if (!this.serviceNames.contains(string2)) {
                    string7 = string2;
                } else {
                    objectArray = new Object[]{string3, string2};
                    object = NLSProvider.getNLS().getFormattedMessage("usedSrvcName00", objectArray, "The service name {0} specified by the class {1} has already been used for the application module.");
                    this.errorMsgs.add((String)object);
                }
            } else {
                string7 = string6;
            }
            this.serviceNames.add(string7);
            objectArray = new WSDL11ToAxisServiceBuilder(inputStream, qName, string4);
            object = new ModuleWSDLLocator(string, inputStream, this.loadStrategy);
            WASURIResolver wASURIResolver = new WASURIResolver(this.loadStrategy);
            objectArray.setCustomWSLD4JResolver((WSDLLocator)object);
            objectArray.setCustomResolver(wASURIResolver);
            axisService = objectArray.populateService();
            this.addServiceParams(axisService, string, string2, qName, string4);
            axisService.setClassLoader(this.classLoader);
            axisService.setName(string7);
            this.setURLPatternParam(axisService, string3);
            this.setOperationMessageReceivers(axisService.getOperations());
            axisService.setWsdlFound(true);
            inputStream.close();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.annotations.generator.WASAnnotationServiceGenerator.buildAxisService", "803", this);
            Object[] objectArray = new Object[]{string3, throwable};
            String string8 = NLSProvider.getNLS().getFormattedMessage("annotations04", objectArray, "Error occurred while attempting to build the Web service {0} from the WSDL file: {1}");
            Tr.error(_tc, "annotations04", objectArray);
            this.errorMsgs.add(string8);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "buildAxisService");
        }
        return axisService;
    }

    private void addImplPublicMethods(ClassDataObject classDataObject, AxisService axisService, String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addImplPublicMethods");
        }
        ClassRefObject classRefObject = (ClassRefObject)classDataObject.getEntry(ClassDataObjectFields.CLASS_INFO);
        ArrayList<MethodRefObject> arrayList = classRefObject.getMethodRefs();
        ArrayList arrayList2 = (ArrayList)classDataObject.getEntry(ClassDataObjectFields.WEBMETHOD);
        ArrayList<String> arrayList3 = Utils.getAnnotatedMethods(arrayList2);
        if (arrayList != null && !arrayList.isEmpty()) {
            for (MethodRefObject methodRefObject : arrayList) {
                Object[] objectArray;
                if (!Utils.isPublic(methodRefObject) || Utils.isAnnotated(methodRefObject, arrayList3) || Utils.isControlOperation(methodRefObject)) continue;
                AxisOperation axisOperation = Utils.getAxisOperation(methodRefObject.getName(), axisService);
                if (axisOperation != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Adding the non-annoated public method of implementation bean: " + axisOperation.getName().getLocalPart());
                    }
                    try {
                        Axis2Utils.setOperationValidated(axisOperation);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.annotations.generator.WASAnnotationServiceGenerator.addImplPublicMethods", "865", this);
                        objectArray = new Object[]{string, throwable};
                        String string2 = NLSProvider.getNLS().getFormattedMessage("bldWebSrvsFail00", objectArray, "Internal error occurred while attempting to build a Web service for class {0}: {1}");
                        Tr.error(_tc, "bldWebSrvsFail00", objectArray);
                        this.errorMsgs.add(string2);
                    }
                    continue;
                }
                Object[] objectArray2 = new Object[]{methodRefObject.getName(), string};
                objectArray = NLSProvider.getNLS().getFormattedMessage("nonAnnotatedMthd00", objectArray2, "The non-annotated public method {0} in class {1} does not adhere to the service's WSDL contract.");
                this.errorMsgs.add((String)objectArray);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addImplPublicMethods");
        }
    }

    private void addSEIPublicMethods(ClassDataObject classDataObject, AxisService axisService, String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addSEIPublicMethods");
        }
        ClassRefObject classRefObject = (ClassRefObject)classDataObject.getEntry(ClassDataObjectFields.CLASS_INFO);
        ArrayList<MethodRefObject> arrayList = classRefObject.getMethodRefs();
        ArrayList arrayList2 = (ArrayList)classDataObject.getEntry(ClassDataObjectFields.WEBMETHOD);
        ArrayList<String> arrayList3 = Utils.getAnnotatedMethods(arrayList2);
        if (arrayList != null && !arrayList.isEmpty()) {
            for (MethodRefObject methodRefObject : arrayList) {
                Object[] objectArray;
                if (Utils.isAnnotated(methodRefObject, arrayList3)) continue;
                AxisOperation axisOperation = Utils.getAxisOperation(methodRefObject.getName(), axisService);
                if (axisOperation == null) {
                    Object[] objectArray2 = new Object[]{methodRefObject.getName(), string};
                    objectArray = NLSProvider.getNLS().getFormattedMessage("mthdNotInWsdl00", objectArray2, "The method {0} was specified in the Service Endpoint Interface {1} but not specified by the WSDL file.");
                    this.errorMsgs.add((String)objectArray);
                    return;
                }
                if (Axis2Utils.getOperationValidated(axisOperation) != null) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Adding non-annotated public method of SEI: " + axisOperation.getName().getLocalPart());
                }
                try {
                    Axis2Utils.setOperationValidated(axisOperation);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.annotations.generator.WASAnnotationServiceGenerator.addSEIPublicMethods", "939", this);
                    objectArray = new Object[]{string, throwable};
                    String string2 = NLSProvider.getNLS().getFormattedMessage("bldWebSrvsFail00", objectArray, "Internal error occurred while attempting to build a Web service for class {0}: {1}");
                    Tr.error(_tc, "bldWebSrvsFail00", objectArray);
                    this.errorMsgs.add(string2);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addSEIPublicMethods");
        }
    }

    private void validateImplementation(ClassDataObject classDataObject, ClassDataObject classDataObject2, String string, String string2) {
        ClassRefObject classRefObject = (ClassRefObject)classDataObject.getEntry(ClassDataObjectFields.CLASS_INFO);
        ArrayList<MethodRefObject> arrayList = classRefObject.getMethodRefs();
        ClassRefObject classRefObject2 = (ClassRefObject)classDataObject2.getEntry(ClassDataObjectFields.CLASS_INFO);
        ArrayList<MethodRefObject> arrayList2 = classRefObject2.getMethodRefs();
        if (arrayList != null && arrayList2 != null) {
            this.checkNames(arrayList, arrayList2, string, string2);
            this.checkParamTypes(arrayList, arrayList2, string, string2);
        }
    }

    private void checkNames(ArrayList<MethodRefObject> arrayList, ArrayList<MethodRefObject> arrayList2, String string, String string2) {
        for (MethodRefObject methodRefObject : arrayList2) {
            if (Utils.implementsMethod(methodRefObject.getName(), arrayList)) continue;
            Object[] objectArray = new Object[]{methodRefObject.getName(), string2, string};
            String string3 = NLSProvider.getNLS().getFormattedMessage("noMthdInImplBean00", objectArray, "The method {0} exists on the Service Endpoint Interface {1}, but the implementation class {2} does not implement this method.");
            this.errorMsgs.add(string3);
        }
    }

    private void checkParamTypes(ArrayList<MethodRefObject> arrayList, ArrayList<MethodRefObject> arrayList2, String string, String string2) {
        for (MethodRefObject methodRefObject : arrayList2) {
            Object[] objectArray;
            MethodRefObject methodRefObject2 = Utils.getMRef(methodRefObject.getName(), arrayList);
            if (methodRefObject2 == null) continue;
            String[] stringArray = methodRefObject.getSignature();
            String[] stringArray2 = methodRefObject2.getSignature();
            if (stringArray == null) continue;
            if (stringArray2 != null) {
                if (stringArray.length == stringArray2.length) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].equals(stringArray2[i])) continue;
                        objectArray = new Object[]{methodRefObject.getName(), string2, string};
                        String string3 = NLSProvider.getNLS().getFormattedMessage("badMthdSig00", objectArray, "The signature of method {0} in the Service Endpoint Interface {1} does not match the method signature in class {2}.");
                        this.errorMsgs.add(string3);
                    }
                    continue;
                }
                Object[] objectArray2 = new Object[]{methodRefObject.getName(), string2, string};
                objectArray = NLSProvider.getNLS().getFormattedMessage("badMthdSig00", objectArray2, "The signature of method {0} in the Service Endpoint Interface {1} does not match the method signature in class {2}.");
                this.errorMsgs.add((String)objectArray);
                continue;
            }
            Object[] objectArray3 = new Object[]{methodRefObject.getName(), string2, string};
            objectArray = NLSProvider.getNLS().getFormattedMessage("badMthdSig00", objectArray3, "The signature of method {0} in the Service Endpoint Interface {1} does not match the method signature in class {2}.");
            this.errorMsgs.add((String)objectArray);
        }
    }

    private void validateProviderEndpoint(ClassDataObject classDataObject, String string) {
        boolean bl = false;
        ClassRefObject classRefObject = (ClassRefObject)classDataObject.getEntry(ClassDataObjectFields.CLASS_INFO);
        String[] stringArray = classRefObject.getInterfaces();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].contains("javax/xml/ws/Provider") && !stringArray[i].contains("javax.xml.ws.Provider")) continue;
            bl = true;
        }
        if (!bl) {
            Object[] objectArray = new Object[]{string};
            String string2 = NLSProvider.getNLS().getFormattedMessage("notImplProvider00", objectArray, "The class {0} has an @WebServiceProvider annotation, but it does not implement javax.xml.ws.Provider.");
            this.errorMsgs.add(string2);
        }
    }

    private void setURLPatternParam(AxisService axisService, String string) {
        try {
            Axis2Utils.setURLPattern(axisService, "/" + string);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Set com.ibm.ws.websvcs.AxisServiceUrlPattern parameter on AxisService [" + string + "], value: /" + string);
            }
        }
        catch (AxisFault axisFault) {
            FFDCFilter.processException((Throwable)axisFault, "com.ibm.ws.websvcs.annotations.generator.WASAnnotationServiceGenerator.setURLPatternParam", "1102", this);
            Object[] objectArray = new Object[]{"", axisFault};
            String string2 = NLSProvider.getNLS().getFormattedMessage("bldWebSrvsFail00", objectArray, "Internal error occurred while attempting to build a Web service for class {0}: {1}");
            Tr.error(_tc, "bldWebSrvsFail00", objectArray);
            this.errorMsgs.add(string2);
        }
    }
}

