/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.generator;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.ClassDataObject;
import com.ibm.ws.metadata.ClassDataObjectFields;
import com.ibm.ws.metadata.ClassRefObject;
import com.ibm.ws.metadata.MetaDataScope;
import com.ibm.ws.metadata.MetaDataSubObject;
import com.ibm.ws.metadata.WebParamRefObject;
import com.ibm.ws.metadata.XmlListRefObject;
import com.ibm.ws.metadata.annotations.MethodRefObject;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.annotations.utils.Utils;
import com.ibm.ws.websvcs.exception.DeploymentException;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.websvcs.wsdl.ModuleWSDLLocator;
import com.ibm.ws.websvcs.wsdl.WASWSDLGenerator;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jws.WebParam;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.axis2.jaxws.description.builder.BindingTypeAnnot;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.FieldDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.HandlerChainAnnot;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.ParameterDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.RequestWrapperAnnot;
import org.apache.axis2.jaxws.description.builder.ResponseWrapperAnnot;
import org.apache.axis2.jaxws.description.builder.ServiceModeAnnot;
import org.apache.axis2.jaxws.description.builder.SoapBindingAnnot;
import org.apache.axis2.jaxws.description.builder.WebEndpointAnnot;
import org.apache.axis2.jaxws.description.builder.WebFaultAnnot;
import org.apache.axis2.jaxws.description.builder.WebMethodAnnot;
import org.apache.axis2.jaxws.description.builder.WebParamAnnot;
import org.apache.axis2.jaxws.description.builder.WebResultAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceClientAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceProviderAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceRefAnnot;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASAnnotationInputBuilder
implements Constants {
    private static final TraceComponent _tc = Tr.register(WASAnnotationInputBuilder.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private List<ClassDataObject> cdoList;
    private ClassRefObject classRef;
    private ArrayList<MetaDataSubObject> hcMethodList;
    private ArrayList<MetaDataSubObject> sbMethodList;
    private ArrayList<MetaDataSubObject> webMethodList;
    private ArrayList<MetaDataSubObject> webParamList;
    private ArrayList<MetaDataSubObject> xmlFieldList;
    private ArrayList<MetaDataSubObject> xmlMethodList;
    private ArrayList<MetaDataSubObject> xmlParameterList;
    private ArrayList<MetaDataSubObject> responseWrapperList;
    private ArrayList<MetaDataSubObject> requestWrapperList;
    private ArrayList<MetaDataSubObject> wsRefMethodList;
    private ArrayList<MetaDataSubObject> wsRefFieldList;
    private ArrayList<MetaDataSubObject> webEndpointList;
    private ArrayList<MetaDataSubObject> oneWayList;
    private ArrayList<MetaDataSubObject> webResultList;
    private ArrayList<MetaDataSubObject> wsRefList;
    private ClassLoader classLoader;
    private LoadStrategy loadStrategy;
    private String applicationName;
    private String moduleName;
    private ModuleFile moduleFile;

    public WASAnnotationInputBuilder(List<ClassDataObject> list, ClassLoader classLoader, ModuleFile moduleFile) {
        this.cdoList = list;
        this.classLoader = classLoader;
        this.loadStrategy = moduleFile.getLoadStrategy();
        this.applicationName = Axis2Utils.getApplicationNameFromModule(moduleFile);
        this.moduleName = moduleFile.getName();
        this.moduleFile = moduleFile;
    }

    public HashMap<String, DescriptionBuilderComposite> buildInputs() throws Exception {
        HashMap<String, DescriptionBuilderComposite> hashMap = new HashMap<String, DescriptionBuilderComposite>();
        for (ClassDataObject classDataObject : this.cdoList) {
            this.setAllAnnotationLists(classDataObject);
            try {
                DescriptionBuilderComposite descriptionBuilderComposite = this.convertCDOToDBC(classDataObject);
                hashMap.put(descriptionBuilderComposite.getClassName(), descriptionBuilderComposite);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.annotations.generator.WASAnnotationInputBuilder.buildInputs", "180", this);
                Object[] objectArray = new Object[]{(String)classDataObject.getEntry(ClassDataObjectFields.CLASS_NAME), exception};
                String string = NLSProvider.getNLS().getFormattedMessage("loadDBCFail00", objectArray, "Configuration data could not be created for the Web service related class {0} : {1}");
                throw new Exception(string);
            }
        }
        return hashMap;
    }

    private void setAllAnnotationLists(ClassDataObject classDataObject) {
        this.hcMethodList = (ArrayList)classDataObject.getEntry(ClassDataObjectFields.HANDLERCHAINMETHOD);
        this.sbMethodList = (ArrayList)classDataObject.getEntry(ClassDataObjectFields.SOAPBINDINGMETHOD);
        this.wsRefList = (ArrayList)classDataObject.getEntry(ClassDataObjectFields.WEBSERVICEREFNONTYPE);
        this.wsRefMethodList = this.separateWSRefAnnotations(this.wsRefList, MetaDataScope.METHOD);
        this.wsRefFieldList = this.separateWSRefAnnotations(this.wsRefList, MetaDataScope.FIELD);
        this.requestWrapperList = (ArrayList)classDataObject.getEntry(ClassDataObjectFields.REQUESTWRAPPER);
        this.responseWrapperList = (ArrayList)classDataObject.getEntry(ClassDataObjectFields.RESPONSEWRAPPER);
        this.webEndpointList = (ArrayList)classDataObject.getEntry(ClassDataObjectFields.WEBENDPOINT);
        this.oneWayList = (ArrayList)classDataObject.getEntry(ClassDataObjectFields.ONEWAY);
        this.webMethodList = (ArrayList)classDataObject.getEntry(ClassDataObjectFields.WEBMETHOD);
        this.webResultList = (ArrayList)classDataObject.getEntry(ClassDataObjectFields.WEBRESULT);
        this.webParamList = (ArrayList)classDataObject.getEntry(ClassDataObjectFields.WEBPARAM);
        this.xmlMethodList = (ArrayList)classDataObject.getEntry(ClassDataObjectFields.XMLLISTMETHOD);
        this.xmlFieldList = (ArrayList)classDataObject.getEntry(ClassDataObjectFields.XMLLISTFIELD);
        this.xmlParameterList = (ArrayList)classDataObject.getEntry(ClassDataObjectFields.XMLLISTPARAMETER);
    }

    private ArrayList<MetaDataSubObject> separateWSRefAnnotations(ArrayList<MetaDataSubObject> arrayList, MetaDataScope metaDataScope) {
        if (arrayList != null && !arrayList.isEmpty()) {
            ArrayList<MetaDataSubObject> arrayList2 = new ArrayList<MetaDataSubObject>();
            for (MetaDataSubObject metaDataSubObject : arrayList) {
                if (!metaDataSubObject.getScope().equals((Object)metaDataScope)) continue;
                arrayList2.add(metaDataSubObject);
            }
            return arrayList2;
        }
        return null;
    }

    private DescriptionBuilderComposite convertCDOToDBC(ClassDataObject classDataObject) throws DeploymentException, ClassNotFoundException {
        DescriptionBuilderComposite descriptionBuilderComposite = new DescriptionBuilderComposite();
        this.attachClassLevelInfo(classDataObject, descriptionBuilderComposite);
        this.attachMethodLevelInfo(classDataObject, descriptionBuilderComposite);
        this.attachFieldLevelInfo(classDataObject, descriptionBuilderComposite);
        return descriptionBuilderComposite;
    }

    private void attachClassLevelInfo(ClassDataObject classDataObject, DescriptionBuilderComposite descriptionBuilderComposite) throws DeploymentException {
        this.attachClassInfo(classDataObject, descriptionBuilderComposite);
        this.attachWebServiceAnnotation(classDataObject, descriptionBuilderComposite);
        this.attachWebServiceProviderAnnotation(classDataObject, descriptionBuilderComposite);
        this.attachHandlerChainAnnotation(classDataObject, descriptionBuilderComposite);
        this.attachServiceModeAnnotation(classDataObject, descriptionBuilderComposite);
        this.attachBindingTypeAnnotation(classDataObject, descriptionBuilderComposite);
        this.attachSoapBindingAnnotationClass(classDataObject, descriptionBuilderComposite);
        this.attachWebFaultAnnotation(classDataObject, descriptionBuilderComposite);
        this.attachWebServiceClientAnnotation(classDataObject, descriptionBuilderComposite);
        this.attachWebServiceRefAnnotation(classDataObject, descriptionBuilderComposite);
    }

    private void attachClassInfo(ClassDataObject classDataObject, DescriptionBuilderComposite descriptionBuilderComposite) throws DeploymentException {
        this.classRef = (ClassRefObject)classDataObject.getEntry(ClassDataObjectFields.CLASS_INFO);
        if (this.classRef == null) {
            throw new DeploymentException("Missing class-level info");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.classRef.getInterfaces();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(this.javifyName(stringArray[i]));
        }
        if (Utils.isPublicClass(classDataObject)) {
            descriptionBuilderComposite.setIsInterface(false);
        } else {
            descriptionBuilderComposite.setIsInterface(true);
        }
        descriptionBuilderComposite.setInterfacesList(arrayList);
        descriptionBuilderComposite.setSuperClassName(this.classRef.getSuperName() != null ? this.javifyName(this.classRef.getSuperName()) : null);
        String string = (String)classDataObject.getEntry(ClassDataObjectFields.CLASS_NAME);
        descriptionBuilderComposite.setClassName(this.javifyName(string));
        descriptionBuilderComposite.setClassLoader(this.classLoader);
    }

    private void attachWebServiceAnnotation(ClassDataObject classDataObject, DescriptionBuilderComposite descriptionBuilderComposite) throws DeploymentException {
        WebServiceAnnot webServiceAnnot = (WebServiceAnnot)classDataObject.getEntry(ClassDataObjectFields.WEBSERVICE);
        if (webServiceAnnot != null) {
            descriptionBuilderComposite.setWebServiceAnnot(webServiceAnnot);
            if (webServiceAnnot.wsdlLocation() != null && !"".equals(webServiceAnnot.wsdlLocation())) {
                this.attachWSDLDefinition(webServiceAnnot.wsdlLocation(), descriptionBuilderComposite);
            }
            if (this.getOutputDirectory() != null) {
                descriptionBuilderComposite.setCustomWsdlGenerator(new WASWSDLGenerator(this.getOutputDirectory(), this.applicationName, this.moduleFile));
            }
        }
    }

    private void attachWebServiceProviderAnnotation(ClassDataObject classDataObject, DescriptionBuilderComposite descriptionBuilderComposite) throws DeploymentException {
        WebServiceProviderAnnot webServiceProviderAnnot = (WebServiceProviderAnnot)classDataObject.getEntry(ClassDataObjectFields.WEBSERVICEPROVIDER);
        if (webServiceProviderAnnot != null) {
            descriptionBuilderComposite.setWebServiceProviderAnnot(webServiceProviderAnnot);
            if (webServiceProviderAnnot.wsdlLocation() != null && !"".equals(webServiceProviderAnnot.wsdlLocation())) {
                this.attachWSDLDefinition(webServiceProviderAnnot.wsdlLocation(), descriptionBuilderComposite);
            }
        }
    }

    private void attachHandlerChainAnnotation(ClassDataObject classDataObject, DescriptionBuilderComposite descriptionBuilderComposite) {
        HandlerChainAnnot handlerChainAnnot = (HandlerChainAnnot)classDataObject.getEntry(ClassDataObjectFields.HANDLERCHAIN);
        if (handlerChainAnnot != null) {
            descriptionBuilderComposite.setHandlerChainAnnot(handlerChainAnnot);
        }
    }

    private void attachHandlerChainAnnotation(ClassDataObject classDataObject, MethodRefObject methodRefObject, MethodDescriptionComposite methodDescriptionComposite) {
        boolean bl = false;
        if (this.hcMethodList != null && !this.hcMethodList.isEmpty()) {
            Iterator<MetaDataSubObject> iterator = this.hcMethodList.iterator();
            while (iterator.hasNext() && !bl) {
                MetaDataSubObject metaDataSubObject = iterator.next();
                if (!this.matchesMethod(methodRefObject, metaDataSubObject)) continue;
                bl = true;
                HandlerChainAnnot handlerChainAnnot = (HandlerChainAnnot)metaDataSubObject.getValue();
                methodDescriptionComposite.setHandlerChainAnnot(handlerChainAnnot);
            }
        }
    }

    private ArrayList<FieldDescriptionComposite> attachHandlerChainAnnotation(ClassDataObject classDataObject, ArrayList<FieldDescriptionComposite> arrayList) {
        ArrayList arrayList2 = (ArrayList)classDataObject.getEntry(ClassDataObjectFields.HANDLERCHAINFIELD);
        if (arrayList2 != null && !arrayList2.isEmpty()) {
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                FieldDescriptionComposite fieldDescriptionComposite = new FieldDescriptionComposite();
                MetaDataSubObject metaDataSubObject = (MetaDataSubObject)iterator.next();
                fieldDescriptionComposite.setFieldName(metaDataSubObject.getName());
                HandlerChainAnnot handlerChainAnnot = (HandlerChainAnnot)metaDataSubObject.getValue();
                fieldDescriptionComposite.setHandlerChainAnnot(handlerChainAnnot);
                arrayList.add(fieldDescriptionComposite);
            }
            return arrayList;
        }
        return null;
    }

    private ArrayList<FieldDescriptionComposite> attachXmlListAnnotation(ClassDataObject classDataObject, ArrayList<FieldDescriptionComposite> arrayList) {
        if (this.xmlFieldList != null && !this.xmlFieldList.isEmpty()) {
            Iterator<MetaDataSubObject> iterator = this.xmlFieldList.iterator();
            while (iterator.hasNext()) {
                FieldDescriptionComposite fieldDescriptionComposite = new FieldDescriptionComposite();
                MetaDataSubObject metaDataSubObject = iterator.next();
                fieldDescriptionComposite.setFieldName(metaDataSubObject.getName());
                fieldDescriptionComposite.setIsListType(true);
                arrayList.add(fieldDescriptionComposite);
            }
            return arrayList;
        }
        return null;
    }

    private void attachServiceModeAnnotation(ClassDataObject classDataObject, DescriptionBuilderComposite descriptionBuilderComposite) {
        ServiceModeAnnot serviceModeAnnot = (ServiceModeAnnot)classDataObject.getEntry(ClassDataObjectFields.SERVICEMODE);
        if (serviceModeAnnot != null) {
            descriptionBuilderComposite.setServiceModeAnnot(serviceModeAnnot);
        }
    }

    private void attachBindingTypeAnnotation(ClassDataObject classDataObject, DescriptionBuilderComposite descriptionBuilderComposite) {
        BindingTypeAnnot bindingTypeAnnot = (BindingTypeAnnot)classDataObject.getEntry(ClassDataObjectFields.BINDINGTYPE);
        if (bindingTypeAnnot != null) {
            descriptionBuilderComposite.setBindingTypeAnnot(bindingTypeAnnot);
        }
    }

    private void attachSoapBindingAnnotationClass(ClassDataObject classDataObject, DescriptionBuilderComposite descriptionBuilderComposite) {
        SoapBindingAnnot soapBindingAnnot = (SoapBindingAnnot)classDataObject.getEntry(ClassDataObjectFields.SOAPBINDING);
        if (soapBindingAnnot != null) {
            descriptionBuilderComposite.setSoapBindingAnnot(soapBindingAnnot);
        }
    }

    private void attachSoapBindingAnnotation(ClassDataObject classDataObject, MethodRefObject methodRefObject, MethodDescriptionComposite methodDescriptionComposite) {
        boolean bl = false;
        if (this.sbMethodList != null && !this.sbMethodList.isEmpty()) {
            Iterator<MetaDataSubObject> iterator = this.sbMethodList.iterator();
            while (iterator.hasNext() && !bl) {
                MetaDataSubObject metaDataSubObject = iterator.next();
                if (!this.matchesMethod(methodRefObject, metaDataSubObject)) continue;
                bl = true;
                SoapBindingAnnot soapBindingAnnot = (SoapBindingAnnot)metaDataSubObject.getValue();
                methodDescriptionComposite.setSoapBindingAnnot(soapBindingAnnot);
            }
        }
    }

    private void attachWebFaultAnnotation(ClassDataObject classDataObject, DescriptionBuilderComposite descriptionBuilderComposite) {
        WebFaultAnnot webFaultAnnot = (WebFaultAnnot)classDataObject.getEntry(ClassDataObjectFields.WEBFAULT);
        if (webFaultAnnot != null) {
            descriptionBuilderComposite.setWebFaultAnnot(webFaultAnnot);
        }
    }

    private void attachWebServiceClientAnnotation(ClassDataObject classDataObject, DescriptionBuilderComposite descriptionBuilderComposite) {
        WebServiceClientAnnot webServiceClientAnnot = (WebServiceClientAnnot)classDataObject.getEntry(ClassDataObjectFields.WEBSERVICECLIENT);
        if (webServiceClientAnnot != null) {
            descriptionBuilderComposite.setWebServiceClientAnnot(webServiceClientAnnot);
        }
    }

    private void attachWebServiceRefAnnotation(ClassDataObject classDataObject, DescriptionBuilderComposite descriptionBuilderComposite) {
        ArrayList arrayList = (ArrayList)classDataObject.getEntry(ClassDataObjectFields.WEBSERVICEREF);
        if (arrayList != null && !arrayList.isEmpty()) {
            for (WebServiceRefAnnot webServiceRefAnnot : arrayList) {
                descriptionBuilderComposite.addWebServiceRefAnnot(webServiceRefAnnot);
            }
        }
    }

    private void attachWebServiceRefAnnotation(ClassDataObject classDataObject, MethodRefObject methodRefObject, MethodDescriptionComposite methodDescriptionComposite) {
        boolean bl = false;
        if (this.wsRefMethodList != null && !this.wsRefMethodList.isEmpty()) {
            Iterator<MetaDataSubObject> iterator = this.wsRefMethodList.iterator();
            while (iterator.hasNext() && !bl) {
                MetaDataSubObject metaDataSubObject = iterator.next();
                if (!this.matchesMethod(methodRefObject, metaDataSubObject)) continue;
                bl = true;
                WebServiceRefAnnot webServiceRefAnnot = (WebServiceRefAnnot)metaDataSubObject.getValue();
                methodDescriptionComposite.setWebServiceRefAnnot(webServiceRefAnnot);
            }
        }
    }

    private ArrayList<FieldDescriptionComposite> attachWebServiceRefAnnotation(ClassDataObject classDataObject, ArrayList<FieldDescriptionComposite> arrayList) {
        if (this.wsRefFieldList != null && !this.wsRefFieldList.isEmpty()) {
            Iterator<MetaDataSubObject> iterator = this.wsRefFieldList.iterator();
            while (iterator.hasNext()) {
                FieldDescriptionComposite fieldDescriptionComposite = new FieldDescriptionComposite();
                MetaDataSubObject metaDataSubObject = iterator.next();
                fieldDescriptionComposite.setFieldName(metaDataSubObject.getName());
                WebServiceRefAnnot webServiceRefAnnot = (WebServiceRefAnnot)metaDataSubObject.getValue();
                fieldDescriptionComposite.setWebServiceRefAnnot(webServiceRefAnnot);
                arrayList.add(fieldDescriptionComposite);
            }
            return arrayList;
        }
        return null;
    }

    private void attachMethodLevelInfo(ClassDataObject classDataObject, DescriptionBuilderComposite descriptionBuilderComposite) throws ClassNotFoundException {
        ArrayList<MethodRefObject> arrayList = this.classRef.getMethodRefs();
        if (arrayList != null && !arrayList.isEmpty()) {
            for (MethodRefObject methodRefObject : arrayList) {
                if (!Utils.isPublicMethod(methodRefObject.getAccess())) continue;
                MethodDescriptionComposite methodDescriptionComposite = new MethodDescriptionComposite();
                methodDescriptionComposite.setDescriptionBuilderCompositeRef(descriptionBuilderComposite);
                methodDescriptionComposite.setMethodName(methodRefObject.getName());
                methodDescriptionComposite.setExceptions(this.javifyExceptions(methodRefObject.getExceptions()));
                methodDescriptionComposite.setReturnType(this.javifyName(methodRefObject.getReturnType()));
                this.attachRequestWrapperAnnotation(classDataObject, methodRefObject, methodDescriptionComposite);
                this.attachResponseWrapperAnnotation(classDataObject, methodRefObject, methodDescriptionComposite);
                this.attachSoapBindingAnnotation(classDataObject, methodRefObject, methodDescriptionComposite);
                this.attachWebEndpointAnnotation(classDataObject, methodRefObject, methodDescriptionComposite);
                this.attachWebServiceRefAnnotation(classDataObject, methodRefObject, methodDescriptionComposite);
                this.attachHandlerChainAnnotation(classDataObject, methodRefObject, methodDescriptionComposite);
                this.attachOneWayAnnotation(classDataObject, methodRefObject, methodDescriptionComposite);
                this.attachWebMethodAnnotation(classDataObject, methodRefObject, methodDescriptionComposite);
                this.attachWebResultAnnotation(classDataObject, methodRefObject, methodDescriptionComposite);
                this.attachXmlListAnnotation(classDataObject, methodRefObject, methodDescriptionComposite);
                String[] stringArray = methodRefObject.getSignature();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    ParameterDescriptionComposite parameterDescriptionComposite = new ParameterDescriptionComposite();
                    parameterDescriptionComposite.setMethodDescriptionCompositeRef(methodDescriptionComposite);
                    parameterDescriptionComposite.setParameterType(string);
                    parameterDescriptionComposite.setListOrder(i);
                    this.attachWebParamAnnotation(classDataObject, methodRefObject, string, i, parameterDescriptionComposite);
                    this.attachXmlListAnnotation(classDataObject, methodRefObject, string, i, parameterDescriptionComposite);
                    methodDescriptionComposite.addParameterDescriptionComposite(parameterDescriptionComposite);
                }
                descriptionBuilderComposite.addMethodDescriptionComposite(methodDescriptionComposite);
            }
        }
    }

    private void attachRequestWrapperAnnotation(ClassDataObject classDataObject, MethodRefObject methodRefObject, MethodDescriptionComposite methodDescriptionComposite) {
        boolean bl = false;
        if (this.requestWrapperList != null && !this.requestWrapperList.isEmpty()) {
            Iterator<MetaDataSubObject> iterator = this.requestWrapperList.iterator();
            while (iterator.hasNext() && !bl) {
                MetaDataSubObject metaDataSubObject = iterator.next();
                if (!this.matchesMethod(methodRefObject, metaDataSubObject)) continue;
                bl = true;
                RequestWrapperAnnot requestWrapperAnnot = (RequestWrapperAnnot)metaDataSubObject.getValue();
                methodDescriptionComposite.setRequestWrapperAnnot(requestWrapperAnnot);
            }
        }
    }

    private void attachResponseWrapperAnnotation(ClassDataObject classDataObject, MethodRefObject methodRefObject, MethodDescriptionComposite methodDescriptionComposite) {
        boolean bl = false;
        if (this.responseWrapperList != null && !this.responseWrapperList.isEmpty()) {
            Iterator<MetaDataSubObject> iterator = this.responseWrapperList.iterator();
            while (iterator.hasNext() && !bl) {
                MetaDataSubObject metaDataSubObject = iterator.next();
                if (!this.matchesMethod(methodRefObject, metaDataSubObject)) continue;
                bl = true;
                ResponseWrapperAnnot responseWrapperAnnot = (ResponseWrapperAnnot)metaDataSubObject.getValue();
                methodDescriptionComposite.setResponseWrapperAnnot(responseWrapperAnnot);
            }
        }
    }

    private void attachWebEndpointAnnotation(ClassDataObject classDataObject, MethodRefObject methodRefObject, MethodDescriptionComposite methodDescriptionComposite) {
        boolean bl = false;
        if (this.webEndpointList != null && !this.webEndpointList.isEmpty()) {
            Iterator<MetaDataSubObject> iterator = this.webEndpointList.iterator();
            while (iterator.hasNext() && !bl) {
                MetaDataSubObject metaDataSubObject = iterator.next();
                if (!this.matchesMethod(methodRefObject, metaDataSubObject)) continue;
                bl = true;
                WebEndpointAnnot webEndpointAnnot = (WebEndpointAnnot)metaDataSubObject.getValue();
                methodDescriptionComposite.setWebEndpointAnnot(webEndpointAnnot);
            }
        }
    }

    private void attachOneWayAnnotation(ClassDataObject classDataObject, MethodRefObject methodRefObject, MethodDescriptionComposite methodDescriptionComposite) {
        boolean bl = false;
        if (this.oneWayList != null && !this.oneWayList.isEmpty()) {
            Iterator<MetaDataSubObject> iterator = this.oneWayList.iterator();
            while (iterator.hasNext() && !bl) {
                MetaDataSubObject metaDataSubObject = iterator.next();
                if (!this.matchesMethod(methodRefObject, metaDataSubObject)) continue;
                bl = true;
                methodDescriptionComposite.setOneWayAnnot(true);
            }
        }
    }

    private void attachXmlListAnnotation(ClassDataObject classDataObject, MethodRefObject methodRefObject, MethodDescriptionComposite methodDescriptionComposite) {
        boolean bl = false;
        if (this.xmlMethodList != null && !this.xmlMethodList.isEmpty()) {
            Iterator<MetaDataSubObject> iterator = this.xmlMethodList.iterator();
            while (iterator.hasNext() && !bl) {
                MetaDataSubObject metaDataSubObject = iterator.next();
                if (!this.matchesMethod(methodRefObject, metaDataSubObject)) continue;
                bl = true;
                methodDescriptionComposite.setIsListType(true);
            }
        }
    }

    private void attachWebMethodAnnotation(ClassDataObject classDataObject, MethodRefObject methodRefObject, MethodDescriptionComposite methodDescriptionComposite) {
        boolean bl = false;
        if (this.webMethodList != null && !this.webMethodList.isEmpty()) {
            Iterator<MetaDataSubObject> iterator = this.webMethodList.iterator();
            while (iterator.hasNext() && !bl) {
                MetaDataSubObject metaDataSubObject = iterator.next();
                if (!this.matchesMethod(methodRefObject, metaDataSubObject)) continue;
                bl = true;
                WebMethodAnnot webMethodAnnot = (WebMethodAnnot)metaDataSubObject.getValue();
                methodDescriptionComposite.setWebMethodAnnot(webMethodAnnot);
            }
        }
    }

    private void attachWebResultAnnotation(ClassDataObject classDataObject, MethodRefObject methodRefObject, MethodDescriptionComposite methodDescriptionComposite) {
        boolean bl = false;
        if (this.webResultList != null && !this.webResultList.isEmpty()) {
            Iterator<MetaDataSubObject> iterator = this.webResultList.iterator();
            while (iterator.hasNext() && !bl) {
                MetaDataSubObject metaDataSubObject = iterator.next();
                if (!this.matchesMethod(methodRefObject, metaDataSubObject)) continue;
                bl = true;
                WebResultAnnot webResultAnnot = (WebResultAnnot)metaDataSubObject.getValue();
                methodDescriptionComposite.setWebResultAnnot(webResultAnnot);
            }
        }
    }

    private void attachWebParamAnnotation(ClassDataObject classDataObject, MethodRefObject methodRefObject, String string, int n, ParameterDescriptionComposite parameterDescriptionComposite) {
        if (this.webParamList != null && !this.webParamList.isEmpty()) {
            for (MetaDataSubObject metaDataSubObject : this.webParamList) {
                WebParamRefObject webParamRefObject = (WebParamRefObject)metaDataSubObject.getValue();
                if (!this.matchesMethod(methodRefObject, metaDataSubObject) || webParamRefObject.getArgOrder() != n) continue;
                WebParamAnnot webParamAnnot = webParamRefObject.getWebParamAnnot();
                parameterDescriptionComposite.setWebParamAnnot(webParamAnnot);
            }
        }
    }

    private void attachXmlListAnnotation(ClassDataObject classDataObject, MethodRefObject methodRefObject, String string, int n, ParameterDescriptionComposite parameterDescriptionComposite) {
        if (this.xmlParameterList != null && !this.xmlParameterList.isEmpty()) {
            for (MetaDataSubObject metaDataSubObject : this.xmlParameterList) {
                XmlListRefObject xmlListRefObject = (XmlListRefObject)metaDataSubObject.getValue();
                if (!this.matchesMethod(methodRefObject, metaDataSubObject) || xmlListRefObject.getArgOrder() != n) continue;
                parameterDescriptionComposite.setIsListType(true);
            }
        }
    }

    private WebParam.Mode getWebParamMode(String string) {
        if (string == null || "".equals(string) || string.equals("IN")) {
            return WebParam.Mode.IN;
        }
        if (string.equals("OUT")) {
            return WebParam.Mode.OUT;
        }
        return WebParam.Mode.INOUT;
    }

    private void attachFieldLevelInfo(ClassDataObject classDataObject, DescriptionBuilderComposite descriptionBuilderComposite) {
        ArrayList<FieldDescriptionComposite> arrayList = new ArrayList<FieldDescriptionComposite>();
        this.attachHandlerChainAnnotation(classDataObject, arrayList);
        this.attachWebServiceRefAnnotation(classDataObject, arrayList);
        this.attachXmlListAnnotation(classDataObject, arrayList);
        if (arrayList != null && !arrayList.isEmpty()) {
            for (FieldDescriptionComposite fieldDescriptionComposite : arrayList) {
                descriptionBuilderComposite.addFieldDescriptionComposite(fieldDescriptionComposite);
            }
        }
    }

    private boolean matchesMethod(MethodRefObject methodRefObject, MetaDataSubObject metaDataSubObject) {
        String[] stringArray;
        if (!methodRefObject.getName().equals(metaDataSubObject.getName())) {
            return false;
        }
        String[] stringArray2 = methodRefObject.getSignature();
        if (stringArray2.length != (stringArray = metaDataSubObject.getSignature().split(" ")).length) {
            return stringArray2.length == 0 && stringArray.length == 1 && stringArray[0].equals("");
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].equals(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    private boolean convertStringToBoolean(String string, boolean bl) {
        if (string == null || "".equals(string)) {
            return bl;
        }
        return !string.equals("false");
    }

    private void attachWSDLDefinition(String string, DescriptionBuilderComposite descriptionBuilderComposite) throws DeploymentException {
        block7: {
            try {
                Definition definition;
                block8: {
                    URL uRL = null;
                    if (Axis2Utils.isAbsolutePath(string)) {
                        Object[] objectArray = new Object[]{descriptionBuilderComposite.getClassName(), string};
                        String string2 = NLSProvider.getNLS().getFormattedMessage("badWsdlLocation00", objectArray, "The Web service implementation class {0} refers to the absolute WSDL location {1} via annotations. Absolute WSDL references are not allowed in @WebService or @WebServiceProvider annotations according to JAX-WS.");
                        throw new DeploymentException(string2);
                    }
                    InputStream inputStream = null;
                    if (this.classLoader != null) {
                        uRL = this.classLoader.getResource(string);
                    }
                    if ((inputStream = uRL != null ? uRL.openStream() : this.loadStrategy.getResourceInputStream(string)) == null) break block7;
                    ModuleWSDLLocator moduleWSDLLocator = new ModuleWSDLLocator(string, inputStream, this.loadStrategy);
                    descriptionBuilderComposite.setwsdlURL(uRL);
                    WSDLFactory wSDLFactory = WSDLFactory.newInstance();
                    WSDLReader wSDLReader = wSDLFactory.newWSDLReader();
                    wSDLReader.setFeature("javax.wsdl.verbose", false);
                    definition = wSDLReader.readWSDL(moduleWSDLLocator);
                    if (uRL != null) {
                        try {
                            definition.setDocumentBaseURI(uRL.toURI().toString());
                        }
                        catch (Exception exception) {
                            if (!_tc.isDebugEnabled()) break block8;
                            Tr.debug(_tc, "Could not set document base URI on WSDL definition");
                        }
                    }
                }
                descriptionBuilderComposite.setWsdlDefinition(definition);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.annotations.generator.WASAnnotationInputBuilder.attachWSDLDefinition", "1153", this);
                Object[] objectArray = new Object[]{string, descriptionBuilderComposite.getClassName().replace('/', '.'), throwable};
                String string3 = NLSProvider.getNLS().getFormattedMessage("loadWsdlFail02", objectArray, "Error occurred attempting to load the WSDL file {0} specified by annotations in the class {1}: {2}");
                Tr.error(_tc, string3);
                throw new DeploymentException(throwable);
            }
        }
    }

    private String getOutputDirectory() {
        String string = Axis2Utils.getCacheDirectory();
        if (string != null) {
            string = string + this.applicationName + File.separator + this.moduleName + File.separator;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Output directory for WsGen artifacts: " + string);
        }
        return string;
    }

    private String[] javifyExceptions(String[] stringArray) {
        if (stringArray != null) {
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                stringArray2[i] = string = this.javifyName(stringArray[i]);
            }
            return stringArray2;
        }
        return null;
    }

    private String javifyName(String string) {
        return string.replaceAll("/", ".");
    }
}

