/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.collector;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.ClassDataObject;
import com.ibm.ws.metadata.ClassDataObjectFields;
import com.ibm.ws.metadata.ClassRefObject;
import com.ibm.ws.metadata.ConfigReader;
import com.ibm.ws.metadata.FileLocator;
import com.ibm.ws.metadata.MetaDataOrchestrator;
import com.ibm.ws.metadata.MetaDataSources;
import com.ibm.ws.metadata.ModuleDataObject;
import com.ibm.ws.metadata.annotations.AnnotationConfigReader;
import com.ibm.ws.metadata.annotations.MethodRefObject;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.annotations.utils.Utils;
import com.ibm.ws.websvcs.deployment.HierarchyFileLocator;
import com.ibm.ws.websvcs.resources.NLSProvider;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASAnnotationCollector
implements Constants {
    private static final TraceComponent _tc = Tr.register(WASAnnotationCollector.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private HashMap<String, ClassDataObject> cdoMap;
    private HashMap<String, ClassDataObject> checkedSuperClasses;
    private HashMap<String, ClassDataObject> checkedSuperInterfaces;
    private ArrayList<ClassDataObject> cdoList = new ArrayList();
    private ClassLoader classLoader;
    private LoadStrategy loadStrategy;

    public WASAnnotationCollector() {
        this.cdoMap = new HashMap();
        this.checkedSuperClasses = new HashMap();
        this.checkedSuperInterfaces = new HashMap();
    }

    public ArrayList<ClassDataObject> collect(List<FileLocator> list) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "collect");
        }
        if (!list.isEmpty()) {
            ModuleDataObject moduleDataObject = this.getMDO(list);
            if (moduleDataObject != null) {
                Collection<ClassDataObject> collection = moduleDataObject.getAllClassDataObjects();
                if (collection != null && collection.size() > 0) {
                    Object object;
                    for (ClassDataObject object22 : collection) {
                        object = (String)object22.getEntry(ClassDataObjectFields.CLASS_NAME);
                        Integer n = (Integer)object22.getEntry(ClassDataObjectFields.CLASS_ACCESS);
                        if (!this.collectClass(object22) && !this.checkLocator(list.get(0)) || this.cdoMap.get(object) != null || !Utils.isPublicType(n)) continue;
                        this.cdoMap.put((String)object, object22);
                        this.cdoList.add(object22);
                    }
                    List<FileLocator> list2 = this.getExceptionLocators();
                    this.addExceptionCDOS(list2);
                    object = this.resolveInheritance(moduleDataObject);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Making recursive ASM call with " + object.size() + " inheritance derived file locators");
                    }
                    return this.collect((List<FileLocator>)object);
                }
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "collect");
                }
                return this.cdoList;
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "collect");
            }
            return this.cdoList;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "collect");
        }
        return this.cdoList;
    }

    public List<ClassDataObject> collectCachedList(List<FileLocator> list) {
        Collection<ClassDataObject> collection;
        ModuleDataObject moduleDataObject;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "collectCachedList");
        }
        if ((moduleDataObject = this.getMDO(list)) != null && (collection = moduleDataObject.getAllClassDataObjects()) != null && collection.size() > 0) {
            for (ClassDataObject classDataObject : collection) {
                this.cdoList.add(classDataObject);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "collectCachedList");
        }
        return this.cdoList;
    }

    private ModuleDataObject getMDO(List<FileLocator> list) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getMDO");
        }
        MetaDataOrchestrator metaDataOrchestrator = new MetaDataOrchestrator();
        MetaDataSources metaDataSources = new MetaDataSources();
        metaDataSources.iv_Sources[MetaDataSources.sv_FileLocatorIndex] = list.iterator();
        ConfigReader[] configReaderArray = new ConfigReader[]{new AnnotationConfigReader("WSClassAdapter")};
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Calling into ASM with FileLocator size: " + list.size());
        }
        ModuleDataObject moduleDataObject = metaDataOrchestrator.getModuleData(configReaderArray, metaDataSources, "", "");
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getMDO");
        }
        return moduleDataObject;
    }

    private boolean collectClass(ClassDataObject classDataObject) {
        Object object = classDataObject.getEntry(ClassDataObjectFields.WEBSERVICE);
        if (object != null) {
            return true;
        }
        object = classDataObject.getEntry(ClassDataObjectFields.WEBSERVICEPROVIDER);
        if (object != null) {
            return true;
        }
        object = classDataObject.getEntry(ClassDataObjectFields.WEBSERVICECLIENT);
        if (object != null) {
            return true;
        }
        object = classDataObject.getEntry(ClassDataObjectFields.WEBFAULT);
        return object != null;
    }

    private List<FileLocator> resolveInheritance(ModuleDataObject moduleDataObject) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "resolveInheritance");
        }
        ArrayList<FileLocator> arrayList = new ArrayList<FileLocator>();
        HashMap<String, FileLocator> hashMap = new HashMap<String, FileLocator>();
        ArrayList<ClassDataObject> arrayList2 = new ArrayList<ClassDataObject>();
        ArrayList<ClassDataObject> arrayList3 = new ArrayList<ClassDataObject>();
        this.resolveExtendedClasses(arrayList2, moduleDataObject, arrayList, hashMap);
        this.resolveImplementedInterfaces(arrayList3, moduleDataObject, arrayList, hashMap);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "resolveInheritance");
        }
        return arrayList;
    }

    private void resolveExtendedClasses(List<ClassDataObject> list, ModuleDataObject moduleDataObject, ArrayList<FileLocator> arrayList, HashMap<String, FileLocator> hashMap) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "resolveExtendedClasses");
        }
        for (ClassDataObject object : this.cdoList) {
            String string = (String)object.getEntry(ClassDataObjectFields.CLASS_NAME);
            if (this.checkedSuperClasses.get(string) != null) continue;
            this.checkedSuperClasses.put(string, object);
            ClassRefObject classRefObject = (ClassRefObject)object.getEntry(ClassDataObjectFields.CLASS_INFO);
            if (classRefObject == null) continue;
            String string2 = classRefObject.getSuperName();
            this.addSuperClass(list, moduleDataObject, string2, arrayList, hashMap);
        }
        for (ClassDataObject classDataObject : list) {
            this.cdoMap.put((String)classDataObject.getEntry(ClassDataObjectFields.CLASS_NAME), classDataObject);
            this.cdoList.add(classDataObject);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "resolveExtendedClasses");
        }
    }

    private void addSuperClass(List<ClassDataObject> list, ModuleDataObject moduleDataObject, String string, ArrayList<FileLocator> arrayList, HashMap<String, FileLocator> hashMap) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addSuperClass");
        }
        if (!string.equals("java/lang/Object")) {
            ClassDataObject classDataObject = moduleDataObject.getClassDataObject(string);
            if (classDataObject != null) {
                if (this.cdoMap.get(string) == null) {
                    list.add(classDataObject);
                }
                ClassRefObject classRefObject = (ClassRefObject)classDataObject.getEntry(ClassDataObjectFields.CLASS_INFO);
                String string2 = classRefObject.getSuperName();
                this.addSuperClass(list, moduleDataObject, string2, arrayList, hashMap);
            } else {
                String string3 = string + ".class";
                try {
                    URL uRL = this.classLoader.getResource(string3);
                    if (uRL != null && hashMap.get(string) == null && this.cdoMap.get(string) == null) {
                        HierarchyFileLocator hierarchyFileLocator = new HierarchyFileLocator(uRL, string3, uRL.toString());
                        hashMap.put(string, hierarchyFileLocator);
                        arrayList.add(hierarchyFileLocator);
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.annotations.collector.WASAnnotationCollector.addSuperClass", "304", this);
                    Object[] objectArray = new Object[]{string3, throwable};
                    String string4 = NLSProvider.getNLS().getFormattedMessage("loadSuperClassFail00", objectArray, "Error occurred while attempting to load URL for class file {0}: {1}");
                    Tr.error(_tc, string4);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addSuperClass");
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private boolean checkLocator(FileLocator fileLocator) {
        return fileLocator != null && fileLocator instanceof HierarchyFileLocator;
    }

    private void resolveImplementedInterfaces(List<ClassDataObject> list, ModuleDataObject moduleDataObject, ArrayList<FileLocator> arrayList, HashMap<String, FileLocator> hashMap) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "resolveImplementedInterfaces");
        }
        for (ClassDataObject object : this.cdoList) {
            String[] stringArray;
            String string = (String)object.getEntry(ClassDataObjectFields.CLASS_NAME);
            if (this.checkedSuperInterfaces.get(string) != null) continue;
            this.checkedSuperInterfaces.put(string, object);
            ClassRefObject classRefObject = (ClassRefObject)object.getEntry(ClassDataObjectFields.CLASS_INFO);
            if (classRefObject == null || (stringArray = classRefObject.getInterfaces()) == null || stringArray.length <= 0) continue;
            this.addImplementedInterfaces(list, moduleDataObject, stringArray, arrayList, hashMap);
        }
        for (ClassDataObject classDataObject : list) {
            this.cdoMap.put((String)classDataObject.getEntry(ClassDataObjectFields.CLASS_NAME), classDataObject);
            this.cdoList.add(classDataObject);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "resolveImplementedInterfaces");
        }
    }

    private void addImplementedInterfaces(List<ClassDataObject> list, ModuleDataObject moduleDataObject, String[] stringArray, ArrayList<FileLocator> arrayList, HashMap<String, FileLocator> hashMap) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addImplementedInterfaces");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            String[] stringArray2;
            Object object2;
            String string = stringArray[i];
            ClassDataObject classDataObject = moduleDataObject.getClassDataObject(string);
            if (classDataObject != null) {
                if (this.cdoMap.get(string) != null) continue;
                list.add(classDataObject);
                object2 = (ClassRefObject)classDataObject.getEntry(ClassDataObjectFields.CLASS_INFO);
                stringArray2 = ((ClassRefObject)object2).getInterfaces();
                if (stringArray2 == null || stringArray2.length <= 0) continue;
                this.addImplementedInterfaces(list, moduleDataObject, stringArray2, arrayList, hashMap);
                continue;
            }
            object2 = string + ".class";
            try {
                stringArray2 = this.classLoader.getResource((String)object2);
                if (stringArray2 == null || hashMap.get(string) != null || this.cdoMap.get(string) != null) continue;
                object = new HierarchyFileLocator((URL)stringArray2, (String)object2, stringArray2.toString());
                hashMap.put(string, (FileLocator)object);
                arrayList.add((FileLocator)object);
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.annotations.collector.WASAnnotationCollector.addImplementedInterfaces", "429", this);
                object = new Object[]{object2, throwable};
                String string2 = NLSProvider.getNLS().getFormattedMessage("loadSuperClassFail00", (Object[])object, "Error occurred while attempting to load URL for class file {0}: {1}");
                Tr.error(_tc, string2);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addImplementedInterfaces");
        }
    }

    private List<FileLocator> getExceptionLocators() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getExceptionLocators");
        }
        ArrayList<FileLocator> arrayList = new ArrayList<FileLocator>();
        HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>();
        for (ClassDataObject classDataObject : this.cdoList) {
            ClassRefObject classRefObject = (ClassRefObject)classDataObject.getEntry(ClassDataObjectFields.CLASS_INFO);
            ArrayList<MethodRefObject> arrayList2 = classRefObject.getMethodRefs();
            if (arrayList2 == null) continue;
            for (MethodRefObject methodRefObject : arrayList2) {
                String[] stringArray = methodRefObject.getExceptions();
                if (stringArray == null) continue;
                for (String string : stringArray) {
                    Object object;
                    String string2 = string + ".class";
                    try {
                        URL uRL = this.classLoader.getResource(string2);
                        if (uRL == null || hashMap.get(string) != null || this.cdoMap.get(string) != null) continue;
                        object = new HierarchyFileLocator(uRL, string2, uRL.toString());
                        hashMap.put(string, (Object[])object);
                        arrayList.add((FileLocator)object);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.annotations.collector.WASAnnotationCollector.addImplementedInterfaces", "429", this);
                        object = new Object[]{string2, throwable};
                        String string3 = NLSProvider.getNLS().getFormattedMessage("loadSuperClassFail00", (Object[])object, "Error occurred while attempting to load URL for class file {0}: {1}");
                        Tr.error(_tc, string3);
                    }
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getExceptionLocators");
        }
        return arrayList;
    }

    private void addExceptionCDOS(List<FileLocator> list) {
        Collection<ClassDataObject> collection;
        ModuleDataObject moduleDataObject;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addExceptionCDOS");
        }
        if ((moduleDataObject = this.getMDO(list)) != null && (collection = moduleDataObject.getAllClassDataObjects()) != null && collection.size() > 0) {
            for (ClassDataObject classDataObject : collection) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Adding exception ClassDataObject: " + classDataObject.getEntry(ClassDataObjectFields.CLASS_NAME));
                }
                if (this.cdoMap.get(classDataObject.getEntry(ClassDataObjectFields.CLASS_NAME)) != null) continue;
                this.cdoMap.put((String)classDataObject.getEntry(ClassDataObjectFields.CLASS_NAME), classDataObject);
                this.cdoList.add(classDataObject);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addExceptionCDOS");
        }
    }
}

