/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.trace;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.trace.BinaryFormatter;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class BaseMessageTrace {
    private static final String irq = "inboundRequest00";
    private static final String orq = "outboundRequest00";
    private static final String irs = "inboundResponse00";
    private static final String ors = "outboundResponse00";
    private static final String HTTP = "HTTP";
    private static final String JMS = "JMS";
    private static final String SOAP = "SOAP";
    public static final TraceContext INBOUND_HTTP_REQUEST = new TraceContext("inboundRequest00", "HTTP");
    public static final TraceContext OUTBOUND_HTTP_REQUEST = new TraceContext("outboundRequest00", "HTTP");
    public static final TraceContext INBOUND_HTTP_RESPONSE = new TraceContext("inboundResponse00", "HTTP");
    public static final TraceContext OUTBOUND_HTTP_RESPONSE = new TraceContext("outboundResponse00", "HTTP");
    public static final TraceContext INBOUND_JMS_REQUEST = new TraceContext("inboundRequest00", "JMS");
    public static final TraceContext OUTBOUND_JMS_REQUEST = new TraceContext("outboundRequest00", "JMS");
    public static final TraceContext INBOUND_JMS_RESPONSE = new TraceContext("inboundResponse00", "JMS");
    public static final TraceContext OUTBOUND_JMS_RESPONSE = new TraceContext("outboundResponse00", "JMS");

    public static void log(TraceContext traceContext, String string, byte[] byArray, TraceComponent traceComponent) {
        try {
            String string2 = "";
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(byArray);
            string2 = BaseMessageTrace.convertBytesToString(string, byteArrayOutputStream);
            BaseMessageTrace.log(traceContext, string, string2, traceComponent);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.BaseMessageTrace.log", "82", null);
        }
    }

    public static void log(TraceContext traceContext, String string, String string2, TraceComponent traceComponent) {
        if (traceContext != null && string2 != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(traceContext.toString(string));
            if (string != null && string.startsWith("text/xml")) {
                stringBuffer.append(string2);
            } else {
                String string3 = new BinaryFormatter(string2.getBytes()).trace();
                stringBuffer.append(string3);
            }
            Tr.debug(traceComponent, stringBuffer.toString());
        }
    }

    private static String convertBytesToString(String string, ByteArrayOutputStream byteArrayOutputStream) {
        String string2;
        if (string != null && string.startsWith("text/xml")) {
            String string3 = BaseMessageTrace.getEncoding(string);
            try {
                string2 = byteArrayOutputStream.toString(string3);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException, "com.ibm.ws.webservices.BaseMessageTrace.convertBytesToString", "121", null);
                string2 = byteArrayOutputStream.toString();
            }
        } else {
            string2 = byteArrayOutputStream.toString();
        }
        return string2;
    }

    private static String getEncoding(String string) {
        String string2;
        if (string != null && (string2 = string.toLowerCase()).indexOf("charset=") > 0 && string2.indexOf("utf-16") > 0) {
            return "utf-16";
        }
        return "utf-8";
    }

    protected static class TraceContext {
        String messageKey;
        String transport;

        public String toString(String string) {
            String string2 = string == null ? "" : string;
            return Messages.getMessage(this.messageKey, this.transport, BaseMessageTrace.SOAP, string2);
        }

        TraceContext(String string, String string2) {
            this.messageKey = string;
            this.transport = string2;
        }
    }
}

