/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.dom.impl;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import com.ibm.ws.webservices.engine.xmlsoap.dom.impl.DOMAttributeMapDelegate;
import com.ibm.ws.webservices.engine.xmlsoap.dom.impl.DOMDocumentImpl;
import com.ibm.ws.webservices.engine.xmlsoap.dom.impl.DOMElementImpl;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class DOMElementImpl_MS
extends DOMElementImpl {
    private static Log log = LogFactory.getLog(DOMElementImpl_MS.class.getName());
    private MappingScope mappingScope = null;
    private boolean msOpt = true;
    private boolean reEnableMSOpt = false;
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_COLON = "xmlns:";
    private static final String EMPTY_STRING = "";
    private DOMAttributeMapDelegate attrMapDelegate = null;

    protected DOMElementImpl_MS(DOMDocumentImpl dOMDocumentImpl, String string, String string2) {
        super(dOMDocumentImpl, string, string2);
    }

    protected MappingScope _getMappingScope() {
        MappingScope mappingScope = this._getMappingScopeInternal();
        return mappingScope;
    }

    private final MappingScope _getMappingScopeInternal() {
        MappingScope mappingScope = null;
        mappingScope = this.msOpt ? this._getCachedMappingScope() : this._getDynamicMappingScope();
        Node node = this.getParentNode();
        if (this.msOpt && node instanceof DOMElementImpl_MS && ((DOMElementImpl_MS)node).msOpt && ((DOMElementImpl_MS)node).mappingScope == mappingScope.getParent()) {
            return mappingScope;
        }
        if (node instanceof DOMElementImpl_MS) {
            DOMElementImpl_MS dOMElementImpl_MS = (DOMElementImpl_MS)node;
            MappingScope mappingScope2 = ((DOMElementImpl_MS)node)._getMappingScope();
            mappingScope.setParent(mappingScope2);
        }
        return mappingScope;
    }

    private final MappingScope _getCachedMappingScope() {
        if (this.mappingScope == null) {
            this.mappingScope = new MappingScope();
        }
        MappingScope mappingScope = this.mappingScope;
        return mappingScope;
    }

    private final MappingScope _getDynamicMappingScope() {
        if (log.isDebugEnabled()) {
            if (this.reEnableMSOpt) {
                log.debug("dynamic build of MappingScope for re-enablement:" + this.getLocalName());
            } else {
                log.debug("dynamic build of MappingScope:" + this.getLocalName());
            }
        }
        MappingScope mappingScope = new MappingScope();
        NamedNodeMap namedNodeMap = this.getSortedAttributes();
        boolean bl = true;
        for (int i = DOMElementImpl_MS.findIndex(XMLNS, namedNodeMap); i < namedNodeMap.getLength() && bl; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            String string = attr.getNodeName();
            if (!string.startsWith(XMLNS)) {
                bl = false;
            }
            String string2 = attr.getValue();
            mappingScope = DOMElementImpl_MS.addMapping(mappingScope, string, string2);
        }
        return mappingScope;
    }

    protected void enableMappingScopeOptimization(boolean bl) {
        if (this.msOpt == bl) {
            return;
        }
        if (!bl) {
            this.mappingScope = null;
        } else if (!this.msOpt) {
            this.reEnableMSOpt = true;
            this.mappingScope = this._getMappingScope();
            this.reEnableMSOpt = false;
        }
        this.msOpt = bl;
    }

    void modifiedXMLNSAttributes() {
        if (this.msOpt) {
            this.enableMappingScopeOptimization(false);
            this.enableMappingScopeOptimization(true);
        }
    }

    protected void changedParent() {
        if (this.msOpt) {
            MappingScope mappingScope = this._getCachedMappingScope();
            Node node = this.getParentNode();
            if (node instanceof DOMElementImpl_MS) {
                mappingScope.setParent(((DOMElementImpl_MS)node)._getMappingScope());
            } else {
                mappingScope.setParent(null);
            }
        }
    }

    public NamedNodeMap getAttributes() {
        NamedNodeMap namedNodeMap = super.getAttributes();
        if (this.attrMapDelegate == null || this.attrMapDelegate.getAttributes() != namedNodeMap) {
            this.attrMapDelegate = new DOMAttributeMapDelegate(namedNodeMap, this.getOwnerDocument());
        }
        return this.attrMapDelegate;
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        DOMElementImpl_MS.removeMapping(this.mappingScope, attr.getName());
        return super.removeAttributeNode(attr);
    }

    public Attr removeAttributeNodeNS(Attr attr) throws DOMException {
        DOMElementImpl_MS.removeMapping(this.mappingScope, attr.getName());
        return super.removeAttributeNode(attr);
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
        if (this.mappingScope != null && "http://www.w3.org/2000/xmlns/".equals(string)) {
            String string3 = string2;
            if (XMLNS.equals(string2)) {
                string3 = EMPTY_STRING;
            }
            boolean bl = this.mappingScope.removeMappingForPrefix(string3);
        }
        super.removeAttributeNS(string, string2);
    }

    public void removeAttribute(String string) throws DOMException {
        if (this.msOpt) {
            DOMElementImpl_MS.removeMapping(this.mappingScope, string);
        }
        super.removeAttribute(string);
    }

    public void setAttribute(String string, String string2) throws DOMException {
        if (this.msOpt) {
            this.mappingScope = DOMElementImpl_MS.addMapping(this.mappingScope, string, string2);
        }
        super.setAttribute(string, string2);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        attr = Utils.create(attr, this.getOwnerDocument());
        if (this.msOpt) {
            this.mappingScope = DOMElementImpl_MS.addMapping(this.mappingScope, attr.getName(), attr.getValue());
        }
        return super.setAttributeNode(attr);
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        if (this.msOpt) {
            this.mappingScope = DOMElementImpl_MS.addMapping(this.mappingScope, string2, string3);
        }
        super.setAttributeNS(string, string2, string3);
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        attr = Utils.create(attr, this.getOwnerDocument());
        if (this.msOpt) {
            this.mappingScope = DOMElementImpl_MS.addMapping(this.mappingScope, attr.getName(), attr.getValue());
        }
        return super.setAttributeNodeNS(attr);
    }

    private static final int findIndex(String string, NamedNodeMap namedNodeMap) {
        int n = 0;
        int n2 = 0;
        int n3 = namedNodeMap.getLength() - 1;
        while (n2 <= n3) {
            n = (n2 + n3) / 2;
            int n4 = string.compareTo(((Attr)namedNodeMap.item(n)).getNodeName());
            if (n4 == 0) {
                return n;
            }
            if (n4 < 0) {
                n3 = n - 1;
                continue;
            }
            n2 = n + 1;
        }
        if (n2 > n) {
            n = n2;
        } else if (n > namedNodeMap.getLength()) {
            n = namedNodeMap.getLength();
        }
        return n;
    }

    private static MappingScope addMapping(MappingScope mappingScope, String string, String string2) {
        if (mappingScope == null) {
            mappingScope = new MappingScope();
        }
        if (XMLNS == string || XMLNS.equals(string)) {
            mappingScope.addMapping(string2, EMPTY_STRING);
        } else if (string.startsWith(XMLNS_COLON)) {
            String string3 = string.substring(6);
            mappingScope.addMapping(string2, string3);
        }
        return mappingScope;
    }

    private static void removeMapping(MappingScope mappingScope, String string) {
        if (mappingScope != null) {
            if (XMLNS == string || XMLNS.equals(string)) {
                mappingScope.removeMappingForPrefix(EMPTY_STRING);
            } else if (string.startsWith(XMLNS_COLON)) {
                String string2 = string.substring(6);
                mappingScope.removeMappingForPrefix(string2);
            }
        }
    }
}

