/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.builders;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.FaultDesc;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.encoding.DefaultDeserializer;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.utils.Callback;
import com.ibm.ws.webservices.engine.encoding.utils.CallbackTarget;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.events.NOOPProcessor;
import com.ibm.ws.webservices.engine.events.PEventProcessor;
import com.ibm.ws.webservices.engine.events.WrapperProcessor;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.Detail;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFault;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class WebServicesFaultProcessor
extends DEventProcessor
implements Callback {
    protected static Log log = LogFactory.getLog(WebServicesFaultProcessor.class.getName());
    private SOAPFault soapFault;
    private FaultDesc faultDesc;
    private Object faultData;
    private boolean inDetail;
    private boolean firstDetail;
    private static HashMap TYPES = new HashMap(8);

    public WebServicesFaultProcessor(SOAPFault sOAPFault) throws SAXException {
        this.soapFault = sOAPFault;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
    }

    public DEventProcessor onStartChild(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: WebServicesFaultProcessor.onStartChild()");
        }
        QName qName = QNameTable.createQName(string, string2);
        if (!this.inDetail && this.soapFault.getSOAPFactory().getSOAPConstants().getFaultDetailQName().equals(qName)) {
            this.inDetail = true;
            this.firstDetail = true;
            return this;
        }
        if (this.inDetail && this.firstDetail) {
            this.firstDetail = false;
            this.faultDesc = WebServicesFaultProcessor.getFaultDesc(qName, deserializationContext, this.soapFault);
            if (this.faultDesc != null && qName.equals(this.faultDesc.getPartQName())) {
                Class clazz = WebServicesFaultProcessor.getFaultClassFromFaultDesc(this.faultDesc);
                if (clazz == null || clazz == javax.xml.soap.SOAPElement.class || clazz == SOAPFaultException.class) {
                    return new NOOPProcessor();
                }
                Deserializer deserializer = null;
                if (attributes.getValue("href") == null) {
                    QName qName2 = AttributeUtils.getTypeFromAttributes(string, string2, attributes, mappingScope);
                    qName2 = qName2 == null ? this.faultDesc.getPartXmlType() : qName2;
                    deserializer = deserializationContext.getDeserializer(null, qName2);
                } else {
                    deserializer = new DefaultDeserializer();
                    deserializer.setDefaultType(this.faultDesc.getPartXmlType());
                }
                if (deserializer != null) {
                    deserializer.registerValueTarget(new CallbackTarget(this, "faultData"));
                }
                return deserializer;
            }
        }
        return new NOOPProcessor();
    }

    public void onEndChild(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        this.inDetail = false;
        super.onEndChild(string, string2, deserializationContext);
    }

    public void endElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
    }

    public void setValue(Object object, Object object2) {
        this.faultData = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebServicesFault createFault(SOAPFault sOAPFault, DeserializationContext deserializationContext) throws SAXException {
        Object object;
        Serializable serializable;
        Serializable serializable2;
        String string;
        Object object2;
        Object object3;
        WebServicesFault webServicesFault = null;
        WebServicesFaultProcessor webServicesFaultProcessor = new WebServicesFaultProcessor(sOAPFault);
        Node node = sOAPFault.getParentNode();
        if (node != null && node instanceof SOAPElement) {
            object3 = ((SOAPElement)node).getChildElements();
            while (object3.hasNext()) {
                object2 = (Node)object3.next();
                if (!(object2 instanceof SOAPElement) || (string = AttributeUtils.getID((serializable2 = (SOAPElement)object2).getSAXAttributes())) == null) continue;
                deserializationContext.getHrefTable().addObjectByID(string, serializable2);
            }
        }
        deserializationContext.createEventConverter(new WrapperProcessor(webServicesFaultProcessor));
        try {
            object3 = deserializationContext.getEventConverter();
            sOAPFault.toEvents((PEventProcessor)object3);
        }
        finally {
            deserializationContext.freeEventConverter();
        }
        object3 = webServicesFaultProcessor.faultDesc;
        object2 = webServicesFaultProcessor.faultData;
        serializable2 = sOAPFault.getFaultCodeAsQName();
        string = sOAPFault.getFaultString();
        if (string != null && string.startsWith("<![CDATA[") && string.endsWith("]]>")) {
            string = string.substring("<![CDATA[".length());
            string = string.substring(0, string.length() - "]]>".length());
        }
        String string2 = sOAPFault.getFaultActor();
        Detail detail = (Detail)sOAPFault.getDetail();
        Element[] elementArray = null;
        if (detail != null) {
            int n = detail.getNumChildren();
            elementArray = new SOAPElement[n];
            for (int i = 0; i < n; ++i) {
                elementArray[i] = detail.getChildElement(i);
            }
        }
        if (object3 == null && detail != null && detail.getNumChildren() == 0) {
            object3 = WebServicesFaultProcessor.getFaultDesc(null, deserializationContext, sOAPFault);
        }
        WebServicesFaultProcessor.copyWSAFaultAction((FaultDesc)object3, deserializationContext.getMessageContext());
        Class clazz = WebServicesFaultProcessor.getFaultClassFromFaultDesc((FaultDesc)object3);
        if (clazz != null && clazz != javax.xml.soap.SOAPElement.class && clazz != SOAPFaultException.class) {
            try {
                if (object2 != null) {
                    Exception exception = null;
                    if (object2 instanceof Exception) {
                        exception = (Exception)object2;
                    } else {
                        serializable = WebServicesFaultProcessor.ConvertWrapper(object2.getClass());
                        object = clazz.getConstructor(new Class[]{serializable});
                        exception = (Exception)((Constructor)object).newInstance(object2);
                    }
                    if (exception != null) {
                        webServicesFault = WebServicesFault.makeUserFault(exception, (QName)serializable2);
                    }
                }
                if (WebServicesFault.class.isAssignableFrom(clazz)) {
                    if (webServicesFault == null) {
                        webServicesFault = (WebServicesFault)clazz.newInstance();
                    }
                    webServicesFault.setFaultDetail(elementArray);
                }
                if (webServicesFault == null && object3 != null) {
                    Exception exception = (Exception)clazz.newInstance();
                    webServicesFault = WebServicesFault.makeUserFault(exception, (QName)serializable2);
                }
                if (webServicesFault != null) {
                    webServicesFault.setFaultCode((QName)serializable2);
                    webServicesFault.setFaultString(string);
                    webServicesFault.setFaultActor(string2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (webServicesFault == null && elementArray != null) {
            SOAPFaultException sOAPFaultException = new SOAPFaultException((QName)serializable2, string, string2, detail);
            webServicesFault = WebServicesFault.makeUserFault(sOAPFaultException, (QName)serializable2);
        }
        if (webServicesFault == null) {
            webServicesFault = new WebServicesFault((QName)serializable2, string, string2, elementArray);
        }
        if (sOAPFault.getSOAPFactory().getSOAPConstants().getSOAPProtocol().equals("SOAP 1.2 Protocol")) {
            Iterator iterator = sOAPFault.getFaultSubcodes();
            if (iterator != null && iterator.hasNext()) {
                serializable = new ArrayList();
                while (iterator.hasNext()) {
                    ((ArrayList)serializable).add(iterator.next());
                }
                webServicesFault.setSOAP12_Subcodes((List)((Object)serializable));
            }
            if ((serializable = sOAPFault.getFaultStringLocale()) != null) {
                webServicesFault.setSOAP12_ReasonLanguage(((Locale)serializable).getLanguage());
            }
            if ((object = sOAPFault.getFaultNode()) != null) {
                webServicesFault.setSOAP12_Node((String)object);
            }
            try {
                Iterator iterator2 = sOAPFault.getFaultReasonLocales();
                Iterator iterator3 = sOAPFault.getFaultReasonTexts();
                if (iterator2 != null && iterator3 != null) {
                    iterator2.next();
                    iterator3.next();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while (iterator2.hasNext() && iterator3.hasNext()) {
                        Locale locale = (Locale)iterator2.next();
                        arrayList.add(locale.getLanguage());
                        arrayList.add((String)iterator3.next());
                    }
                    webServicesFault.setSOAP12_AdditionalReasons(arrayList);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return webServicesFault;
    }

    public static void copyWSAFaultAction(FaultDesc faultDesc, MessageContext messageContext) {
        if (faultDesc != null) {
            String string = (String)faultDesc.getOption(OperationDesc.FAULT_WSA_ACTION);
            if (string == null) {
                string = new String("");
            }
            messageContext.setProperty(OperationDesc.FAULT_WSA_ACTION, string);
            String string2 = (String)faultDesc.getOption(OperationDesc.FAULT_NAME);
            if (string2 == null) {
                string2 = new String("");
            }
            messageContext.setProperty(OperationDesc.FAULT_NAME, string2);
        }
    }

    private static Class getFaultClassFromFaultDesc(FaultDesc faultDesc) {
        if (faultDesc != null) {
            try {
                return ClassUtils.forName(faultDesc.getClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private static FaultDesc getFaultDesc(QName qName, DeserializationContext deserializationContext, SOAPFault sOAPFault) {
        OperationDesc operationDesc;
        FaultDesc faultDesc = null;
        MessageContext messageContext = deserializationContext.getMessageContext();
        if (messageContext != null && (operationDesc = messageContext.getOperation()) != null) {
            FaultDesc faultDesc2;
            int n;
            ArrayList arrayList = operationDesc.getFaults();
            if (arrayList != null) {
                for (n = 0; n < arrayList.size() && faultDesc == null; ++n) {
                    faultDesc2 = (FaultDesc)arrayList.get(n);
                    if (faultDesc2.getPartQName() == null || faultDesc2.getPartQName() != qName && !faultDesc2.getPartQName().equals(qName)) continue;
                    faultDesc = faultDesc2;
                }
            }
            if (faultDesc == null) {
                faultDesc = operationDesc.getFaultByFaultCode(sOAPFault.getFaultCodeAsQName());
            }
            if (faultDesc == null && arrayList != null) {
                for (n = 0; n < arrayList.size() && faultDesc == null; ++n) {
                    faultDesc2 = (FaultDesc)arrayList.get(n);
                    String string = (String)faultDesc2.getOption(FaultDesc.MESSAGE_PART_NAME);
                    if (string == null || string != qName.getLocalPart() && !string.equals(qName.getLocalPart())) continue;
                    faultDesc = faultDesc2;
                }
            }
        }
        return faultDesc;
    }

    private static Class ConvertWrapper(Class clazz) {
        Class clazz2 = (Class)TYPES.get(clazz);
        if (clazz2 != null) {
            return clazz2;
        }
        return clazz;
    }

    static {
        TYPES.put(Character.class, Character.TYPE);
        TYPES.put(Integer.class, Integer.TYPE);
        TYPES.put(Float.class, Float.TYPE);
        TYPES.put(Boolean.class, Boolean.TYPE);
        TYPES.put(Double.class, Double.TYPE);
        TYPES.put(Byte.class, Byte.TYPE);
        TYPES.put(Short.class, Short.TYPE);
        TYPES.put(Long.class, Long.TYPE);
    }
}

