/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.websphere.webservices.soap.IBMAttr;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.dom.DOMAttr;
import com.ibm.ws.webservices.engine.xmlsoap.dom.impl.DOMAttrImpl;
import com.ibm.ws.webservices.engine.xmlsoap.dom.impl.DOMAttrNSImpl;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.apache.xerces.dom.AttrImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Utils {
    private static Log log = LogFactory.getLog(Utils.class.getName());
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_COLON = "xmlns:";
    private static final String EMPTY_STRING = "";
    private static boolean enableSAAJ13 = true;
    private static boolean enableDOM3 = true;
    private static final boolean isSAAJ13Available = Utils.discoverSAAJ13Availability();
    private static final boolean isDOM3Available = Utils.discoverDOM3Availability();
    private static boolean gotSOAPDynamicConstants = false;

    static void addImplicitNamespaceDeclarations(SOAPElement sOAPElement) {
        SOAPElement sOAPElement2;
        Node node = sOAPElement.getParentNode();
        if (node instanceof SOAPElement && (sOAPElement2 = (SOAPElement)node).getParentNode() == null && sOAPElement == sOAPElement2.getFirstChild() && sOAPElement == sOAPElement2.getLastChild()) {
            Utils._addImplicitNamespaces(sOAPElement2);
            Utils._addImplicitNamespacesForAttrs(sOAPElement2);
        }
        Utils._addImplicitNamespaces(sOAPElement);
        Utils._addImplicitNamespacesForAttrs(sOAPElement);
    }

    private static void _addImplicitNamespaces(SOAPElement sOAPElement) {
        String string;
        String string2;
        MappingScope mappingScope = sOAPElement._getMappingScope();
        boolean bl = Utils.needsNamespaceDeclaration(mappingScope, string2 = sOAPElement.getNamespaceURI(), string = sOAPElement.getPrefix(), false);
        if (bl) {
            if (log.isDebugEnabled()) {
                log.debug("adding implicit xmlns declaration for prefix = {" + string + "} and " + "namespace = {" + string2 + "}");
            }
            Utils.addXMLNSAttribute(sOAPElement, string, string2);
        }
    }

    private static void _addImplicitNamespacesForAttrs(SOAPElement sOAPElement) {
        MappingScope mappingScope = sOAPElement._getMappingScope();
        NamedNodeMap namedNodeMap = sOAPElement.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            int n;
            Attr attr = (Attr)namedNodeMap.item(i);
            String string = attr.getNamespaceURI();
            if ("http://www.w3.org/2000/xmlns/" == string || "http://www.w3.org/2000/xmlns/".equals(string)) continue;
            String string2 = attr.getPrefix();
            if (string2 == null || string2.length() == 0) {
                n = attr.getName().indexOf(58);
                if (n >= 0) {
                    string2 = attr.getName().substring(0, n);
                }
                if (string2 == null) {
                    string2 = EMPTY_STRING;
                }
            }
            if ((n = (int)(Utils.needsNamespaceDeclaration(mappingScope, string, string2, true) ? 1 : 0)) == 0) continue;
            if (log.isDebugEnabled()) {
                log.debug("adding implicit xmlns declaration for prefix = {" + string2 + "} and " + "namespace = {" + string + "} due to attr reference");
            }
            Utils.addXMLNSAttribute(sOAPElement, string2, string);
        }
    }

    private static boolean needsNamespaceDeclaration(MappingScope mappingScope, String string, String string2, boolean bl) {
        Mapping mapping;
        Mapping mapping2;
        Mapping mapping3;
        boolean bl2 = false;
        bl2 = string == null || string.length() == 0 ? (bl ? false : (mapping3 = mappingScope.getMappingForPrefix(EMPTY_STRING, false)) != null && (mapping3.getPrefix().length() != 0 || mapping3.getNamespaceURI().length() != 0)) : (string2 == null || string2.length() == 0 ? (mapping2 = mappingScope.getMappingForPrefix(EMPTY_STRING, false)) == null || mapping2.getPrefix().length() != 0 || mapping2.getNamespaceURI() != string && !mapping2.getNamespaceURI().equals(string) : (mapping = mappingScope.getMappingForPrefix(string2, false)) == null || !mapping.getPrefix().equals(string2) || mapping.getNamespaceURI() != string && !mapping.getNamespaceURI().equals(string));
        return bl2;
    }

    static void addXMLNSAttribute(Element element, String string, String string2) {
        String string3 = XMLNS;
        if (string != null && string.length() != 0) {
            string3 = string3 + ":" + string;
        }
        if (string2 == null) {
            string2 = EMPTY_STRING;
        }
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", string3, string2);
    }

    static boolean removeXMLNSAttribute(Element element, String string) {
        boolean bl;
        String string2 = XMLNS;
        if (string != null && string.length() > 0) {
            string2 = string2 + ":" + string;
        }
        if (bl = element.hasAttribute(string2)) {
            element.removeAttribute(string2);
        }
        return bl;
    }

    public static DOMAttr create(Attr attr, Document document) {
        if (!(attr instanceof DOMAttr)) {
            AttrImpl attrImpl = null;
            attrImpl = attr.getNamespaceURI() == null ? DOMAttrImpl.create(attr, document) : DOMAttrNSImpl.create(attr, document);
            attr = attrImpl;
        }
        return (DOMAttr)attr;
    }

    static List getNamespaceDeclarations(SOAPElement sOAPElement, boolean bl, boolean bl2, boolean bl3) {
        ArrayList arrayList = new ArrayList();
        if (bl) {
            Utils._getNamespaceDeclarationsAbove(sOAPElement, arrayList);
        }
        if (bl2) {
            Utils._getNamespaceDeclarationsOn(sOAPElement, arrayList);
        }
        if (bl3) {
            Utils._getNamespaceDeclarationsBelow(sOAPElement, arrayList);
        }
        return arrayList;
    }

    private static void _getNamespaceDeclarationsAbove(SOAPElement sOAPElement, List list) {
        for (SOAPElement sOAPElement2 = (SOAPElement)sOAPElement.getParentElement(); sOAPElement2 != null; sOAPElement2 = (SOAPElement)sOAPElement2.getParentElement()) {
            MappingScope mappingScope = sOAPElement2._getMappingScope();
            if (mappingScope.size() <= 0) continue;
            NamedNodeMap namedNodeMap = sOAPElement2.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                IBMAttr iBMAttr = (IBMAttr)namedNodeMap.item(i);
                if (!iBMAttr.isNamespaceDeclaration()) continue;
                list.add(0, iBMAttr);
            }
        }
    }

    private static void _getNamespaceDeclarationsOn(SOAPElement sOAPElement, List list) {
        MappingScope mappingScope = sOAPElement._getMappingScope();
        if (mappingScope.size() > 0) {
            NamedNodeMap namedNodeMap = sOAPElement.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                IBMAttr iBMAttr = (IBMAttr)namedNodeMap.item(i);
                if (!iBMAttr.isNamespaceDeclaration()) continue;
                list.add(iBMAttr);
            }
        }
    }

    private static void _getNamespaceDeclarationsBelow(SOAPElement sOAPElement, List list) {
        for (Node node = sOAPElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof SOAPElement)) continue;
            Utils._getNamespaceDeclarationsOn((SOAPElement)node, list);
            Utils._getNamespaceDeclarationsBelow((SOAPElement)node, list);
        }
    }

    public static List getAttributes(SOAPElement sOAPElement, boolean bl, boolean bl2, boolean bl3) {
        ArrayList arrayList = new ArrayList();
        if (bl) {
            Utils._getAttributesAbove(sOAPElement, arrayList);
        }
        if (bl2) {
            Utils._getAttributesOn(sOAPElement, arrayList);
        }
        if (bl3) {
            Utils._getAttributesBelow(sOAPElement, arrayList);
        }
        return arrayList;
    }

    private static void _getAttributesAbove(SOAPElement sOAPElement, List list) {
        for (SOAPElement sOAPElement2 = (SOAPElement)sOAPElement.getParentElement(); sOAPElement2 != null; sOAPElement2 = (SOAPElement)sOAPElement2.getParentElement()) {
            NamedNodeMap namedNodeMap = sOAPElement2.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                IBMAttr iBMAttr = (IBMAttr)namedNodeMap.item(i);
                list.add(0, iBMAttr);
            }
        }
    }

    private static void _getAttributesOn(SOAPElement sOAPElement, List list) {
        NamedNodeMap namedNodeMap = sOAPElement.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            IBMAttr iBMAttr = (IBMAttr)namedNodeMap.item(i);
            list.add(iBMAttr);
        }
    }

    private static void _getAttributesBelow(SOAPElement sOAPElement, List list) {
        for (Node node = sOAPElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof SOAPElement)) continue;
            Utils._getAttributesOn((SOAPElement)node, list);
            Utils._getAttributesBelow((SOAPElement)node, list);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static QName toQName(SOAPElement sOAPElement, String string) {
        String string2;
        String string3;
        String string4;
        int n = string.indexOf(":");
        if (n > 0) {
            string4 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string4 = EMPTY_STRING;
            string3 = string;
        }
        MappingScope mappingScope = sOAPElement._getMappingScope();
        Mapping mapping = mappingScope.getMappingForPrefix(string4, false);
        if (mapping == null) {
            if (string4.length() != 0) throw new IllegalArgumentException();
            string2 = EMPTY_STRING;
            return new QName(string2, string3, string4);
        } else {
            string2 = mapping.getNamespaceURI();
        }
        return new QName(string2, string3, string4);
    }

    static String toQualifiedName(SOAPElement sOAPElement, QName qName) {
        String string = EMPTY_STRING;
        MappingScope mappingScope = sOAPElement._getMappingScope();
        if (qName.getNamespaceURI().length() > 0) {
            String string2 = null;
            if (qName.getPrefix() != null || qName.getPrefix().length() > 0) {
                string2 = qName.getPrefix();
            }
            string = mappingScope.getOrCreatePrefix(qName.getNamespaceURI(), string2, true);
        } else {
            Mapping mapping = mappingScope.getMappingForPrefix(EMPTY_STRING, false);
            if (mapping != null && mapping.getNamespaceURI().length() > 0) {
                mappingScope.addMapping(EMPTY_STRING, EMPTY_STRING);
            }
        }
        if (string.length() == 0) {
            return qName.getLocalPart();
        }
        return string + ":" + qName.getLocalPart();
    }

    public static boolean _isSAAJ13Enabled() {
        return Utils._isSAAJ13Available() && enableSAAJ13;
    }

    public static boolean _isSAAJ13Available() {
        return isSAAJ13Available;
    }

    public static boolean _isDOM3Enabled() {
        return Utils._isDOM3Available() && enableDOM3 && Utils._isSAAJ13Enabled();
    }

    public static boolean _isDOM3Available() {
        return isSAAJ13Available;
    }

    private static boolean discoverSAAJ13Availability() {
        if (gotSOAPDynamicConstants) {
            return true;
        }
        return Utils.loadSOAPDynamicConstants() != null;
    }

    private static boolean discoverDOM3Availability() {
        try {
            return SOAPElement.class.getMethod("getSchemaTypeInfo", new Class[0]) != null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    static SOAPConstants loadSOAPDynamicConstants() {
        SOAPConstants sOAPConstants = null;
        try {
            Class clazz = null;
            try {
                clazz = ClassUtils.forName("com.ibm.ws.webservices.engine.xmlsoap.SOAPDynamicConstants");
            }
            catch (Exception exception) {
                clazz = null;
            }
            if (clazz == null) {
                clazz = ClassUtils.forName("com.ibm.ws.webservices.engine.xmlsoap.saaj13only.SOAPDynamicConstants");
            }
            sOAPConstants = (SOAPConstants)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        if (sOAPConstants != null) {
            gotSOAPDynamicConstants = true;
            return sOAPConstants;
        }
        return null;
    }

    public static SOAPConstants getSOAPConstants(String string) throws SOAPException {
        if (string.equals("SOAP 1.1 Protocol")) {
            return SOAPConstants.SOAP11_CONSTANTS;
        }
        if (string.equals("SOAP 1.2 Protocol")) {
            return SOAPConstants.SOAP12_CONSTANTS;
        }
        if (string.equals("Dynamic Protocol")) {
            return SOAPConstants.SOAPDYNAMIC_CONSTANTS;
        }
        throw new SOAPException(Messages.getMessage("unrecognizedProtocol", string));
    }
}

