/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.websphere.webservices.soap.IBMSOAPHeaderElement;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;

public final class SOAPHeaderElement
extends SOAPElement
implements IBMSOAPHeaderElement {
    protected boolean processed = false;

    SOAPHeaderElement(String string, String string2, SOAPFactory sOAPFactory) {
        super(string, string2, sOAPFactory);
    }

    public void setParentElement(javax.xml.soap.SOAPElement sOAPElement) throws SOAPException {
        if (sOAPElement == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullParent00"));
        }
        if (!(sOAPElement instanceof SOAPHeader)) {
            throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
        }
        try {
            super.setParentElement((SOAPHeader)sOAPElement);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement.setParentElement", "117", this);
            throw new SOAPException(throwable);
        }
    }

    public boolean getMustUnderstand() {
        QName qName = this.soapFactory.getSOAPConstants().getMustUnderstandAttributeQName();
        String string = this.getAttributeValue(qName.getNamespaceURI(), qName.getLocalPart());
        return string != null && string.equals(this.soapFactory.getSOAPConstants().getMustUnderstandAttributeValue(true));
    }

    public void setMustUnderstand(boolean bl) {
        QName qName = this.soapFactory.getSOAPConstants().getMustUnderstandAttributeQName();
        SOAPConstants sOAPConstants = this.soapFactory.getSOAPConstants();
        String string = sOAPConstants.getMustUnderstandAttributeValue(true);
        String string2 = sOAPConstants.getMustUnderstandAttributeValue(false);
        String string3 = bl ? string : string2;
        this.setAttribute(qName.getNamespaceURI(), qName.getLocalPart(), string3);
    }

    public String getActor() {
        SOAPConstants sOAPConstants = this.soapFactory.getSOAPConstants();
        QName qName = sOAPConstants.getRoleOrActorAttributeQName();
        return this.getAttributeValue(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public void setActor(String string) {
        SOAPConstants sOAPConstants = this.soapFactory.getSOAPConstants();
        QName qName = sOAPConstants.getRoleOrActorAttributeQName();
        Utils.addImplicitNamespaceDeclarations(this);
        MappingScope mappingScope = this._getMappingScope();
        String string2 = mappingScope.getOrCreatePrefix(qName.getNamespaceURI(), null, true);
        String string3 = null;
        string3 = string2 != null && string2.length() != 0 ? string2 + ":" + qName.getLocalPart() : qName.getLocalPart();
        if (string != null) {
            this.setAttributeNS(qName.getNamespaceURI(), string3, string);
        } else {
            this.removeAttribute(qName);
        }
    }

    public void setProcessed(boolean bl) {
        this.processed = bl;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setRole(String string) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "setRole(String)", "javax.xml.soap.SOAPHeaderElement"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "setRole(String)", "javax.xml.soap.SOAPHeaderElement", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        SOAPConstants sOAPConstants = this.soapFactory.getSOAPConstants();
        QName qName = sOAPConstants.getRoleAttributeQName();
        Utils.addImplicitNamespaceDeclarations(this);
        MappingScope mappingScope = this._getMappingScope();
        String string2 = mappingScope.getOrCreatePrefix(qName.getNamespaceURI(), null, true);
        String string3 = null;
        string3 = string2 != null && string2.length() != 0 ? string2 + ":" + qName.getLocalPart() : qName.getLocalPart();
        if (string != null) {
            this.setAttributeNS(qName.getNamespaceURI(), string3, string);
        } else {
            this.removeAttribute(qName);
        }
    }

    public String getRole() {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "getRole()", "javax.xml.soap.SOAPHeaderElement"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "getRole()", "javax.xml.soap.SOAPHeaderElement", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        SOAPConstants sOAPConstants = this.soapFactory.getSOAPConstants();
        if (!sOAPConstants.getSOAPProtocol().equals("SOAP 1.2 Protocol")) {
            return null;
        }
        QName qName = sOAPConstants.getRoleAttributeQName();
        return this.getAttributeValue(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public void setRelay(boolean bl) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "setRelay(String)", "javax.xml.soap.SOAPHeaderElement"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "setRelay(String)", "javax.xml.soap.SOAPHeaderElement", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        SOAPConstants sOAPConstants = this.soapFactory.getSOAPConstants();
        QName qName = sOAPConstants.getRelayAttributeQName();
        Utils.addImplicitNamespaceDeclarations(this);
        MappingScope mappingScope = this._getMappingScope();
        String string = mappingScope.getOrCreatePrefix(qName.getNamespaceURI(), null, true);
        String string2 = null;
        string2 = string != null && string.length() != 0 ? string + ":" + qName.getLocalPart() : qName.getLocalPart();
        String string3 = bl ? "1" : "0";
        this.setAttributeNS(qName.getNamespaceURI(), string2, string3);
    }

    public boolean getRelay() {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "getRelay()", "javax.xml.soap.SOAPHeaderElement"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "getRelay()", "javax.xml.soap.SOAPHeaderElement", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        SOAPConstants sOAPConstants = this.soapFactory.getSOAPConstants();
        if (!sOAPConstants.getSOAPProtocol().equals("SOAP 1.2 Protocol")) {
            return false;
        }
        QName qName = sOAPConstants.getRelayAttributeQName();
        String string = this.getAttributeValue(qName.getNamespaceURI(), qName.getLocalPart());
        boolean bl = string.equals("1") || string.equals("false");
        return bl;
    }
}

