/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.websphere.webservices.soap.IBMSOAPFault;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.Comment;
import com.ibm.ws.webservices.engine.xmlsoap.Detail;
import com.ibm.ws.webservices.engine.xmlsoap.Name;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBodyElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFaultElement;
import com.ibm.ws.webservices.engine.xmlsoap.Text;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPFaultBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.builders.WebServicesFaultProcessor;
import com.ibm.ws.webservices.engine.xmlsoap.dom.impl.DOMElementImpl;
import com.ibm.ws.webservices.engine.xmlsoap.ext.WebServicesFaultAlternateContent;
import com.ibm.ws.webservices.engine.xmlsoap.saaj12.SAAJ12Text;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class SOAPFault
extends SOAPBodyElement
implements IBMSOAPFault {
    private Locale locale;
    protected static Log log = LogFactory.getLog(SOAPFault.class.getName());

    SOAPFault(SOAPFactory sOAPFactory) {
        super(sOAPFactory.getSOAPConstants().getFaultQName().getNamespaceURI(), sOAPFactory.getSOAPConstants().getFaultQName().getLocalPart(), sOAPFactory);
    }

    private void _setFaultCode(String string) throws SOAPException {
        if (this.isSOAP12()) {
            if (this._getFault() != null) {
                String string2 = SOAPFault.extractPrefixFromQName(string);
                String string3 = SOAPFault.extractLocalNameFromQName(string);
                String string4 = null;
                string2 = string2 == null ? "" : string2;
                Mapping mapping = this._getMappingScope().getMappingForPrefix(string2, false);
                if (mapping != null) {
                    string4 = mapping.getNamespaceURI();
                }
                if (string4 != null && string4.length() > 0) {
                    string = "{" + string4 + "}" + string3;
                }
                this._getFault().setFaultCodeAsString(string);
            } else {
                QName qName;
                SOAPElement sOAPElement;
                QName qName2 = this.soapFactory.getSOAPConstants().getFaultCodeQName();
                SOAPElement sOAPElement2 = this.getChildElement(qName2.getNamespaceURI(), qName2.getLocalPart());
                if (sOAPElement2 == null) {
                    sOAPElement2 = this.createChildElement(qName2);
                    this.addChild(sOAPElement2);
                }
                if ((sOAPElement = sOAPElement2.getChildElement((qName = this.soapFactory.getSOAPConstants().getFaultCodeValueQName()).getNamespaceURI(), qName.getLocalPart())) != null) {
                    sOAPElement.detachNode();
                }
                sOAPElement = this.createChildElement(qName);
                sOAPElement.addTextNode(string);
                sOAPElement2.insertBefore(sOAPElement, sOAPElement2.getFirstChild());
            }
        } else if (this._getFault() != null) {
            String string5 = SOAPFault.extractPrefixFromQName(string);
            String string6 = SOAPFault.extractLocalNameFromQName(string);
            String string7 = null;
            string5 = string5 == null ? "" : string5;
            Mapping mapping = this._getMappingScope().getMappingForPrefix(string5, false);
            if (mapping != null) {
                string7 = mapping.getNamespaceURI();
            }
            if (string7 != null && string7.length() > 0) {
                string = "{" + string7 + "}" + string6;
            }
            this._getFault().setFaultCodeAsString(string);
        } else {
            QName qName = this.soapFactory.getSOAPConstants().getFaultCodeQName();
            SOAPElement sOAPElement = this.getChildElement(qName.getNamespaceURI(), qName.getLocalPart());
            if (sOAPElement != null) {
                sOAPElement.detachNode();
            }
            sOAPElement = this.createChildElement(qName);
            sOAPElement = this.addChild(sOAPElement);
            sOAPElement.addTextNode(string);
        }
    }

    public void setFaultCode(String string) throws SOAPException {
        this._validateFaultCode(string);
        this._setFaultCode(string);
    }

    public void setFaultCode(javax.xml.soap.Name name) throws SOAPException {
        String string = name.getURI();
        String string2 = name.getLocalName();
        String string3 = name.getPrefix();
        this._validateFaultCode(string, string2, string3);
        if (this._getFault() != null) {
            WebServicesFault webServicesFault = this._getFault();
            webServicesFault.setFaultCode(QNameTable.createQName(string, string2));
        } else {
            String string4 = string2;
            if (string3 != null && string3.length() > 0) {
                string4 = string3 + ":" + string4;
                if (this._getMappingScope().getMappingForPrefix(string3, false) == null) {
                    this.addNamespaceDeclaration(string3, string);
                }
            } else if (string != null && string.length() > 0) {
                Mapping mapping = this._getMappingScope().getMappingForNamespaceURI(string, false, true);
                if (mapping != null) {
                    string3 = mapping.getPrefix();
                    string4 = string3 + ":" + string4;
                } else {
                    string4 = "{" + string + "}" + string4;
                }
            }
            this._setFaultCode(string4);
        }
    }

    private void _validateFaultCode(String string) throws SOAPException {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(58);
        if (n != -1) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string3 = string;
        }
        this._validateFaultCode(null, string3, string2);
    }

    private void _validateFaultCode(String string, String string2, String string3) throws SOAPException {
        QName qName;
        string = this._validateQName(string, string2, string3, "FaultCode");
        if (!(!this.isSOAP12() || (qName = QNameTable.createQName(string, string2)).equals(SOAPConstants.SOAP_DATAENCODINGUNKNOWN_FAULT) || qName.equals(SOAPConstants.SOAP_MUSTUNDERSTAND_FAULT) || qName.equals(SOAPConstants.SOAP_RECEIVER_FAULT) || qName.equals(SOAPConstants.SOAP_SENDER_FAULT) || qName.equals(SOAPConstants.SOAP_VERSIONMISMATCH_FAULT))) {
            throw new SOAPException(Messages.getMessage("invalidFaultCode", string2, string));
        }
    }

    protected String _validateQName(String string, String string2, String string3, String string4) throws SOAPException {
        if (disableSOAPNamespaceValidation) {
            return string;
        }
        if (string == null || string.equals("")) {
            if (string3 == null || string3.equals("")) {
                throw new SOAPException(Messages.getMessage("unqualifiedName", string4, string2, string3, string));
            }
            Mapping mapping = this._getMappingScope().getMappingForPrefix(string3, false);
            if (mapping == null) {
                throw new SOAPException(Messages.getMessage("unqualifiedName", string4, string2, string3, string));
            }
            string = mapping.getNamespaceURI();
        }
        return string;
    }

    public String getFaultCode() {
        if (this.isSOAP12()) {
            if (this._getFault() != null) {
                return this._getFault().getFaultCode().toString();
            }
            QName qName = this.soapFactory.getSOAPConstants().getFaultCodeQName();
            SOAPElement sOAPElement = this._getChildElement(qName);
            if (sOAPElement != null) {
                QName qName2 = this.soapFactory.getSOAPConstants().getFaultCodeValueQName();
                try {
                    SOAPElement sOAPElement2 = sOAPElement.getChildElement(qName2.getNamespaceURI(), qName2.getLocalPart());
                    if (sOAPElement2 != null) {
                        return sOAPElement2.getValue();
                    }
                }
                catch (SOAPException sOAPException) {
                    FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.xmlsoap.SOAPFault.getFaultCode", "292", this);
                    throw new RuntimeException(sOAPException);
                }
            }
            return null;
        }
        if (this._getFault() != null) {
            return this._getFault().getFaultCode().toString();
        }
        QName qName = this.soapFactory.getSOAPConstants().getFaultCodeQName();
        SOAPElement sOAPElement = this._getChildElement(qName);
        if (sOAPElement != null) {
            return sOAPElement.getValue();
        }
        sOAPElement = this._getChildElement(QNameTable.createQName("http://schemas.xmlsoap.org/soap/envelope/", Constants.QNAME_FAULTCODE.getLocalPart()));
        if (sOAPElement != null) {
            if (sOAPElement.getPrefix() == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Per section 3.3.3 of the WS-I Basic Profile, SOAP Fault children should not have a namespace. However, this namespace will be tolerated.");
                }
                return sOAPElement.getValue();
            }
            if (sOAPElement.getPrefix() != null && sOAPElement.getPrefix().length() > 0 && log.isDebugEnabled()) {
                log.debug("Error: Per section 3.3.3 of the WS-I Basic Profile, SOAP Fault children must not be namespace qualified.");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Error: Namespace for this SOAP Fault child is not valid.");
        }
        return null;
    }

    public QName getFaultCodeAsQName() {
        int n;
        if (this._getFault() != null) {
            WebServicesFault webServicesFault = this._getFault();
            return webServicesFault.getFaultCode();
        }
        String string = this.getFaultCode();
        if (string == null) {
            return null;
        }
        if (string.startsWith("{") && (n = string.indexOf("}")) > 0) {
            String string2 = string.substring(1, n);
            string = string.substring(n + 1);
            return QNameTable.createQName(string2, string);
        }
        String string3 = SOAPFault.extractPrefixFromQName(string);
        String string4 = SOAPFault.extractLocalNameFromQName(string);
        String string5 = null;
        string3 = string3 == null ? "" : string3;
        QName qName = this.soapFactory.getSOAPConstants().getFaultCodeQName();
        SOAPElement sOAPElement = this._getChildElement(qName);
        if (sOAPElement == null) {
            sOAPElement = this._getChildElement(QNameTable.createQName("http://schemas.xmlsoap.org/soap/envelope/", Constants.QNAME_FAULTCODE.getLocalPart()));
            if (sOAPElement != null) {
                if (sOAPElement.getPrefix() == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Per section 3.3.3 of the WS-I Basic Profile, SOAP Fault children should not have a namespace. However, this namespace will be tolerated.");
                    }
                } else if (sOAPElement.getPrefix() != null && sOAPElement.getPrefix().length() > 0 && log.isDebugEnabled()) {
                    log.debug("Error: Per section 3.3.3 of the WS-I Basic Profile, SOAP Fault children must not be namespace qualified.");
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Error: Namespace for this SOAP Fault child is not valid.");
            }
        }
        Mapping mapping = null;
        if (sOAPElement != null) {
            mapping = sOAPElement._getMappingScope().getMappingForPrefix(string3, false);
        }
        if (mapping != null) {
            string5 = mapping.getNamespaceURI();
        }
        return new QName(string5, string4, string3);
    }

    public javax.xml.soap.Name getFaultCodeAsName() {
        QName qName = this.getFaultCodeAsQName();
        if (qName == null) {
            return null;
        }
        return new Name(qName);
    }

    public void setFaultActor(String string) throws SOAPException {
        if (this.isSOAP12()) {
            this.setFaultRole(string);
            return;
        }
        if (this._getFault() != null) {
            this._getFault().setFaultActor(string);
        } else {
            QName qName = this.soapFactory.getSOAPConstants().getFaultActorOrRoleQName();
            SOAPElement sOAPElement = this.getChildElement(qName.getNamespaceURI(), qName.getLocalPart());
            if (sOAPElement != null) {
                sOAPElement.detachNode();
            }
            sOAPElement = this.createChildElement(qName);
            sOAPElement = this.addChild(sOAPElement);
            sOAPElement.addTextNode(string);
        }
    }

    public String getFaultActor() {
        if (this.isSOAP12()) {
            return this.getFaultRole();
        }
        if (this._getFault() != null) {
            return this._getFault().getFaultActor();
        }
        QName qName = this.soapFactory.getSOAPConstants().getFaultActorOrRoleQName();
        SOAPElement sOAPElement = this._getChildElement(qName);
        if (sOAPElement != null) {
            return sOAPElement.getValue();
        }
        sOAPElement = this._getChildElement(QNameTable.createQName("http://schemas.xmlsoap.org/soap/envelope/", Constants.QNAME_FAULTACTOR.getLocalPart()));
        if (sOAPElement != null) {
            if (sOAPElement.getPrefix() == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Per section 3.3.3 of the WS-I Basic Profile, SOAP Fault children should not have a namespace. However, this namespace will be tolerated.");
                }
                return sOAPElement.getValue();
            }
            if (sOAPElement.getPrefix() != null && sOAPElement.getPrefix().length() > 0 && log.isDebugEnabled()) {
                log.debug("Error: Per section 3.3.3 of the WS-I Basic Profile, SOAP Fault children must not be namespace qualified.");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Error: Namespace for this SOAP Fault child is not valid.");
        }
        return null;
    }

    public void setFaultString(String string) throws SOAPException {
        if (this.isSOAP12()) {
            this.addFaultReasonText(string, Locale.getDefault());
        } else if (this._getFault() != null) {
            this._getFault().setFaultString(string);
        } else {
            QName qName = this.soapFactory.getSOAPConstants().getFaultStringOrReasonQName();
            SOAPElement sOAPElement = this.getChildElement(qName.getNamespaceURI(), qName.getLocalPart());
            if (sOAPElement != null) {
                sOAPElement.detachNode();
            }
            sOAPElement = this.createChildElement(qName);
            sOAPElement = this.addChild(sOAPElement);
            sOAPElement.addTextNode(string);
        }
    }

    public void setFaultString(String string, Locale locale) throws SOAPException {
        if (this.isSOAP12()) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            this.addFaultReasonText(string, locale);
        } else {
            this.setFaultString(string);
            this.locale = locale;
        }
    }

    public Locale getFaultStringLocale() {
        if (this.isSOAP12()) {
            try {
                return (Locale)this.getFaultReasonLocales().next();
            }
            catch (SOAPException sOAPException) {
                return null;
            }
        }
        return this.locale;
    }

    public String getFaultString() {
        if (this.isSOAP12()) {
            String string = null;
            try {
                string = (String)this.getFaultReasonTexts().next();
            }
            catch (SOAPException sOAPException) {
                // empty catch block
            }
            return string;
        }
        if (this._getFault() != null) {
            return this._getFault().getFaultString();
        }
        QName qName = this.soapFactory.getSOAPConstants().getFaultStringOrReasonQName();
        SOAPElement sOAPElement = this._getChildElement(qName);
        if (sOAPElement != null) {
            return sOAPElement.getValue();
        }
        sOAPElement = this._getChildElement(QNameTable.createQName("http://schemas.xmlsoap.org/soap/envelope/", Constants.QNAME_FAULTSTRING.getLocalPart()));
        if (sOAPElement != null) {
            if (sOAPElement.getPrefix() == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Per section 3.3.3 of the WS-I Basic Profile, SOAP Fault children should not have a namespace. However, this namespace will be tolerated.");
                }
                return sOAPElement.getValue();
            }
            if (sOAPElement.getPrefix() != null && sOAPElement.getPrefix().length() > 0 && log.isDebugEnabled()) {
                log.debug("Error: Per section 3.3.3 of the WS-I Basic Profile, SOAP Fault children must not be namespace qualified.");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Error: Namespace for this SOAP Fault child is not valid.");
        }
        return null;
    }

    public boolean isUserFault() {
        return this.getDetail() != null;
    }

    public javax.xml.soap.Detail getDetail() {
        QName qName = this.soapFactory.getSOAPConstants().getFaultDetailQName();
        javax.xml.soap.Detail detail = (javax.xml.soap.Detail)((Object)this._getChildElement(qName));
        if (detail != null) {
            return detail;
        }
        detail = (javax.xml.soap.Detail)((Object)this._getChildElement(QNameTable.createQName("http://schemas.xmlsoap.org/soap/envelope/", Constants.QNAME_FAULTDETAILS.getLocalPart())));
        if (detail != null) {
            if (detail.getPrefix() == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Per section 3.3.3 of the sWS-I Basic Profile, SOAP Fault children should not have a namespace. However, this namespace will be tolerated.");
                }
                return detail;
            }
            if (detail.getPrefix() != null && detail.getPrefix().length() > 0 && log.isDebugEnabled()) {
                log.debug("Error: Per section 3.3.3 of the WS-I Basic Profile, SOAP Fault children must not be namespace qualified.");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Error: Namespace for this SOAP Fault child is not valid.");
        }
        return null;
    }

    public javax.xml.soap.Detail addDetail() throws SOAPException {
        if (this.getDetail() != null) {
            throw new SOAPException(Messages.getMessage("valuePresent"));
        }
        QName qName = this.soapFactory.getSOAPConstants().getFaultDetailQName();
        Detail detail = (Detail)this.createChildElement(qName);
        detail = (Detail)this.addChild(detail);
        return detail;
    }

    protected WebServicesFault _getFault() {
        Object object = this.getAlternateContent();
        if (object instanceof WebServicesFault) {
            return (WebServicesFault)object;
        }
        return null;
    }

    public WebServicesFault getFault() {
        WebServicesFault webServicesFault = this._getFault();
        if (webServicesFault == null) {
            this.asSOAPElement(SOAPElement.CONTEXT_CONTENT);
            try {
                webServicesFault = WebServicesFaultProcessor.createFault(this, this.getSOAPFactory().getDeserializationContext());
                this.setFault(webServicesFault);
            }
            catch (SAXException sAXException) {
                FFDCFilter.processException((Throwable)sAXException, "com.ibm.ws.webservices.engine.xmlsoap.SOAPFault.getFault", "485", this);
                throw new RuntimeException(sAXException);
            }
        }
        return webServicesFault;
    }

    public void setFault(WebServicesFault webServicesFault) {
        try {
            this.removeContents();
            this.setAlternateContent(WebServicesFaultAlternateContent.create(webServicesFault));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.xmlsoap.SOAPFault.setFault", "472", this);
            throw new RuntimeException(exception);
        }
    }

    public void setFault(SOAPFaultException sOAPFaultException) {
        this.setFault(new WebServicesFault(sOAPFaultException));
    }

    protected SOAPBuilder createBuilder() {
        return new SOAPFaultBuilder();
    }

    protected SOAPElement createChildElement(String string, String string2, SOAPFactory sOAPFactory) throws SOAPException {
        QName qName = sOAPFactory.getSOAPConstants().getFaultDetailQName();
        if (string == null) {
            string = "";
        }
        if (qName.getLocalPart().equals(string2) && qName.getNamespaceURI().equals(string)) {
            return new Detail(sOAPFactory);
        }
        return super.createChildElement(string, string2, sOAPFactory);
    }

    private SOAPElement createChildElement(QName qName) throws SOAPException {
        return this.createChildElement(qName.getNamespaceURI(), qName.getLocalPart(), this.getSOAPFactory());
    }

    protected boolean isValidSAAJChild(Node node) {
        Class<?> clazz = node.getClass();
        if (node instanceof SOAPElement && !(node instanceof Detail)) {
            QName qName = this.soapFactory.getSOAPConstants().getFaultDetailQName();
            SOAPElement sOAPElement = (SOAPElement)node;
            if (sOAPElement.getQName().equals(qName)) {
                return false;
            }
        }
        return (clazz.equals(SOAPElement.class) || clazz.equals(SOAPFaultElement.class) || clazz.equals(Detail.class) || clazz.equals(Text.class) || clazz.equals(Comment.class) || clazz.equals(SAAJ12Text.class)) && this.getOwnerDocument() == node.getOwnerDocument();
    }

    public javax.xml.soap.SOAPElement addTextNode(String string) throws SOAPException {
        if (this.isSOAP12() && !XMLUtils.isXMLWhitespace(string)) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "addTextNode(String)", "javax.xml.soap.SOAPFault"));
        }
        return super.addTextNode(string);
    }

    public void setEncodingStyle(String string) throws SOAPException {
        if (this.isSOAP12()) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "setEncodingStyle(String)", "javax.xml.soap.SOAPFault"));
        }
        super.setEncodingStyle(string);
    }

    private SOAPElement _getChildElement(QName qName) {
        try {
            return this.getChildElement(qName.getNamespaceURI(), qName.getLocalPart());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.xmlsoap.SOAPFault.setFault", "519", this);
            throw new RuntimeException(exception);
        }
    }

    public void setFaultCode(QName qName) throws SOAPException {
        String string = qName.getNamespaceURI();
        String string2 = qName.getLocalPart();
        String string3 = qName.getPrefix();
        this._validateFaultCode(string, string2, string3);
        if (this._getFault() != null) {
            WebServicesFault webServicesFault = this._getFault();
            webServicesFault.setFaultCode(QNameTable.createQName(string, string2));
        } else {
            String string4 = string2;
            if (string3 != null && string3.length() > 0) {
                string4 = string3 + ":" + string4;
                if (this._getMappingScope().getMappingForPrefix(string3, false) == null) {
                    this.addNamespaceDeclaration(string3, string);
                }
            } else if (string != null && string.length() > 0) {
                Mapping mapping = this._getMappingScope().getMappingForNamespaceURI(string, false, true);
                if (mapping != null) {
                    string3 = mapping.getPrefix();
                    string4 = string3 + ":" + string4;
                } else {
                    string4 = "{" + string + "}" + string4;
                }
            }
            this._setFaultCode(string4);
        }
    }

    public Iterator getFaultSubcodes() {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "getFaultSubcodes()", "javax.xml.soap.Fault"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "getFaultSubcodes()", "javax.xml.soap.Fault", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        if (this._getFault() != null) {
            WebServicesFault webServicesFault = this._getFault();
            List list = webServicesFault.getSOAP12_Subcodes();
            if (list == null) {
                return new ArrayList().iterator();
            }
            return list.iterator();
        }
        QName qName = this.soapFactory.getSOAPConstants().getFaultCodeQName();
        QName qName2 = this.soapFactory.getSOAPConstants().getFaultSubcodeQName();
        SOAPElement sOAPElement = this._getChildElement(qName);
        if (sOAPElement == null) {
            return new ArrayList().iterator();
        }
        String string = "javax.xml.soap.Fault.getFaultSubcodes()";
        NestedNodeIterator nestedNodeIterator = new NestedNodeIterator(sOAPElement, qName2, string);
        NodeIteratorFilter nodeIteratorFilter = new NodeIteratorFilter(nestedNodeIterator, string){
            final QName valueQName;
            {
                this.valueQName = SOAPFault.this.soapFactory.getSOAPConstants().getFaultCodeValueQName();
            }

            public Object getObject(Node node) {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (!this.valueQName.getNamespaceURI().equals(node2.getNamespaceURI()) || !this.valueQName.getLocalPart().equals(node2.getLocalName())) continue;
                    String string = node2.getTextContent();
                    return Utils.toQName((SOAPElement)node2, string);
                }
                throw new IllegalArgumentException();
            }
        };
        return nodeIteratorFilter;
    }

    public void removeAllFaultSubcodes() {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "removeAllFaultSubcodes()", "javax.xml.soap.Fault"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "removeAllFaultSubcodes()", "javax.xml.soap.Fault", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        if (this._getFault() != null) {
            WebServicesFault webServicesFault = this._getFault();
            webServicesFault.setSOAP12_Subcodes(null);
        } else {
            QName qName = this.soapFactory.getSOAPConstants().getFaultCodeQName();
            QName qName2 = this.soapFactory.getSOAPConstants().getFaultSubcodeQName();
            SOAPElement sOAPElement = this._getChildElement(qName);
            if (sOAPElement == null) {
                return;
            }
            String string = "javax.xml.soap.Fault.removeAllFaultSubcodes()";
            NestedNodeIterator nestedNodeIterator = new NestedNodeIterator(sOAPElement, qName2, string);
            if (nestedNodeIterator.hasNext()) {
                Node node = (Node)nestedNodeIterator.next();
                node.getParentNode().removeChild(node);
            }
        }
    }

    public void appendFaultSubcode(QName qName) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "appendFaultSubcode(QName)", "javax.xml.soap.Fault"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "appendFaultSubcode(QName)", "javax.xml.soap.Fault", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        this._validateQName(qName.getNamespaceURI(), qName.getLocalPart(), qName.getPrefix(), "FaultSubcode");
        if (this._getFault() != null) {
            WebServicesFault webServicesFault = this._getFault();
            ArrayList<QName> arrayList = webServicesFault.getSOAP12_Subcodes();
            if (arrayList == null) {
                arrayList = new ArrayList<QName>();
            }
            arrayList.add(qName);
            webServicesFault.setSOAP12_Subcodes(arrayList);
        } else {
            QName qName2 = this.soapFactory.getSOAPConstants().getFaultCodeQName();
            QName qName3 = this.soapFactory.getSOAPConstants().getFaultSubcodeQName();
            QName qName4 = this.soapFactory.getSOAPConstants().getFaultCodeValueQName();
            SOAPElement sOAPElement = this._getChildElement(qName2);
            String string = "javax.xml.soap.Fault.appendFaultSubcode(QName)";
            if (sOAPElement == null) {
                throw new SOAPException(Messages.getMessage("noFaultCode", string));
            }
            String string2 = this.soapFactory.getSOAPConstants().getEnvelopePrefix();
            SOAPElement sOAPElement2 = (SOAPElement)this.soapFactory.createElement(qName3.getLocalPart(), string2, qName3.getNamespaceURI());
            SOAPElement sOAPElement3 = (SOAPElement)sOAPElement2.addChildElement(qName4.getLocalPart(), string2, qName4.getNamespaceURI());
            String string3 = qName.getPrefix();
            if (string3 != null && string3.length() > 0 && this._getMappingScope().getMappingForPrefix(string3, false) == null) {
                sOAPElement3.addNamespaceDeclaration(string3, qName.getNamespaceURI());
            }
            String string4 = Utils.toQualifiedName(sOAPElement3, qName);
            sOAPElement3.setTextContent(string4);
            Node node = sOAPElement;
            NestedNodeIterator nestedNodeIterator = new NestedNodeIterator(node, qName3, string);
            while (nestedNodeIterator.hasNext()) {
                node = (Node)nestedNodeIterator.next();
            }
            node.appendChild(sOAPElement2);
        }
    }

    public Iterator getFaultReasonLocales() throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "getFaultReasonLocales()", "javax.xml.soap.Fault"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "getFaultReasonLocales()", "javax.xml.soap.Fault", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        if (this._getFault() != null) {
            WebServicesFault webServicesFault = this._getFault();
            ArrayList<Locale> arrayList = new ArrayList<Locale>();
            String string = webServicesFault.getSOAP12_ReasonLanguage();
            arrayList.add(this.getLocale(string));
            List list = webServicesFault.getSOAP12_AdditionalReasons();
            if (list != null) {
                for (int i = 0; i < list.size(); i += 2) {
                    string = (String)list.get(i);
                    arrayList.add(this.getLocale(string));
                }
            }
            return arrayList.iterator();
        }
        QName qName = this.soapFactory.getSOAPConstants().getFaultStringOrReasonQName();
        QName qName2 = this.soapFactory.getSOAPConstants().getFaultReasonTextQName();
        SOAPElement sOAPElement = this._getChildElement(qName);
        String string = "javax.xml.soap.Fault.getFaultReasonLocales()";
        if (sOAPElement == null) {
            throw new SOAPException(Messages.getMessage("noFaultReason", string));
        }
        CE_Iterator cE_Iterator = new CE_Iterator(sOAPElement, qName2.getNamespaceURI(), qName2.getLocalPart(), string);
        NodeIteratorFilter nodeIteratorFilter = new NodeIteratorFilter(cE_Iterator, string){
            QName xmlLang;
            {
                this.xmlLang = SOAPFault.this.soapFactory.getSOAPConstants().getXMLLangAttributeQName();
            }

            public Object getObject(Node node) {
                Element element = (Element)node;
                String string = element.getAttributeNS(this.xmlLang.getNamespaceURI(), this.xmlLang.getLocalPart());
                Locale locale = SOAPFault.this.getLocale(string);
                return locale;
            }
        };
        return nodeIteratorFilter;
    }

    public Iterator getFaultReasonTexts() throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "getFaultReasonTexts()", "javax.xml.soap.Fault"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "getFaultReasonTexts()", "javax.xml.soap.Fault", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        if (this._getFault() != null) {
            WebServicesFault webServicesFault = this._getFault();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(webServicesFault.getFaultString());
            List list = webServicesFault.getSOAP12_AdditionalReasons();
            if (list != null) {
                for (int i = 1; i < list.size(); i += 2) {
                    arrayList.add((String)list.get(i));
                }
            }
            return arrayList.iterator();
        }
        QName qName = this.soapFactory.getSOAPConstants().getFaultStringOrReasonQName();
        QName qName2 = this.soapFactory.getSOAPConstants().getFaultReasonTextQName();
        SOAPElement sOAPElement = this._getChildElement(qName);
        String string = "javax.xml.soap.Fault.getFaultReasonTexts()";
        if (sOAPElement == null) {
            throw new SOAPException(Messages.getMessage("noFaultReason", string));
        }
        CE_Iterator cE_Iterator = new CE_Iterator(sOAPElement, qName2.getNamespaceURI(), qName2.getLocalPart(), string);
        NodeIteratorFilter nodeIteratorFilter = new NodeIteratorFilter(cE_Iterator, string){

            public Object getObject(Node node) {
                return node.getTextContent();
            }
        };
        return nodeIteratorFilter;
    }

    public String getFaultReasonText(Locale locale) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "getFaultReasonText(Locale)", "javax.xml.soap.Fault"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "getFaultReasonText(Locale)", "javax.xml.soap.Fault", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        Iterator iterator = this.getFaultReasonLocales();
        Iterator iterator2 = this.getFaultReasonTexts();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Locale locale2 = (Locale)iterator.next();
            String string = (String)iterator2.next();
            if (!locale2.equals(locale)) continue;
            return string;
        }
        throw new SOAPException(Messages.getMessage("noFaultReasonTextLocale", locale.toString()));
    }

    public void addFaultReasonText(String string, Locale locale) throws SOAPException {
        Object object;
        Object object2;
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addFaultReasonText(String, Locale)", "javax.xml.soap.Fault"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "addFaultReasonText(String, Locale)", "javax.xml.soap.Fault", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        QName qName = this.soapFactory.getSOAPConstants().getFaultStringOrReasonQName();
        QName qName2 = this.soapFactory.getSOAPConstants().getFaultReasonTextQName();
        QName qName3 = this.soapFactory.getSOAPConstants().getXMLLangAttributeQName();
        SOAPElement sOAPElement = this._getChildElement(qName);
        if (sOAPElement == null) {
            sOAPElement = this.createChildElement(qName);
            sOAPElement = this.addChild(sOAPElement);
        }
        String string2 = "javax.xml.soap.Fault.addFaultReasonText(String,Locale)";
        CE_Iterator cE_Iterator = new CE_Iterator(sOAPElement, qName2.getNamespaceURI(), qName2.getLocalPart(), string2);
        while (cE_Iterator.hasNext() && string != null) {
            object2 = (Element)cE_Iterator.next();
            object = object2.getAttributeNS(qName3.getNamespaceURI(), qName3.getLocalPart());
            if (!this.isMatchingLocale((String)object, locale)) continue;
            object2.setTextContent(string);
            return;
        }
        object2 = this.getPrefix();
        object = (SOAPElement)sOAPElement.addChildElement(qName2.getLocalPart(), (String)object2, qName2.getNamespaceURI());
        ((SOAPElement)object).setAttributeNS(qName3.getNamespaceURI(), "xml:" + qName3.getLocalPart(), this.localeToXmlLang(locale));
        ((DOMElementImpl)object).setTextContent(string);
    }

    public String getFaultNode() {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "getFaultNode()", "javax.xml.soap.Fault"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "getFaultReasonNode()", "javax.xml.soap.Fault", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        if (this._getFault() != null) {
            WebServicesFault webServicesFault = this._getFault();
            return webServicesFault.getSOAP12_Node();
        }
        SOAPElement sOAPElement = this._getChildElement(this.soapFactory.getSOAPConstants().getFaultNodeQName());
        return sOAPElement == null ? null : sOAPElement.getValue();
    }

    public void setFaultNode(String string) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "setFaultNode(String)", "javax.xml.soap.Fault"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "setFaultNode(String)", "javax.xml.soap.Fault", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        if (this._getFault() != null) {
            WebServicesFault webServicesFault = this._getFault();
            webServicesFault.setSOAP12_Node(string);
        } else {
            QName qName = this.soapFactory.getSOAPConstants().getFaultNodeQName();
            SOAPElement sOAPElement = this._getChildElement(qName);
            if (sOAPElement != null) {
                sOAPElement.detachNode();
            }
            sOAPElement = this.createChildElement(qName);
            sOAPElement = this.addChild(sOAPElement);
            sOAPElement.addTextNode(string);
        }
    }

    public String getFaultRole() {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "getFaultRole()", "javax.xml.soap.Fault"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "getFaultRole()", "javax.xml.soap.Fault", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        if (this._getFault() != null) {
            WebServicesFault webServicesFault = this._getFault();
            return webServicesFault.getFaultActor();
        }
        SOAPElement sOAPElement = this._getChildElement(this.soapFactory.getSOAPConstants().getFaultActorOrRoleQName());
        return sOAPElement == null ? null : sOAPElement.getValue();
    }

    public void setFaultRole(String string) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "setFaultRole(String)", "javax.xml.soap.Fault"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "setFaultRole(String)", "javax.xml.soap.Fault", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        if (this._getFault() != null) {
            WebServicesFault webServicesFault = this._getFault();
            webServicesFault.setFaultActor(string);
        } else {
            QName qName = this.soapFactory.getSOAPConstants().getFaultActorOrRoleQName();
            SOAPElement sOAPElement = this._getChildElement(qName);
            if (sOAPElement != null) {
                sOAPElement.detachNode();
            }
            sOAPElement = this.createChildElement(qName);
            sOAPElement = this.addChild(sOAPElement);
            sOAPElement.addTextNode(string);
        }
    }

    public boolean hasDetail() {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "hasDetail()", "javax.xml.soap.Fault"));
        }
        return this.getDetail() != null;
    }

    private Locale getLocale(String string) {
        Locale locale = null;
        locale = string == null || string.length() == 0 ? Locale.getDefault() : this.xmlLangToLocale(string);
        return locale;
    }

    private Locale xmlLangToLocale(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        Locale locale = null;
        int n = string.indexOf(45);
        if (n < 0) {
            locale = new Locale(string);
        } else {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            locale = new Locale(string2, string3);
        }
        return locale;
    }

    private String localeToXmlLang(Locale locale) {
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        return new String(string + "-" + string2);
    }

    private boolean isMatchingLocale(String string, Locale locale) {
        Locale locale2 = this.getLocale(string);
        return locale2.getLanguage().equals(locale.getLanguage()) && locale2.getCountry().equals(locale.getCountry());
    }

    private SOAPElement addChild(SOAPElement sOAPElement) {
        SOAPConstants sOAPConstants = this.soapFactory.getSOAPConstants();
        if (!this.isSOAP12()) {
            if (sOAPElement.getLocalName().equals(sOAPConstants.getFaultCodeQName().getLocalPart())) {
                return (SOAPElement)this.insertBefore(sOAPElement, this.getFirstChild());
            }
            if (sOAPElement.getLocalName().equals(sOAPConstants.getFaultStringOrReasonQName().getLocalPart())) {
                SOAPElement sOAPElement2 = this._getChildElement(sOAPConstants.getFaultActorOrRoleQName());
                if (sOAPElement2 == null) {
                    sOAPElement2 = this._getChildElement(sOAPConstants.getFaultDetailQName());
                }
                return (SOAPElement)this.insertBefore(sOAPElement, sOAPElement2);
            }
            if (sOAPElement.getLocalName().equals(sOAPConstants.getFaultActorOrRoleQName().getLocalPart())) {
                SOAPElement sOAPElement3 = this._getChildElement(sOAPConstants.getFaultDetailQName());
                return (SOAPElement)this.insertBefore(sOAPElement, sOAPElement3);
            }
            return (SOAPElement)this.appendChild(sOAPElement);
        }
        if (sOAPElement.getLocalName().equals(sOAPConstants.getFaultCodeQName().getLocalPart())) {
            return (SOAPElement)this.insertBefore(sOAPElement, this.getFirstChild());
        }
        if (sOAPElement.getLocalName().equals(sOAPConstants.getFaultStringOrReasonQName().getLocalPart())) {
            SOAPElement sOAPElement4 = this._getChildElement(sOAPConstants.getFaultNodeQName());
            if (sOAPElement4 == null) {
                sOAPElement4 = this._getChildElement(sOAPConstants.getFaultActorOrRoleQName());
            }
            if (sOAPElement4 == null) {
                sOAPElement4 = this._getChildElement(sOAPConstants.getFaultDetailQName());
            }
            return (SOAPElement)this.insertBefore(sOAPElement, sOAPElement4);
        }
        if (sOAPElement.getLocalName().equals(sOAPConstants.getFaultNodeQName().getLocalPart())) {
            SOAPElement sOAPElement5 = this._getChildElement(sOAPConstants.getFaultActorOrRoleQName());
            if (sOAPElement5 == null) {
                sOAPElement5 = this._getChildElement(sOAPConstants.getFaultDetailQName());
            }
            return (SOAPElement)this.insertBefore(sOAPElement, sOAPElement5);
        }
        if (sOAPElement.getLocalName().equals(sOAPConstants.getFaultActorOrRoleQName().getLocalPart())) {
            SOAPElement sOAPElement6 = this._getChildElement(sOAPConstants.getFaultDetailQName());
            return (SOAPElement)this.insertBefore(sOAPElement, sOAPElement6);
        }
        return (SOAPElement)this.appendChild(sOAPElement);
    }

    public javax.xml.soap.SOAPElement setElementQName(QName qName) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "setElementQName(QName)", "javax.xml.soap.SOAPFault"));
        }
        if (!qName.getNamespaceURI().equals(this.getNamespaceURI()) || !qName.getLocalPart().equals(this.getLocalName())) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "setElementQName(QName)", "javax.xml.soap.SOAPFault"));
        }
        return super.setElementQName(qName);
    }

    class CE_Iterator
    implements Iterator {
        Node parent;
        Node prev;
        boolean first = true;
        boolean safeRemove = false;
        String ns = null;
        String localPart = null;
        String methodName = null;
        boolean elementsOnly = false;

        CE_Iterator(Node node, boolean bl, String string) {
            this.parent = node;
            this.methodName = string;
            node.normalize();
            this.elementsOnly = bl;
            this.prev = node;
        }

        CE_Iterator(Node node, String string, String string2, String string3) {
            this.parent = node;
            this.methodName = string3;
            node.normalize();
            this.prev = node;
            this.ns = string;
            this.localPart = string2;
            this.elementsOnly = true;
        }

        public boolean hasNext() {
            Node node = this.getNext();
            return node != null;
        }

        public Object next() {
            Node node = this.getNext();
            if (node == null) {
                throw new NoSuchElementException(Messages.getMessage("exception00"));
            }
            this.safeRemove = true;
            this.first = false;
            this.prev = node;
            return node;
        }

        public void remove() {
            if (!this.safeRemove || this.prev == null) {
                throw new IllegalStateException(Messages.getMessage("unsupportedIteratorRemove", this.methodName));
            }
            this.safeRemove = false;
            Node node = this.getPrev();
            this.parent.removeChild(this.prev);
            if (node == null) {
                this.first = true;
                this.prev = this.parent;
            } else {
                this.prev = node;
            }
        }

        private Node getNext() {
            Node node = null;
            if (this.prev == null) {
                return node;
            }
            for (node = this.first ? this.prev.getFirstChild() : this.prev.getNextSibling(); node != null && !this.match(node); node = node.getNextSibling()) {
            }
            return node;
        }

        private Node getPrev() {
            Node node = null;
            if (this.prev == null) {
                return node;
            }
            for (node = this.prev.getPreviousSibling(); node != null && !this.match(node); node = node.getPreviousSibling()) {
            }
            return node;
        }

        protected boolean match(Node node) {
            if (this.localPart == null) {
                return !this.elementsOnly || node instanceof Element;
            }
            String string = node.getLocalName();
            if (string == null) {
                string = SOAPElement.extractLocalNameFromQName(node.getNodeName());
            }
            if (!this.localPart.equals(string)) {
                return false;
            }
            String string2 = node.getNamespaceURI();
            return this.ns.equals(string2) || this.ns.length() == 0 && string2 == null;
        }
    }

    private abstract class NodeIteratorFilter
    implements Iterator {
        public Iterator nodeIterator;
        private String methodName;

        public NodeIteratorFilter(Iterator iterator, String string) {
            this.nodeIterator = iterator;
            this.methodName = string;
        }

        public boolean hasNext() {
            return this.nodeIterator.hasNext();
        }

        public Object next() {
            return this.getObject((Node)this.nodeIterator.next());
        }

        public void remove() {
            throw new IllegalStateException(Messages.getMessage("unsupportedIteratorRemove", this.methodName));
        }

        protected abstract Object getObject(Node var1);
    }

    private class NestedNodeIterator
    implements Iterator {
        Node curr = null;
        QName nestedQName;
        String methodName;

        public NestedNodeIterator(Node node, QName qName, String string) {
            this.curr = node;
            this.nestedQName = qName;
            this.methodName = string;
        }

        public boolean hasNext() {
            return this.getNext(this.curr) != null;
        }

        public Object next() {
            this.curr = this.getNext(this.curr);
            return this.curr;
        }

        public void remove() {
            throw new IllegalStateException(Messages.getMessage("unsupportedIteratorRemove", this.methodName));
        }

        private Node getNext(Node node) {
            if (node == null) {
                return null;
            }
            Node node2 = null;
            for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (!(node2 instanceof Element) || !node2.getNamespaceURI().equals(this.nestedQName.getNamespaceURI()) || !node2.getLocalName().equals(this.nestedQName.getLocalPart())) continue;
                return node2;
            }
            return node2;
        }
    }
}

