/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.websphere.webservices.soap.IBMSOAPFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.client.ClientEngine;
import com.ibm.ws.webservices.engine.client.ClientEngineFactory;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configuration.NullEngineConfigurationProvider;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl;
import com.ibm.ws.webservices.engine.enumtype.MessageType;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.Detail;
import com.ibm.ws.webservices.engine.xmlsoap.DetailEntry;
import com.ibm.ws.webservices.engine.xmlsoap.Name;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBodyElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPDocument;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFault;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFaultElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ElementAlternateContent;
import com.ibm.ws.webservices.engine.xmlsoap.ext.XMLInputSourceAlternateContent;
import com.ibm.ws.webservices.engine.xmlsoap.ext.XMLStringAlternateContent;
import java.io.InputStream;
import java.io.Serializable;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SOAPFactory
extends IBMSOAPFactory
implements Serializable {
    protected static Log log = LogFactory.getLog(SOAPFactory.class.getName());
    protected SOAPEnvelope envelope;
    protected SOAPConstants soapConstants;
    protected MessageType messageType;
    protected boolean protectState;
    protected boolean protectionViolation = false;
    private transient DeserializationContext context = null;
    private transient MessageContext msgContext = null;
    private SOAPDocument ownerDocument = new SOAPDocument();
    private static EngineConfiguration nullEngineConfig = null;

    public SOAPFactory(SOAPConstants sOAPConstants) {
        this.setSOAPConstants(sOAPConstants);
    }

    public SOAPFactory() {
        this.setSOAPConstants(SOAPConstants.SOAP11_CONSTANTS);
    }

    public SOAPFactory(String string) throws SOAPException {
        this.setSOAPConstants(Utils.getSOAPConstants(string));
    }

    public SOAPConstants getSOAPConstants() {
        return this.soapConstants;
    }

    public void setSOAPConstants(SOAPConstants sOAPConstants) {
        if (!sOAPConstants.getSOAPProtocol().equals(SOAPConstants.SOAP11_CONSTANTS.getSOAPProtocol()) && !Utils._isSAAJ13Enabled()) {
            throw new UnsupportedOperationException(Messages.getMessage("unsupportedSOAPProtocol", sOAPConstants.getSOAPProtocol()));
        }
        this.soapConstants = sOAPConstants;
    }

    public SOAPDocument getOwnerDocument() {
        return this.ownerDocument;
    }

    public javax.xml.soap.SOAPElement createElement(javax.xml.soap.Name name) throws SOAPException {
        Class clazz = this.getSOAPElementClass(name.getURI(), name.getLocalName());
        javax.xml.soap.SOAPElement sOAPElement = this.createElement(name.getURI(), name.getLocalName(), clazz);
        sOAPElement.setPrefix(name.getPrefix());
        return sOAPElement;
    }

    public javax.xml.soap.SOAPElement createElement(String string) throws SOAPException {
        return this.createElement(string, "", "");
    }

    public javax.xml.soap.SOAPElement createElement(String string, String string2, String string3) throws SOAPException {
        Class clazz = this.getSOAPElementClass(string3, string);
        javax.xml.soap.SOAPElement sOAPElement = this.createElement(string3, string, clazz);
        sOAPElement.setPrefix(string2);
        return sOAPElement;
    }

    public javax.xml.soap.SOAPElement createElementFromXMLString(String string) throws SOAPException {
        SOAPElement sOAPElement = this.createSOAPElement("", "elem");
        sOAPElement.setAlternateContent(XMLStringAlternateContent.create(string));
        return sOAPElement;
    }

    public javax.xml.soap.SOAPElement createElementFromXMLString(String string, Class clazz) throws SOAPException {
        SOAPElement sOAPElement = (SOAPElement)this.createElement("", "elem", clazz);
        if (sOAPElement != null) {
            sOAPElement.removeContents();
            sOAPElement.setAlternateContent(XMLStringAlternateContent.create(string));
        }
        return sOAPElement;
    }

    public javax.xml.soap.SOAPElement createElementFromInputSource(InputSource inputSource) throws SOAPException {
        SOAPElement sOAPElement = this.createSOAPElement("", "elem");
        sOAPElement.setAlternateContent(XMLInputSourceAlternateContent.create(inputSource));
        return sOAPElement;
    }

    public javax.xml.soap.SOAPElement createElementFromInputSource(InputSource inputSource, Class clazz) throws SOAPException {
        SOAPElement sOAPElement = (SOAPElement)this.createElement("", "elem", clazz);
        if (sOAPElement != null) {
            sOAPElement.removeContents();
            sOAPElement.setAlternateContent(XMLInputSourceAlternateContent.create(inputSource));
        }
        return sOAPElement;
    }

    public javax.xml.soap.SOAPElement createElementFromDOMElement(Element element, Class clazz) throws SOAPException {
        String string;
        String string2 = element.getNamespaceURI();
        SOAPElement sOAPElement = (SOAPElement)this.createElement(string2, string = (string = element.getLocalName()) == null || string.length() == 0 ? element.getNodeName() : string, clazz);
        if (sOAPElement != null) {
            sOAPElement.removeContents();
            sOAPElement.setPrefix(element.getPrefix());
            sOAPElement.setAlternateContent(ElementAlternateContent.create(element));
        }
        return sOAPElement;
    }

    public javax.xml.soap.SOAPElement createElement(QName qName) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "createElement(QName)", "javax.xml.soap.SOAPFactory"));
        }
        Class clazz = this.getSOAPElementClass(qName.getNamespaceURI(), qName.getLocalPart());
        javax.xml.soap.SOAPElement sOAPElement = this.createElement(qName.getNamespaceURI(), qName.getLocalPart(), clazz);
        if (qName.getPrefix().length() > 0) {
            sOAPElement.setPrefix(qName.getPrefix());
        }
        return sOAPElement;
    }

    javax.xml.soap.SOAPElement createElement(String string, String string2, Class clazz) throws SOAPException {
        if (clazz.equals(javax.xml.soap.SOAPEnvelope.class) || clazz.equals(SOAPEnvelope.class)) {
            if (this.envelope != null) {
                throw new SOAPException(Messages.getMessage("oneEnvelopePerFactory00"));
            }
            this.adjustProtocol(string);
            this.envelope = this.createDynamicSOAPEnvelope();
            return this.envelope;
        }
        if (clazz.equals(javax.xml.soap.SOAPBody.class) || clazz.equals(SOAPBody.class)) {
            this.adjustProtocol(string);
            return new SOAPBody(this);
        }
        if (clazz.equals(javax.xml.soap.SOAPHeader.class) || clazz.equals(SOAPHeader.class)) {
            this.adjustProtocol(string);
            return new SOAPHeader(this);
        }
        if (clazz.equals(javax.xml.soap.SOAPFault.class) || clazz.equals(SOAPFault.class)) {
            this.adjustProtocol(string);
            return new SOAPFault(this);
        }
        if (clazz.equals(javax.xml.soap.Detail.class) || clazz.equals(Detail.class)) {
            return new Detail(this);
        }
        if (clazz.equals(javax.xml.soap.SOAPBodyElement.class) || clazz.equals(SOAPBodyElement.class)) {
            return new SOAPBodyElement(string, string2, this);
        }
        if (clazz.equals(javax.xml.soap.SOAPHeaderElement.class) || clazz.equals(SOAPHeaderElement.class)) {
            return new SOAPHeaderElement(string, string2, this);
        }
        if (clazz.equals(javax.xml.soap.DetailEntry.class) || clazz.equals(DetailEntry.class)) {
            return new DetailEntry(string, string2, this);
        }
        if (clazz.equals(javax.xml.soap.SOAPFaultElement.class) || clazz.equals(SOAPFaultElement.class)) {
            return new SOAPFaultElement(string, string2, this);
        }
        if (clazz.equals(javax.xml.soap.SOAPElement.class) || clazz.equals(SOAPElement.class)) {
            return new SOAPElement(string, string2, this);
        }
        return null;
    }

    public javax.xml.soap.SOAPElement createElement(Element element) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "createElement(Element)", "javax.xml.soap.SOAPFactory"));
        }
        if (element instanceof SOAPElement) {
            return (SOAPElement)element;
        }
        Class clazz = this.getSOAPElementClass(element.getNamespaceURI(), element.getLocalName());
        return this.createElementFromDOMElement(element, clazz);
    }

    public javax.xml.soap.Detail createDetail() throws SOAPException {
        if (this.soapConstants.getSOAPProtocol().equals("Dynamic Protocol")) {
            throw new UnsupportedOperationException(Messages.getMessage("unavailableMethodWithSOAPDynamicProtocol", "javax.xml.soap.SOAPFactory.createDetail()"));
        }
        return new Detail(this);
    }

    public javax.xml.soap.SOAPFault createFault() throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "createFault()", "javax.xml.soap.SOAPFactory"));
        }
        if (this.soapConstants.getSOAPProtocol().equals("Dynamic Protocol")) {
            throw new UnsupportedOperationException(Messages.getMessage("unavailableMethodWithSOAPDynamicProtocol", "javax.xml.soap.SOAPFactory.createDetail()"));
        }
        return new SOAPFault(this);
    }

    public javax.xml.soap.SOAPFault createFault(String string, QName qName) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "createFault(String, QName)", "javax.xml.soap.SOAPFactory"));
        }
        if (this.soapConstants.getSOAPProtocol().equals("Dynamic Protocol")) {
            throw new UnsupportedOperationException(Messages.getMessage("unavailableMethodWithSOAPDynamicProtocol", "javax.xml.soap.SOAPFactory.createDetail()"));
        }
        SOAPFault sOAPFault = new SOAPFault(this);
        sOAPFault.setFaultCode(qName);
        sOAPFault.setFaultString(string);
        return sOAPFault;
    }

    public javax.xml.soap.Name createName(String string, String string2, String string3) throws SOAPException {
        return new Name(string3, string, string2);
    }

    public javax.xml.soap.Name createName(String string) throws SOAPException {
        return new Name("", string, "");
    }

    public SOAPEnvelope createSOAPEnvelope() throws SOAPException {
        return this.createSOAPEnvelope(false);
    }

    public SOAPEnvelope createSOAPEnvelope(boolean bl) throws SOAPException {
        if (this.envelope != null) {
            throw new SOAPException(Messages.getMessage("oneEnvelopePerFactory00"));
        }
        this.envelope = new SOAPEnvelope(bl, this);
        return this.envelope;
    }

    public SOAPEnvelope createSOAPEnvelope(InputStream inputStream) throws SOAPException {
        if (this.envelope != null) {
            throw new SOAPException(Messages.getMessage("oneEnvelopePerFactory00"));
        }
        this.envelope = this.createDynamicSOAPEnvelope();
        InputSource inputSource = new InputSource(inputStream);
        ClientEngine clientEngine = ClientEngineFactory.getEngine(SOAPFactory.getNullEngineConfig());
        MessageContext messageContext = new MessageContext(clientEngine);
        this.setMessageContext(messageContext);
        DeserializationContextImpl deserializationContextImpl = new DeserializationContextImpl(inputSource, messageContext, MessageType.REQUEST, this.envelope);
        try {
            deserializationContextImpl.parse();
        }
        catch (SAXException sAXException) {
            FFDCFilter.processException((Throwable)sAXException, "com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory.createSOAPEnvelope", "214", this);
            throw new SOAPException(Messages.getMessage("parseError00", sAXException.toString()));
        }
        return this.envelope;
    }

    SOAPEnvelope getSOAPEnvelope() {
        return this.envelope;
    }

    public SOAPElement createSOAPElement(String string, String string2) throws SOAPException {
        SOAPElement sOAPElement = string == null || string.length() == 0 ? new SOAPElement(null, string2, this) : new SOAPElement(string, string2, this);
        return sOAPElement;
    }

    public SOAPElement createSOAPElement(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext, SOAPElement sOAPElement) throws SOAPException {
        string = string == null ? "" : string;
        SOAPElement sOAPElement2 = this.createSOAPElement(string, string2);
        this.elementInit(sOAPElement2, string3, attributes, mappingScope, deserializationContext, sOAPElement);
        return sOAPElement2;
    }

    public SOAPBody createSOAPBody(String string, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext, SOAPEnvelope sOAPEnvelope) throws SOAPException {
        SOAPBody sOAPBody = new SOAPBody(this);
        this.elementInit(sOAPBody, string, attributes, mappingScope, deserializationContext, sOAPEnvelope);
        return sOAPBody;
    }

    public SOAPBodyElement createSOAPBodyElement(String string, String string2) throws SOAPException {
        return new SOAPBodyElement(string, string2, this);
    }

    public SOAPBodyElement createSOAPBodyElement(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext, SOAPBody sOAPBody) throws SOAPException {
        string = string == null ? "" : string;
        SOAPBodyElement sOAPBodyElement = new SOAPBodyElement(string, string2, this);
        this.elementInit(sOAPBodyElement, string3, attributes, mappingScope, deserializationContext, sOAPBody);
        return sOAPBodyElement;
    }

    public SOAPHeader createSOAPHeader(String string, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext, SOAPEnvelope sOAPEnvelope) throws SOAPException {
        SOAPHeader sOAPHeader = new SOAPHeader(this);
        this.elementInit(sOAPHeader, string, attributes, mappingScope, deserializationContext, sOAPEnvelope);
        return sOAPHeader;
    }

    public SOAPHeaderElement createSOAPHeaderElement(String string, String string2) throws SOAPException {
        return new SOAPHeaderElement(string, string2, this);
    }

    public SOAPHeaderElement createSOAPHeaderElement(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext, SOAPHeader sOAPHeader) throws SOAPException {
        string = string == null ? "" : string;
        SOAPHeaderElement sOAPHeaderElement = new SOAPHeaderElement(string, string2, this);
        this.elementInit(sOAPHeaderElement, string3, attributes, mappingScope, deserializationContext, sOAPHeader);
        return sOAPHeaderElement;
    }

    public SOAPFault createSOAPFault() throws SOAPException {
        SOAPFault sOAPFault = new SOAPFault(this);
        if (this.envelope != null) {
            sOAPFault.setPrefix(this.envelope.getPrefix());
        } else {
            sOAPFault.setPrefix(this.getSOAPConstants().getEnvelopePrefix());
        }
        return sOAPFault;
    }

    public SOAPFault createSOAPFault(String string, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext, SOAPBody sOAPBody) throws SOAPException {
        SOAPFault sOAPFault = new SOAPFault(this);
        this.elementInit(sOAPFault, string, attributes, mappingScope, deserializationContext, sOAPBody);
        return sOAPFault;
    }

    public DetailEntry createDetailEntry(String string, String string2) throws SOAPException {
        return new DetailEntry(string, string2, this);
    }

    public DetailEntry createDetailEntry(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext, SOAPElement sOAPElement) throws SOAPException {
        string = string == null ? "" : string;
        DetailEntry detailEntry = new DetailEntry(string, string2, this);
        this.elementInit(detailEntry, string3, attributes, mappingScope, deserializationContext, sOAPElement);
        return detailEntry;
    }

    public Detail createDetail(Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext, SOAPElement sOAPElement) throws SOAPException {
        Detail detail = new Detail(this);
        this.elementInit(detail, "", attributes, mappingScope, deserializationContext, sOAPElement);
        return detail;
    }

    private void elementInit(SOAPElement sOAPElement, String string, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext, SOAPElement sOAPElement2) throws SOAPException {
        sOAPElement.setMappingScope(mappingScope);
        String string2 = "";
        int n = string.indexOf(58);
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        sOAPElement.setPrefix(string2);
        if (sOAPElement2 != null) {
            sOAPElement.setParentElement(sOAPElement2);
        }
        if (attributes != null && attributes.getLength() > 0) {
            sOAPElement.setAttributes(attributes);
        }
        this.context = deserializationContext;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public boolean getProtectState() {
        return this.protectState;
    }

    public void setProtectState(boolean bl) {
        this.protectState = bl;
    }

    void setProtectionViolation(boolean bl) {
        this.protectionViolation = bl;
    }

    public boolean getProtectionViolation() {
        return this.protectionViolation;
    }

    DeserializationContext getDeserializationContext() {
        if (this.context == null) {
            SOAPEnvelope sOAPEnvelope = this.envelope;
            if (sOAPEnvelope == null) {
                try {
                    sOAPEnvelope = this.createDynamicSOAPEnvelope();
                }
                catch (SOAPException sOAPException) {
                    FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory.getDeserializationContext", "593", this);
                    throw new InternalException(sOAPException);
                }
            }
            this.context = new DeserializationContextImpl(null, this.getMessageContext(), this.getMessageType(), sOAPEnvelope);
        }
        return this.context;
    }

    public void setMessageContext(MessageContext messageContext) {
        this.msgContext = messageContext;
    }

    public MessageContext getMessageContext() {
        if (this.msgContext == null) {
            if (this.context != null) {
                this.setMessageContext(this.context.getMessageContext());
            } else {
                this.setMessageContext(MessageContext.getCurrentThreadsContext());
            }
        }
        return this.msgContext;
    }

    private void adjustProtocol(String string) throws SOAPException {
        if (string.length() == 0) {
            return;
        }
        if (this.soapConstants.getSOAPProtocol().equals("Dynamic Protocol")) {
            if (SOAPConstants.SOAP11_CONSTANTS.getEnvelopeURI().equals(string)) {
                this.soapConstants = SOAPConstants.SOAP11_CONSTANTS;
                return;
            }
            if (SOAPConstants.SOAP12_CONSTANTS.getEnvelopeURI().equals(string)) {
                this.soapConstants = SOAPConstants.SOAP12_CONSTANTS;
                return;
            }
            throw new SOAPException(Messages.getMessage("namespaceDoesNotMatchProtocol", string, this.soapConstants.getSOAPProtocol()));
        }
        if (!this.soapConstants.getEnvelopeURI().equals(string)) {
            throw new SOAPException(Messages.getMessage("namespaceDoesNotMatchProtocol", string, this.soapConstants.getSOAPProtocol()));
        }
    }

    private Class getSOAPElementClass(String string, String string2) {
        Class clazz;
        Class clazz2 = clazz = SOAPElement.class;
        if ("http://www.w3.org/2003/05/soap-envelope".equals(string)) {
            SOAPConstants sOAPConstants = SOAPConstants.SOAP12_CONSTANTS;
            if (sOAPConstants.getEnvelopeQName().getLocalPart().equals(string2)) {
                clazz = SOAPEnvelope.class;
            } else if (sOAPConstants.getHeaderQName().getLocalPart().equals(string2)) {
                clazz = SOAPHeader.class;
            } else if (sOAPConstants.getBodyQName().getLocalPart().equals(string2)) {
                clazz = SOAPBody.class;
            } else if (sOAPConstants.getFaultQName().getLocalPart().equals(string2)) {
                clazz = SOAPFault.class;
            } else if (sOAPConstants.getFaultDetailQName().getLocalPart().equals(string2)) {
                clazz = Detail.class;
            } else if (sOAPConstants.getFaultCodeQName().getLocalPart().equals(string2) || sOAPConstants.getFaultStringOrReasonQName().getLocalPart().equals(string2) || sOAPConstants.getFaultNodeQName().getLocalPart().equals(string2) || sOAPConstants.getFaultActorOrRoleQName().getLocalPart().equals(string2)) {
                clazz = SOAPFaultElement.class;
            }
        } else if ("http://schemas.xmlsoap.org/soap/envelope/".equals(string)) {
            SOAPConstants sOAPConstants = SOAPConstants.SOAP11_CONSTANTS;
            if (sOAPConstants.getEnvelopeQName().getLocalPart().equals(string2)) {
                clazz = SOAPEnvelope.class;
            } else if (sOAPConstants.getHeaderQName().getLocalPart().equals(string2)) {
                clazz = SOAPHeader.class;
            } else if (sOAPConstants.getBodyQName().getLocalPart().equals(string2)) {
                clazz = SOAPBody.class;
            } else if (sOAPConstants.getFaultQName().getLocalPart().equals(string2)) {
                clazz = SOAPFault.class;
            }
        } else if (string.length() == 0) {
            SOAPConstants sOAPConstants = SOAPConstants.SOAP11_CONSTANTS;
            if (sOAPConstants.getFaultDetailQName().getLocalPart().equals(string2)) {
                clazz = Detail.class;
            } else if (sOAPConstants.getFaultCodeQName().getLocalPart().equals(string2) || sOAPConstants.getFaultStringOrReasonQName().getLocalPart().equals(string2) || sOAPConstants.getFaultActorOrRoleQName().getLocalPart().equals(string2)) {
                clazz = SOAPFaultElement.class;
            }
        }
        return clazz;
    }

    private SOAPEnvelope createDynamicSOAPEnvelope() throws SOAPException {
        SOAPConstants sOAPConstants = this.soapConstants;
        if (this.soapConstants.getSOAPProtocol().equals("Dynamic Protocol")) {
            this.soapConstants = SOAPConstants.SOAP11_CONSTANTS;
        }
        SOAPEnvelope sOAPEnvelope = new SOAPEnvelope(false, this);
        this.soapConstants = sOAPConstants;
        return sOAPEnvelope;
    }

    private static EngineConfiguration getNullEngineConfig() {
        if (nullEngineConfig == null) {
            nullEngineConfig = new NullEngineConfigurationProvider();
        }
        return nullEngineConfig;
    }
}

