/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.websphere.webservices.soap.IBMSOAPElement;
import com.ibm.websphere.webservices.soap.IBMSOAPFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.AttachmentPart;
import com.ibm.ws.webservices.engine.attachments.AttachmentUtils;
import com.ibm.ws.webservices.engine.attachments.Attachments;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializationContextImpl;
import com.ibm.ws.webservices.engine.encoding.SerializationWriter;
import com.ibm.ws.webservices.engine.events.NOOPProcessor;
import com.ibm.ws.webservices.engine.events.P2DConverter;
import com.ibm.ws.webservices.engine.events.PEventProcessor;
import com.ibm.ws.webservices.engine.events.WrapperProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MCUtils;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.NullAttributes;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.WebServicesParser;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.AlternateContentBase;
import com.ibm.ws.webservices.engine.xmlsoap.Comment;
import com.ibm.ws.webservices.engine.xmlsoap.Name;
import com.ibm.ws.webservices.engine.xmlsoap.ProtectionChecker;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPDocument;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.Text;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import com.ibm.ws.webservices.engine.xmlsoap.builders.AsSOAPElementProcessor;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.dom.impl.DOMElementImpl_MS;
import com.ibm.ws.webservices.engine.xmlsoap.saaj12.SAAJ12Document;
import com.ibm.ws.webservices.engine.xmlsoap.saaj12.SAAJ12Text;
import com.ibm.ws.webservices.utils.BufferedWriter;
import com.ibm.ws.webservices.utils.WebServicesInputSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SOAPElement
extends DOMElementImpl_MS
implements Serializable,
IBMSOAPElement {
    private static Log log;
    protected SOAPFactory soapFactory;
    boolean isProtect = false;
    transient AlternateContentBase altContent;
    protected static int CONTEXT_CONTENT;
    protected static int CONTEXT_ATTRS;
    protected static int CONTEXT_TAG;
    protected boolean inAsSOAPElement = false;
    protected boolean rebuildTagQName = false;
    protected boolean rebuildAttributesAndMapping = false;
    public static boolean disableSOAPNamespaceValidation;
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_COLON = "xmlns:";
    private static final String EMPTY_STRING = "";
    private String deferredMimeType = null;
    private Object deferredAttachment = null;

    SOAPElement(String string, String string2, SOAPFactory sOAPFactory) {
        super(sOAPFactory.getOwnerDocument(), string, string2);
        this.soapFactory = sOAPFactory;
    }

    public SOAPElement(Element element, SOAPFactory sOAPFactory) {
        super(sOAPFactory.getOwnerDocument(), element.getNamespaceURI(), element.getLocalName() == null || element.getLocalName().length() == 0 ? element.getNodeName() : element.getLocalName());
        this.setPrefix(element.getPrefix());
        this.soapFactory = sOAPFactory;
        try {
            this.setAlternateContent(element);
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.init", "210", this);
            throw new RuntimeException(sOAPException);
        }
    }

    public final javax.xml.soap.SOAPElement addAttribute(javax.xml.soap.Name name, String string) throws SOAPException {
        QName qName = this.soapFactory.getSOAPConstants().getEncodingStyleQName();
        if (qName.getNamespaceURI().equals(name.getURI()) && qName.getLocalPart().equals(name.getLocalName())) {
            this.setEncodingStyle(string);
        } else {
            this.addAttribute(name.getURI(), name.getPrefix(), name.getLocalName(), string);
        }
        return this;
    }

    public final javax.xml.soap.SOAPElement addChildElement(javax.xml.soap.Name name) throws SOAPException {
        return this.addChildElement(name.getLocalName(), name.getPrefix(), name.getURI());
    }

    public javax.xml.soap.SOAPElement addChildElement(javax.xml.soap.SOAPElement sOAPElement) throws SOAPException {
        this.asSOAPElement(CONTEXT_CONTENT);
        sOAPElement = (javax.xml.soap.SOAPElement)this.insertBefore(sOAPElement, null);
        try {
            sOAPElement.setParentElement(this);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.addChildElement", "313", this);
            this.removeChild(sOAPElement);
            sOAPElement = null;
        }
        return sOAPElement;
    }

    public final javax.xml.soap.SOAPElement addChildElement(String string) throws SOAPException {
        boolean bl = false;
        if (bl) {
            SOAPElement sOAPElement = this.createChildElement(EMPTY_STRING, string, this.soapFactory);
            return this.addChildElement(sOAPElement);
        }
        String string2 = this.getNamespaceURI(EMPTY_STRING);
        string2 = string2 == null ? EMPTY_STRING : string2;
        SOAPElement sOAPElement = this.createChildElement(string2, string, this.soapFactory);
        return this.addChildElement(sOAPElement);
    }

    public final javax.xml.soap.SOAPElement addChildElement(String string, String string2) throws SOAPException {
        String string3 = this.getNamespaceURI(string2);
        if (string3 == null) {
            throw new SOAPException(Messages.getMessage("addChildUnboundPrefix", string2, string));
        }
        return this.addChildElement(string, string2, this.getNamespaceURI(string2));
    }

    public final javax.xml.soap.SOAPElement addChildElement(String string, String string2, String string3) throws SOAPException {
        SOAPElement sOAPElement = this.createChildElement(string3, string, this.soapFactory);
        sOAPElement.setPrefix(string2);
        return this.addChildElement(sOAPElement);
    }

    public final javax.xml.soap.SOAPElement addNamespaceDeclaration(String string, String string2) {
        ProtectionChecker.protectionCheck_changeNamespaces(this);
        Utils.addXMLNSAttribute(this, string, string2);
        return this;
    }

    public javax.xml.soap.SOAPElement addTextNode(String string) throws SOAPException {
        this.asSOAPElement(CONTEXT_CONTENT);
        if (SAAJ12Text.isCommentValue(string)) {
            this.addComment(string);
        } else {
            this.insertBefore(new Text((SOAPDocument)this.ownerDocument, string), null);
        }
        return this;
    }

    public javax.xml.soap.SOAPElement addComment(String string) throws SOAPException {
        this.asSOAPElement(CONTEXT_CONTENT);
        this.insertBefore(new Comment((SOAPDocument)this.ownerDocument, string), null);
        return this;
    }

    public final Iterator getAllAttributes() {
        this.asSOAPElement(CONTEXT_ATTRS);
        ArrayList<javax.xml.soap.Name> arrayList = new ArrayList<javax.xml.soap.Name>();
        NamedNodeMap namedNodeMap = this.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            org.w3c.dom.Node node = namedNodeMap.item(i);
            String string = node.getNamespaceURI();
            String string2 = node.getLocalName();
            String string3 = node.getPrefix();
            try {
                arrayList.add(this.soapFactory.createName(string2, string3, string));
                continue;
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.getAllAttributes", "443", this);
                throw new InternalException(sOAPException);
            }
        }
        return arrayList.iterator();
    }

    public final Iterator getAllAttributesAsQNames() {
        this.asSOAPElement(CONTEXT_ATTRS);
        ArrayList<QName> arrayList = new ArrayList<QName>();
        NamedNodeMap namedNodeMap = this.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            org.w3c.dom.Node node = namedNodeMap.item(i);
            String string = node.getNamespaceURI();
            String string2 = node.getLocalName();
            String string3 = node.getPrefix();
            arrayList.add(QNameTable.createQName(string, string2));
        }
        return arrayList.iterator();
    }

    public final String getAttributeValue(javax.xml.soap.Name name) {
        this.asSOAPElement(CONTEXT_ATTRS);
        String string = null;
        String string2 = this.domifyNamespace(name.getURI());
        String string3 = name.getLocalName();
        string = string2 == null ? this.getAttribute(name.getQualifiedName()) : this.getAttributeNS(string2, string3);
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    public final Iterator getChildElements() {
        this.asSOAPElement(CONTEXT_CONTENT);
        return new CEIterator(this, "javax.xml.soap.SOAPElement.getChildElements");
    }

    public final Iterator getChildElements(javax.xml.soap.Name name) {
        return this.getChildElements(name.getURI(), name.getLocalName());
    }

    public final javax.xml.soap.Name getElementName() {
        try {
            return this.soapFactory.createName(this.getLocalName(), this.getPrefix(), this.getNamespaceURI());
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.getElementName", "534", this);
            throw new InternalException(sOAPException);
        }
    }

    public void setEncodingStyle(String string) throws SOAPException {
        QName qName;
        this.asSOAPElement(CONTEXT_ATTRS);
        if (string == null) {
            string = EMPTY_STRING;
        }
        if (this.hasAttributeNS((qName = this.soapFactory.getSOAPConstants().getEncodingStyleQName()).getNamespaceURI(), qName.getLocalPart())) {
            throw new IllegalArgumentException("illegalArgumentException01");
        }
        Utils.addImplicitNamespaceDeclarations(this);
        MappingScope mappingScope = this._getMappingScope();
        String string2 = mappingScope.getOrCreatePrefix(qName.getNamespaceURI(), null, false);
        String string3 = qName.getLocalPart();
        if (string2 != null && string2.length() > 0) {
            string3 = string2 + ":" + string3;
        }
        this.setAttributeNS(qName.getNamespaceURI(), string3, string);
    }

    public final Iterator getNamespacePrefixes() {
        this.asSOAPElement(CONTEXT_ATTRS);
        ArrayList<String> arrayList = new ArrayList<String>();
        Utils.addImplicitNamespaceDeclarations(this);
        MappingScope mappingScope = this._getMappingScope();
        if (mappingScope != null) {
            for (int i = 0; i < mappingScope.size(); ++i) {
                Mapping mapping = mappingScope.get(i);
                arrayList.add(mapping.getPrefix());
            }
        }
        return arrayList.iterator();
    }

    public final String getNamespaceURI(String string) {
        this.asSOAPElement(CONTEXT_TAG);
        Utils.addImplicitNamespaceDeclarations(this);
        MappingScope mappingScope = this._getMappingScope();
        Mapping mapping = mappingScope.getMappingForPrefix(string, false);
        return mapping != null ? mapping.getNamespaceURI() : null;
    }

    public final Iterator getVisibleNamespacePrefixes() {
        this.asSOAPElement(CONTEXT_ATTRS);
        ArrayList<String> arrayList = new ArrayList<String>();
        Utils.addImplicitNamespaceDeclarations(this);
        MappingScope mappingScope = this._getMappingScope();
        if (mappingScope != null) {
            MappingScope mappingScope2 = mappingScope.flatten();
            for (int i = 0; i < mappingScope2.size(); ++i) {
                Mapping mapping = mappingScope2.get(i);
                arrayList.add(mapping.getPrefix());
            }
        }
        return arrayList.iterator();
    }

    public final boolean removeAttribute(javax.xml.soap.Name name) {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeAttributes(this);
        String string = this.domifyNamespace(name.getURI());
        String string2 = name.getLocalName();
        boolean bl = false;
        if (this.hasAttributeNS(string, string2)) {
            this.removeAttributeNS(string, string2);
            bl = true;
        }
        return bl;
    }

    public final void removeContents() {
        if (this.getAlternateContent() != null) {
            this.altContent.removeChildNodes();
        } else {
            Iterator iterator = this.getChildElements();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
    }

    public final boolean removeNamespaceDeclaration(String string) {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeNamespaces(this);
        return Utils.removeXMLNSAttribute(this, string);
    }

    public final String getEncodingStyle() {
        javax.xml.soap.SOAPElement sOAPElement;
        this.asSOAPElement(CONTEXT_ATTRS);
        QName qName = this.soapFactory.getSOAPConstants().getEncodingStyleQName();
        String string = null;
        if (super.hasAttributeNS(qName.getNamespaceURI(), qName.getLocalPart())) {
            string = super.getAttributeNS(qName.getNamespaceURI(), qName.getLocalPart());
        }
        if (string == null && (sOAPElement = this.getParentElement()) != null) {
            string = sOAPElement.getEncodingStyle();
        }
        return string;
    }

    public final javax.xml.soap.SOAPElement getParentElement() {
        org.w3c.dom.Node node = this.getParentNode();
        return node instanceof Document ? null : (javax.xml.soap.SOAPElement)node;
    }

    public void setParentElement(javax.xml.soap.SOAPElement sOAPElement) throws SOAPException {
        SOAPElement sOAPElement2;
        SOAPElement sOAPElement3 = (SOAPElement)sOAPElement;
        if (sOAPElement3 == null) {
            throw new SOAPException(Messages.getMessage("nullParent00"));
        }
        if (this.getAlternateContent() != null) {
            this.soapFactory = sOAPElement3.getSOAPFactory();
        }
        if (sOAPElement3 != (sOAPElement2 = (SOAPElement)this.getParentElement())) {
            if (sOAPElement2 != null) {
                ProtectionChecker.protectionCheck_removeChildElement(sOAPElement2);
            }
            ProtectionChecker.protectionCheck_addChildElement(sOAPElement3);
            ProtectionChecker.protectionCheck_removeElement(this);
            sOAPElement3.addChildElement(this);
        }
    }

    public final void detachNode() {
        SOAPElement sOAPElement = (SOAPElement)this.getParentElement();
        if (sOAPElement != null) {
            sOAPElement.removeChild(this);
        }
    }

    public void recycleNode() {
        this.detachNode();
        this.soapFactory = null;
        if (this.altContent != null) {
            this.altContent.detach();
        }
        this.enableMappingScopeOptimization(false);
    }

    public final String getValue() {
        org.w3c.dom.Node node;
        this.asSOAPElement(CONTEXT_CONTENT);
        org.w3c.dom.Node node2 = this.getFirstChild();
        if (node2 != null && node2.getNextSibling() == null) {
            if (node2 instanceof CharacterData && !(node2 instanceof org.w3c.dom.Comment)) {
                return ((CharacterData)node2).getData();
            }
            return null;
        }
        org.w3c.dom.Node node3 = null;
        for (node = node2; node != null && node3 == null; node = node.getNextSibling()) {
            if (!(node instanceof CharacterData) || node instanceof org.w3c.dom.Comment) continue;
            node3 = (CharacterData)node;
        }
        if (node3 == null) {
            return null;
        }
        node = node3.getNextSibling();
        if (!(node instanceof CharacterData) || node instanceof org.w3c.dom.Comment) {
            return node3.getData();
        }
        super.normalize();
        for (node = node2 = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof CharacterData) || node instanceof org.w3c.dom.Comment) continue;
            return ((CharacterData)node).getData();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setValue(String string) {
        this.asSOAPElement(CONTEXT_CONTENT);
        Node node = null;
        boolean bl = false;
        int n = 0;
        Iterator iterator = this.getChildElements();
        while (iterator.hasNext()) {
            bl = true;
            Object e = iterator.next();
            if (!(e instanceof javax.xml.soap.Text)) continue;
            node = (javax.xml.soap.Text)e;
            n = (short)(n + 1);
        }
        if (bl) {
            if (n == 1) {
                node.setValue(string);
                return;
            }
            if (!log.isDebugEnabled()) throw new IllegalStateException(Messages.getMessage("badTextNode00"));
            log.debug("can not set value");
            throw new IllegalStateException(Messages.getMessage("badTextNode00"));
        }
        try {
            this.addTextNode(string);
            return;
        }
        catch (SOAPException sOAPException) {
            throw new IllegalStateException(Messages.getMessage("badTextNode00"));
        }
    }

    public final String getAttribute(String string) {
        this.asSOAPElement(CONTEXT_ATTRS);
        return super.getAttribute(string);
    }

    public final Attr getAttributeNode(String string) {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_accessAttributes(this);
        return super.getAttributeNode(string);
    }

    public final Attr getAttributeNodeNS(String string, String string2) {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_accessAttributes(this);
        string = this.domifyNamespace(string);
        return super.getAttributeNodeNS(string, string2);
    }

    public final String getAttributeNS(String string, String string2) {
        this.asSOAPElement(CONTEXT_ATTRS);
        string = this.domifyNamespace(string);
        return super.getAttributeNS(string, string2);
    }

    public final NodeList getElementsByTagName(String string) {
        this.asSOAPElement(CONTEXT_CONTENT);
        return super.getElementsByTagName(string);
    }

    public final NodeList getElementsByTagNameNS(String string, String string2) {
        this.asSOAPElement(CONTEXT_CONTENT);
        string = this.domifyNamespace(string);
        return super.getElementsByTagNameNS(string, string2);
    }

    public final String getTagName() {
        return this.getNodeName();
    }

    public final boolean hasAttribute(String string) {
        this.asSOAPElement(CONTEXT_ATTRS);
        return super.hasAttribute(string);
    }

    public final boolean hasAttributeNS(String string, String string2) {
        this.asSOAPElement(CONTEXT_ATTRS);
        string = this.domifyNamespace(string);
        return super.hasAttributeNS(string, string2);
    }

    public final void removeAttribute(String string) throws DOMException {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeAttributes(this);
        super.removeAttribute(string);
    }

    public final Attr removeAttributeNode(Attr attr) throws DOMException {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeAttributes(this);
        return super.removeAttributeNode(attr);
    }

    public final void removeAttributeNS(String string, String string2) throws DOMException {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeAttributes(this);
        string = this.domifyNamespace(string);
        super.removeAttributeNS(string, string2);
    }

    public final void setAttribute(String string, String string2) throws DOMException {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeAttributes(this);
        super.setAttribute(string, string2);
    }

    public final Attr setAttributeNode(Attr attr) throws DOMException {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeAttributes(this);
        attr = this.importAttr(attr);
        return super.setAttributeNode(attr);
    }

    public final void setAttributeNS(String string, String string2, String string3) throws DOMException {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeAttributes(this);
        string = this.domifyNamespace(string);
        super.setAttributeNS(string, string2, string3);
    }

    public final Attr setAttributeNodeNS(Attr attr) throws DOMException {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeAttributes(this);
        attr = this.importAttr(attr);
        return super.setAttributeNodeNS(attr);
    }

    public final org.w3c.dom.Node appendChild(org.w3c.dom.Node node) throws DOMException {
        return super.appendChild(node);
    }

    public final org.w3c.dom.Node removeChild(org.w3c.dom.Node node) throws DOMException {
        this.asSOAPElement(CONTEXT_CONTENT);
        ProtectionChecker.protectionCheck_removeChildElement(this);
        org.w3c.dom.Node node2 = super.removeChild(node);
        if (node2 instanceof SOAPElement) {
            ((SOAPElement)node2).changedParent();
        }
        return node2;
    }

    public final org.w3c.dom.Node cloneNode(boolean bl) {
        this.asSOAPElement(CONTEXT_CONTENT);
        return super.cloneNode(bl);
    }

    public final NamedNodeMap getAttributes() {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_accessAttributes(this);
        return super.getAttributes();
    }

    public final NodeList getChildNodes() {
        this.asSOAPElement(CONTEXT_CONTENT);
        return super.getChildNodes();
    }

    public final org.w3c.dom.Node getFirstChild() {
        this.asSOAPElement(CONTEXT_CONTENT);
        return super.getFirstChild();
    }

    public final org.w3c.dom.Node getLastChild() {
        this.asSOAPElement(CONTEXT_CONTENT);
        return super.getLastChild();
    }

    public final String getLocalName() {
        this.asSOAPElement(CONTEXT_TAG);
        return super.getLocalName();
    }

    public final String getNamespaceURI() {
        this.asSOAPElement(CONTEXT_TAG);
        String string = this.domifyNamespace(super.getNamespaceURI());
        return string;
    }

    public final org.w3c.dom.Node getNextSibling() {
        return super.getNextSibling();
    }

    public final String getNodeName() {
        this.asSOAPElement(CONTEXT_TAG);
        return super.getNodeName();
    }

    public final short getNodeType() {
        return super.getNodeType();
    }

    public final String getNodeValue() {
        return super.getNodeValue();
    }

    public final Document getOwnerDocument() {
        return super.getOwnerDocument();
    }

    public final org.w3c.dom.Node getParentNode() {
        return super.getParentNode();
    }

    public final String getPrefix() {
        this.asSOAPElement(CONTEXT_TAG);
        if (this.getNamespaceURI() == null) {
            return null;
        }
        return super.getPrefix();
    }

    public final org.w3c.dom.Node getPreviousSibling() {
        return super.getPreviousSibling();
    }

    public final boolean hasAttributes() {
        this.asSOAPElement(CONTEXT_ATTRS);
        return super.hasAttributes();
    }

    public final boolean hasChildNodes() {
        this.asSOAPElement(CONTEXT_CONTENT);
        return super.hasChildNodes();
    }

    public final org.w3c.dom.Node insertBefore(org.w3c.dom.Node node, org.w3c.dom.Node node2) throws DOMException {
        org.w3c.dom.Node node3;
        this.asSOAPElement(CONTEXT_CONTENT);
        MappingScope mappingScope = null;
        if (node instanceof SOAPElement && (node3 = (SOAPElement)((SOAPElement)node).getParentElement()) != null) {
            mappingScope = ((SOAPElement)node3)._getMappingScope();
            mappingScope.flatten();
        }
        node3 = null;
        node3 = this.isValidSAAJChild(node) ? node : this.wrapChildDOMNode(node);
        node3 = super.insertBefore(node3, node2);
        if (node instanceof SOAPElement && ((SOAPElement)node).getAlternateContent() == null) {
            ((DOMElementImpl_MS)node3).changedParent();
            Utils.addImplicitNamespaceDeclarations((SOAPElement)node3);
            if (mappingScope != null) {
                MappingScope mappingScope2 = this._getMappingScope();
                for (int i = 0; i < mappingScope.size(); ++i) {
                    Mapping mapping = mappingScope.get(i);
                    Mapping mapping2 = mappingScope2.getMappingForPrefix(mapping.getPrefix(), false);
                    if (mapping2 != null && mapping2.getNamespaceURI().equals(mapping.getNamespaceURI())) continue;
                    Utils.addXMLNSAttribute((SOAPElement)node3, mapping.getPrefix(), mapping.getNamespaceURI());
                }
            }
        }
        return node3;
    }

    public final boolean isSupported(String string, String string2) {
        return super.isSupported(string, string2);
    }

    public final void normalize() {
        this.asSOAPElement(CONTEXT_CONTENT);
        super.normalize();
    }

    public final void setNodeValue(String string) {
        super.setNodeValue(string);
    }

    public final void setPrefix(String string) throws DOMException {
        this.asSOAPElement(CONTEXT_TAG);
        super.setPrefix(string);
    }

    public final Attributes getSAXAttributes() {
        AttributesImpl attributesImpl = null;
        NamedNodeMap namedNodeMap = this.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            if (attributesImpl == null) {
                attributesImpl = new AttributesImpl();
            }
            org.w3c.dom.Node node = namedNodeMap.item(i);
            String string = this.domifyNamespace(node.getNamespaceURI());
            String string2 = node.getLocalName();
            String string3 = node.getNodeValue();
            String string4 = ((Attr)node).getName();
            if (XMLNS.equals(string4) || string4.startsWith(XMLNS_COLON)) continue;
            attributesImpl.addAttribute(string, string2, string4, "CDATA", string3);
        }
        if (attributesImpl != null) {
            return attributesImpl;
        }
        return NullAttributes.singleton;
    }

    public final void setAttributes(Attributes attributes) {
        ProtectionChecker.protectionCheck_changeAttributes(this);
        NamedNodeMap namedNodeMap = this.getAttributes();
        Document document = this.getOwnerDocument();
        if (attributes != null && attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attr = document.createAttributeNS(attributes.getURI(i), attributes.getQName(i));
                attr.setValue(attributes.getValue(i));
                namedNodeMap.setNamedItem(attr);
            }
        }
    }

    public final void setAttribute(String string, String string2, String string3) {
        this.addAttribute(string, string2, string3);
    }

    public final String getAttributeValue(String string, String string2) {
        this.asSOAPElement(CONTEXT_ATTRS);
        return this.getAttributeNS(string, string2);
    }

    public final void setMappingScope(MappingScope mappingScope) {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeNamespaces(this);
        if (mappingScope != null) {
            for (int i = 0; i < mappingScope.size(); ++i) {
                Mapping mapping = mappingScope.get(i);
                Utils.addXMLNSAttribute(this, mapping.getPrefix(), mapping.getNamespaceURI());
            }
        }
    }

    public final String getLocalPart() {
        return this.getLocalName();
    }

    public final int getNumChildren() {
        this.asSOAPElement(CONTEXT_CONTENT);
        org.w3c.dom.Node node = this.getFirstChild();
        int n = 0;
        for (org.w3c.dom.Node node2 = node; node2 != null; node2 = node2.getNextSibling()) {
            if (node2 instanceof CharacterData) continue;
            ++n;
        }
        return n;
    }

    public final SOAPElement getChildElement(int n) {
        this.asSOAPElement(CONTEXT_CONTENT);
        org.w3c.dom.Node node = this.getFirstChild();
        int n2 = -1;
        for (org.w3c.dom.Node node2 = node; node2 != null; node2 = node2.getNextSibling()) {
            if (!(node2 instanceof CharacterData)) {
                ++n2;
            }
            if (n2 != n) continue;
            return (SOAPElement)node2;
        }
        return null;
    }

    public final SOAPElement getChildElement(String string, String string2) throws SOAPException {
        Iterator iterator = this.getChildElements(string, string2);
        if (iterator == null || !iterator.hasNext()) {
            return null;
        }
        SOAPElement sOAPElement = (SOAPElement)iterator.next();
        if (iterator.hasNext()) {
            throw new SOAPException(Messages.getMessage("getChildElementErr00", string, string2));
        }
        return sOAPElement;
    }

    public final void output(SerializationContext serializationContext) throws Exception {
        this.outputImpl(serializationContext, true);
    }

    protected void outputImpl(SerializationContext serializationContext, boolean bl) throws Exception {
        Object object;
        this.soapFactory.setMessageContext(serializationContext.getMessageContext());
        if (this.deferredAttachment != null) {
            this.addSwaRefTextNode(this.deferredMimeType, this.deferredAttachment, serializationContext.getCurrentMessage());
            this.deferredAttachment = null;
        }
        if (this.getAlternateContent() != null) {
            this.altContent.serialize(serializationContext, bl);
            return;
        }
        MappingScope mappingScope = null;
        if (this.getParentElement() == null && !(this.getFirstChild() instanceof SOAPElement)) {
            Utils.addImplicitNamespaceDeclarations(this);
        }
        if (bl) {
            mappingScope = this._getMappingScope();
            object = this.getMappingScopeForAncestorsNotWritten(serializationContext);
            mappingScope.setParent((MappingScope)object);
            mappingScope = mappingScope.flatten();
        } else {
            mappingScope = this._getMappingScope();
        }
        object = this.getValue();
        org.w3c.dom.Node node = this.getFirstChild();
        if (object != null && this.altContent == null && node != null && node.getNextSibling() == null) {
            serializationContext.getSerializationWriter().simpleElement(this.getQName(), this.getPrefix(), this.getSAXAttributes(), mappingScope, (String)object);
        } else {
            serializationContext.getSerializationWriter().startElement(this.getQName(), this.getPrefix(), this.getSAXAttributes(), mappingScope);
            this.outputContentsImpl(serializationContext);
            if (this instanceof SOAPBody) {
                serializationContext.outputMultiRefs();
            }
            serializationContext.getSerializationWriter().endElement();
        }
    }

    protected void outputContentsImpl(SerializationContext serializationContext) throws Exception {
        for (org.w3c.dom.Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof SOAPElement) {
                ((SOAPElement)node).outputImpl(serializationContext, false);
                continue;
            }
            short s = node.getNodeType();
            String string = node.getNodeValue();
            if (s == 8) {
                serializationContext.getSerializationWriter().writeComment(string);
                continue;
            }
            if (string == null) continue;
            serializationContext.getSerializationWriter().writeSafeString(string);
        }
    }

    MappingScope getMappingScopeForAncestorsNotWritten(SerializationContext serializationContext) {
        MappingScope mappingScope = new MappingScope();
        SOAPElement sOAPElement = (SOAPElement)this.getParentElement();
        SerializationWriter serializationWriter = serializationContext.getSerializationWriter();
        if (sOAPElement != null && serializationWriter != null) {
            mappingScope = sOAPElement._getMappingScope();
            mappingScope = mappingScope.flatten();
            int n = 0;
            while (n < mappingScope.size()) {
                String string = mappingScope.get(n).getPrefix();
                String string2 = serializationWriter.getNamespaceURI(string);
                if (mappingScope.get(n).getNamespaceURI().equals(string2)) {
                    mappingScope.removeMappingForPrefix(string);
                    continue;
                }
                ++n;
            }
        }
        return mappingScope;
    }

    private final String getAsString(boolean bl) throws Exception {
        Object object;
        Object object2;
        Object object3;
        if (this.altContent != null && !bl && (object3 = this.altContent.getXMLString()) != null) {
            return object3;
        }
        object3 = null;
        StringWriter stringWriter = null;
        int n = 1024;
        if (this.altContent != null && (object2 = this.altContent.getContent()) instanceof WebServicesInputSource && (object = ((WebServicesInputSource)this.altContent.getContent()).getBytes()) != null) {
            n += ((byte[])object).length;
        }
        stringWriter = new StringWriter(n);
        object2 = this.soapFactory.getMessageContext();
        object3 = new SerializationContextImpl(stringWriter, (MessageContext)object2, false);
        if (bl) {
            this.output((SerializationContext)object3);
        } else {
            this.outputImpl((SerializationContext)object3, false);
        }
        stringWriter.close();
        object = stringWriter.getBuffer().toString();
        return object;
    }

    public final String toString() {
        return this.toXMLString(true);
    }

    public final void toEvents(PEventProcessor pEventProcessor) throws SAXException {
        this.asSOAPElement(CONTEXT_ATTRS);
        if (this.getAlternateContent() != null && this.altContent.hasToEvents()) {
            this.altContent.toEvents(pEventProcessor);
            return;
        }
        Utils.addImplicitNamespaceDeclarations(this);
        String string = this.getLocalPart();
        String string2 = this.getPrefix();
        if (string2 != null && string2.length() != 0) {
            string = string2 + ":" + string;
        }
        pEventProcessor.startElement(this.getNamespaceURI(), this.getLocalPart(), string, this.getSAXAttributes(), this._getMappingScope(), this);
        this.toContainedEvents(pEventProcessor);
        pEventProcessor.endElement(this.getNamespaceURI(), this.getLocalPart(), string);
    }

    protected final void toContainedEvents(PEventProcessor pEventProcessor) throws SAXException {
        for (org.w3c.dom.Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof SOAPElement) {
                ((SOAPElement)node).toEvents(pEventProcessor);
                continue;
            }
            short s = node.getNodeType();
            String string = node.getNodeValue();
            if (s == 8) {
                pEventProcessor.comment(string.toCharArray(), 0, string.length());
                continue;
            }
            pEventProcessor.characters(string);
        }
    }

    public final Element getAsDOM() throws Exception {
        return this.getAsDOM(true);
    }

    public final Element getAsDOM(boolean bl) throws Exception {
        return this.getAsDocument(bl).getDocumentElement();
    }

    public final Document getAsDocument() throws Exception {
        return this.getAsDocument(true);
    }

    public final Document getAsDocument(boolean bl) throws Exception {
        String string = this.getAsString(bl);
        StringReader stringReader = new StringReader(string);
        Document document = XMLUtils.newDocument(new InputSource(stringReader));
        if (document == null) {
            throw new Exception(Messages.getMessage("noDoc00", string));
        }
        return document;
    }

    public void setAlternateContent(Object object) throws SOAPException {
        ProtectionChecker.protectionCheck_setAlternateContent(this);
        if (object == null) {
            if (this.altContent != null) {
                this.altContent.detach();
            }
            this.enableMappingScopeOptimization(false);
            return;
        }
        AlternateContentBase alternateContentBase = AlternateContentBase.create(object);
        if (alternateContentBase.affectsTagAttributes() || alternateContentBase.affectsTagQName()) {
            this.enableMappingScopeOptimization(false);
        }
        alternateContentBase.attach(this);
        Element element = this._getDOMElement();
        if (element != null && element.getOwnerDocument() != this.getOwnerDocument()) {
            if (log.isDebugEnabled()) {
                log.debug("setAlternateContent: immediate transformation because documents are different");
            }
            this.asSOAPElement(CONTEXT_TAG);
        }
    }

    public final void expand() {
        this.asSOAPElement(CONTEXT_TAG);
    }

    protected final void asSOAPElement(int n) {
        if (this.getAlternateContent() == null || n == CONTEXT_TAG && !this.altContent.affectsTagQName() || n == CONTEXT_ATTRS && !this.altContent.affectsTagAttributes()) {
            return;
        }
        if (this.inAsSOAPElement) {
            throw new InternalException(Messages.getMessage("exception01", "Error in SOAPElement.asSOAPElement"));
        }
        this._asSOAPElement(n);
    }

    protected final void _asSOAPElement(int n) {
        this.inAsSOAPElement = true;
        this.rebuildTagQName = this.altContent.affectsTagQName();
        AlternateContentBase alternateContentBase = this.altContent;
        this.rebuildAttributesAndMapping = alternateContentBase.affectsTagAttributes();
        boolean bl = alternateContentBase.hasToEvents();
        if (log.isDebugEnabled()) {
            log.debug("transforming to SOAPElement with alternate content " + alternateContentBase.getClass());
        }
        DeserializationContext deserializationContext = this.soapFactory.getDeserializationContext();
        deserializationContext.createEventConverter(new WrapperProcessor(new NOOPProcessor()));
        P2DConverter p2DConverter = deserializationContext.getEventConverter();
        WebServicesParser webServicesParser = null;
        try {
            Serializable serializable;
            boolean bl2;
            Cloneable cloneable;
            String string = null;
            MappingScope mappingScope = null;
            InputSource inputSource = null;
            if (!bl) {
                string = "<XXX>" + this.getAsString(true) + "</XXX>";
                mappingScope = this._getStrippedMappingScope();
                inputSource = new InputSource(new StringReader(string));
                webServicesParser = (WebServicesParser)XMLUtils.getSAXParser();
            }
            SOAPBuilder sOAPBuilder = this.createBuilder();
            sOAPBuilder.setMyElement(this);
            if (string != null) {
                for (cloneable = (SOAPElement)this.getParentElement(); cloneable != null && !(cloneable instanceof SOAPBody); cloneable = (SOAPElement)((SOAPElement)cloneable).getParentElement()) {
                }
                SOAPBody sOAPBody = cloneable == null ? null : (SOAPBody)cloneable;
                p2DConverter.pushDEventProcessor(new WrapperProcessor(new AsSOAPElementProcessor(sOAPBuilder, sOAPBody)));
            } else {
                p2DConverter.pushDEventProcessor(new WrapperProcessor(sOAPBuilder));
            }
            cloneable = this.soapFactory.getMessageContext();
            boolean bl3 = bl2 = cloneable != null && ((MessageContext)cloneable).getProperty(MessageContext.SAAJ_TRANSFORMATION) == null && (((MessageContext)cloneable).isPropertyTrue(MessageContext.FAULT_ON_SAAJ_TRANSFORMATION) || log.isDebugEnabled() || !((MessageContext)cloneable).isHighFidelity() && (((MessageContext)cloneable).isRequestPath() && ((MessageContext)cloneable).isServer() || !((MessageContext)cloneable).isRequestPath() && !((MessageContext)cloneable).isServer()));
            if (bl2) {
                serializable = new RuntimeException(Messages.getMessage("saajtransform00", string));
                if (((MessageContext)cloneable).isPropertyTrue(MessageContext.FAULT_ON_SAAJ_TRANSFORMATION)) {
                    throw serializable;
                }
                if (((MessageContext)cloneable).getProperty(MessageContext.SAAJ_TRANSFORMATION) == null) {
                    ((MessageContext)cloneable).setProperty(MessageContext.SAAJ_TRANSFORMATION, serializable);
                }
                if (log.isDebugEnabled()) {
                    log.debug(serializable);
                }
            }
            serializable = (SOAPDocument)this.getOwnerDocument();
            boolean bl4 = ((CoreDocumentImpl)serializable).getErrorChecking();
            ((CoreDocumentImpl)serializable).setErrorChecking(false);
            p2DConverter.startDocument();
            if (!bl) {
                alternateContentBase.detach();
                webServicesParser.parse(inputSource, (DefaultHandler)p2DConverter);
            } else {
                this.altContent = null;
                alternateContentBase.toEvents(p2DConverter);
            }
            p2DConverter.endDocument();
            ((CoreDocumentImpl)serializable).setErrorChecking(bl4);
            p2DConverter.popDEventProcessor();
            if (!bl && mappingScope != null) {
                for (int i = 0; i < mappingScope.size(); ++i) {
                    Mapping mapping = mappingScope.get(i);
                    String string2 = mapping.getPrefix();
                    if (string2 == null || string2.length() == 0) {
                        string2 = XMLNS;
                    }
                    String string3 = this.getAttributeNS("http://www.w3.org/2000/xmlns/", string2);
                    if (!mapping.getNamespaceURI().equals(string3)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("removing namespace declaration for " + string2 + " with namespace " + string3);
                    }
                    this.removeAttributeNS("http://www.w3.org/2000/xmlns/", string2);
                }
            }
            this.setProtect(this.isProtect);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.asSOAPElement", "1675", this);
            throw new InternalException(exception);
        }
        finally {
            this.inAsSOAPElement = false;
            this.rebuildTagQName = false;
            this.rebuildAttributesAndMapping = false;
            deserializationContext.freeEventConverter();
            if (webServicesParser != null) {
                try {
                    webServicesParser.setProperty("http://xml.org/sax/properties/lexical-handler", null);
                }
                catch (Throwable throwable) {}
                webServicesParser.recycle();
                webServicesParser = null;
            }
        }
        this.enableMappingScopeOptimization(true);
    }

    private MappingScope _getStrippedMappingScope() {
        MappingScope mappingScope = null;
        if (this.getParentElement() != null) {
            mappingScope = ((SOAPElement)this.getParentElement())._getMappingScope();
            mappingScope = mappingScope.flatten();
        }
        return mappingScope;
    }

    public final boolean isInAsSOAPElement() {
        return this.inAsSOAPElement;
    }

    public final boolean rebuildTagQName() {
        return this.rebuildTagQName && this.inAsSOAPElement;
    }

    public final boolean rebuildAttributesAndMapping() {
        return this.rebuildAttributesAndMapping && this.inAsSOAPElement;
    }

    public final Object asObject() throws Exception {
        QName qName = this.getType();
        if (qName == null) {
            qName = QNameTable.createQName(this.namespaceURI, ">" + this.getLocalName());
        }
        try {
            return this.asObject(qName);
        }
        catch (Exception exception) {
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("exception01", JavaUtils.stackToString(exception)));
            }
            return this;
        }
    }

    private void removeChildren() {
        while (this.getFirstChild() != null) {
            this.removeChild((Node)this.getFirstChild());
        }
    }

    public final Object asObject(QName qName) throws Exception {
        if (this.isObjectContent()) {
            return this.getAlternateContent();
        }
        Object object = this.convertToObject(qName);
        this.removeChildren();
        if (this.altContent != null) {
            this.altContent.detach();
        }
        this.setAlternateContent(object);
        return object;
    }

    protected final QName getType() {
        SOAPElement sOAPElement;
        String string;
        this.asSOAPElement(CONTEXT_ATTRS);
        Utils.addImplicitNamespaceDeclarations(this);
        Attributes attributes = this.getSAXAttributes();
        QName qName = AttributeUtils.getTypeFromAttributes(this.getNamespaceURI(), this.getLocalName(), attributes, this._getMappingScope());
        if (attributes.getValue(Constants.URI_DEFAULT_SOAP_ENC, "arrayType") != null) {
            qName = Constants.SOAP_ARRAY;
        }
        if (qName == null && this.soapFactory.getDeserializationContext() != null && (string = AttributeUtils.getHref(attributes)) != null && (sOAPElement = this.soapFactory.getDeserializationContext().getHrefTable().getElementByHref(string)) != null) {
            qName = sOAPElement.getType();
        }
        return qName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object convertToObject(QName qName) throws Exception {
        if (this.soapFactory.getDeserializationContext() == null) {
            throw new Exception(Messages.getMessage("noContext00"));
        }
        Deserializer deserializer = this.soapFactory.getDeserializationContext().getDeserializer(null, qName);
        if (deserializer == null) {
            throw new Exception(Messages.getMessage("noDeser00", EMPTY_STRING + qName));
        }
        DeserializationContext deserializationContext = this.soapFactory.getDeserializationContext();
        deserializationContext.createEventConverter(new WrapperProcessor(deserializer));
        P2DConverter p2DConverter = deserializationContext.getEventConverter();
        try {
            this.toEvents(p2DConverter);
        }
        finally {
            deserializationContext.freeEventConverter();
        }
        return deserializer.getValue();
    }

    protected boolean isObjectContent() throws Exception {
        return this.altContent != null && this.altContent.isBusinessObject();
    }

    protected SOAPBuilder createBuilder() {
        return new SOAPBuilder();
    }

    protected SOAPElement createChildElement(String string, String string2, SOAPFactory sOAPFactory) throws SOAPException {
        string = this.domifyNamespace(string);
        return new SOAPElement(string, string2, sOAPFactory);
    }

    protected boolean isValidSAAJChild(org.w3c.dom.Node node) {
        Class<?> clazz = node.getClass();
        return (clazz.equals(SOAPElement.class) || clazz.equals(Text.class) || clazz.equals(Comment.class) || clazz.equals(SAAJ12Text.class)) && this.getOwnerDocument() == node.getOwnerDocument();
    }

    public final void setProtect(boolean bl) {
        this.isProtect = bl;
        if (this.getAlternateContent() == null) {
            for (org.w3c.dom.Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof SOAPElement)) continue;
                SOAPElement sOAPElement = (SOAPElement)node;
                if (sOAPElement.isProtect == bl) continue;
                sOAPElement.setProtect(bl);
            }
        }
    }

    private final Node wrapChildDOMNode(org.w3c.dom.Node node) {
        if (node instanceof CharacterData) {
            String string = ((CharacterData)node).getNodeValue();
            if (SAAJ12Text.isCommentValue(string)) {
                return new Comment((SOAPDocument)this.ownerDocument, string);
            }
            return new Text((SOAPDocument)this.ownerDocument, string);
        }
        try {
            SOAPElement sOAPElement = this.createChildElement(node.getNamespaceURI(), node.getLocalName() == null || node.getLocalName().length() == 0 ? node.getNodeName() : node.getLocalName(), this.soapFactory);
            sOAPElement.setPrefix(node.getPrefix());
            sOAPElement.setAlternateContent(node);
            return sOAPElement;
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.wrapChildDOMNode", "2799", this);
            throw new RuntimeException(sOAPException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
    }

    public Object getAlternateContent() {
        return this.altContent == null ? null : this.altContent.getContent();
    }

    public final SOAPFactory getSOAPFactory() {
        return this.soapFactory;
    }

    public final IBMSOAPFactory getIBMSOAPFactory() {
        return this.getSOAPFactory();
    }

    public final void setQName(String string, String string2) {
        String string3 = SOAPElement.extractLocalNameFromQName(string2);
        this.namespaceURI = string;
        this.localName = string3;
        this.setPrefix(SOAPElement.extractPrefixFromQName(string2));
    }

    public final QName getQName() {
        return QNameTable.createQName(this.getNamespaceURI(), this.getLocalName());
    }

    public final void addAttribute(String string, String string2, String string3) {
        this.addAttribute(string, null, string2, string3);
    }

    public final void addAttribute(String string, String string2, String string3, String string4) {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeAttributes(this);
        if (string == null) {
            this.setAttribute(string3, string4);
        } else {
            if (string2 == null || string2.length() == 0) {
                if (string.equals("http://www.w3.org/2000/xmlns/")) {
                    string2 = XMLNS;
                    if (string3.equals(XMLNS)) {
                        string2 = EMPTY_STRING;
                    }
                } else if (string2 == null) {
                    Utils.addImplicitNamespaceDeclarations(this);
                    string2 = this._getMappingScope().getOrCreatePrefix(string, null, true);
                }
            }
            String string5 = string2.length() > 0 ? string2 + ":" + string3 : string3;
            this.setAttributeNS(string, string5, string4);
        }
    }

    public final Iterator getChildElements(String string, String string2) {
        this.asSOAPElement(CONTEXT_CONTENT);
        if (string == null) {
            string = EMPTY_STRING;
        }
        ArrayList<javax.xml.soap.SOAPElement> arrayList = new ArrayList<javax.xml.soap.SOAPElement>();
        for (org.w3c.dom.Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof javax.xml.soap.SOAPElement)) continue;
            javax.xml.soap.SOAPElement sOAPElement = (javax.xml.soap.SOAPElement)node;
            String string3 = sOAPElement.getNamespaceURI();
            String string4 = sOAPElement.getLocalName();
            if (string3 == null) {
                string3 = EMPTY_STRING;
            }
            if (string4 == null) {
                string4 = SOAPElement.extractLocalNameFromQName(sOAPElement.getNodeName());
            }
            if (!string.equals(string3) || !string2.equals(string4)) continue;
            arrayList.add(sOAPElement);
        }
        return arrayList.iterator();
    }

    private final String domifyNamespace(String string) {
        return string == null || string.length() == 0 ? null : string;
    }

    private final Element _getDOMElement() {
        return this.altContent == null ? null : this.altContent.getDOMElement();
    }

    protected final SAAJ12Document getSAAJ12Document() {
        return (SAAJ12Document)this.ownerDocument;
    }

    protected final SOAPDocument getSOAPDocument() {
        return (SOAPDocument)this.ownerDocument;
    }

    final Attr importAttr(Attr attr) {
        Document document;
        Document document2 = this.getOwnerDocument();
        if (!document2.equals(document = attr.getOwnerDocument())) {
            attr = (Attr)document2.importNode(attr, true);
        }
        return attr;
    }

    protected static String extractPrefixFromQName(String string) {
        int n = string.indexOf(58);
        if (n > 0) {
            return string.substring(0, n);
        }
        return null;
    }

    protected static String extractLocalNameFromQName(String string) {
        int n = string.indexOf(58);
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    protected final MappingScope _getMappingScope() {
        this.asSOAPElement(CONTEXT_TAG);
        return super._getMappingScope();
    }

    public final String toXMLString() {
        return this.toXMLString(true);
    }

    public final String toXMLString(boolean bl) {
        try {
            return this.getAsString(bl);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.toXMLString", "3265", this);
            if (log.isDebugEnabled()) {
                log.error(Messages.getMessage("exception00"), exception);
            }
            throw new InternalException(exception);
        }
    }

    public InputSource toInputSource(boolean bl) throws SAXException {
        try {
            Object object;
            if (this.altContent != null && !bl && (object = this.altContent.getXMLInputSource()) != null) {
                return object;
            }
            object = this.soapFactory.getMessageContext();
            Message message = object != null ? ((MessageContext)object).getCurrentMessage() : null;
            String string = message != null ? message.getCharacterEncoding() : null;
            byte[] byArray = this.getContentAsBytes((MessageContext)object, string, bl);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            InputSource inputSource = new InputSource(byteArrayInputStream);
            if (string != null) {
                inputSource.setEncoding(string);
            }
            return inputSource;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.toInputSource", "2999", this);
            throw new SAXException(exception);
        }
    }

    private byte[] getContentAsBytes(MessageContext messageContext, String string, boolean bl) throws Exception {
        Object object;
        Object object2;
        int n = 1024;
        if (this.altContent != null && (object2 = this.altContent.getContent()) instanceof WebServicesInputSource && (object = ((WebServicesInputSource)object2).getBytes()) != null) {
            n += ((byte[])object).length;
        }
        object2 = new ByteArrayOutputStream(n);
        object = string == null ? (Object)new OutputStreamWriter((OutputStream)object2) : (Object)new OutputStreamWriter((OutputStream)object2, string);
        object = new BufferedWriter((Writer)object, (OutputStream)object2, "utf-8");
        SerializationContextImpl serializationContextImpl = new SerializationContextImpl((Writer)object, messageContext, false);
        if (bl) {
            this.output(serializationContextImpl);
        } else {
            this.outputImpl(serializationContextImpl, false);
        }
        ((Writer)object).close();
        return ((ByteArrayOutputStream)object2).toByteArray();
    }

    public boolean hasAlternateContent() {
        return this.getAlternateContent() != null;
    }

    public List getNamespaceDeclarations(boolean bl, boolean bl2, boolean bl3) {
        return Utils.getNamespaceDeclarations(this, bl, bl2, bl3);
    }

    public List getAttributes(boolean bl, boolean bl2, boolean bl3) {
        return Utils.getAttributes(this, bl, bl2, bl3);
    }

    public javax.xml.soap.Name getNameFromText(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.indexOf(58);
        String string2 = n == -1 ? EMPTY_STRING : string.substring(0, n);
        String string3 = n == -1 ? string : string.substring(n + 1);
        String string4 = this.getNamespaceURI(string2);
        if (string4 == null) {
            if (string2.length() > 0) {
                return null;
            }
            string4 = EMPTY_STRING;
        }
        return new Name(string4, string3, string2);
    }

    public String getTextFromName(javax.xml.soap.Name name, boolean bl) {
        if (name == null) {
            return null;
        }
        String string = name.getPrefix() == null ? EMPTY_STRING : name.getPrefix();
        String string2 = name.getURI() == null ? EMPTY_STRING : name.getURI();
        String string3 = name.getLocalName();
        if (bl) {
            string = string2.length() == 0 ? EMPTY_STRING : "ns" + string2.hashCode();
        }
        if (string2.length() == 0 && string.length() > 0) {
            return null;
        }
        String string4 = this.getNamespaceURI(string);
        if (!(string4 != null && string4.equals(string2) || string.length() == 0 && string4 == null && string2.length() == 0)) {
            this.addNamespaceDeclaration(string, string2);
        }
        if (string.length() == 0) {
            return string3;
        }
        return string + ":" + string3;
    }

    public javax.xml.soap.SOAPElement addSwaRefTextNode(String string, Object object) throws SOAPException {
        boolean bl;
        SOAPMessage sOAPMessage;
        if (log.isDebugEnabled()) {
            log.debug("Enter: addSwaRefTextNode(mimeType, attachment)");
        }
        MessageContext messageContext = this.soapFactory.getMessageContext();
        MessageContext messageContext2 = MessageContext.getCurrentThreadsContext();
        SOAPMessage sOAPMessage2 = sOAPMessage = messageContext != null ? messageContext.getMessage() : null;
        if (log.isDebugEnabled()) {
            if (messageContext != messageContext2) {
                log.debug("WARNING: This SOAPElement was created with a static SOAPFactory");
            }
            log.debug("msgContext.getMessage() is " + (sOAPMessage == null ? "null" : "not null"));
            log.debug("isServer=" + messageContext2.isServer());
            log.debug("isInvokingTarget=" + messageContext2.isInvokingTarget());
        }
        boolean bl2 = bl = sOAPMessage == null || messageContext != messageContext2 || messageContext.isServer() && messageContext.isInvokingTarget();
        if (bl) {
            if (log.isDebugEnabled()) {
                log.debug("Adding a deferred attachment for " + string);
            }
            this.deferredMimeType = string;
            this.deferredAttachment = object;
            if (log.isDebugEnabled()) {
                log.debug("Exit: addSwaRefTextNode(mimeType, attachment)");
            }
            return this;
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding an attachment on the message context for " + string);
        }
        javax.xml.soap.SOAPElement sOAPElement = this.addSwaRefTextNode(string, object, sOAPMessage);
        if (log.isDebugEnabled()) {
            log.debug("Exit: addSwaRefTextNode(mimeType, attachment)");
        }
        return sOAPElement;
    }

    private javax.xml.soap.SOAPElement addSwaRefTextNode(String string, Object object, SOAPMessage sOAPMessage) throws SOAPException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: addSwaRefTextNode(mimeType, attachment, msg)");
            log.debug("mimeType=" + string);
        }
        DataHandler dataHandler = AttachmentUtils.dataHandlerForObject(string, object);
        Attachments attachments = ((Message)sOAPMessage).getAttachmentsImpl();
        try {
            Part part = attachments.createAttachmentPart(dataHandler);
            javax.xml.soap.SOAPElement sOAPElement = this.addTextNode(part.getContentIdRef());
            if (log.isDebugEnabled()) {
                log.debug("Exit: addSwaRefTextNode(mimeType, attachment, msg)");
            }
            return sOAPElement;
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.addSwaRefTextNode", "2994", this);
            throw new SOAPException(webServicesFault.getMessage());
        }
    }

    public boolean isSwaRef() {
        try {
            this.getSwaRefAttachment();
            return true;
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.isSwaRef", "3026", this);
            return false;
        }
    }

    public Object getSwaRefAttachment() throws SOAPException {
        if (this.deferredAttachment != null) {
            return this.deferredAttachment;
        }
        MessageContext messageContext = this.soapFactory.getMessageContext();
        if (messageContext != null) {
            SOAPMessage sOAPMessage = messageContext.getMessage();
            return this.getSwaRefAttachment(sOAPMessage);
        }
        throw new SOAPException(Messages.getMessage("notSwaRef00"));
    }

    public Object getSwaRefAttachment(SOAPMessage sOAPMessage) throws SOAPException {
        String string;
        if (this.deferredAttachment != null) {
            return this.deferredAttachment;
        }
        if (sOAPMessage != null && (string = this.getValue()) != null) {
            Iterator iterator = sOAPMessage.getAttachments();
            while (iterator.hasNext()) {
                AttachmentPart attachmentPart = (AttachmentPart)iterator.next();
                if (!string.equals(attachmentPart.getContentIdRef())) continue;
                return AttachmentUtils.objectForDataHandler(attachmentPart.getDataHandler());
            }
        }
        throw new SOAPException(Messages.getMessage("notSwaRef00"));
    }

    protected boolean isSOAP12() {
        return this.getSOAPFactory().getSOAPConstants().getSOAPProtocol().equals("SOAP 1.2 Protocol");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.asSOAPElement(CONTEXT_TAG);
        this.enableMappingScopeOptimization(false);
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public javax.xml.soap.SOAPElement addChildElement(QName qName) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addChildElement(QName)", "javax.xml.soap.SOAPElement"));
        }
        return this.addChildElement(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
    }

    public javax.xml.soap.SOAPElement addAttribute(QName qName, String string) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addAttribute(QName, value)", "javax.xml.soap.SOAPElement"));
        }
        QName qName2 = this.soapFactory.getSOAPConstants().getEncodingStyleQName();
        if (qName2.equals(qName)) {
            this.setEncodingStyle(string);
        } else {
            this.addAttribute(qName.getNamespaceURI(), qName.getPrefix(), qName.getLocalPart(), string);
        }
        return this;
    }

    public String getAttributeValue(QName qName) {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "getAttributeValue(QName)", "javax.xml.soap.SOAPElement"));
        }
        String string = null;
        String string2 = this.domifyNamespace(qName.getNamespaceURI());
        String string3 = qName.getLocalPart();
        string = string2 == null ? this.getAttribute(string3) : this.getAttributeNS(string2, string3);
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    public QName createQName(String string, String string2) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "creaeQName(String localName, String prefix)", "javax.xml.soap.SOAPElement"));
        }
        String string3 = this.getNamespaceURI(string2);
        if (string3 == null) {
            throw new SOAPException(Messages.getMessage("exception01", "Null namespaceURI"));
        }
        return new QName(string3, string, string2);
    }

    public QName getElementQName() {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "getElementQName()", "javax.xml.soap.SOAPElement"));
        }
        String string = this.getNamespaceURI();
        string = string == null ? EMPTY_STRING : string;
        String string2 = this.getPrefix();
        string2 = string2 == null ? EMPTY_STRING : string2;
        String string3 = this.getLocalName();
        return new QName(string, string3, string2);
    }

    public javax.xml.soap.SOAPElement setElementQName(QName qName) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "setElementQName(QName)", "javax.xml.soap.SOAPElement"));
        }
        this.setQName(qName.getNamespaceURI(), qName.getLocalPart());
        this.setPrefix(qName.getPrefix());
        return this;
    }

    public boolean removeAttribute(QName qName) {
        String string = this.domifyNamespace(qName.getNamespaceURI());
        String string2 = qName.getLocalPart();
        boolean bl = false;
        if (this.hasAttributeNS(string, string2)) {
            this.removeAttributeNS(string, string2);
            bl = true;
        }
        return bl;
    }

    public Iterator getChildElements(QName qName) {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "getChildElements(QName)", "javax.xml.soap.SOAPElement"));
        }
        return this.getChildElements(qName.getNamespaceURI(), qName.getLocalPart());
    }

    static {
        block3: {
            log = LogFactory.getLog(SOAPElement.class.getName());
            CONTEXT_CONTENT = 1;
            CONTEXT_ATTRS = 2;
            CONTEXT_TAG = 3;
            disableSOAPNamespaceValidation = false;
            String string = "com.ibm.ws.webservices.disableSOAPNamespaceValidation";
            try {
                disableSOAPNamespaceValidation = MCUtils.isPropertyEnabled(string);
                if (log.isDebugEnabled()) {
                    log.debug(MCUtils.getSettingMsg(string, disableSOAPNamespaceValidation));
                }
            }
            catch (Exception exception) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Exception occurred obtaining and evaluating system property {" + string + "}", exception);
            }
        }
    }

    class CEIterator
    implements Iterator {
        org.w3c.dom.Node parent;
        org.w3c.dom.Node prev;
        boolean first = true;
        boolean safeRemove = false;
        String methodName;

        CEIterator(org.w3c.dom.Node node, String string) {
            this.parent = node;
            this.methodName = string;
            this.prev = node;
        }

        public boolean hasNext() {
            if (this.prev == null) {
                return false;
            }
            if (this.first) {
                return this.prev.getFirstChild() != null;
            }
            return this.prev.getNextSibling() != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException(Messages.getMessage("exception00"));
            }
            this.safeRemove = true;
            if (this.first) {
                this.prev = this.prev.getFirstChild();
                this.first = false;
            } else {
                this.prev = this.prev.getNextSibling();
            }
            return this.prev;
        }

        public void remove() {
            if (!this.safeRemove || this.prev == null) {
                throw new IllegalStateException(Messages.getMessage("unsupportedIteratorRemove", this.methodName));
            }
            this.safeRemove = false;
            org.w3c.dom.Node node = this.prev.getPreviousSibling();
            this.parent.removeChild(this.prev);
            if (node == null) {
                this.first = true;
                this.prev = this.parent;
            } else {
                this.prev = node;
            }
        }
    }
}

