/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.security;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.net.DefaultHTTPSTransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.TransportClientPropertiesFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.Config;
import com.ibm.ws.webservices.engine.transport.ConfigProvider;
import com.ibm.ws.webservices.engine.transport.channel.WSAddress;
import com.ibm.ws.webservices.engine.transport.security.ConfigSSL;
import com.ibm.ws.webservices.engine.transport.security.JSSEConfigSSL;
import com.ibm.ws.webservices.engine.transport.security.WASConfigSSL;
import com.ibm.ws.webservices.engine.transport.security.WSConfigSSLChangeListener;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class ConfigSSLProvider
implements ConfigProvider {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent _tc = Tr.register(ConfigSSLProvider.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static JSSEHelper _jhlpr = null;
    private static ConfigSSLProvider cfgPvdr = null;
    private static Hashtable sslConfigTable = null;
    private static HashMap connInfoTable = null;

    private ConfigSSLProvider() {
    }

    public static final synchronized ConfigSSLProvider getInstance() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ConfigSSLProvider.getInstance()");
        }
        if (cfgPvdr == null) {
            _jhlpr = JSSEHelper.getInstance();
            cfgPvdr = new ConfigSSLProvider();
            sslConfigTable = new Hashtable();
            connInfoTable = new HashMap();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ConfigSSLProvider.getInstance()");
        }
        return cfgPvdr;
    }

    public Config getConfig(MessageContext messageContext, WSAddress wSAddress) throws WebServicesFault {
        ConfigSSL configSSL = null;
        Object var4_4 = null;
        Properties properties = null;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ConfigSSLProvider.getConfig()");
        }
        try {
            boolean bl = false;
            boolean bl2 = false;
            String string = null;
            String string2 = null;
            WSConfigSSLChangeListener wSConfigSSLChangeListener = new WSConfigSSLChangeListener();
            properties = _jhlpr.getSSLPropertiesOnThread();
            if (properties != null) {
                bl = true;
                properties = _jhlpr.getProperties(null, null, wSConfigSSLChangeListener);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("sslPropertiesProgramSet", properties.toString(), wSConfigSSLChangeListener.toString()));
                }
                configSSL = new WASConfigSSL();
            } else if (!bl) {
                try {
                    string = ((DefaultHTTPSTransportClientProperties)TransportClientPropertiesFactory.create(wSAddress.getSchemaInString())).getSSLConfigurationName();
                    string2 = ((DefaultHTTPSTransportClientProperties)TransportClientPropertiesFactory.create(wSAddress.getSchemaInString())).getSSLCertificateAliasName();
                }
                catch (ClassCastException classCastException) {
                    FFDCFilter.processException((Throwable)classCastException, "com.ibm.ws.webservices.engine.transport.security.getConfigSSL", "%C", this);
                    string = null;
                    string2 = null;
                    throw WebServicesFault.makeFault(classCastException);
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("sslConfigFromContext", string == null ? "" : string, string2 == null ? "" : string2));
                }
                if ((properties = _jhlpr.getProperties(string, this.getConnInfo(wSAddress), wSConfigSSLChangeListener)) == null) {
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("sslConfigResolveFailed00"));
                    }
                    if ((properties = _jhlpr.getProperties("DefaultSystemProperties", this.getConnInfo(wSAddress), wSConfigSSLChangeListener)) == null) {
                        throw new WebServicesFault(Messages.getMessage("sslConfigResolveFailed01", wSAddress.toString()));
                    }
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("sslPropertiesFromJSSEHelper", properties.toString(), wSConfigSSLChangeListener.toString()));
                }
                if (properties.getProperty("com.ibm.ssl.alias").equalsIgnoreCase("DefaultSystemProperties")) {
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("invokeMethod00", "JSSEConfigSSL", JSSEConfigSSL.class.getName()));
                    }
                    configSSL = new JSSEConfigSSL();
                } else {
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("invokeMethod00", "WASConfigSSL", WASConfigSSL.class.getName()));
                    }
                    configSSL = new WASConfigSSL();
                    String string3 = string;
                    int n = string3.lastIndexOf("/");
                    if (n != -1) {
                        string3 = string3.substring(n + 1);
                    }
                    String string4 = properties.getProperty("com.ibm.ssl.alias");
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "The absolute name for configured SSL Configuration alias is: " + string3);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "The SSL alias name from JSSEHelper properties is: " + string4);
                    }
                    if (string4.equalsIgnoreCase(string3)) {
                        bl2 = true;
                    }
                }
            }
            configSSL.putAll((Map)properties);
            configSSL.setlistener(wSConfigSSLChangeListener);
            if (bl) {
                configSSL.setPreConfig(properties);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Saved previous programmatic SSL configuration: " + properties.toString());
                }
            } else {
                configSSL.setPreConfig(null);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "No previous programmatic SSL configuration to be saved.");
                }
            }
            if (JavaUtils.hasValue(string2) && !bl && bl2) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Setting com.ibm.ssl.keyStoreClientAlias = " + string2);
                }
                configSSL.setProperty("com.ibm.ssl.keyStoreClientAlias", string2);
            }
            if (JavaUtils.hasValue(string) && !bl && bl2) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Setting alias = " + string);
                }
                configSSL.setProperty("alias", string);
            }
            _jhlpr.setSSLPropertiesOnThread(configSSL);
        }
        catch (SSLException sSLException) {
            FFDCFilter.processException((Throwable)sSLException, "com.ibm.ws.webservices.engine.transport.security.getConfigSSL", "%C", this);
            WebServicesFault.makeFault(sSLException);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ConfigSSLProvider.getConfig()");
        }
        return configSSL;
    }

    private HashMap getConnInfo(WSAddress wSAddress) {
        String string = "outbound" + wSAddress.getSchemaInString() + wSAddress.getHostname() + String.valueOf(wSAddress.getPort());
        HashMap<String, String> hashMap = (HashMap<String, String>)connInfoTable.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
            hashMap.put("com.ibm.ssl.direction", "outbound");
            if (wSAddress.getSchema() == 1 || wSAddress.getSchema() == 2) {
                hashMap.put("com.ibm.ssl.endPointName", "WEBSERVICES_HTTP");
            } else {
                hashMap.put("com.ibm.ssl.endPointName", wSAddress.getSchemaInString());
            }
            hashMap.put("com.ibm.ssl.remoteHost", wSAddress.getHostname());
            hashMap.put("com.ibm.ssl.remotePort", String.valueOf(wSAddress.getPort()));
            connInfoTable.put(string, hashMap);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, Messages.getMessage("sslConnectionInfo", hashMap.toString()));
        }
        return hashMap;
    }
}

