/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.protocol.Protocols;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class JMSURLParser {
    private URL url = null;
    private Properties props = null;
    private int destinationType = 0;
    private static String QueueMode = "/queue";
    private static String TopicMode = "/topic";
    private static String URL_CHARSET = "UTF-8";
    private static String URL_PROPERTY_DELIM = "&";
    private static final TraceComponent _tc = Tr.register(JMSURLParser.class, "WebServices", "com.ibm.ws.webservices.engine.resources.engineMessages");

    public JMSURLParser(URL uRL) throws Exception {
        this.setURL(uRL);
    }

    public void setURL(URL uRL) throws Exception {
        this.url = uRL;
        this.parseURL();
    }

    private void parseURL() throws Exception {
        String string;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "parseURL");
        }
        this.props = null;
        this.destinationType = 0;
        if (this.url == null) {
            return;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "About to parse JMS URL string: [" + this.url.toString() + "]");
        }
        if (!(string = this.url.getProtocol()).equals("jms")) {
            throw new MalformedURLException(Messages.getMessage("JMS.invalid_protocol", string));
        }
        String string2 = this.url.getPath();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Destination type is: " + string2);
        }
        if (string2.equalsIgnoreCase(QueueMode)) {
            this.destinationType = 1;
        } else if (string2.equalsIgnoreCase(TopicMode)) {
            this.destinationType = 2;
        } else {
            throw new MalformedURLException(Messages.getMessage("JMS.InvalidDestinationType", string2));
        }
        this.props = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(this.url.getQuery(), "&|");
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            String string4 = stringTokenizer.nextToken();
            int n = string4.indexOf("=");
            String string5 = n > -1 ? string4.substring(0, n) : string4;
            String string6 = string3 = n > -1 ? string4.substring(n + 1) : "";
            if (string5 == null || string3 == null) continue;
            string5 = URLDecoder.decode(string5, URL_CHARSET);
            string3 = URLDecoder.decode(string3, URL_CHARSET);
            this.props.setProperty(string5, string3);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Properties contained in the JMS URL string:\n" + this.props.toString());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "parseURL");
        }
    }

    public String getProperty(String string, String string2) {
        return this.props.getProperty(string, string2);
    }

    public void setProperty(String string, String string2) {
        if (string2 == null) {
            this.props.remove(string);
        } else {
            this.props.setProperty(string, string2);
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    public int getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(int n) {
        this.destinationType = n;
    }

    public String getDestination() {
        return this.getProperty("destination", null);
    }

    public void setDestination(String string) {
        this.setProperty("destination", string);
    }

    public String getConnectionFactory() {
        return this.getProperty("connectionFactory", null);
    }

    public void setConnectionFactory(String string) {
        this.setProperty("connectionFactory", string);
    }

    public String getTargetService() {
        return this.getProperty("targetService", null);
    }

    public void setTargetService(String string) {
        this.setProperty("targetService", string);
    }

    public String getJndiProviderURL() {
        return this.getProperty("jndiProviderURL", null);
    }

    public void setJndiProviderURL(String string) {
        this.setProperty("jndiProviderURL", string);
    }

    public String getInitialContextFactory() {
        return this.getProperty("initialContextFactory", null);
    }

    public void setInitialContextFactory(String string) {
        this.setProperty("initialContextFactory", string);
    }

    public String getTimeToLive() {
        return this.getProperty("timeToLive", null);
    }

    public void setTimeToLive(int n) {
        this.setProperty("timeToLive", Integer.toString(n));
    }

    public String getDeliveryMode() {
        return this.getProperty("deliveryMode", null);
    }

    public void setDeliveryMode(int n) {
        this.setProperty("deliveryMode", Integer.toString(n));
    }

    public String getPriority() {
        return this.getProperty("priority", null);
    }

    public void setPriority(int n) {
        this.setProperty("priority", Integer.toString(n));
    }

    public String getURLString() throws Exception {
        String string = this.getDestination();
        String string2 = this.getConnectionFactory();
        String string3 = this.getTargetService();
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0 || string3 == null || string3.length() == 0) {
            throw new MalformedURLException(Messages.getMessage("JMS.MissingRequiredProperties"));
        }
        int n = this.getDestinationType();
        if (n != 1 && n != 2) {
            throw new MalformedURLException(Messages.getMessage("JMS.InvalidDestinationType", Integer.toString(n)));
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("jms:");
        if (n == 1) {
            stringBuffer.append("/queue");
        } else {
            stringBuffer.append("/topic");
        }
        stringBuffer.append("?");
        boolean bl = false;
        Enumeration<?> enumeration = this.props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            String string5 = this.getProperty(string4, null);
            if (bl) {
                stringBuffer.append(URL_PROPERTY_DELIM);
            } else {
                bl = true;
            }
            stringBuffer.append(URLEncoder.encode(string4, URL_CHARSET) + "=");
            if (string5 == null) continue;
            stringBuffer.append(URLEncoder.encode(string5, URL_CHARSET));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        String string = null;
        try {
            string = this.getURLString();
        }
        catch (Exception exception) {
            string = Messages.getMessage("JMS.no_url_string", exception.toString());
        }
        String string2 = new String(this.destinationType == 1 ? "queue" : "topic");
        String string3 = new String("JMSURLParser contains:\n  Destination Type: " + string2 + "\n  Properties: " + this.props.toString() + "\n  URL String: " + string);
        return string3;
    }

    static {
        Protocols.init();
    }
}

