/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.TransactionSuspender;
import com.ibm.ws.webservices.engine.transport.jms.JMSCacheData;
import com.ibm.ws.webservices.engine.transport.jms.JMSConnectionCache;
import com.ibm.ws.webservices.engine.transport.jms.JMSConnectionData;
import com.ibm.ws.webservices.engine.transport.jms.JMSURLParser;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.trace.MessageTrace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.soap.SOAPException;

public class JMSSender
extends BasicHandler {
    private static Hashtable icTable = new Hashtable();
    private static HashMap jndiCache = new HashMap();
    private static final int CHUNK_SIZE = 4096;
    private static final TraceComponent _tc = Tr.register(JMSSender.class, "WebServices", "com.ibm.ws.webservices.engine.resources.engineMessages");
    private JMSConnectionCache activeConnections = JMSConnectionCache.newInstance();
    private boolean connectionManagementChecked = false;
    private boolean connectionManagementDesired = false;
    private static boolean JNDICacheExpirationTimeRetrieved = false;
    private static long JNDICacheExpirationTime = 0L;

    public void invoke(MessageContext messageContext) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "invoke");
        }
        JMSConnectionData jMSConnectionData = new JMSConnectionData();
        try {
            URL uRL = messageContext.getTargetEndpointAddressAsURL();
            if (uRL == null) {
                throw new WebServicesFault(Messages.getMessage("JMS.noEndpoint"));
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Target URL string is [" + uRL.toString() + "]");
            }
            this.parseURL(jMSConnectionData, uRL);
            this.getJMSObjects(jMSConnectionData);
            this.sendMessage(jMSConnectionData, messageContext, uRL);
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.invoke", "178", this);
            throw webServicesFault;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.invoke", "183", this);
            WebServicesFault webServicesFault = WebServicesFault.makeFault(exception);
            throw webServicesFault;
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "invoke");
            }
        }
    }

    private void parseURL(JMSConnectionData jMSConnectionData, URL uRL) throws WebServicesFault, Exception {
        Integer n;
        String string;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "parseURL");
        }
        JMSURLParser jMSURLParser = new JMSURLParser(uRL);
        jMSConnectionData.messageMode = jMSURLParser.getDestinationType();
        jMSConnectionData.connectionFactoryName = jMSURLParser.getConnectionFactory();
        jMSConnectionData.destinationName = jMSURLParser.getDestination();
        jMSConnectionData.targetService = jMSURLParser.getTargetService();
        if (jMSConnectionData.connectionFactoryName == null || jMSConnectionData.connectionFactoryName.length() == 0 || jMSConnectionData.destinationName == null || jMSConnectionData.destinationName.length() == 0 || jMSConnectionData.targetService == null || jMSConnectionData.targetService.length() == 0) {
            Tr.error(_tc, "JMS.MissingRequiredProperties");
            throw new WebServicesFault("JMS", Messages.getMessage("JMS.MissingRequiredProperties"), null, null);
        }
        try {
            string = jMSURLParser.getDeliveryMode();
            if (string != null) {
                n = new Integer(string);
                jMSConnectionData.deliveryMode = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.parseURL", "256", this);
            Tr.error(_tc, "JMS.BadPropValue", "deliveryMode");
            throw new WebServicesFault(Messages.getMessage("JMS.BadPropValue", "deliveryMode"), numberFormatException);
        }
        try {
            string = jMSURLParser.getPriority();
            if (string != null) {
                n = new Integer(string);
                jMSConnectionData.priority = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.parseURL", "274", this);
            Tr.error(_tc, "JMS.BadPropValue", "priority");
            throw new WebServicesFault(Messages.getMessage("JMS.BadPropValue", "priority"), numberFormatException);
        }
        try {
            string = jMSURLParser.getTimeToLive();
            if (string != null) {
                n = new Integer(string);
                jMSConnectionData.timeToLive = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.parseURL", "292", this);
            Tr.error(_tc, "JMS.BadPropValue", "timeToLive");
            throw new WebServicesFault(Messages.getMessage("JMS.BadPropValue", "timeToLive"), numberFormatException);
        }
        jMSConnectionData.initialContextFactory = jMSURLParser.getInitialContextFactory();
        jMSConnectionData.jndiProviderURL = jMSURLParser.getJndiProviderURL();
        jMSConnectionData.permanentReplyToQueueJNDI = jMSURLParser.getProperty("replyToDestination", null);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Permanent reply queue (URL) JNDI name property is " + jMSConnectionData.permanentReplyToQueueJNDI);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "message mode: [" + jMSConnectionData.messageMode + "], connectionFactoryName: [" + jMSConnectionData.connectionFactoryName + "], destinationName: [" + jMSConnectionData.destinationName + "], targetService: [" + jMSConnectionData.targetService + "]");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "parseURL");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getJMSObjects(JMSConnectionData jMSConnectionData) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getJMSObjects");
        }
        try {
            try {
                jMSConnectionData.jndiContext = JMSSender.getInitialContext(jMSConnectionData.initialContextFactory, jMSConnectionData.jndiProviderURL);
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.getJMSObjects", "357", this);
                Tr.error(_tc, "JMS.JNDIError01", namingException.toString());
                throw new WebServicesFault("JMS", Messages.getMessage("JMS.JNDIError01", namingException.toString()), null, null);
            }
            switch (jMSConnectionData.messageMode) {
                case 1: {
                    try {
                        jMSConnectionData.queueConnectionFactory = (QueueConnectionFactory)JMSSender.getJNDIObject(jMSConnectionData, jMSConnectionData.connectionFactoryName);
                        jMSConnectionData.queue = (Queue)JMSSender.getJNDIObject(jMSConnectionData, jMSConnectionData.destinationName);
                        return;
                    }
                    catch (NamingException namingException) {
                        FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.getJMSObjects", "385", this);
                        Tr.error(_tc, "JMS.JNDIError02", namingException.toString());
                        throw new WebServicesFault("JMS", Messages.getMessage("JMS.JNDIError02", namingException.toString()), null, null);
                    }
                }
                case 2: {
                    try {
                        jMSConnectionData.topicConnectionFactory = (TopicConnectionFactory)JMSSender.getJNDIObject(jMSConnectionData, jMSConnectionData.connectionFactoryName);
                        jMSConnectionData.topic = (Topic)JMSSender.getJNDIObject(jMSConnectionData, jMSConnectionData.destinationName);
                        return;
                    }
                    catch (NamingException namingException) {
                        FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.getJMSObjects", "410", this);
                        Tr.error(_tc, "JMS.JNDIError02", namingException.toString());
                        throw new WebServicesFault("JMS", Messages.getMessage("JMS.JNDIError02", namingException.toString()), null, null);
                    }
                }
            }
            return;
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.getJMSObjects", "425", this);
            throw webServicesFault;
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getJMSObjects");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InitialContext getInitialContext(String string, String string2) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getInitialContext");
        }
        InitialContext initialContext = null;
        String string3 = (string2 != null ? string2 : "<null>") + (string != null ? string : "<null>");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "InitialContext key=[" + string3 + "].");
        }
        Hashtable hashtable = icTable;
        synchronized (hashtable) {
            initialContext = (InitialContext)icTable.get(string3);
            if (initialContext == null) {
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                if (string != null) {
                    hashtable2.put("java.naming.factory.initial", string);
                }
                if (string2 != null) {
                    hashtable2.put("java.naming.provider.url", string2);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "About to create an InitialContext with the following properties:" + hashtable2.toString());
                }
                initialContext = new InitialContext(hashtable2);
                icTable.put(string3, initialContext);
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Re-using existing InitialContext with key=[" + string3 + "].");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getInitialContext");
        }
        return initialContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getJNDIObject(JMSConnectionData jMSConnectionData, String string) throws NamingException {
        JNDICacheObject jNDICacheObject;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getJNDIObject, jndiName=" + string);
        }
        Object object = null;
        try {
            String string2 = string + "#" + (jMSConnectionData.jndiProviderURL != null ? jMSConnectionData.jndiProviderURL : "<null>") + "#" + (jMSConnectionData.initialContextFactory != null ? jMSConnectionData.initialContextFactory : "<null>");
            HashMap hashMap = jndiCache;
            synchronized (hashMap) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Looking for object in JNDI cache, key=[" + string2 + "].");
                }
                if ((jNDICacheObject = (JNDICacheObject)jndiCache.get(string2)) == null || jNDICacheObject.cacheObjectIsStale()) {
                    if (_tc.isDebugEnabled()) {
                        if (jNDICacheObject == null) {
                            Tr.debug(_tc, "Object not in cache, performing JNDI lookup()...");
                        } else if (jNDICacheObject.cacheObjectIsStale()) {
                            Tr.debug(_tc, "Object in cache but stale, performing JNDI lookup()...");
                        }
                    }
                    object = jMSConnectionData.jndiContext.lookup(string);
                    jNDICacheObject = new JNDICacheObject(object);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Adding object to cache, key=[" + string2 + "], object=" + (object != null ? object.toString() : "<null>"));
                    }
                    jndiCache.put(string2, jNDICacheObject);
                }
            }
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getJNDIObject");
            }
        }
        return jNDICacheObject.getObject();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeConnection(JMSConnectionData jMSConnectionData) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "closeConnection");
        }
        try {
            switch (jMSConnectionData.messageMode) {
                case 1: {
                    if (jMSConnectionData.queueConnection == null) return;
                    jMSConnectionData.queueConnection.close();
                    return;
                }
                case 2: {
                    if (jMSConnectionData.topicConnection == null) return;
                    jMSConnectionData.topicConnection.close();
                    return;
                }
            }
            return;
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.closeConnection", "562", this);
            Tr.error(_tc, "JMS.JMSError01", jMSException.toString());
            throw new WebServicesFault("JMS", Messages.getMessage("JMS.JMSError01", jMSException.toString()), null, null);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "closeConnection");
            }
        }
    }

    private void cleanUp(JMSConnectionData jMSConnectionData) throws WebServicesFault {
        if (!this.connectionManagementIsDesired()) {
            this.closeConnection(jMSConnectionData);
        } else {
            try {
                if (jMSConnectionData.topicSession != null) {
                    jMSConnectionData.topicSession.close();
                    jMSConnectionData.topicSession = null;
                }
                if (jMSConnectionData.queueSession != null) {
                    jMSConnectionData.queueSession.close();
                    jMSConnectionData.queueSession = null;
                }
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.cleanUp", "612", this);
                Tr.error(_tc, "JMS.JMSError01", jMSException.toString());
                throw new WebServicesFault("JMS", Messages.getMessage("JMS.JMSError01", jMSException.toString()), null, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendMessage(JMSConnectionData jMSConnectionData, MessageContext messageContext, URL uRL) throws WebServicesFault, IOException, SOAPException {
        String string;
        int n;
        Comparable<StringBuffer> comparable;
        Object object;
        Object object2;
        boolean bl;
        OperationDesc operationDesc;
        Object object3;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "sendMessage");
        }
        if ((object3 = messageContext.getProperty("enableTransactionalOneWay")) != null) {
            jMSConnectionData.enableTranOneWay = JavaUtils.isTrue(object3);
        }
        boolean bl2 = (operationDesc = messageContext.getOperation()) == null ? true : (bl = !operationDesc.isOneway());
        if (bl && jMSConnectionData.messageMode == 2) {
            Tr.error(_tc, "JMS.NoTwoWay");
            throw new WebServicesFault("JMS", Messages.getMessage("JMS.NoTwoWay"), null, null);
        }
        TransactionSuspender transactionSuspender = null;
        boolean bl3 = false;
        if (!bl && jMSConnectionData.enableTranOneWay) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Bypassing transaction suspension...");
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Initiating transaction suspension...");
            }
            transactionSuspender = new TransactionSuspender();
            transactionSuspender.suspendTransaction();
            bl3 = TransactionSuspender.isTxnServiceEnabled();
        }
        Message message = messageContext.getRequestMessage();
        String string2 = messageContext.getUsername();
        String string3 = messageContext.getPassword();
        if (_tc.isDebugEnabled()) {
            object2 = string2 == null || string2.length() == 0 ? "<not-specified>" : string2;
            if (string3 == null || string3.length() == 0) {
                object = "<not-specified>";
            } else {
                comparable = new StringBuffer();
                for (n = 0; n < string3.length(); ++n) {
                    ((StringBuffer)comparable).append('*');
                }
                object = ((StringBuffer)comparable).toString();
            }
            Tr.debug(_tc, "Userid: " + (String)object2);
            Tr.debug(_tc, "Password: " + (String)object);
        }
        if ((object2 = (Integer)messageContext.getProperty("deliveryMode")) != null) {
            jMSConnectionData.deliveryMode = (Integer)object2;
        }
        if ((object = (Integer)messageContext.getProperty("priority")) != null) {
            jMSConnectionData.priority = (Integer)object;
        }
        if ((comparable = (Integer)messageContext.getProperty("timeToLive")) != null) {
            jMSConnectionData.timeToLive = (Integer)comparable;
        }
        if ((n = messageContext.getTimeout()) > 0 && (jMSConnectionData.timeToLive <= 0 || jMSConnectionData.timeToLive > n)) {
            jMSConnectionData.timeToLive = n;
        }
        if ((string = (String)messageContext.getProperty("JMSReplyQueueJndiName")) != null) {
            jMSConnectionData.permanentReplyToQueueJNDI = string;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Permanent reply queue (stub or client-binding) JNDI name property is " + jMSConnectionData.permanentReplyToQueueJNDI);
        }
        HashMap hashMap = null;
        hashMap = (HashMap)messageContext.getProperty("com.ibm.websphere.webservices.requestTransportProperties");
        HashMap hashMap2 = null;
        hashMap2 = (HashMap)messageContext.getProperty("com.ibm.websphere.webservices.responseTransportProperties");
        QueueSender queueSender = null;
        TopicPublisher topicPublisher = null;
        BytesMessage bytesMessage = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        String string4 = null;
        boolean bl4 = false;
        try {
            switch (jMSConnectionData.messageMode) {
                case 1: {
                    void var25_29;
                    this.getQueueConnectionAndSession(jMSConnectionData, string2, string3, bl3);
                    queueSender = jMSConnectionData.queueSession.createSender(jMSConnectionData.queue);
                    string4 = message.getContentType(messageContext.getSOAPConstants());
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Content-Type from Queue Request Message is " + string4);
                    }
                    bytesMessage = jMSConnectionData.queueSession.createBytesMessage();
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    message.writeTo(byteArrayOutputStream, string4);
                    message.removeAllAttachments();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "About to write the following Bytes request message to the JMS message:\n" + byteArrayOutputStream.toString());
                    }
                    bytesMessage.writeBytes(byteArrayOutputStream.toByteArray());
                    if (MessageTrace.isTraceEnabled()) {
                        MessageTrace.log(MessageTrace.OUTBOUND_JMS_REQUEST, string4, byteArrayOutputStream.toByteArray());
                    }
                    bytesMessage.setStringProperty("contentType", string4);
                    bytesMessage.setStringProperty("targetService", jMSConnectionData.targetService);
                    bytesMessage.setStringProperty("endpointURL", uRL.toString());
                    bytesMessage.setStringProperty("transportVersion", "1");
                    if (!bl && jMSConnectionData.enableTranOneWay) {
                        bytesMessage.setStringProperty("enableTransaction", "true");
                    }
                    this.setSoapAction(bytesMessage, messageContext);
                    if (hashMap != null) {
                        this.setRequestUserTransportProperties(bytesMessage, hashMap);
                    }
                    Object var25_25 = null;
                    QueueReceiver queueReceiver = null;
                    String string5 = null;
                    String string6 = null;
                    if (bl) {
                        void var25_28;
                        string6 = this.getPermanentReplyQueueJNDI(jMSConnectionData.permanentReplyToQueueJNDI);
                        if (string6 != null) {
                            jMSConnectionData.permanentReplyToQueueJNDI = string6;
                            try {
                                Queue queue = (Queue)jMSConnectionData.jndiContext.lookup(jMSConnectionData.permanentReplyToQueueJNDI);
                            }
                            catch (NamingException namingException) {
                                FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.sendMessage", "830", this);
                                Tr.error(_tc, "JMS.JNDIError02", namingException.toString());
                                throw new WebServicesFault("JMS", Messages.getMessage("JMS.JNDIError02", namingException.toString()), null, null);
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Using permanent reply-to queue " + string6);
                            }
                        } else {
                            TemporaryQueue temporaryQueue = jMSConnectionData.queueSession.createTemporaryQueue();
                        }
                        bytesMessage.setJMSReplyTo((Destination)var25_28);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Set the reply-to queue and started the queue connection in preparation for the reply message.");
                        }
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "About to send message:\n" + bytesMessage.toString() + "\n" + "Message send options:\n" + "deliveryMode=" + jMSConnectionData.deliveryMode + ", priority=" + jMSConnectionData.priority + ", timeToLive=" + jMSConnectionData.timeToLive);
                    }
                    queueSender.send(bytesMessage, jMSConnectionData.deliveryMode, jMSConnectionData.priority, jMSConnectionData.timeToLive);
                    String string7 = bytesMessage.getJMSMessageID();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Sent the message, messageID=" + string7);
                    }
                    if (bl3) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "About to commit QueueSession (send)");
                        }
                        jMSConnectionData.queueSession.commit();
                    }
                    if (var25_29 == null) return;
                    if (string6 != null) {
                        string5 = "JMSCorrelationID = '" + string7 + "'";
                    }
                    queueReceiver = jMSConnectionData.queueSession.createReceiver((Queue)var25_29, string5);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Created the queue receiver with selector " + string5);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "About to receive response message, requestTimeout=" + n + "ms.");
                    }
                    javax.jms.Message message2 = queueReceiver.receive(n);
                    if (_tc.isDebugEnabled()) {
                        if (message2 != null) {
                            Tr.debug(_tc, "Received JMS response message:\n" + message2.toString());
                        } else {
                            Tr.debug(_tc, "Received null response message :-(");
                        }
                    }
                    if (message2 == null) {
                        Tr.error(_tc, "JMS.RequestTimeOut");
                        throw new WebServicesFault(Messages.getMessage("JMS.RequestTimeOut"));
                    }
                    if (bl3) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "About to commit QueueSession (receive)");
                        }
                        jMSConnectionData.queueSession.commit();
                    }
                    String string8 = message2.getJMSCorrelationID();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Reply message contains correlation id: " + string8);
                    }
                    if (string8 == null || !string8.equals(string7)) {
                        Tr.error(_tc, "JMS.MismatchedReply");
                        throw new WebServicesFault(Messages.getMessage("JMS.MismatchedReply"));
                    }
                    String string9 = message2.getStringProperty("contentType");
                    string9 = string9 == null ? null : string9.trim();
                    Message message3 = null;
                    if (message2 instanceof BytesMessage) {
                        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                        byte[] byArray = new byte[4096];
                        int n2 = 1;
                        while (n2 > 0) {
                            n2 = ((BytesMessage)message2).readBytes(byArray);
                            if (n2 <= 0) continue;
                            byteArrayOutputStream2.write(byArray, 0, n2);
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Extracted the following SOAP Bytes message from the JMS response message:\n" + byteArrayOutputStream2.toString());
                        }
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream2.toByteArray());
                        message3 = new Message((Object)byteArrayInputStream, string9, null);
                        messageContext.setResponseMessage(message3);
                    } else {
                        if (!(message2 instanceof TextMessage)) {
                            Tr.error(_tc, "JMS.InvalidReplyMsgType");
                            throw new WebServicesFault(Messages.getMessage("JMS.InvalidReplyMsgType"));
                        }
                        String string10 = ((TextMessage)message2).getText();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Extracted the following SOAP Text message from the JMS response message:\n" + string10);
                        }
                        message3 = new Message((Object)string10, string9, null);
                        messageContext.setResponseMessage(message3);
                    }
                    if (hashMap2 == null) return;
                    this.getResponseUserTransportProperties(hashMap2, message2);
                    return;
                }
                case 2: {
                    this.getTopicConnectionAndSession(jMSConnectionData, string2, string3, bl3);
                    topicPublisher = jMSConnectionData.topicSession.createPublisher(jMSConnectionData.topic);
                    string4 = message.getContentType(messageContext.getSOAPConstants());
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Content-Type from Topic Request Message is " + string4);
                    }
                    bytesMessage = jMSConnectionData.topicSession.createBytesMessage();
                    if (jMSConnectionData.enableTranOneWay) {
                        bytesMessage.setStringProperty("enableTransaction", "true");
                    }
                    this.setSoapAction(bytesMessage, messageContext);
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    message.writeTo(byteArrayOutputStream, string4);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "About to write the following Bytes request message to the JMS message:\n" + byteArrayOutputStream.toString());
                    }
                    bytesMessage.writeBytes(byteArrayOutputStream.toByteArray());
                    bytesMessage.setStringProperty("contentType", string4);
                    bytesMessage.setStringProperty("targetService", jMSConnectionData.targetService);
                    bytesMessage.setStringProperty("endpointURL", uRL.toString());
                    bytesMessage.setStringProperty("transportVersion", "1");
                    if (hashMap != null) {
                        this.setRequestUserTransportProperties(bytesMessage, hashMap);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "About to publish message:\n" + bytesMessage.toString());
                    }
                    topicPublisher.publish(bytesMessage);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Published the message.");
                    }
                    if (!bl3) return;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "About to commit TopicSession (publish)");
                    }
                    jMSConnectionData.topicSession.commit();
                    return;
                }
            }
            return;
        }
        catch (JMSException jMSException) {
            StringBuffer stringBuffer;
            block78: {
                bl4 = true;
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.sendMessage", "968", this);
                stringBuffer = new StringBuffer();
                stringBuffer.append(Messages.getMessage("JMS.JMSError01", jMSException.toString()));
                Exception exception = jMSException.getLinkedException();
                while (exception != null) {
                    stringBuffer.append("\n");
                    stringBuffer.append(Messages.getMessage("JMS.JMSError02", exception.toString()));
                    if (exception instanceof JMSException) {
                        exception = ((JMSException)exception).getLinkedException();
                        continue;
                    }
                    exception = null;
                }
                if (bl3) {
                    try {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Doing rollback of session due to JMSException.");
                        }
                        if (jMSConnectionData.queueSession != null) {
                            jMSConnectionData.queueSession.rollback();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Rolled back queue session.");
                            }
                        }
                        if (jMSConnectionData.topicSession == null) break block78;
                        jMSConnectionData.topicSession.rollback();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Rolled back topic session.");
                        }
                    }
                    catch (Throwable throwable) {
                        if (!_tc.isDebugEnabled()) break block78;
                        Tr.debug(_tc, "Session rollback failed with exception: " + throwable.toString());
                    }
                }
            }
            Tr.error(_tc, stringBuffer.toString());
            if (!_tc.isDebugEnabled()) throw new WebServicesFault("JMS", stringBuffer.toString(), null, null);
            Tr.debug(_tc, stringBuffer.toString());
            throw new WebServicesFault("JMS", stringBuffer.toString(), null, null);
        }
        finally {
            if (transactionSuspender != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Initiating transaction resumption...");
                }
                transactionSuspender.resumeTransaction();
            }
            this.cleanUp(jMSConnectionData);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "sendMessage");
            }
        }
    }

    private void setSoapAction(javax.jms.Message message, MessageContext messageContext) throws JMSException {
        String string = messageContext.getSOAPActionURI();
        if (!messageContext.useSOAPAction() || string == null) {
            message.setStringProperty("soapAction", "");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting soapAction on JMSMessage to empty string...");
            }
        } else {
            message.setStringProperty("soapAction", "\"" + string + "\"");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting soapAction on JMSMessage to: \"" + string + "\"");
            }
        }
    }

    private boolean connectionManagementIsDesired() {
        if (!this.connectionManagementChecked) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "connectionManagementIsDesired() raw System property = " + System.getProperty("com.ibm.ws.webservices.JMSUseConnectionManagement"));
            }
            this.connectionManagementDesired = JavaUtils.isTrueExplicitly(System.getProperty("com.ibm.ws.webservices.JMSUseConnectionManagement"), false);
            this.connectionManagementChecked = true;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "connectionManagementIsDesired() desired = " + this.connectionManagementDesired);
            }
        }
        return this.connectionManagementDesired;
    }

    private String getKey(JMSConnectionData jMSConnectionData, String string) {
        String string2 = jMSConnectionData.connectionFactoryName + "#" + (string != null && string.length() != 0 ? string : "<null>") + (jMSConnectionData.initialContextFactory != null && jMSConnectionData.initialContextFactory.length() != 0 ? jMSConnectionData.initialContextFactory : "<null>") + (jMSConnectionData.jndiProviderURL != null && jMSConnectionData.jndiProviderURL.length() != 0 ? jMSConnectionData.jndiProviderURL : "<null>");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getQueueConnectionAndSession(JMSConnectionData jMSConnectionData, String string, String string2, boolean bl) throws JMSException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getQueueConnectionAndSession");
        }
        jMSConnectionData.queueConnection = null;
        jMSConnectionData.queueSession = null;
        if (!this.connectionManagementIsDesired()) {
            this.createQueueConnection(jMSConnectionData, string, string2);
        } else {
            JMSConnectionCache jMSConnectionCache = this.activeConnections;
            synchronized (jMSConnectionCache) {
                JMSCacheData jMSCacheData;
                String string3 = this.getKey(jMSConnectionData, string);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Looking for Queue connection in cache, key=[" + string3 + "].");
                }
                if ((jMSCacheData = this.activeConnections.get(string3)) != null) {
                    jMSConnectionData.queueConnection = (QueueConnection)jMSCacheData.getConnection();
                }
                if (jMSConnectionData.queueConnection != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Queue connection found: " + jMSConnectionData.queueConnection.toString());
                    }
                    try {
                        jMSConnectionData.queueSession = jMSConnectionData.queueConnection.createQueueSession(bl, 1);
                    }
                    catch (JMSException jMSException) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "createQueueSession threw JMSException, must create fresh QueueConnection.");
                        }
                        jMSConnectionData.queueConnection.close();
                        jMSConnectionData.queueConnection = null;
                        jMSConnectionData.queueSession = null;
                    }
                }
                if (jMSConnectionData.queueConnection == null) {
                    this.createQueueConnection(jMSConnectionData, string, string2);
                    this.activeConnections.put(string3, jMSConnectionData.queueConnection);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Queue connection added to cache, key=[" + string3 + "].");
                        Tr.debug(_tc, "Queue connection added: " + jMSConnectionData.queueConnection.toString());
                    }
                }
            }
        }
        if (jMSConnectionData.queueSession == null) {
            jMSConnectionData.queueSession = jMSConnectionData.queueConnection.createQueueSession(bl, 1);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getQueueConnectionAndSession");
        }
    }

    private void createQueueConnection(JMSConnectionData jMSConnectionData, String string, String string2) throws JMSException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createQueueConnection");
        }
        if (string != null && string.length() != 0 && string2 != null && string2.length() != 0) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Creating queue connection with user [" + string + "] and password.");
            }
            jMSConnectionData.queueConnection = jMSConnectionData.queueConnectionFactory.createQueueConnection(string, string2);
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Creating queue connection without user/password.");
            }
            jMSConnectionData.queueConnection = jMSConnectionData.queueConnectionFactory.createQueueConnection();
        }
        if (jMSConnectionData.queueConnection != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Starting queue connection...");
            }
            jMSConnectionData.queueConnection.start();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createQueueConnection");
        }
    }

    private void createTopicConnection(JMSConnectionData jMSConnectionData, String string, String string2) throws JMSException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createTopicConnection");
        }
        if (string != null && string.length() != 0 && string2 != null && string2.length() != 0) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Creating topic connection with user [" + string + "] and password.");
            }
            jMSConnectionData.topicConnection = jMSConnectionData.topicConnectionFactory.createTopicConnection(string, string2);
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Creating topic connection without user/password.");
            }
            jMSConnectionData.topicConnection = jMSConnectionData.topicConnectionFactory.createTopicConnection();
        }
        if (jMSConnectionData.topicConnection != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Starting topic connection...");
            }
            jMSConnectionData.topicConnection.start();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createTopicConnection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTopicConnectionAndSession(JMSConnectionData jMSConnectionData, String string, String string2, boolean bl) throws JMSException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getTopicConnectionAndSession");
        }
        jMSConnectionData.topicConnection = null;
        jMSConnectionData.topicSession = null;
        if (!this.connectionManagementIsDesired()) {
            this.createTopicConnection(jMSConnectionData, string, string2);
        } else {
            JMSConnectionCache jMSConnectionCache = this.activeConnections;
            synchronized (jMSConnectionCache) {
                JMSCacheData jMSCacheData;
                String string3 = this.getKey(jMSConnectionData, string);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Looking for Topic connection in cache, key=[" + string3 + "].");
                }
                if ((jMSCacheData = this.activeConnections.get(string3)) != null) {
                    jMSConnectionData.topicConnection = (TopicConnection)jMSCacheData.getConnection();
                }
                if (jMSConnectionData.topicConnection != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Topic connection found: " + jMSConnectionData.topicConnection.toString());
                    }
                    try {
                        jMSConnectionData.topicSession = jMSConnectionData.topicConnection.createTopicSession(bl, 1);
                    }
                    catch (JMSException jMSException) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "createTopicSession threw JMSException, must create fresh TopicConnection.");
                        }
                        jMSConnectionData.topicConnection.close();
                        jMSConnectionData.topicConnection = null;
                        jMSConnectionData.topicSession = null;
                    }
                }
                if (jMSConnectionData.topicConnection == null) {
                    this.createTopicConnection(jMSConnectionData, string, string2);
                    this.activeConnections.put(string3, jMSConnectionData.topicConnection);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Topic connection added to cache, key=[" + this.getKey(jMSConnectionData, string) + "].");
                    }
                }
            }
        }
        if (jMSConnectionData.topicSession == null) {
            jMSConnectionData.topicSession = jMSConnectionData.topicConnection.createTopicSession(bl, 1);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getTopicConnectionAndSession");
        }
    }

    public void _init() {
        super._init();
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSender _init() " + this.toString());
        }
    }

    public void _destroy() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSender _destroy() " + this.toString());
        }
        try {
            if (this.connectionManagementIsDesired()) {
                this.activeConnections.closeConnections();
            }
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.transport.jms.JMSSender._destroy", "1436", this);
        }
        super._destroy();
    }

    private String getPermanentReplyQueueJNDI(String string) {
        String string2 = null;
        if (string != null) {
            if (!string.equals("") && !string.equals("Transient")) {
                string2 = string;
            }
            return string2;
        }
        String string3 = System.getProperty("com.ibm.websphere.webservices.JMSReplyQueueJndiName");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Permanent reply queue (System property) is " + string3);
        }
        if (string3 != null && !string3.equals("") && !string3.equals("Transient")) {
            string2 = string3;
        }
        return string2;
    }

    private static long getJNDICacheExpirationTime() {
        if (!JNDICacheExpirationTimeRetrieved) {
            Integer n = Integer.getInteger(System.getProperty("com.ibm.websphere.webservices.transport.jms.JNDICacheExpirationThreshhold"), 600);
            JNDICacheExpirationTimeRetrieved = true;
            JNDICacheExpirationTime = n.longValue() * 1000L;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting JNDI Cache Expiration time to: " + n + " seconds");
            }
        }
        return JNDICacheExpirationTime;
    }

    private void setRequestUserTransportProperties(javax.jms.Message message, HashMap hashMap) throws WebServicesFault {
        try {
            if (hashMap != null) {
                Iterator iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string = ((String)entry.getKey()).trim();
                    if (!JavaUtils.hasValue(string)) {
                        Tr.warning(_tc, "invalid.transportheader.key");
                        continue;
                    }
                    String string2 = ((String)entry.getValue()).trim();
                    if (!JavaUtils.hasValue(string2)) {
                        Tr.warning(_tc, "invalid.transportheader.value", (Object)new Object[]{string});
                        continue;
                    }
                    if (message.propertyExists(string)) continue;
                    message.setStringProperty(string, string2);
                }
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.setRequestUserTransportProperties", "1227", this);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Messages.getMessage("JMS.JMSError01", jMSException.toString()));
            Exception exception = jMSException.getLinkedException();
            while (exception != null) {
                stringBuffer.append("\n");
                stringBuffer.append(Messages.getMessage("JMS.JMSError02", exception.toString()));
                if (exception instanceof JMSException) {
                    exception = ((JMSException)exception).getLinkedException();
                    continue;
                }
                exception = null;
            }
            Tr.error(_tc, stringBuffer.toString());
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, stringBuffer.toString());
            }
            throw new WebServicesFault("JMS", stringBuffer.toString(), null, null);
        }
    }

    private void getResponseUserTransportProperties(HashMap hashMap, javax.jms.Message message) throws WebServicesFault {
        if (hashMap != null) {
            try {
                if (hashMap.isEmpty()) {
                    Enumeration enumeration = message.getPropertyNames();
                    while (enumeration.hasMoreElements()) {
                        String string = ((String)enumeration.nextElement()).trim();
                        if (!JavaUtils.hasValue(string)) {
                            Tr.warning(_tc, "invalid.transportheader.key");
                            continue;
                        }
                        String string2 = null;
                        string2 = message.getStringProperty(string);
                        hashMap.put(string, string2);
                    }
                } else {
                    Iterator iterator = hashMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        String string = ((String)entry.getKey()).trim();
                        if (!JavaUtils.hasValue(string)) {
                            Tr.warning(_tc, "invalid.transportheader.key");
                            continue;
                        }
                        String string3 = null;
                        string3 = message.getStringProperty(string);
                        hashMap.put(string, string3);
                    }
                }
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.getResponseUserTransportProperties", "1304", this);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Messages.getMessage("JMS.JMSError01", jMSException.toString()));
                Exception exception = jMSException.getLinkedException();
                while (exception != null) {
                    stringBuffer.append("\n");
                    stringBuffer.append(Messages.getMessage("JMS.JMSError02", exception.toString()));
                    if (exception instanceof JMSException) {
                        exception = ((JMSException)exception).getLinkedException();
                        continue;
                    }
                    exception = null;
                }
                Tr.error(_tc, stringBuffer.toString());
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, stringBuffer.toString());
                }
                throw new WebServicesFault("JMS", stringBuffer.toString(), null, null);
            }
        }
    }

    private static class JNDICacheObject {
        private long timeCreated = System.currentTimeMillis();
        private Object data = null;

        JNDICacheObject(Object object) {
            this.data = object;
        }

        private Object getObject() {
            return this.data;
        }

        private boolean cacheObjectIsStale() {
            return JMSSender.getJNDICacheExpirationTime() != 0L && System.currentTimeMillis() - this.timeCreated > JMSSender.getJNDICacheExpirationTime();
        }
    }
}

