/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.engine.transport.http.CookieComparator;
import com.ibm.ws.webservices.engine.transport.http.CookieValueItem;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import java.util.Iterator;
import java.util.TreeSet;

public class CookieValueList {
    private static final TraceComponent _tc = Tr.register(CookieValueList.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private String cookieName = null;
    private String cookieValue = null;
    private TreeSet cookieTree = null;
    private String cookie_name = null;
    private CookieValueItem CV = null;

    public CookieValueList(String string) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Cookie is : " + this.cookie_name);
        }
        this.cookie_name = string;
        this.cookieTree = new TreeSet(new CookieComparator());
    }

    public void setCookieNameValue(String string, String string2) {
        this.cookieName = string;
        this.cookieValue = string2;
    }

    public void setCookie(String string) {
        if (_tc.isDebugEnabled()) {
            Tr.entry(_tc, "setCookie");
        }
        if (string != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "cookie : " + string);
            }
            this.CV = new CookieValueItem(this.cookie_name);
            this.CV.setCookieValue(this.cookieValue);
            boolean bl = this.CV.setCookie(string);
            if (bl) {
                if (this.cookie_name == HTTPConstants.HEADER_SET_COOKIE2 && this.CV.getVersion() != null) {
                    this.checkList(this.CV);
                    this.cookieTree.add(this.CV);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Added cookie");
                    }
                } else if (this.cookie_name == HTTPConstants.HEADER_SET_COOKIE) {
                    this.checkList(this.CV);
                    this.cookieTree.add(this.CV);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Added cookie");
                    }
                }
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.exit(_tc, "setCookie");
        }
    }

    private void checkList(CookieValueItem cookieValueItem) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "checkList");
        }
        String string = cookieValueItem.getPath();
        String string2 = cookieValueItem.getDomain();
        String string3 = null;
        String string4 = null;
        Iterator iterator = this.cookieTree.iterator();
        while (iterator.hasNext()) {
            CookieValueItem cookieValueItem2 = (CookieValueItem)iterator.next();
            string3 = cookieValueItem2.getPath();
            string4 = cookieValueItem2.getDomain();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Stored cookie path : " + string3 + ". Received cookie path : " + string);
            }
            if (string3 == null || string == null || !string.equals(string3)) continue;
            if (string4 == null && string2 == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Path match : " + string3 + ". Removing old cookie");
                }
                this.cookieTree.remove(cookieValueItem2);
                break;
            }
            if (cookieValueItem.doesDomainMatch(string2, string4)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Path : " + string3 + " and Domain :  " + string4 + " match. Removing old cookie");
                }
                this.cookieTree.remove(cookieValueItem2);
                break;
            }
            if (!_tc.isDebugEnabled()) continue;
            Tr.debug(_tc, "Domains don't match. Not removing old cookie");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "checkList");
        }
    }

    public String printList() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.cookieTree.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(this.cookieName + HTTPConstants.ATTR_VALUE_SEPARATOR);
            CookieValueItem cookieValueItem = (CookieValueItem)iterator.next();
            stringBuffer.append(cookieValueItem.printList() + HTTPConstants.HEADER_TOKEN_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    public String getList(String string, String string2, int n, boolean bl) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getList path : " + string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.cookieTree.iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            String string3;
            CookieValueItem cookieValueItem = (CookieValueItem)iterator.next();
            if (cookieValueItem.hasExpired()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Cookie has expired removing it : " + this.cookieName + HTTPConstants.ATTR_VALUE_SEPARATOR + cookieValueItem.getList(string2, n, bl));
                }
                iterator.remove();
                continue;
            }
            String string4 = cookieValueItem.getPath();
            if (string4 == null && (string3 = cookieValueItem.getList(string2, n, bl)) != null) {
                stringBuffer.append(this.cookieName + HTTPConstants.ATTR_VALUE_SEPARATOR);
                stringBuffer.append(string3);
                bl2 = true;
            }
            if (string4 != null && string.contains(string4) && (string3 = cookieValueItem.getList(string2, n, bl)) != null) {
                stringBuffer.append(this.cookieName + HTTPConstants.ATTR_VALUE_SEPARATOR);
                stringBuffer.append(string3);
                bl2 = true;
            }
            if (!bl2) continue;
            stringBuffer.append(HTTPConstants.HEADER_TOKEN_SEPARATOR);
            bl2 = false;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getList : " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }
}

