/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers.jaxrpc;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerPool;
import com.ibm.ws.webservices.engine.resources.Messages;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerInfo;
import org.apache.commons.logging.Log;

public class MonoHandlerPool
extends HandlerPool {
    protected static Log log = LogFactory.getLog(MonoHandlerPool.class.getName());
    private final Handler _handler = (Handler)this.getHandlerClass().newInstance();
    private boolean _inited = false;

    MonoHandlerPool(HandlerInfo handlerInfo) throws IllegalAccessException, InstantiationException {
        super(handlerInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handler get() {
        if (!this._inited) {
            MonoHandlerPool monoHandlerPool = this;
            synchronized (monoHandlerPool) {
                if (!this._inited) {
                    this._handler.init(this.getHandlerInfo());
                    this._inited = true;
                }
            }
        }
        return this._handler;
    }

    public void put(Handler handler) {
        if (this._handler != handler) {
            log.error(Messages.getMessage("jaxRpcHandlerPoolBadPut00", handler.getClass().getName(), this.getHandlerClassName()));
            throw new JAXRPCException(Messages.getMessage("jaxRpcHandlerPoolBadPut00", handler.getClass().getName(), this.getHandlerClassName()));
        }
    }

    public void faulted(Handler handler) {
        this.put(handler);
    }

    public void destroy() {
        this._handler.destroy();
    }
}

