/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers.jaxrpc;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.ExtendedHandlerInfo;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerChain;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerPool;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerPoolFactory;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.wsspi.webservices.rpc.handler.Handler;
import com.ibm.wsspi.webservices.rpc.handler.SystemHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.commons.logging.Log;

public class JAXRPCHandlerChain
extends AbstractList
implements HandlerChain {
    protected static Log log = LogFactory.getLog(JAXRPCHandlerChain.class.getName());
    private static final String emptyString = "".intern();
    private List _handlerPools = new ArrayList();
    private Collection _headerQNames = new JAXRPCHandler.QNameSet();
    private Collection _roles;
    static /* synthetic */ Class class$com$ibm$wsspi$webservices$rpc$handler$SystemHandler;
    static /* synthetic */ Class class$com$ibm$wsspi$webservices$rpc$handler$Handler;

    public JAXRPCHandlerChain(List list, Collection collection) {
        if (list != null) {
            this.addAll(list);
        }
        this.setRoles(collection);
    }

    protected void finalize() {
        this.destroy();
    }

    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: JAXRPCHandlerChain.destroy()");
        }
        this.clear();
        if (this._handlerPools != null) {
            this._handlerPools.clear();
            this._handlerPools = null;
        }
        if (this._headerQNames != null) {
            this._headerQNames.clear();
            this._headerQNames = null;
        }
        if (this._roles != null) {
            this._roles.clear();
            this._roles = null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: JAXRPCHandlerChain.destroy()");
        }
    }

    public void preHandleIncoming(MessageContext messageContext) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: JAXRPCHandlerChain.preHandleIncoming()");
        }
        boolean bl = false;
        for (int i = 0; !bl && i < this._handlerPools.size(); ++i) {
            HandlerPool handlerPool;
            if (!(class$com$ibm$wsspi$webservices$rpc$handler$SystemHandler == null ? JAXRPCHandlerChain.class$("com.ibm.wsspi.webservices.rpc.handler.SystemHandler") : class$com$ibm$wsspi$webservices$rpc$handler$SystemHandler).isAssignableFrom((handlerPool = (HandlerPool)this._handlerPools.get(i)).getHandlerClass())) continue;
            SystemHandler systemHandler = (SystemHandler)handlerPool.get();
            String string = handlerPool.getHandlerClassName();
            if (log.isDebugEnabled()) {
                log.debug("Calling:  " + string + ".preHandleIncoming()");
            }
            try {
                com.ibm.wsspi.webservices.rpc.handler.MessageContext messageContext2 = this.getHandlerMC(messageContext);
                systemHandler.preHandleIncoming(messageContext2);
                handlerPool.put(systemHandler);
                if (!log.isDebugEnabled()) continue;
                log.debug("Returning from:  " + string + ".preHandleIncoming()");
                continue;
            }
            catch (SOAPFaultException sOAPFaultException) {
                FFDCFilter.processException((Throwable)sOAPFaultException, "com.ibm.ws.webservices.engine.handlers.JAXRPCHandlerChain.preHandleIncoming", "202", this);
                if (log.isDebugEnabled()) {
                    log.debug("Caught exception from:  " + string + ".preHandleIncoming(). " + sOAPFaultException.toString());
                }
                bl = true;
                handlerPool.put(systemHandler);
                throw sOAPFaultException;
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandlerChain.preHandleIncoming", "210", this);
                if (log.isDebugEnabled()) {
                    log.debug("Caught exception from:  " + string + ".preHandleIncoming(). " + runtimeException.toString());
                }
                bl = true;
                handlerPool.faulted(systemHandler);
                throw runtimeException;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: JAXRPCHandlerChain.preHandleIncoming()");
        }
    }

    public boolean handleRequest(MessageContext messageContext) throws WebServicesFault {
        Object object;
        Object object2;
        Object object3;
        boolean bl = true;
        boolean bl2 = false;
        SOAPMessage sOAPMessage = messageContext.getMessage();
        if (sOAPMessage != null && (object3 = sOAPMessage.getSOAPPart()) != null) {
            object2 = null;
            try {
                object2 = (SOAPEnvelope)((SOAPPart)object3).getEnvelope();
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.handlers.soap.SOAPHandlerChain.handleRequest", "140", this);
                throw WebServicesFault.makeFault(sOAPException);
            }
        }
        object3 = null;
        object2 = null;
        int n = 0;
        boolean bl3 = false;
        while (!bl2 && n < this._handlerPools.size()) {
            object3 = messageContext.getRequestMessage();
            object = (HandlerPool)this._handlerPools.get(n);
            object2 = ((HandlerPool)object).getHandlerClassName();
            boolean bl4 = ExtendedHandlerInfo.isFaultLocal(((HandlerPool)object).getOriginalInfo());
            bl3 = ExtendedHandlerInfo.isAutoResponse(((HandlerPool)object).getOriginalInfo());
            javax.xml.rpc.handler.Handler handler = ((HandlerPool)object).get();
            try {
                com.ibm.wsspi.webservices.rpc.handler.MessageContext messageContext2 = this.getHandlerMC(messageContext);
                if (log.isDebugEnabled()) {
                    log.debug("Calling: " + (String)object2 + ".handleRequest().  MessageContext: " + messageContext2);
                }
                bl = handler.handleRequest(messageContext2);
                if (log.isDebugEnabled()) {
                    log.debug("Returning from: " + (String)object2 + ".handleRequest().  Return value is " + (bl ? "true" : "false"));
                }
                if (messageContext.isServer()) {
                    this.checkProtectedStateViolation(messageContext, (String)object2);
                }
                if (!bl) {
                    bl2 = true;
                } else {
                    ++n;
                }
                ((HandlerPool)object).put(handler);
            }
            catch (SOAPFaultException sOAPFaultException) {
                FFDCFilter.processException((Throwable)sOAPFaultException, "com.ibm.ws.webservices.engine.handlers.HandlerChain.handleRequest", "135", this);
                if (log.isDebugEnabled()) {
                    log.debug("Caught exception from: " + (String)object2 + ".handleRequest(). " + sOAPFaultException.toString());
                }
                bl2 = true;
                ((HandlerPool)object).put(handler);
                this.handleSOAPException(messageContext, (String)object2, n, bl3, bl4, (Message)object3, sOAPFaultException);
                throw sOAPFaultException;
            }
            catch (RuntimeException runtimeException) {
                Throwable throwable;
                FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandlerChain.handleRequest", "228", this);
                if (log.isDebugEnabled()) {
                    log.debug("Caught exception from: " + (String)object2 + ".handleRequest(). " + runtimeException.toString());
                }
                bl2 = true;
                if (runtimeException instanceof JAXRPCException && (throwable = WebServicesFault.getRootCause(runtimeException)) instanceof WebServicesFault) {
                    ((HandlerPool)object).put(handler);
                    this.handleSOAPException(messageContext, (String)object2, n, bl3, bl4, (Message)object3, throwable);
                    throw (WebServicesFault)throwable;
                }
                ((HandlerPool)object).faulted(handler);
                this.handleClosure(messageContext, n - 1);
                n = -1;
                if (messageContext.isServer()) {
                    this.handleRuntimeException(runtimeException, messageContext, (String)object2, "handleRequest");
                    continue;
                }
                throw WebServicesFault.makeFault(runtimeException);
            }
        }
        if (!bl) {
            if (bl3) {
                this.forceResponse(messageContext, (Message)object3, (String)object2, false, null);
            }
            if (n >= 0) {
                if (messageContext.isOneWay()) {
                    this.handleClosure(messageContext, n);
                } else {
                    object = new LoopControls(n, -1);
                    this.oneHandleResponse(messageContext, (LoopControls)object);
                    if (!bl3) {
                        this.forceResponse(messageContext, (Message)object3, (String)object2, true, null);
                    }
                    this.handleResponse(messageContext, (LoopControls)object);
                }
            }
        }
        return bl;
    }

    public void forceResponse(MessageContext messageContext, Message message, String string, boolean bl, Throwable throwable) throws MissingResourceException {
        messageContext.setPastPivot(true);
        if (!messageContext.isOneWay()) {
            Message message2 = messageContext.getRequestMessage();
            if (message2 == message) {
                if (messageContext.getResponseMessage() == null) {
                    if (bl) {
                        log.warn(Messages.getMessage("jaxRpcHandlerMissingResponse00", string));
                    }
                    if (throwable == null) {
                        SOAPFactory sOAPFactory = new SOAPFactory(messageContext.getSOAPConstants());
                        try {
                            SOAPEnvelope sOAPEnvelope = sOAPFactory.createSOAPEnvelope(true);
                            Message message3 = new Message(sOAPEnvelope);
                            messageContext.setResponseMessage(message3);
                        }
                        catch (SOAPException sOAPException) {
                            log.warn(Messages.getMessage("jaxRpcHandlerMissingResponse01"));
                        }
                    } else {
                        Message message4 = new Message(throwable);
                        messageContext.setResponseMessage(message4);
                    }
                }
            } else {
                messageContext.setResponseMessage(message2);
                messageContext.setRequestMessage(message);
            }
        }
    }

    protected void handleSOAPException(MessageContext messageContext, String string, int n, boolean bl, boolean bl2, Message message, Throwable throwable) throws WebServicesFault, MissingResourceException {
        if (messageContext.isServer()) {
            LoopControls loopControls = new LoopControls(n, -1);
            if (bl) {
                this.forceResponse(messageContext, message, string, false, throwable);
            }
            if (loopControls.idx() >= 0) {
                if (bl2) {
                    this.oneHandleFault(messageContext, loopControls);
                } else {
                    loopControls.next();
                }
            }
            if (!bl) {
                this.forceResponse(messageContext, message, string, true, throwable);
            }
            this.handleFault(messageContext, loopControls);
        } else {
            log.error(Messages.getMessage("jaxRpcHandlerRequestClientFault00", string));
            this.handleClosure(messageContext, n);
        }
    }

    protected com.ibm.wsspi.webservices.rpc.handler.MessageContext getHandlerMC(MessageContext messageContext) {
        return messageContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRuntimeException(RuntimeException runtimeException, MessageContext messageContext, String string, String string2) throws WebServicesFault {
        log.error(Messages.getMessage("jaxRpcHandlerServerRuntimeException00", string, string2), runtimeException);
        WebServicesFault webServicesFault = new WebServicesFault(QNameTable.createQName(messageContext.getSOAPConstants().getEnvelopeURI(), "Server.generalException"), Messages.getMessage("jaxRpcHandlerServerRuntimeException00", string, string2), string, null);
        if (!messageContext.isOneWay()) {
            Message message = messageContext.getResponseMessage();
            if (message != null) {
                String string3;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    message.writeTo(byteArrayOutputStream);
                    string3 = byteArrayOutputStream.toString();
                }
                catch (Exception exception) {
                    string3 = "!!responseMessage.writeTo() failed!!" + exception.toString();
                }
                finally {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
                log.info(Messages.getMessage("jaxRpcHandlerReplaceResponse00", string3));
            }
            message = new Message(webServicesFault);
            messageContext.setResponseMessage(message);
        }
        throw webServicesFault;
    }

    public boolean handleResponse(MessageContext messageContext) throws WebServicesFault {
        LoopControls loopControls = new LoopControls(this._handlerPools.size() - 1, -1);
        this.handleResponse(messageContext, loopControls);
        return loopControls.isResult();
    }

    private void handleResponse(MessageContext messageContext, LoopControls loopControls) throws WebServicesFault {
        while (!loopControls.isDone() && loopControls.idx() >= 0) {
            this.oneHandleResponse(messageContext, loopControls);
        }
    }

    private void oneHandleResponse(MessageContext messageContext, LoopControls loopControls) throws WebServicesFault {
        block12: {
            HandlerPool handlerPool = (HandlerPool)this._handlerPools.get(loopControls.idx());
            String string = handlerPool.getHandlerClassName();
            javax.xml.rpc.handler.Handler handler = handlerPool.get();
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Calling: " + string + ".handleResponse()");
                }
                loopControls.next();
                com.ibm.wsspi.webservices.rpc.handler.MessageContext messageContext2 = this.getHandlerMC(messageContext);
                boolean bl = handler.handleResponse(messageContext2);
                loopControls.setResult(bl);
                if (log.isDebugEnabled()) {
                    log.debug("Returning from: " + string + ".handleResponse().  Return value is " + (bl ? "true" : "false"));
                }
                handlerPool.put(handler);
                if (!loopControls.isResult()) {
                    loopControls.setDone(true);
                    this.handleClosure(messageContext, loopControls);
                    break block12;
                }
                if (loopControls.isDone() || loopControls.idx() < 0) break block12;
                try {
                    if (messageContext.getResponseMessage().getFault() != null) {
                        this.handleFault(messageContext, loopControls);
                    }
                }
                catch (SOAPException sOAPException) {
                    FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.handler.jaxrpc.JAXRPCHandlerChain.oneHandleResponse", "722", null);
                    throw WebServicesFault.makeFault(sOAPException);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.engine.handler.jaxrpc.JAXRPCHandlerChain.oneHandleResponse", "757", null);
                    throw WebServicesFault.makeFault(iOException);
                }
            }
            catch (RuntimeException runtimeException) {
                Throwable throwable;
                FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandlerChain.oneHandleResponse", "541", this);
                if (log.isDebugEnabled()) {
                    log.debug("Caught exception from: " + string + ".handleResponse(). " + runtimeException.toString());
                }
                loopControls.setDone(true);
                if (runtimeException instanceof JAXRPCException && (throwable = WebServicesFault.getRootCause(runtimeException)) instanceof WebServicesFault) {
                    handlerPool.put(handler);
                    this.handleClosure(messageContext, loopControls);
                    throw (WebServicesFault)throwable;
                }
                handlerPool.faulted(handler);
                this.handleClosure(messageContext, loopControls);
                if (messageContext.isServer()) {
                    this.handleRuntimeException(runtimeException, messageContext, string, "handleResponse");
                }
                throw WebServicesFault.makeFault(runtimeException);
            }
        }
    }

    public void handleClosure(MessageContext messageContext) {
        this.handleClosure(messageContext, this._handlerPools.size() - 1);
    }

    public void handleClosure(MessageContext messageContext, LoopControls loopControls) {
        int n = loopControls.idx();
        loopControls.clear();
        this.handleClosure(messageContext, n);
    }

    private void handleClosure(MessageContext messageContext, int n) {
        for (int i = n; i >= 0; --i) {
            HandlerPool handlerPool;
            if (!(class$com$ibm$wsspi$webservices$rpc$handler$Handler == null ? JAXRPCHandlerChain.class$("com.ibm.wsspi.webservices.rpc.handler.Handler") : class$com$ibm$wsspi$webservices$rpc$handler$Handler).isAssignableFrom((handlerPool = (HandlerPool)this._handlerPools.get(i)).getHandlerClass())) continue;
            String string = handlerPool.getHandlerClassName();
            Handler handler = (Handler)handlerPool.get();
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Calling: " + string + ".handleClosure()");
                }
                com.ibm.wsspi.webservices.rpc.handler.MessageContext messageContext2 = this.getHandlerMC(messageContext);
                handler.handleClosure(messageContext2);
                if (log.isDebugEnabled()) {
                    log.debug("Returning from: " + string + ".handleClosure()");
                }
                handlerPool.put(handler);
                continue;
            }
            catch (RuntimeException runtimeException) {
                if (log.isDebugEnabled()) {
                    log.debug("Ignoring caught exception from: " + string + ".handleClosure(). " + runtimeException.toString());
                }
                handlerPool.faulted(handler);
            }
        }
    }

    public boolean handleFault(MessageContext messageContext) throws WebServicesFault {
        LoopControls loopControls = new LoopControls(this._handlerPools.size() - 1, -1);
        this.handleFault(messageContext, loopControls);
        return loopControls.isResult();
    }

    private void handleFault(MessageContext messageContext, LoopControls loopControls) throws WebServicesFault {
        while (!loopControls.isDone() && loopControls.idx() >= 0) {
            this.oneHandleFault(messageContext, loopControls);
        }
    }

    private void oneHandleFault(MessageContext messageContext, LoopControls loopControls) throws WebServicesFault {
        HandlerPool handlerPool = (HandlerPool)this._handlerPools.get(loopControls.idx());
        String string = handlerPool.getHandlerClassName();
        javax.xml.rpc.handler.Handler handler = handlerPool.get();
        try {
            if (log.isDebugEnabled()) {
                log.debug("Calling: " + string + ".handleFault()");
            }
            loopControls.next();
            com.ibm.wsspi.webservices.rpc.handler.MessageContext messageContext2 = this.getHandlerMC(messageContext);
            boolean bl = handler.handleFault(messageContext2);
            loopControls.setResult(bl);
            if (log.isDebugEnabled()) {
                log.debug("Returning from: " + string + ".handleFault().  Return value is " + (bl ? "true" : "false"));
            }
            handlerPool.put(handler);
            if (!loopControls.isResult()) {
                loopControls.setDone(true);
                this.handleClosure(messageContext, loopControls);
            }
        }
        catch (RuntimeException runtimeException) {
            Throwable throwable;
            FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandlerChain.oneHandleFault", "681", this);
            if (log.isDebugEnabled()) {
                log.debug("Caught exception from: " + string + ".handleFault(). " + runtimeException.toString());
            }
            loopControls.setDone(true);
            if (runtimeException instanceof JAXRPCException && (throwable = WebServicesFault.getRootCause(runtimeException)) instanceof WebServicesFault) {
                handlerPool.put(handler);
                this.handleClosure(messageContext, loopControls);
                throw (WebServicesFault)throwable;
            }
            handlerPool.faulted(handler);
            this.handleClosure(messageContext, loopControls);
            if (messageContext.isServer()) {
                this.handleRuntimeException(runtimeException, messageContext, string, "handleFault");
            }
            throw WebServicesFault.makeFault(runtimeException);
        }
    }

    public void setRoles(String[] stringArray) {
        this._roles = new TreeSet();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                this._roles.add(string == null ? emptyString : string);
            }
        }
        this.addManditoryRoles();
    }

    public void setRoles(Collection collection) {
        this._roles = new TreeSet();
        if (collection != null && collection.size() > 0) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this._roles.add(string == null ? emptyString : string);
            }
        }
        this.addManditoryRoles();
    }

    private void addManditoryRoles() {
        this._roles.add("http://schemas.xmlsoap.org/soap/actor/next");
        this._roles.add("http://www.w3.org/2002/06/soap-envelope/actor/next");
    }

    public Collection getRoles() {
        return this._roles;
    }

    public Collection getHeaderQNames() {
        return this._headerQNames;
    }

    protected void checkProtectedStateViolation(MessageContext messageContext, String string) throws SOAPFaultException {
    }

    private Object wrapObject(Object object) {
        if (object instanceof HandlerInfo) {
            HandlerInfo handlerInfo = (HandlerInfo)object;
            try {
                QName[] qNameArray = handlerInfo.getHeaders();
                if (qNameArray != null) {
                    for (int i = 0; i < qNameArray.length; ++i) {
                        this._headerQNames.add(qNameArray[i]);
                    }
                }
                return HandlerPoolFactory.createHandlerPool((HandlerInfo)object);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.webservices.engine.handlers.HandlerChain.newHandlerPool", "170");
                String string = exception.getMessage() != null ? exception.getMessage() : JavaUtils.stackToString(exception);
                String string2 = Messages.getMessage("NoJAXRPCHandler00", handlerInfo.getHandlerClass().toString(), string);
                log.error(string2, exception);
                throw new JAXRPCException(string2, exception);
            }
        }
        throw new JAXRPCException("Internal: improper element type '" + object.getClass().getName() + "' for JAXRPCHandlerChain");
    }

    public void add(int n, Object object) {
        this._handlerPools.add(n, this.wrapObject(object));
    }

    public Object get(int n) {
        return ((HandlerPool)this._handlerPools.get(n)).getOriginalInfo();
    }

    public Object remove(int n) {
        HandlerPool handlerPool = (HandlerPool)this._handlerPools.get(n);
        HandlerInfo handlerInfo = handlerPool.getOriginalInfo();
        handlerPool.destroy();
        this._handlerPools.remove(n);
        QName[] qNameArray = handlerInfo.getHeaders();
        if (qNameArray != null) {
            for (int i = 0; i < qNameArray.length; ++i) {
                this._headerQNames.remove(qNameArray[i]);
            }
        }
        return handlerInfo;
    }

    public Object set(int n, Object object) {
        return this._handlerPools.set(n, this.wrapObject(object));
    }

    public int size() {
        return this._handlerPools.size();
    }

    private class LoopControls {
        private boolean _done = false;
        private boolean _result = true;
        private int _idx;
        private int _dir;

        LoopControls(int n, int n2) {
            this._idx = n;
            this._dir = n2;
        }

        void clear() {
            this._idx = -1;
        }

        void setDone(boolean bl) {
            this._done = bl;
        }

        void setResult(boolean bl) {
            this._result = bl;
        }

        boolean isDone() {
            return this._done;
        }

        boolean isResult() {
            return this._result;
        }

        void next() {
            this._idx += this._dir;
        }

        int idx() {
            return this._idx;
        }
    }
}

