/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.PreHandler;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import org.apache.commons.logging.Log;

public abstract class WrappedHandler
extends BasicHandler
implements PreHandler {
    protected static Log log = LogFactory.getLog(WrappedHandler.class.getName());

    protected abstract Handler getHandler(MessageContext var1) throws WebServicesFault;

    public void invoke(MessageContext messageContext) throws WebServicesFault {
        Handler handler = this.getHandler(messageContext);
        if (handler != null) {
            if (log.isDebugEnabled()) {
                log.debug("WrapperHandler.invoke(): handler.invoke()");
            }
            handler.invoke(messageContext);
        } else if (log.isDebugEnabled()) {
            log.debug("WrapperHandler.invoke(): NO handler!");
        }
    }

    public void onFault(MessageContext messageContext) {
        Handler handler;
        try {
            handler = this.getHandler(messageContext);
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.handlers.WrappedHandler.onFault", "80", this);
            log.info(Messages.getMessage("unexpectedException00"), webServicesFault);
            handler = null;
        }
        if (handler != null) {
            if (log.isDebugEnabled()) {
                log.debug("WrapperHandler.onFault(): handler.onFault()");
            }
            handler.onFault(messageContext);
        } else if (log.isDebugEnabled()) {
            log.debug("WrapperHandler.onFault(): NO handler!");
        }
    }

    public void preHandleIncoming(MessageContext messageContext) {
        Handler handler;
        try {
            handler = this.getHandler(messageContext);
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.handlers.WrappedHandler.preHandleIncoming", "104", this);
            log.info(Messages.getMessage("unexpectedException00"), webServicesFault);
            handler = null;
        }
        if (handler instanceof PreHandler) {
            if (log.isDebugEnabled()) {
                log.debug("WrapperHandler.preHandleIncoming(): handler.preHandleIncoming()");
            }
            ((PreHandler)handler).preHandleIncoming(messageContext);
        } else if (log.isDebugEnabled()) {
            if (handler != null) {
                log.debug("WrapperHandler.preHandleIncoming(): handler not instanceof PreHandler");
            } else {
                log.debug("WrapperHandler.preHandleIncoming(): NO handler!");
            }
        }
    }

    public void generateWSDL(MessageContext messageContext) throws WebServicesFault {
        Handler handler;
        if (log.isDebugEnabled()) {
            log.debug("Enter: WrapperHandler::generateWSDL");
        }
        if ((handler = this.getHandler(messageContext)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("WrapperHandler.generateWSDL(): handler.generateWSDL()");
            }
            handler.generateWSDL(messageContext);
        } else if (log.isDebugEnabled()) {
            log.debug("WrapperHandler.generateWSDL(): NO handler!");
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: WrapperHandler::generateWSDL");
        }
    }
}

