/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.dispatchers.java;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configurable.Configurable;
import com.ibm.ws.webservices.engine.dispatchers.java.JavaDispatcher;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;

public class EJBDispatcher
extends JavaDispatcher {
    protected static Log log = LogFactory.getLog(EJBDispatcher.class.getName());
    private static final String D_OPTION_BEANJNDINAME = "beanJndiName".intern();
    private static final String D_OPTION_HOMEINTERFACENAME = "homeInterfaceName".intern();
    private static final String D_OPTION_REMOTEINTERFACENAME = "remoteInterfaceName".intern();
    private static final String D_OPTION_INITIALCONTEXT = "Internal.InitialContext".intern();
    private static final String D_OPTION_REMOTEINTERFACE = "Internal.RemoteInterface".intern();
    private static final String D_OPTION_EJBHOME = "Internal.EJBHome".intern();
    public static final String jndiContextClass = "jndiContextClass".intern();
    public static final String jndiURL = "jndiURL".intern();
    public static final String jndiUsername = "jndiUser".intern();
    public static final String jndiPassword = "jndiPassword".intern();
    protected static final Class[] empty_class_array = new Class[0];
    protected static final Object[] empty_object_array = new Object[0];

    public static final void setBeanJndiName(Configurable configurable, String string) {
        configurable.setOption(D_OPTION_BEANJNDINAME, string);
    }

    public static final String getBeanJndiName(Configurable configurable) {
        return (String)configurable.getOption(D_OPTION_BEANJNDINAME);
    }

    public static final void setHomeInterfaceName(Configurable configurable, String string) {
        configurable.setOption(D_OPTION_HOMEINTERFACENAME, string);
    }

    public static final String getHomeInterfaceName(Configurable configurable) {
        return (String)configurable.getOption(D_OPTION_HOMEINTERFACENAME);
    }

    public static final void setRemoteInterfaceName(Configurable configurable, String string) {
        configurable.setOption(D_OPTION_REMOTEINTERFACENAME, string);
    }

    public static final String getRemoteInterfaceName(Configurable configurable) {
        return (String)configurable.getOption(D_OPTION_REMOTEINTERFACENAME);
    }

    public static final void setInitialContext(Configurable configurable, InitialContext initialContext) {
        configurable.setOption(D_OPTION_INITIALCONTEXT, initialContext);
    }

    public static final InitialContext getInitialContext(Configurable configurable) {
        return (InitialContext)configurable.getOption(D_OPTION_INITIALCONTEXT);
    }

    public static final void setRemoteInterface(Configurable configurable, Class clazz) {
        configurable.setOption(D_OPTION_REMOTEINTERFACE, clazz);
    }

    public static final Class getRemoteInterface(Configurable configurable) {
        return (Class)configurable.getOption(D_OPTION_REMOTEINTERFACE);
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public void invoke(MessageContext messageContext) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: EJBDispatcher::invoke (" + this + ")");
        }
        try {
            SOAPPort sOAPPort = messageContext.getPort();
            Object object = this.createServiceObject(sOAPPort);
            this.processMessage(messageContext, object);
        }
        catch (WebServicesFault webServicesFault) {
            throw webServicesFault;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.dispatchers.java.Dispatcher.invoke", "246", this);
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("toWebServicesFault00"), exception);
            }
            throw WebServicesFault.makeFault(exception);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("Exit: EJBDispatcher::invoke (" + this + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class getServiceClass(SOAPPort sOAPPort) throws WebServicesFault {
        Class clazz;
        SOAPPort sOAPPort2 = sOAPPort;
        synchronized (sOAPPort2) {
            clazz = EJBDispatcher.getRemoteInterface(sOAPPort);
            if (clazz == null) {
                try {
                    ClassLoader classLoader = this.getClassLoader();
                    String string = EJBDispatcher.getRemoteInterfaceName(sOAPPort);
                    if (string != null) {
                        clazz = ClassUtils.forName(string, true, classLoader);
                    } else {
                        Object object = this.getEJBHome(sOAPPort);
                        String string2 = EJBDispatcher.getHomeInterfaceName(sOAPPort);
                        if (string2 == null) {
                            throw new WebServicesFault(Messages.getMessage("noOption00", D_OPTION_HOMEINTERFACENAME, sOAPPort.getName()));
                        }
                        Class clazz2 = ClassUtils.forName(string2, true, classLoader);
                        Object object2 = PortableRemoteObject.narrow((Object)object, (Class)clazz2);
                        Method method = clazz2.getMethod("getEJBMetaData", empty_class_array);
                        Object object3 = method.invoke(object2, empty_object_array);
                        Method method2 = object3.getClass().getMethod("getRemoteInterfaceClass", empty_class_array);
                        clazz = (Class)method2.invoke(object3, empty_object_array);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.dispatchers.java.EJBDispatcher.getServiceClass", "252", this);
                    throw WebServicesFault.makeFault(exception);
                }
                EJBDispatcher.setRemoteInterface(sOAPPort, clazz);
            }
        }
        return clazz;
    }

    protected Object createServiceObject(SOAPPort sOAPPort) throws Exception {
        Object object = this.getEJBHome(sOAPPort);
        String string = EJBDispatcher.getHomeInterfaceName(sOAPPort);
        if (string == null) {
            throw new WebServicesFault(Messages.getMessage("noOption00", D_OPTION_HOMEINTERFACENAME, sOAPPort.getName()));
        }
        Class clazz = ClassUtils.forName(string, true, this.getClassLoader());
        Object object2 = PortableRemoteObject.narrow((Object)object, (Class)clazz);
        Method method = clazz.getMethod("create", empty_class_array);
        Object object3 = method.invoke(object2, empty_object_array);
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getEJBHome(SOAPPort sOAPPort) throws WebServicesFault {
        Object object;
        SOAPPort sOAPPort2 = sOAPPort;
        synchronized (sOAPPort2) {
            object = sOAPPort.getOption(D_OPTION_EJBHOME);
            if (object == null) {
                try {
                    InitialContext initialContext = this.getContext(sOAPPort);
                    if (initialContext == null) {
                        throw new WebServicesFault(Messages.getMessage("cannotCreateInitialContext00"));
                    }
                    String string = EJBDispatcher.getBeanJndiName(sOAPPort);
                    object = initialContext.lookup(string);
                    if (object == null) {
                        throw new WebServicesFault(Messages.getMessage("cannotFindJNDIHome00", string));
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.dispatchers.java.EJBDispatcher.getEJBHome", "328", this);
                    throw WebServicesFault.makeFault(exception);
                }
                sOAPPort.setOption(D_OPTION_EJBHOME, object);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InitialContext getContext(SOAPPort sOAPPort) throws WebServicesFault, NamingException {
        InitialContext initialContext;
        SOAPPort sOAPPort2 = sOAPPort;
        synchronized (sOAPPort2) {
            initialContext = EJBDispatcher.getInitialContext(sOAPPort);
            if (initialContext == null) {
                String string;
                String string2;
                String string3;
                Properties properties = null;
                String string4 = this.getStrOption(jndiUsername, sOAPPort);
                if (string4 != null) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setProperty("java.naming.security.principal", string4);
                }
                if ((string3 = this.getStrOption(jndiPassword, sOAPPort)) != null) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setProperty("java.naming.security.credentials", string3);
                }
                if ((string2 = this.getStrOption(jndiContextClass, sOAPPort)) != null) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setProperty("java.naming.factory.initial", string2);
                }
                if ((string = this.getStrOption(jndiURL, sOAPPort)) != null) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setProperty("java.naming.provider.url", string);
                }
                initialContext = new InitialContext(properties);
                EJBDispatcher.setInitialContext(sOAPPort, initialContext);
            }
        }
        return initialContext;
    }

    private String getStrOption(String string, Handler handler) {
        String string2 = null;
        if (handler != null) {
            string2 = (String)handler.getOption(string);
        }
        if (string2 == null) {
            string2 = (String)this.getOption(string);
        }
        return string2;
    }
}

