/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.configuration;

import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.SimpleTargetedChain;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configuration.NullEngineConfigurationProvider;
import com.ibm.ws.webservices.engine.description.PortDesc;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistryImpl;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;

public class SimpleEngineConfigurationProvider
extends NullEngineConfigurationProvider
implements EngineConfiguration {
    protected static Log log = LogFactory.getLog(SimpleEngineConfigurationProvider.class.getName());
    private HashMap _transports = new HashMap();
    private HashMap _soapPorts = new HashMap();
    private TypeMappingRegistry _tmr = null;
    private final EngineConfiguration _defaultConfiguration;

    public SimpleEngineConfigurationProvider() {
        this(null);
    }

    public SimpleEngineConfigurationProvider(EngineConfiguration engineConfiguration) {
        EngineConfiguration engineConfiguration2 = this._defaultConfiguration = engineConfiguration != null ? engineConfiguration : this.defaultEngineConfigurationFactory();
        if (this._defaultConfiguration != null) {
            this.manageLifeCycleOf(this._defaultConfiguration);
        }
    }

    protected EngineConfiguration defaultEngineConfigurationFactory() {
        return null;
    }

    public EngineConfiguration getDefaultEngineConfiguration() {
        return this._defaultConfiguration;
    }

    public Map getGlobalOptions() throws ConfigurationException {
        if (this._defaultConfiguration != null) {
            return this._defaultConfiguration.getGlobalOptions();
        }
        return null;
    }

    public SimpleTargetedChain getGlobalHandler() throws ConfigurationException {
        if (this._defaultConfiguration != null) {
            return this._defaultConfiguration.getGlobalHandler();
        }
        return null;
    }

    public TypeMappingRegistry getTypeMappingRegistry() throws ConfigurationException {
        if (this._tmr != null) {
            return this._tmr;
        }
        if (this._defaultConfiguration != null) {
            return this._defaultConfiguration.getTypeMappingRegistry();
        }
        this._tmr = new TypeMappingRegistryImpl();
        return this._tmr;
    }

    public TypeMapping getTypeMapping(String string) throws ConfigurationException {
        return (TypeMapping)this.getTypeMappingRegistry().getTypeMapping(string);
    }

    public Handler getTransport(QName qName) throws ConfigurationException {
        Handler handler = (Handler)this._transports.get(qName);
        if (this._defaultConfiguration != null && handler == null) {
            handler = this._defaultConfiguration.getTransport(qName);
        }
        return handler;
    }

    public SOAPPort getPort(QName qName) throws ConfigurationException {
        SOAPPort sOAPPort = (SOAPPort)this._soapPorts.get(qName);
        if (this._defaultConfiguration != null && sOAPPort == null) {
            sOAPPort = this._defaultConfiguration.getPort(qName);
        }
        return sOAPPort;
    }

    public SOAPPort getPortByNamespaceURI(String string) throws ConfigurationException {
        SOAPPort sOAPPort = (SOAPPort)this._soapPorts.get(QNameTable.createQName("", string));
        if (sOAPPort == null && this._defaultConfiguration != null) {
            sOAPPort = this._defaultConfiguration.getPortByNamespaceURI(string);
        }
        return sOAPPort;
    }

    public void deployPort(QName qName, SOAPPort sOAPPort) {
        SOAPPort sOAPPort2 = (SOAPPort)this._soapPorts.get(qName);
        if (sOAPPort2 != null && this.releaseLifeCycleManagementOf(sOAPPort2) && sOAPPort2.isActive()) {
            sOAPPort2.destroy();
        }
        if (sOAPPort != null) {
            this._soapPorts.put(qName, sOAPPort);
            this.manageLifeCycleOf(sOAPPort);
        }
    }

    public void deployPort(String string, SOAPPort sOAPPort) {
        this.deployPort(QNameTable.createQName(null, string), sOAPPort);
    }

    public void deployTransport(QName qName, SimpleTargetedChain simpleTargetedChain) {
        Handler handler = (Handler)this._transports.get(qName);
        if (handler != null && this.releaseLifeCycleManagementOf(handler) && handler.isActive()) {
            handler.destroy();
        }
        if (simpleTargetedChain != null) {
            this._transports.put(qName, simpleTargetedChain);
            this.manageLifeCycleOf(simpleTargetedChain);
        }
    }

    public void deployTransport(String string, SimpleTargetedChain simpleTargetedChain) {
        this.deployTransport(QNameTable.createQName(null, string), simpleTargetedChain);
    }

    public Iterator getDeployedPorts() throws ConfigurationException {
        ArrayList<PortDesc> arrayList = new ArrayList<PortDesc>();
        Iterator iterator = this._soapPorts.values().iterator();
        while (iterator.hasNext()) {
            SOAPPort sOAPPort = (SOAPPort)iterator.next();
            arrayList.add(sOAPPort.getPortDesc());
        }
        return arrayList.iterator();
    }
}

