/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.components.image;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.components.image.ImageIO;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedAction;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class MerlinIO
extends Component
implements ImageIO {
    private Exception propagateException = null;
    Exception propagateLoadException = null;

    public void saveImage(final String string, final Image image, final OutputStream outputStream) throws Exception {
        this.propagateException = null;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                MerlinIO.this.privilegedSaveImage(string, image, outputStream);
                return null;
            }
        });
        if (this.propagateException != null) {
            throw this.propagateException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void privilegedSaveImage(String string, Image image, OutputStream outputStream) {
        try {
            Iterator<ImageWriter> iterator = javax.imageio.ImageIO.getImageWritersByMIMEType(string);
            ImageWriter imageWriter = iterator.hasNext() ? iterator.next() : null;
            boolean bl = javax.imageio.ImageIO.getUseCache();
            javax.imageio.ImageIO.setUseCache(false);
            try {
                ImageOutputStream imageOutputStream = javax.imageio.ImageIO.createImageOutputStream(outputStream);
                imageWriter.setOutput(imageOutputStream);
                BufferedImage bufferedImage = null;
                if (image instanceof BufferedImage) {
                    bufferedImage = (BufferedImage)image;
                } else {
                    MediaTracker mediaTracker = new MediaTracker(this);
                    mediaTracker.addImage(image, 0);
                    mediaTracker.waitForAll();
                    bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.drawImage(image, 0, 0, null);
                }
                imageWriter.write(new IIOImage(bufferedImage, null, null));
                imageWriter.dispose();
            }
            finally {
                if (bl) {
                    javax.imageio.ImageIO.setUseCache(true);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.components.image.MerlinIO.privilegedSaveImage", "153", this);
            this.propagateException = exception;
        }
    }

    public Image loadImage(final InputStream inputStream) throws Exception {
        this.propagateLoadException = null;
        Image image = (Image)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return MerlinIO.this.privilegedLoadImage(inputStream);
            }
        });
        if (this.propagateLoadException != null) {
            throw this.propagateLoadException;
        }
        return image;
    }

    private Image privilegedLoadImage(InputStream inputStream) {
        try {
            return javax.imageio.ImageIO.read(inputStream);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.components.image.MerlinIO.privilegedLoadImage", "187", this);
            this.propagateLoadException = exception;
            return null;
        }
    }
}

