/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.client;

import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.PivotHandlerWrapper;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder;
import com.ibm.ws.webservices.engine.resources.Messages;
import org.apache.commons.logging.Log;

public class ClientEngine
extends WebServicesEngine {
    protected static Log log = LogFactory.getLog(ClientEngine.class.getName());

    public ClientEngine() {
        super(EngineConfigurationFactoryFinder.newFactory().getClientEngineConfig());
    }

    public ClientEngine(EngineConfiguration engineConfiguration) {
        super(engineConfiguration == null ? EngineConfigurationFactoryFinder.newFactory().getClientEngineConfig() : engineConfiguration);
    }

    public WebServicesEngine getClientEngine() {
        return this;
    }

    protected Handler createMessageFlow(MessageContext messageContext) throws WebServicesFault, ConfigurationException {
        Handler handler;
        String string = messageContext.getTransportName();
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("transport01", "ServerEngine.invoke", string));
        }
        if ((handler = this.getTransport(string)) == null) {
            throw new WebServicesFault(Messages.getMessage("noTransport00", string));
        }
        handler = PivotHandlerWrapper.factory(this.getGlobalHandler(), handler);
        return PivotHandlerWrapper.factory(messageContext.getPort(), handler);
    }

    public boolean isServer() {
        return false;
    }
}

