/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.AttachmentPart;
import com.ibm.ws.webservices.engine.attachments.BoundaryDelimitedStream;
import com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource;
import com.ibm.ws.webservices.engine.attachments.MultiPartInputStream;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import javax.activation.DataHandler;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import org.apache.commons.logging.Log;

public class MultiPartRelatedInputStream
extends MultiPartInputStream {
    protected static Log log = LogFactory.getLog(MultiPartRelatedInputStream.class.getName());
    public static final String MIME_MULTIPART_RELATED = "multipart/related";
    protected HashMap parts = new HashMap();
    protected LinkedList orderedParts = new LinkedList();
    protected int rootPartLength = 0;
    protected BoundaryDelimitedStream boundaryDelimitedStream = null;
    protected InputStream soapStreamBDS = null;
    protected byte[] boundary = null;
    protected ByteArrayInputStream cachedSOAPEnvelope = null;
    protected String contentLocation = null;
    protected String contentId = null;
    protected static final String[] READ_ALL = new String[]{" * \u0000 ".intern()};

    public MultiPartRelatedInputStream(String string, InputStream inputStream) throws WebServicesFault {
        super(null);
        if (log.isDebugEnabled()) {
            log.debug("Content-Type: " + string);
        }
        try {
            boolean bl;
            Object object;
            String string2;
            CharSequence charSequence;
            Object object2;
            String string3 = "type=text/xml;";
            int n = string.indexOf(string3);
            if (n >= 0) {
                object2 = new StringBuffer(string);
                object2 = ((StringBuffer)object2).delete(n, n + string3.length());
                object2 = ((StringBuffer)object2).append("; type=\"text/xml\"");
                string = ((StringBuffer)object2).toString();
                if (log.isDebugEnabled()) {
                    log.debug("Content-Type edited to: " + string);
                }
            }
            if (string.indexOf("type=\"text/xml\"") == -1) {
                int n2;
                if (log.isDebugEnabled()) {
                    log.debug("Invalid Content-Type header: No parameter type=\"text/xml\" given");
                }
                if ((n2 = string.indexOf((String)(object2 = " type=\"application/xop+xml\";"))) >= 0) {
                    charSequence = new StringBuffer(string);
                    string2 = ((StringBuffer)(charSequence = ((StringBuffer)charSequence).delete(n2, n2 + ((String)object2).length()))).toString().trim();
                    charSequence = string2.endsWith(";") ? ((StringBuffer)charSequence).append(" type=\"text/xml\"") : ((StringBuffer)charSequence).append("; type=\"text/xml\"");
                    string = ((StringBuffer)charSequence).toString();
                    if (log.isDebugEnabled()) {
                        log.debug("Content-Type edited to: " + string);
                    }
                }
            }
            object2 = new ContentType(string);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            charSequence = ((ContentType)object2).getParameter("start");
            if (((ContentType)object2).getParameter("boundary") != null) {
                string2 = "--" + ((ContentType)object2).getParameter("boundary");
                if (charSequence != null) {
                    if (((String)(charSequence = ((String)charSequence).trim())).startsWith("<")) {
                        charSequence = ((String)charSequence).substring(1);
                    }
                    if (((String)charSequence).endsWith(">")) {
                        charSequence = ((String)charSequence).substring(0, ((String)charSequence).length() - 1);
                    }
                }
                object = new byte[2][string2.length() + 2];
                dataInputStream.readFully((byte[])object[0]);
                this.boundary = (string2 + "\r\n").getBytes("US-ASCII");
                int n3 = 0;
                bl = false;
                while (!bl) {
                    bl = Arrays.equals((byte[])object[n3 & 1], this.boundary);
                    if (!bl) {
                        System.arraycopy(object[n3 & 1], 1, object[n3 + 1 & 1], 0, ((Object)object[0]).length - 1);
                        if (dataInputStream.read((byte[])object[n3 + 1 & 1], ((Object)object[0]).length - 1, 1) < 1) {
                            throw new WebServicesFault(Messages.getMessage("mimeErrorNoBoundary", new String(this.boundary)));
                        }
                    }
                    ++n3;
                }
                string2 = "\r\n" + string2;
                this.boundary = string2.getBytes("US-ASCII");
                if (log.isDebugEnabled()) {
                    log.debug("[1] Boundary found: " + string2);
                }
            } else {
                string2 = "--";
                object = string2.getBytes("US-ASCII");
                byte[] byArray = new byte[((byte[])object).length];
                dataInputStream.readFully(byArray);
                bl = false;
                while (!bl) {
                    bl = Arrays.equals((byte[])object, byArray);
                    if (bl || dataInputStream.read(byArray) >= 1) continue;
                    throw new WebServicesFault(Messages.getMessage("mimeErrorNoBoundary", string2));
                }
                string2 = "\r\n--" + this.readBoundary(dataInputStream);
                this.boundary = string2.getBytes("US-ASCII");
                if (log.isDebugEnabled()) {
                    log.debug("[2] Boundary found: " + string2);
                }
            }
            this.boundaryDelimitedStream = new BoundaryDelimitedStream(dataInputStream, this.boundary, 1024);
            string2 = null;
            do {
                this.contentId = null;
                this.contentLocation = null;
                string2 = null;
                object = new InternetHeaders(this.boundaryDelimitedStream);
                this.contentId = ((InternetHeaders)object).getHeader("Content-Id", null);
                if (this.contentId != null) {
                    this.contentId = this.contentId.trim();
                    if (this.contentId.startsWith("<")) {
                        this.contentId = this.contentId.substring(1);
                    }
                    if (this.contentId.endsWith(">")) {
                        this.contentId = this.contentId.substring(0, this.contentId.length() - 1);
                    }
                    this.contentId = this.contentId.trim();
                }
                this.contentLocation = ((InternetHeaders)object).getHeader("Content-Location", null);
                if (this.contentLocation != null) {
                    this.contentLocation = this.contentLocation.trim();
                    if (this.contentLocation.startsWith("<")) {
                        this.contentLocation = this.contentLocation.substring(1);
                    }
                    if (this.contentLocation.endsWith(">")) {
                        this.contentLocation = this.contentLocation.substring(0, this.contentLocation.length() - 1);
                    }
                    this.contentLocation = this.contentLocation.trim();
                }
                if ((string = ((InternetHeaders)object).getHeader("Content-Type", null)) != null) {
                    string = string.trim();
                }
                if ((string2 = ((InternetHeaders)object).getHeader("Content-Transfer-Encoding", null)) != null) {
                    string2 = string2.trim();
                }
                InputStream inputStream2 = this.boundaryDelimitedStream;
                if (string2 != null && 0 != string2.length()) {
                    inputStream2 = MimeUtility.decode(inputStream2, string2);
                }
                if (charSequence == null || ((String)charSequence).equals(this.contentId)) continue;
                DataHandler dataHandler = new DataHandler(new ManagedMemoryDataSource(inputStream2, string));
                AttachmentPart attachmentPart = new AttachmentPart(dataHandler);
                if (this.contentId != null) {
                    attachmentPart.setMimeHeader("Content-Id", this.contentId);
                }
                if (this.contentLocation != null) {
                    attachmentPart.setMimeHeader("Content-Location", this.contentLocation);
                }
                Enumeration enumeration = ((InternetHeaders)object).getNonMatchingHeaders(new String[]{"Content-Id", "Content-Location", "Content-Type"});
                while (enumeration.hasMoreElements()) {
                    Header header = (Header)enumeration.nextElement();
                    String string4 = header.getName();
                    String string5 = header.getValue();
                    if (string4 == null || string5 == null || (string4 = string4.trim()).length() == 0) continue;
                    attachmentPart.addMimeHeader(string4, string5);
                }
                this.addPart(this.contentId, this.contentLocation, attachmentPart);
                this.boundaryDelimitedStream = this.boundaryDelimitedStream.getNextStream();
            } while (null != this.boundaryDelimitedStream && charSequence != null && !((String)charSequence).equals(this.contentId));
            if (this.boundaryDelimitedStream == null) {
                throw new WebServicesFault(Messages.getMessage("noRoot", (String)charSequence));
            }
            this.soapStreamBDS = this.boundaryDelimitedStream;
            this.soapStream = string2 != null && 0 != string2.length() ? MimeUtility.decode(this.boundaryDelimitedStream, string2) : this.boundaryDelimitedStream;
        }
        catch (ParseException parseException) {
            FFDCFilter.processException((Throwable)parseException, "com.ibm.ws.webservices.engine.attachments.MultiPartRelatedInputStream.MultiPartRelatedInputStream", "447", this);
            throw new WebServicesFault(Messages.getMessage("mimeErrorParsing", parseException.getMessage()));
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.engine.attachments.MultiPartRelatedInputStream.MultiPartRelatedInputStream", "451", this);
            throw new WebServicesFault(Messages.getMessage("readError", iOException.getMessage()));
        }
        catch (MessagingException messagingException) {
            FFDCFilter.processException((Throwable)messagingException, "com.ibm.ws.webservices.engine.attachments.MultiPartRelatedInputStream.MultiPartRelatedInputStream", "455", this);
            throw new WebServicesFault(Messages.getMessage("readError", messagingException.getMessage()));
        }
    }

    private final String readBoundary(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        boolean bl = false;
        block4: while (!bl) {
            n = inputStream.read();
            switch (n) {
                case -1: 
                case 10: {
                    bl = true;
                    continue block4;
                }
                case 13: {
                    bl = true;
                    inputStream.read();
                    continue block4;
                }
            }
            stringBuffer.append((char)n);
        }
        if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public Part getAttachmentByReference(String[] stringArray) throws WebServicesFault {
        Part part = null;
        for (int i = stringArray.length - 1; part == null && i > -1; --i) {
            part = (AttachmentPart)this.parts.get(stringArray[i]);
        }
        if (null == part) {
            part = this.readTillFound(stringArray);
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("return02", "getAttachmentByReference(\"" + stringArray + "\"", part == null ? "null" : part.toString()));
        }
        return part;
    }

    protected void addPart(String string, String string2, AttachmentPart attachmentPart) {
        if (string != null && string.trim().length() != 0) {
            this.parts.put(string, attachmentPart);
        }
        if (string2 != null && string2.trim().length() != 0) {
            this.parts.put(string2, attachmentPart);
        }
        this.orderedParts.add(attachmentPart);
    }

    protected void readAll() throws WebServicesFault {
        this.readTillFound(READ_ALL);
    }

    public Collection getAttachments() throws WebServicesFault {
        this.readAll();
        return this.orderedParts;
    }

    protected Part readTillFound(String[] stringArray) throws WebServicesFault {
        if (this.boundaryDelimitedStream == null) {
            return null;
        }
        AttachmentPart attachmentPart = null;
        try {
            Object object;
            Object object2;
            if (this.soapStreamBDS == this.boundaryDelimitedStream) {
                if (!this.eos) {
                    object2 = new ByteArrayOutputStream(8192);
                    object = new byte[16384];
                    int n = 0;
                    do {
                        if ((n = this.soapStream.read((byte[])object)) <= 0) continue;
                        ((ByteArrayOutputStream)object2).write((byte[])object, 0, n);
                    } while (n > -1);
                    ((ByteArrayOutputStream)object2).close();
                    this.soapStream = new ByteArrayInputStream(((ByteArrayOutputStream)object2).toByteArray());
                }
                this.boundaryDelimitedStream = this.boundaryDelimitedStream.getNextStream();
            }
            if (null != this.boundaryDelimitedStream) {
                do {
                    object2 = null;
                    object = null;
                    String string = null;
                    String string2 = null;
                    InternetHeaders internetHeaders = new InternetHeaders(this.boundaryDelimitedStream);
                    object = internetHeaders.getHeader("Content-Id", null);
                    if (object != null) {
                        if (((String)(object = ((String)object).trim())).startsWith("<")) {
                            object = ((String)object).substring(1);
                        }
                        if (((String)object).endsWith(">")) {
                            object = ((String)object).substring(0, ((String)object).length() - 1);
                        }
                        object = ((String)object).trim();
                    }
                    if ((object2 = internetHeaders.getHeader("Content-Type", null)) != null) {
                        object2 = ((String)object2).trim();
                    }
                    if ((string2 = internetHeaders.getHeader("Content-Location", null)) != null) {
                        string2 = string2.trim();
                    }
                    if ((string = internetHeaders.getHeader("Content-Transfer-Encoding", null)) != null) {
                        string = string.trim();
                    }
                    InputStream inputStream = this.boundaryDelimitedStream;
                    if (string != null && 0 != string.length()) {
                        inputStream = MimeUtility.decode(inputStream, string);
                    }
                    DataHandler dataHandler = new DataHandler(new ManagedMemoryDataSource(inputStream, (String)object2));
                    AttachmentPart attachmentPart2 = new AttachmentPart(dataHandler);
                    if (object != null) {
                        attachmentPart2.setMimeHeader("Content-Id", (String)object);
                    }
                    if (string2 != null) {
                        attachmentPart2.setMimeHeader("Content-Location", string2);
                    }
                    Enumeration enumeration = internetHeaders.getNonMatchingHeaders(new String[]{"Content-Id", "Content-Location", "Content-Type"});
                    while (enumeration.hasMoreElements()) {
                        Header header = (Header)enumeration.nextElement();
                        String string3 = header.getName();
                        String string4 = header.getValue();
                        if (string3 == null || string4 == null || (string3 = string3.trim()).length() == 0) continue;
                        attachmentPart2.addMimeHeader(string3, string4);
                    }
                    this.addPart((String)object, string2, attachmentPart2);
                    for (int i = stringArray.length - 1; attachmentPart == null && i > -1; --i) {
                        if (object != null && stringArray[i].equals(object)) {
                            attachmentPart = attachmentPart2;
                            continue;
                        }
                        if (string2 == null || !stringArray[i].equals(string2)) continue;
                        attachmentPart = attachmentPart2;
                    }
                    this.boundaryDelimitedStream = this.boundaryDelimitedStream.getNextStream();
                } while (null == attachmentPart && null != this.boundaryDelimitedStream);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.attachments.MultiPartRelatedInputStream.readTillFound", "664", this);
            throw WebServicesFault.makeFault(exception);
        }
        return attachmentPart;
    }

    public String getContentLocation() {
        return this.contentLocation;
    }

    public String getContentId() {
        return this.contentId;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException(Messages.getMessage("streamClosed"));
        }
        if (this.eos) {
            return -1;
        }
        int n3 = this.soapStream.read(byArray, n, n2);
        if (n3 < 0) {
            this.eos = true;
        }
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(Messages.getMessage("streamClosed"));
        }
        if (this.eos) {
            return -1;
        }
        int n = this.soapStream.read();
        if (n < 0) {
            this.eos = true;
        }
        return n;
    }
}

