/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.logging.Log;

public class BoundaryDelimitedStream
extends FilterInputStream {
    protected static Log log = LogFactory.getLog(BoundaryDelimitedStream.class.getName());
    protected byte[] boundary = null;
    int boundaryLen = 0;
    int boundaryBufLen = 0;
    InputStream is = null;
    boolean closed = true;
    boolean eos = false;
    boolean theEnd = false;
    int readbufsz = 0;
    byte[] readbuf = null;
    int readBufPos = 0;
    int readBufEnd = 0;
    protected static final int BOUNDARY_NOT_FOUND = Integer.MAX_VALUE;
    int boundaryPos = Integer.MAX_VALUE;
    static int streamCount = 0;
    protected int streamNo = -1;
    static boolean isDebugEnabled = false;
    private int[] skip = null;

    protected static synchronized int newStreamNo() {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("streamNo", "" + (streamCount + 1)));
        }
        return ++streamCount;
    }

    public synchronized BoundaryDelimitedStream getNextStream() throws IOException {
        return this.getNextStream(this.readbufsz);
    }

    protected synchronized BoundaryDelimitedStream getNextStream(int n) throws IOException {
        BoundaryDelimitedStream boundaryDelimitedStream = null;
        if (!this.theEnd) {
            boundaryDelimitedStream = new BoundaryDelimitedStream(this, n);
        }
        return boundaryDelimitedStream;
    }

    protected BoundaryDelimitedStream(BoundaryDelimitedStream boundaryDelimitedStream, int n) throws IOException {
        super(null);
        this.streamNo = BoundaryDelimitedStream.newStreamNo();
        this.boundary = boundaryDelimitedStream.boundary;
        this.boundaryLen = boundaryDelimitedStream.boundaryLen;
        this.boundaryBufLen = boundaryDelimitedStream.boundaryBufLen;
        this.skip = boundaryDelimitedStream.skip;
        this.is = boundaryDelimitedStream.is;
        this.closed = false;
        this.eos = false;
        n = boundaryDelimitedStream.readbufsz;
        this.readbuf = boundaryDelimitedStream.readbuf;
        this.readBufPos = boundaryDelimitedStream.readBufPos + this.boundaryBufLen;
        this.readBufEnd = boundaryDelimitedStream.readBufEnd;
        this.boundaryPos = this.boundaryPosition(this.readbuf, this.readBufPos, this.readBufEnd);
        boundaryDelimitedStream.theEnd = this.theEnd;
    }

    BoundaryDelimitedStream(InputStream inputStream, byte[] byArray, int n) throws WebServicesFault {
        super(null);
        isDebugEnabled = log.isDebugEnabled();
        this.streamNo = BoundaryDelimitedStream.newStreamNo();
        this.closed = false;
        this.is = inputStream;
        this.boundary = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.boundary, 0, byArray.length);
        this.boundaryLen = this.boundary.length;
        this.boundaryBufLen = this.boundaryLen + 2;
        this.readbufsz = Math.max(this.boundaryBufLen * 2, n);
    }

    private final int readFromStream(byte[] byArray) throws IOException {
        return this.readFromStream(byArray, 0, byArray.length);
    }

    private final int readFromStream(byte[] byArray, int n, int n2) throws IOException {
        int n3 = Math.max(this.boundaryBufLen * 2, n2);
        n3 = Math.min(n3, n2 - n);
        int n4 = 0;
        int n5 = 0;
        do {
            if ((n4 = this.is.read(byArray, n5 + n, n2 - n5)) <= 0) continue;
            n5 += n4;
        } while (n4 > -1 && n5 < n3);
        return n5 != 0 ? n5 : n4;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException(Messages.getMessage("streamClosed"));
        }
        if (this.eos) {
            return -1;
        }
        if (this.readbuf == null) {
            this.readbuf = new byte[Math.max(n2, this.readbufsz)];
            this.readBufEnd = this.readFromStream(this.readbuf);
            if (this.readBufEnd < 0) {
                this.readbuf = null;
                this.closed = true;
                this.finalClose();
                throw new IOException(Messages.getMessage("eosBeforeMarker"));
            }
            this.readBufPos = 0;
            this.boundaryPos = this.boundaryPosition(this.readbuf, 0, this.readBufEnd);
        }
        int n3 = 0;
        do {
            int n4 = Math.min(this.readBufEnd - this.readBufPos - this.boundaryBufLen, n2 - n3);
            if ((n4 = Math.min(n4, this.boundaryPos - this.readBufPos)) > 0) {
                System.arraycopy(this.readbuf, this.readBufPos, byArray, n + n3, n4);
                n3 += n4;
                this.readBufPos += n4;
            }
            if (this.readBufPos == this.boundaryPos) {
                this.eos = true;
                if (!log.isDebugEnabled()) continue;
                log.debug(Messages.getMessage("atEOS", "" + this.streamNo));
                continue;
            }
            if (n3 >= n2) continue;
            byte[] byArray2 = this.readbuf;
            if (this.readbuf.length < n2) {
                byArray2 = new byte[n2];
            }
            int n5 = this.readBufEnd - this.readBufPos;
            System.arraycopy(this.readbuf, this.readBufPos, byArray2, 0, n5);
            int n6 = this.readFromStream(byArray2, n5, byArray2.length - n5);
            if (n6 < 0) {
                this.readbuf = null;
                this.closed = true;
                this.finalClose();
                throw new IOException(Messages.getMessage("eosBeforeMarker"));
            }
            this.readBufEnd = n6 + n5;
            this.readbuf = byArray2;
            this.readBufPos = 0;
            if (Integer.MAX_VALUE != this.boundaryPos) {
                this.boundaryPos -= n5;
                continue;
            }
            this.boundaryPos = this.boundaryPosition(this.readbuf, this.readBufPos, this.readBufEnd);
        } while (!this.eos && n3 < n2);
        if (log.isDebugEnabled() && n3 > 0) {
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray, n, byArray3, 0, n3);
            log.debug(Messages.getMessage("readBStream", new String[]{"" + n3, "" + this.streamNo, new String(byArray3)}));
        }
        if (this.eos && this.theEnd) {
            this.readbuf = null;
        }
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray);
        if (n < 0) {
            return -1;
        }
        return byArray[0];
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("bStreamClosed", "" + this.streamNo));
        }
        this.closed = true;
        if (!this.eos) {
            byte[] byArray = new byte[16384];
            int n = 0;
            while ((n = this.read(byArray)) > -1) {
            }
        }
    }

    public void mark(int n) {
    }

    public void reset() throws IOException {
        throw new IOException(Messages.getMessage("attach.bounday.mns"));
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        int n = this.readBufEnd - this.readBufPos - this.boundaryBufLen;
        n = Math.min(n, this.boundaryPos - this.readBufPos);
        return Math.max(0, n);
    }

    protected int boundaryPosition(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.boundarySearch(byArray, n, n2);
        if (Integer.MAX_VALUE != n3) {
            if (n3 + this.boundaryLen + 2 > n2) {
                n3 = Integer.MAX_VALUE;
            } else if (byArray[n3 + this.boundaryLen] == 45 && byArray[n3 + this.boundaryLen + 1] == 45) {
                this.finalClose();
            } else if (byArray[n3 + this.boundaryLen] != 13 || byArray[n3 + this.boundaryLen + 1] != 10) {
                n3 = Integer.MAX_VALUE;
            }
        }
        return n3;
    }

    private int boundarySearch(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.boundaryLen > n2 - n) {
            return Integer.MAX_VALUE;
        }
        if (null == this.skip) {
            this.skip = new int[256];
            Arrays.fill(this.skip, this.boundaryLen);
            for (n5 = 0; n5 < this.boundaryLen - 1; ++n5) {
                this.skip[this.boundary[n5]] = this.boundaryLen - n5 - 1;
            }
        }
        for (n5 = n + this.boundaryLen - 1; n5 < n2; n5 += this.skip[byArray[n5] & 0xFF]) {
            try {
                n3 = n5;
                for (n4 = this.boundaryLen - 1; n4 >= 0 && byArray[n3] == this.boundary[n4]; --n4) {
                    --n3;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                FFDCFilter.processException((Throwable)arrayIndexOutOfBoundsException, "com.ibm.ws.webservices.engine.attachments.BoundaryDelimitedStream.boundarySearch", "588", this);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(">>>" + arrayIndexOutOfBoundsException);
                stringBuffer.append("start=" + n);
                stringBuffer.append("k=" + n5);
                stringBuffer.append("text.length=" + byArray.length);
                stringBuffer.append("i=" + n3);
                stringBuffer.append("boundary.length=" + this.boundary.length);
                stringBuffer.append("j=" + n4);
                stringBuffer.append("end=" + n2);
                log.warn(Messages.getMessage("exception01", stringBuffer.toString()));
                throw arrayIndexOutOfBoundsException;
            }
            if (n4 != -1) continue;
            return n3 + 1;
        }
        return Integer.MAX_VALUE;
    }

    protected void finalClose() throws IOException {
        if (this.theEnd) {
            return;
        }
        this.theEnd = true;
        this.is.close();
        this.is = null;
    }

    public static void printarry(byte[] byArray, int n, int n2) {
        if (log.isDebugEnabled()) {
            byte[] byArray2 = new byte[n2 - n];
            System.arraycopy(byArray, n, byArray2, 0, n2 - n);
            log.debug("\"" + new String(byArray2) + "\"");
        }
    }
}

