/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.Base64;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.SessionUtils;
import com.ibm.ws.webservices.utils.WebServicesInputSource;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.UnsupportedDataTypeException;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;

public class AttachmentPart
extends javax.xml.soap.AttachmentPart
implements Part {
    protected static Log log = LogFactory.getLog(AttachmentPart.class.getName());
    DataHandler datahandler = null;
    private MimeHeaders mimeHeaders = new MimeHeaders();
    private Object contentObject;
    private String contentIdPartName;

    public AttachmentPart() {
        this.setMimeHeader("Content-Id", SessionUtils.generateSessionId());
    }

    public AttachmentPart(DataHandler dataHandler) {
        this.setMimeHeader("Content-Id", SessionUtils.generateSessionId());
        this.datahandler = dataHandler;
        if (dataHandler != null) {
            this.setMimeHeader("Content-Type", dataHandler.getContentType());
        }
    }

    public AttachmentPart(DataHandler dataHandler, String string) {
        this.setMimeHeader("Content-Id", (string == null ? "" : string + "=") + SessionUtils.generateSessionId());
        this.contentIdPartName = string;
        this.datahandler = dataHandler;
        if (dataHandler != null) {
            this.setMimeHeader("Content-Type", dataHandler.getContentType());
        }
    }

    public AttachmentPart(DataHandler dataHandler, String string, String string2) {
        this.setMimeHeader("Content-Id", (string == null ? "" : string + "=") + (string2 == null ? SessionUtils.generateSessionId() : string2));
        this.contentIdPartName = string;
        this.datahandler = dataHandler;
        if (dataHandler != null) {
            this.setMimeHeader("Content-Type", dataHandler.getContentType());
        }
    }

    public DataHandler getActivationDataHandler() {
        return this.datahandler;
    }

    public String getContentType() {
        return this.getFirstMimeHeader("Content-Type");
    }

    public void addMimeHeader(String string, String string2) {
        this.mimeHeaders.addHeader(string, string2);
    }

    public String getFirstMimeHeader(String string) {
        String[] stringArray = this.mimeHeaders.getHeader(string.toLowerCase());
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public boolean matches(MimeHeaders mimeHeaders) {
        Iterator iterator = mimeHeaders.getAllHeaders();
        while (iterator.hasNext()) {
            MimeHeader mimeHeader = (MimeHeader)iterator.next();
            String[] stringArray = this.mimeHeaders.getHeader(mimeHeader.getName());
            boolean bl = false;
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!mimeHeader.getValue().equalsIgnoreCase(stringArray[i])) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public String getContentLocation() {
        return this.getFirstMimeHeader("Content-Location");
    }

    public void setContentLocation(String string) {
        this.setMimeHeader("Content-Location", string);
    }

    public void setContentId(String string) {
        this.setMimeHeader("Content-Id", string);
    }

    public String getContentId() {
        return this.getFirstMimeHeader("Content-Id");
    }

    public String getContentIdPartName() {
        String string;
        int n;
        if (this.contentIdPartName == null && (n = (string = this.getContentId()).indexOf("=")) >= 0) {
            this.contentIdPartName = string.substring(0, n);
        }
        return this.contentIdPartName;
    }

    public Iterator getMatchingMimeHeaders(String[] stringArray) {
        return this.mimeHeaders.getMatchingHeaders(stringArray);
    }

    public Iterator getNonMatchingMimeHeaders(String[] stringArray) {
        return this.mimeHeaders.getNonMatchingHeaders(stringArray);
    }

    public Iterator getAllMimeHeaders() {
        return this.mimeHeaders.getAllHeaders();
    }

    public void setMimeHeader(String string, String string2) {
        if (string2 != null && string2.length() > 0 && string2.startsWith("<") && string2.endsWith(">")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        this.mimeHeaders.setHeader(string, string2);
    }

    public void removeAllMimeHeaders() {
        this.mimeHeaders.removeAllHeaders();
    }

    public void removeMimeHeader(String string) {
        this.mimeHeaders.removeHeader(string);
    }

    public DataHandler getDataHandler() throws SOAPException {
        if (this.datahandler == null) {
            throw new SOAPException(Messages.getMessage("noContent"));
        }
        return this.datahandler;
    }

    public void setDataHandler(DataHandler dataHandler) {
        if (dataHandler == null) {
            throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
        }
        this.datahandler = dataHandler;
        this.setMimeHeader("Content-Type", dataHandler.getContentType());
    }

    public Object getContent() throws SOAPException {
        if (this.contentObject != null) {
            if (log.isDebugEnabled()) {
                log.debug("Using cached content object = " + this.contentObject.getClass().getCanonicalName());
            }
            return this.contentObject;
        }
        if (this.datahandler == null) {
            throw new SOAPException(Messages.getMessage("noContent"));
        }
        try {
            DataSource dataSource;
            if (log.isDebugEnabled()) {
                log.debug("Building content object from DataHandler");
            }
            if ((dataSource = this.datahandler.getDataSource()).getContentType().equals("text/plain") || dataSource.getContentType().equals("text/html") || dataSource.getContentType().equals("text/xml")) {
                Object object;
                InputStream inputStream;
                String string = null;
                byte[] byArray = new byte[]{};
                try {
                    inputStream = null;
                    object = dataSource;
                    inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction((DataSource)object){
                        private final /* synthetic */ DataSource val$finalds;
                        {
                            this.val$finalds = dataSource;
                        }

                        public Object run() throws IOException {
                            return this.val$finalds.getInputStream();
                        }
                    });
                    DataInputStream dataInputStream = new DataInputStream(inputStream);
                    byArray = new byte[dataInputStream.available()];
                    dataInputStream.read(byArray);
                    string = new String(byArray);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.webservices.engine.attachments.AttachmentPart.getContent", "406", this);
                    log.error(Messages.getMessage("javaIOException00"), privilegedActionException.getException());
                }
                if (dataSource.getContentType().equals("text/plain") || dataSource.getContentType().equals("text/html")) {
                    if (log.isDebugEnabled()) {
                        log.debug("Content Type = " + dataSource.getContentType());
                        log.debug("Content = " + string);
                    }
                    this.contentObject = string;
                    return this.contentObject;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Content Type = " + dataSource.getContentType());
                    log.debug("Content is a StreamSource containing= " + string);
                }
                inputStream = new ByteArrayInputStream(byArray);
                object = new StreamSource(inputStream);
                return object;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Content Type = " + dataSource.getContentType());
                    log.debug("Using DataHandler.getContent() to get the content");
                }
                return this.datahandler.getContent();
            }
            catch (UnsupportedDataTypeException unsupportedDataTypeException) {
                if (log.isDebugEnabled()) {
                    log.debug("The DataHandler can't get the content.  Fallback to the DataHandler InputStream as indicated by the SAAJ specification.");
                }
                return dataSource.getInputStream();
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.engine.attachments.AttachmentPart.getContent", "409", this);
            log.error(Messages.getMessage("javaIOException00"), iOException);
            return null;
        }
    }

    public void setContent(Object object, String string) {
        Object object2;
        if (log.isDebugEnabled()) {
            object2 = object == null ? null : object.getClass().getCanonicalName();
            log.debug("content = " + (String)object2);
            log.debug("contentType = " + string);
        }
        object2 = null;
        if (object instanceof String) {
            object2 = new ByteArrayInputStream(((String)object).getBytes());
        } else if (object instanceof byte[]) {
            object2 = new ByteArrayInputStream((byte[])object);
        } else if (object instanceof InputStream) {
            object2 = (InputStream)object;
        } else if (object instanceof StreamSource) {
            object2 = ((StreamSource)object).getInputStream();
        }
        try {
            if (object2 != null) {
                ManagedMemoryDataSource managedMemoryDataSource = new ManagedMemoryDataSource((InputStream)object2, string);
                this.datahandler = new DataHandler(managedMemoryDataSource);
            } else {
                this.datahandler = new DataHandler(object, string);
            }
            this.contentObject = string != null && (string.equals("text/plain") || string.equals("text/html")) ? (object instanceof String ? object : null) : (string != null && string.equals("text/xml") ? null : (string != null && (string.equals("image/jpeg") || string.equals("image/gif")) ? (object instanceof Image ? object : null) : null));
            this.removeMimeHeader("Content-Type");
            this.setMimeHeader("Content-Type", string);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.engine.attachments.AttachmentPart.setContent", "414", this);
            log.error(Messages.getMessage("javaIOException00"), iOException);
            throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
        }
        if (this.contentObject == null && this.datahandler == null) {
            throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
        }
    }

    public void clearContent() {
        this.datahandler = null;
        this.contentObject = null;
    }

    public int getSize() throws SOAPException {
        if (this.datahandler == null) {
            return 0;
        }
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = (ByteBuffer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    ByteBuffer byteBuffer = new ByteBuffer();
                    AttachmentPart.this.datahandler.writeTo(byteBuffer);
                    return byteBuffer;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.webservices.engine.attachments.AttachmentPart.getSize", "463", this);
            log.error(Messages.getMessage("javaIOException00"), privilegedActionException);
            throw new SOAPException(Messages.getMessage("javaIOException01", privilegedActionException.getMessage()), privilegedActionException);
        }
        byte[] byArray = byteBuffer.getBytes();
        if (byArray != null) {
            return byArray.length;
        }
        return -1;
    }

    public String[] getMimeHeader(String string) {
        return this.mimeHeaders.getHeader(string);
    }

    public String getContentIdRef() {
        return "cid:" + this.getContentId();
    }

    public InputStream getBase64Content() throws SOAPException {
        byte[] byArray = this.getRawContentBytes();
        String string = Base64.encode(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return byteArrayInputStream;
    }

    public void setBase64Content(InputStream inputStream, String string) throws SOAPException {
        if (inputStream == null) {
            throw new SOAPException(Messages.getMessage("null00", "content"));
        }
        try {
            WebServicesInputSource webServicesInputSource = WebServicesInputSource.create(inputStream);
            String string2 = webServicesInputSource.getString();
            byte[] byArray = Base64.decode(string2);
            this.setRawContentBytes(byArray, 0, byArray.length, string);
        }
        catch (Exception exception) {
            throw new SOAPException(Messages.getMessage("exception01", "Base64 decoding error"), exception);
        }
    }

    private Object getDataHandlerContent() throws SOAPException {
        try {
            Object object = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return AttachmentPart.this.datahandler.getContent();
                }
            });
            return object;
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.webservices.engine.attachments.AttachmentPart.getSize", "744", this);
            log.error(Messages.getMessage("javaIOException00"), privilegedActionException);
            throw new SOAPException(Messages.getMessage("javaIOException01", privilegedActionException.getMessage()), privilegedActionException);
        }
    }

    public InputStream getRawContent() throws SOAPException {
        if (this.datahandler == null) {
            throw new SOAPException(Messages.getMessage("internalAttachErr", this.getContentId()));
        }
        try {
            InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return AttachmentPart.this.datahandler.getInputStream();
                }
            });
            return inputStream;
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.webservices.engine.attachments.AttachmentPart.getSize", "744", this);
            log.error(Messages.getMessage("javaIOException00"), privilegedActionException);
            throw new SOAPException(Messages.getMessage("javaIOException01", privilegedActionException.getMessage()), privilegedActionException);
        }
    }

    public void setRawContent(InputStream inputStream, String string) throws SOAPException {
        if (inputStream == null) {
            throw new SOAPException(Messages.getMessage("null00", "content"));
        }
        this.setContent(inputStream, string);
    }

    public byte[] getRawContentBytes() throws SOAPException {
        InputStream inputStream = this.getRawContent();
        WebServicesInputSource webServicesInputSource = WebServicesInputSource.create(inputStream);
        return webServicesInputSource.getBytes();
    }

    public void setRawContentBytes(byte[] byArray, int n, int n2, String string) throws SOAPException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        this.setRawContent(byteArrayInputStream, string);
    }

    private class ByteBuffer
    extends ByteArrayOutputStream {
        private ByteBuffer() {
        }

        byte[] getBytes() {
            return super.toByteArray();
        }
    }
}

