/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.Version;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.SimpleTargetedChain;
import com.ibm.ws.webservices.engine.WSDDEngineConfiguration;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configurable.ConfigurableImpl;
import com.ibm.ws.webservices.engine.configuration.SimpleEngineConfigurationProvider;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDGlobalConfiguration;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.session.Session;
import com.ibm.ws.webservices.engine.session.SimpleSession;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.server.ServiceLifecycle;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;

public abstract class WebServicesEngine
extends ConfigurableImpl {
    private static String binaryCopyright = Version.getBinaryCopyright();
    protected static Log log = LogFactory.getLog(WebServicesEngine.class.getName());
    public static final String PROP_DEBUG_LEVEL = "debugLevel";
    public static final String PROP_DEBUG_FILE = "debugFile";
    public static final String PROP_XML_DECL = "sendXMLDeclaration";
    public static final String PROP_DOMULTIREFS = "sendMultiRefs";
    public static final String PROP_SYNC_CONFIG = "syncConfiguration";
    public static final String PROP_SEND_XSI = "sendXsiTypes";
    public static final String PROP_ATTACHMENT_DIR = "attachments.Directory";
    public static final String PROP_ATTACHMENT_IMPLEMENTATION = "attachments.implementation";
    public static final String PROP_ATTACHMENT_CLEANUP = "attachment.DirectoryCleanUp";
    public static final String PROP_SOAP_VERSION = "defaultSOAPVersion";
    public static final String DEFAULT_ATTACHMENT_IMPL = "com.ibm.ws.webservices.engine.attachments.AttachmentsImpl";
    public static final String ENV_ATTACHMENT_DIR = "webservices.attachments.Directory";
    public static final String ENV_SERVLET_REALPATH = "servlet.realpath";
    public static final String ENV_SERVLET_CONTEXT = "servletContext";
    public static final String ENV_TEMP_DIR = "java.io.tmpdir";
    private final EngineConfiguration config;
    private Session session = new SimpleSession();
    private static final Set booleanOptions = new HashSet<String>(Arrays.asList("sendMultiRefs", "sendXsiTypes", "sendXMLDeclaration"));

    protected WebServicesEngine(EngineConfiguration engineConfiguration) {
        this.config = engineConfiguration;
        this.init();
    }

    public EngineConfiguration getConfiguration() {
        return this.config;
    }

    private void init() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: WebServicesEngine::init");
        }
        this.config.init();
        try {
            Map map = this.config.getGlobalOptions();
            this.setOptions(map);
        }
        catch (ConfigurationException configurationException) {
            String string = Messages.getMessage("unloadable.configuration");
            log.error(string, configurationException);
            throw new InternalException(configurationException);
        }
        this.setOptionDefault(PROP_ATTACHMENT_IMPLEMENTATION, WebServicesProperties.getProperty("webservices.attachments.implementation"));
        this.setOptionDefault(PROP_ATTACHMENT_IMPLEMENTATION, DEFAULT_ATTACHMENT_IMPL);
        if (log.isDebugEnabled()) {
            log.debug("Exit: WebServicesEngine::init");
        }
    }

    public void destroy() {
        Enumeration enumeration = this.session.getKeys();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object = this.session.get(string);
                if (object != null && object instanceof ServiceLifecycle) {
                    ((ServiceLifecycle)object).destroy();
                }
                this.session.remove(string);
            }
        }
        this.config.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext messageContext) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: WebServicesEngine::invoke");
        }
        MessageContext messageContext2 = MessageContext.getCurrentThreadsContext();
        try {
            MessageContext.setCurrentThreadsContext(messageContext);
            messageContext.setResponseMessage(null);
            messageContext.setProperty("com.ibm.ws.webservices.engine.SimpleChain.caughtFaultInResponse", Boolean.FALSE);
            Handler handler = this.getMessageFlow(messageContext);
            if (handler.getOwner() == null) {
                handler.init();
            }
            try {
                messageContext.setPastPivot(false);
                messageContext.setMessagePath(0);
                handler.invoke(messageContext);
            }
            finally {
                if (handler.getOwner() == null) {
                    handler.destroy();
                }
            }
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.WebServicesEngine.invoke", "265", this);
            throw webServicesFault;
        }
        catch (ConfigurationException configurationException) {
            FFDCFilter.processException((Throwable)configurationException, "com.ibm.ws.webservices.engine.WebServicesEngine.invoke", "268", this);
            throw WebServicesFault.makeFault(configurationException);
        }
        finally {
            MessageContext.setCurrentThreadsContext(messageContext2);
            if (log.isDebugEnabled()) {
                log.debug("Exit: WebServicesEngine::invoke");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateWSDL(MessageContext messageContext) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: WebServicesEngine::generateWSDL");
        }
        MessageContext messageContext2 = MessageContext.getCurrentThreadsContext();
        try {
            MessageContext.setCurrentThreadsContext(messageContext);
            Handler handler = this.getMessageFlow(messageContext);
            if (handler.getOwner() == null) {
                handler.init();
            }
            try {
                messageContext.setPastPivot(false);
                handler.generateWSDL(messageContext);
            }
            finally {
                if (handler.getOwner() == null) {
                    handler.destroy();
                }
            }
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.WebServicesEngine.generateWSDL", "315", this);
            throw webServicesFault;
        }
        catch (ConfigurationException configurationException) {
            FFDCFilter.processException((Throwable)configurationException, "com.ibm.ws.webservices.engine.WebServicesEngine.generateWSDL", "318", this);
            throw WebServicesFault.makeFault(configurationException);
        }
        finally {
            MessageContext.setCurrentThreadsContext(messageContext2);
            if (log.isDebugEnabled()) {
                log.debug("Exit: WebServicesEngine::generateWSDL");
            }
        }
    }

    protected Handler getMessageFlow(MessageContext messageContext) throws WebServicesFault, ConfigurationException {
        Handler handler;
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("defaultLogic00"));
        }
        if ((handler = this.createMessageFlow(messageContext)) == null) {
            throw new WebServicesFault(QNameTable.createQName(messageContext.getSOAPConstants().getEnvelopeURI(), "Server"), Messages.getMessage("noHandler00", "(engine message flow)"), null, null);
        }
        return handler;
    }

    protected abstract Handler createMessageFlow(MessageContext var1) throws WebServicesFault, ConfigurationException;

    public SOAPPort getPort(QName qName) throws WebServicesFault {
        try {
            return this.config.getPort(qName);
        }
        catch (ConfigurationException configurationException) {
            FFDCFilter.processException((Throwable)configurationException, "com.ibm.ws.webservices.engine.WebServicesEngine.getPort", "378", this);
            throw new WebServicesFault(configurationException);
        }
    }

    public SOAPPort getPort(String string) throws WebServicesFault {
        return this.getPort(QNameTable.createQName(null, string));
    }

    public SOAPPort getPortByNamespaceURI(String string) throws WebServicesFault {
        try {
            return this.config.getPortByNamespaceURI(string);
        }
        catch (ConfigurationException configurationException) {
            FFDCFilter.processException((Throwable)configurationException, "com.ibm.ws.webservices.engine.WebServicesEngine.getPortByNamespaceURI", "393", this);
            throw new WebServicesFault(configurationException);
        }
    }

    public Iterator getDeployedPorts() throws WebServicesFault {
        try {
            return this.config.getDeployedPorts();
        }
        catch (ConfigurationException configurationException) {
            FFDCFilter.processException((Throwable)configurationException, "com.ibm.ws.webservices.engine.WebServicesEngine.getDeployedPorts", "403", this);
            throw new WebServicesFault(configurationException);
        }
    }

    public Handler getTransport(String string) throws WebServicesFault {
        if (string == null) {
            return null;
        }
        try {
            return this.config.getTransport(QNameTable.createQName(null, string));
        }
        catch (ConfigurationException configurationException) {
            FFDCFilter.processException((Throwable)configurationException, "com.ibm.ws.webservices.engine.WebServicesEngine.getTransport", "417", this);
            throw new WebServicesFault(configurationException);
        }
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        TypeMappingRegistry typeMappingRegistry = null;
        try {
            typeMappingRegistry = this.config.getTypeMappingRegistry();
        }
        catch (ConfigurationException configurationException) {
            FFDCFilter.processException((Throwable)configurationException, "com.ibm.ws.webservices.engine.WebServicesEngine.getTypeMappingRegistry", "428", this);
            log.error(Messages.getMessage("webServicesConfigurationException00"), configurationException);
        }
        return typeMappingRegistry;
    }

    public SimpleTargetedChain getGlobalHandler() throws ConfigurationException {
        return this.config.getGlobalHandler();
    }

    public List getProtectedHeaders() {
        List list = null;
        WSDDGlobalConfiguration wSDDGlobalConfiguration = this.getGlobalConfig();
        if (wSDDGlobalConfiguration != null) {
            list = wSDDGlobalConfiguration.getProtectedHeaders();
        }
        return list;
    }

    private WSDDGlobalConfiguration getGlobalConfig() {
        WSDDGlobalConfiguration wSDDGlobalConfiguration = null;
        EngineConfiguration engineConfiguration = this.config;
        while (engineConfiguration != null && wSDDGlobalConfiguration == null) {
            if (engineConfiguration instanceof WSDDDeployment) {
                wSDDGlobalConfiguration = ((WSDDDeployment)engineConfiguration).getGlobalConfig();
                engineConfiguration = null;
                continue;
            }
            if (engineConfiguration instanceof SimpleEngineConfigurationProvider) {
                engineConfiguration = ((SimpleEngineConfigurationProvider)engineConfiguration).getDefaultEngineConfiguration();
                continue;
            }
            engineConfiguration = null;
        }
        return wSDDGlobalConfiguration;
    }

    public Document getConfigurationDocument() {
        if (this.config instanceof WSDDEngineConfiguration) {
            try {
                return ((WSDDEngineConfiguration)this.config).getDocument();
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        return null;
    }

    public abstract WebServicesEngine getClientEngine();

    public Session getApplicationSession() {
        return this.session;
    }

    public boolean isContainerManaged() {
        return this.config.isContainerManaged();
    }

    public abstract boolean isServer();

    public Set getOptionsBooleanNames() {
        return booleanOptions;
    }
}

