/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.custom;

import com.ibm.ws.webservices.custom.CustomPropertyConstants;
import com.ibm.ws.webservices.custom.CustomPropertyDescriptor;
import com.ibm.ws.webservices.custom.CustomPropertyLoader;
import com.ibm.ws.webservices.custom.CustomPropertyLoaderImpl;
import com.ibm.ws.webservices.custom.CustomPropertyProvider;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CustomPropertyProviderImpl
implements CustomPropertyProvider {
    private Log log = LogFactory.getLog(CustomPropertyProviderImpl.class.getName());
    private static final String newline = "\n";
    CustomPropertyLoader loader;
    private Map map = new HashMap();

    public CustomPropertyProviderImpl() {
        this.loader = new CustomPropertyLoaderImpl();
        this.loadDeclaredProperties();
        this.loadGlobalDefaults();
        this.loadGlobalProperties();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Custom Properties: " + this.toString());
        }
    }

    public Object getValue(String string) {
        CustomPropertyDescriptor customPropertyDescriptor = (CustomPropertyDescriptor)this.map.get(string);
        if (customPropertyDescriptor == null) {
            throw new IllegalArgumentException(string);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("customKey: " + string + " value: " + customPropertyDescriptor.getValue());
        }
        return customPropertyDescriptor.getValue();
    }

    public Object getValue(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        String string = "Custom Properties: \n";
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            CustomPropertyDescriptor customPropertyDescriptor = (CustomPropertyDescriptor)this.map.get(string2);
            string = string + customPropertyDescriptor.toString() + newline;
        }
        return string;
    }

    private void loadDeclaredProperties() {
        this.map.putAll(CustomPropertyConstants.getDeclaredPropertiesMap());
    }

    private void loadGlobalDefaults() {
    }

    private void loadGlobalProperties() {
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            CustomPropertyDescriptor customPropertyDescriptor;
            String string2;
            block6: {
                string2 = (String)iterator.next();
                customPropertyDescriptor = (CustomPropertyDescriptor)this.map.get(string2);
                string = null;
                try {
                    string = this.loader.loadGlobalValue(string2);
                }
                catch (Throwable throwable) {
                    if (!this.log.isDebugEnabled()) break block6;
                    this.log.debug("Failure occured loading global value:" + string2);
                    this.log.debug("Processing continues with the default property: " + customPropertyDescriptor);
                    this.log.debug("The caught exception is " + throwable);
                }
            }
            if (string == null) continue;
            try {
                Object object = CustomPropertyProviderImpl.convert(customPropertyDescriptor.getType(), string);
                object = customPropertyDescriptor.getValidator().validate(object, customPropertyDescriptor);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Storing value " + object + " for " + customPropertyDescriptor.getKey());
                }
                CustomPropertyDescriptor customPropertyDescriptor2 = new CustomPropertyDescriptor(customPropertyDescriptor.getKey(), customPropertyDescriptor.getType(), object, customPropertyDescriptor.getScope(), customPropertyDescriptor.getUsage(), customPropertyDescriptor.getValidator());
                this.map.put(string2, customPropertyDescriptor2);
            }
            catch (Throwable throwable) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Failure occured converting [" + string + "] into a " + customPropertyDescriptor.getType());
                this.log.debug("Processing continues with the default values: " + customPropertyDescriptor);
                this.log.debug("The caught exception is " + throwable);
            }
        }
    }

    private static Object convert(Class clazz, String string) {
        if (clazz == String.class) {
            return string;
        }
        if (clazz == Integer.class) {
            string = string.trim();
            return new Integer(Integer.parseInt(string));
        }
        if (clazz == Boolean.class) {
            return CustomPropertyProviderImpl.convertBoolean(string);
        }
        throw new IllegalArgumentException(string);
    }

    private static Boolean convertBoolean(String string) {
        if (string == null) {
            throw new IllegalArgumentException(string);
        }
        if ((string = string.trim()).equalsIgnoreCase("true") || string.equalsIgnoreCase("1") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("enable")) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("0") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("disable")) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException(string);
    }
}

