/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.sysmgmt.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.webservices.admin.WebServiceAdminConstants;
import com.ibm.ws.webservices.admin.commands.WebServiceUtils;
import com.ibm.ws.webservices.admin.exceptions.NoItemFoundException;
import com.ibm.ws.webservices.admin.sysmgmt.SysMgmtHelper;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class SysMgmtHelperImpl
implements SysMgmtHelper,
WebServiceAdminConstants {
    private static String APP_REPOSITORY_TYPE = "deployments";
    private static String WEB_APP_SUFFIX = ".war";
    private Session session;
    private static TraceComponent tc = Tr.register(SysMgmtHelperImpl.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.webservices.admin.resources.websvcsAdmin", Locale.getDefault());

    public SysMgmtHelperImpl(Session session) {
        this.session = session;
    }

    public String getFilePath(String string, String string2, String string3, boolean bl) throws NoItemFoundException, WorkSpaceException {
        String string4 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFilePath, appName=" + string + " , moduleName=" + string2 + " , fileName=" + string3 + " , createIfNotFound=" + bl);
        }
        SysMgmtHelperImpl.validateFileName(string3);
        Collection collection = SysMgmtHelperImpl.getAppRepositoryCollection(this.session, string);
        Iterator iterator = collection.iterator();
        RepositoryContext repositoryContext = null;
        WorkSpaceFile workSpaceFile = null;
        String string5 = SysMgmtHelperImpl.getPathToFileName(string2, string3);
        while (iterator.hasNext() && !bl2) {
            repositoryContext = (RepositoryContext)iterator.next();
            List list = repositoryContext.getAllList(true);
            for (int i = 0; i < list.size(); ++i) {
                workSpaceFile = (WorkSpaceFile)list.get(i);
                String string6 = workSpaceFile.getFileName();
                if (string6.contains(string2 + File.separator)) {
                    bl3 = true;
                }
                if (!string6.endsWith(string5)) continue;
                bl2 = true;
                i = list.size();
                if (!repositoryContext.isAvailable(string5)) continue;
                if (!repositoryContext.isExtracted(string5)) {
                    repositoryContext.extract(string5, false);
                }
                string4 = SysMgmtHelperImpl.getFullPath(repositoryContext, string5);
            }
        }
        if (!bl3) {
            throw new NoItemFoundException(WebServiceUtils.getFormattedMessage(resourceBundle, "CWSAD0004E", new Object[]{string2}, "No module is found: " + string2));
        }
        if (!bl2 && bl) {
            repositoryContext.getOutputStream(string5);
            repositoryContext.notifyChanged(0, string5);
            string4 = SysMgmtHelperImpl.getFullPath(repositoryContext, string5);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFilePath, fullPath=" + string4);
        }
        return string4;
    }

    public boolean updateFilePath(String string, String string2, String string3) throws NoItemFoundException, WorkSpaceException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateFilePath, appName=" + string + " , moduleName=" + string2 + " , fileName=" + string3);
        }
        SysMgmtHelperImpl.validateFileName(string3);
        Collection collection = SysMgmtHelperImpl.getAppRepositoryCollection(this.session, string);
        Iterator iterator = collection.iterator();
        RepositoryContext repositoryContext = null;
        WorkSpaceFile workSpaceFile = null;
        String string4 = SysMgmtHelperImpl.getPathToFileName(string2, string3);
        while (iterator.hasNext() && !bl2) {
            repositoryContext = (RepositoryContext)iterator.next();
            List list = repositoryContext.getAllList(true);
            for (int i = 0; i < list.size(); ++i) {
                workSpaceFile = (WorkSpaceFile)list.get(i);
                String string5 = workSpaceFile.getFileName();
                if (string5.contains(string2 + File.separator)) {
                    bl3 = true;
                }
                if (!string5.endsWith(string4)) continue;
                bl2 = true;
                i = list.size();
                if (!repositoryContext.isAvailable(string4)) {
                    throw new NoItemFoundException(WebServiceUtils.getFormattedMessage(resourceBundle, "CWSAD0013E", new Object[]{string4}, "The file name was not found: " + string4));
                }
                repositoryContext.notifyChanged(1, string4);
                bl = true;
            }
        }
        if (!bl3) {
            throw new NoItemFoundException(WebServiceUtils.getFormattedMessage(resourceBundle, "CWSAD0004E", new Object[]{string2}, "No module is found: " + string2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateFilePath, expectedFileName=" + string4);
        }
        return bl;
    }

    public static Collection getAppRepositoryCollection(Session session, String string) throws WorkSpaceException, NoItemFoundException {
        WorkSpace workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName());
        Collection collection = workSpace.getRootContext().findContext(APP_REPOSITORY_TYPE, string);
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            return collection;
        }
        throw new NoItemFoundException(WebServiceUtils.getFormattedMessage(resourceBundle, "CWSAD0003E", new Object[]{string}, "No application is found: " + string));
    }

    private static String getPathToFileName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.toLowerCase().endsWith(WEB_APP_SUFFIX)) {
            stringBuffer.append(string).append(File.separator).append("WEB-INF").append(File.separator).append(string2);
        } else {
            stringBuffer.append(string).append(File.separator).append("META-INF").append(File.separator).append(string2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPathToFileName, buf=" + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static String getFullPath(RepositoryContext repositoryContext, String string) {
        StringBuffer stringBuffer = new StringBuffer(repositoryContext.getPath());
        stringBuffer.append(File.separator).append(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getFullPath, buf=" + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static void validateFileName(String string) throws NoItemFoundException {
        if (string.contains("/") || string.contains("\\")) {
            throw new NoItemFoundException(WebServiceUtils.getFormattedMessage(resourceBundle, "CWSAD0012E", new Object[]{string}, "The file name provided is not allowed to have embedded slashes: " + string));
        }
    }
}

