/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.serviceindex.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.admin.serviceindex.Endpoint;
import com.ibm.ws.webservices.admin.serviceindex.WebService;
import com.ibm.ws.webservices.admin.serviceindex.impl.EndpointBean;
import java.util.ArrayList;
import java.util.List;

public class WebServiceBean
implements WebService {
    public static int NUM_ATTRIBUTES = 4;
    protected static final String SEPARATOR = ",";
    private String serviceName = null;
    private String type = null;
    private boolean client = false;
    private ArrayList endpoints = new ArrayList();
    private static TraceComponent tc = Tr.register(WebServiceBean.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");

    public WebServiceBean() {
    }

    public WebServiceBean(String string) {
        this.serviceName = string;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceNameLocalPart() {
        if (this.serviceName == null) {
            return null;
        }
        int n = this.serviceName.indexOf(125);
        return this.serviceName.substring(n + 1);
    }

    public String getType() {
        return this.type;
    }

    public boolean isClient() {
        return this.client;
    }

    public List listEndpoints() {
        return this.endpoints;
    }

    public Endpoint getEndpoint(String string) {
        if (this.endpoints.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "This service does not have any endpoint, service name is " + this.serviceName);
            }
            return null;
        }
        if (string == null) {
            return null;
        }
        EndpointBean endpointBean = null;
        for (int i = 0; i < this.endpoints.size(); ++i) {
            endpointBean = (EndpointBean)this.endpoints.get(i);
            if (!string.equals(endpointBean.getName())) continue;
            return endpointBean;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEndpoint, cannot find endpoint", new Object[]{this.serviceName, string});
        }
        return null;
    }

    public boolean contains(String string) {
        return this.getEndpoint(string) != null;
    }

    public boolean hasEndpoint() {
        return this.endpoints.size() > 0;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setClient(boolean bl) {
        this.client = bl;
    }

    public void addEndpoint(Endpoint endpoint) {
        if (endpoint == null) {
            return;
        }
        this.endpoints.add(endpoint);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("serviceName=").append(this.serviceName);
        stringBuffer.append(SEPARATOR).append("type=").append(this.type);
        stringBuffer.append("\n");
        for (int i = 0; i < this.endpoints.size(); ++i) {
            stringBuffer.append(((EndpointBean)this.endpoints.get(i)).toString());
        }
        return stringBuffer.toString();
    }

    public String toXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string + "    ";
        stringBuffer.append(string);
        if (this.client) {
            stringBuffer.append("<webserviceClient name=\"");
        } else {
            stringBuffer.append("<webservice name=\"");
        }
        stringBuffer.append(this.serviceName);
        stringBuffer.append("\" type=\"").append(this.type);
        stringBuffer.append("\">\n");
        for (int i = 0; i < this.endpoints.size(); ++i) {
            stringBuffer.append(((EndpointBean)this.endpoints.get(i)).toXML(string2));
        }
        if (this.client) {
            stringBuffer.append(string).append("</webserviceClient>\n");
        } else {
            stringBuffer.append(string).append("</webservice>\n");
        }
        return stringBuffer.toString();
    }

    public int validate(boolean bl) {
        if (this.type == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validate, no service type is found: " + this.serviceName);
            }
            return -6;
        }
        if (bl && this.endpoints.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validate, no endpoint exists in service : " + this.serviceName);
            }
            return -4;
        }
        if (bl) {
            int n = 0;
            for (int i = 0; i < this.endpoints.size(); ++i) {
                n = ((EndpointBean)this.endpoints.get(i)).validate();
                if (n >= 0) continue;
                return n;
            }
        }
        return 0;
    }
}

