/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.serviceindex.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.admin.serviceindex.impl.WebServiceBean;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;

public class ServiceIndexWriter {
    public static final String INDENT_SPACE = "    ";
    private static TraceComponent tc = Tr.register(ServiceIndexWriter.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private static final String SOURCE_FILE = "com.ibm.ws.webservices.admin.serviceindex.impl.ServerIndexWriter";
    private static final String FFDC_ID_1 = "FFDC-1";

    public static int write(OutputStream outputStream, Map map) throws IOException {
        return ServiceIndexWriter.write(outputStream, map, null);
    }

    public static int write(OutputStream outputStream, Map map, Map map2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "write, web services, serviceProviderMap=" + map + ", serviceClientMap=" + map2);
        }
        int n = 0;
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            outputStreamWriter.write("<?xml version=\"1.0\" ?>\n");
            outputStreamWriter.write("<services>\n");
            int n2 = 0;
            if (map != null) {
                for (WebServiceBean webServiceBean : map.values()) {
                    n2 = ServiceIndexWriter.writeWebService(outputStreamWriter, webServiceBean);
                    if (n2 >= 0) continue;
                    n = n2;
                }
            }
            if (map2 != null) {
                for (WebServiceBean webServiceBean : map2.values()) {
                    n2 = ServiceIndexWriter.writeWebService(outputStreamWriter, webServiceBean);
                    if (n2 >= 0) continue;
                    n = n2;
                }
            }
            outputStreamWriter.write("</services>\n");
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.webservices.admin.serviceindex.impl.ServerIndexWriter.write", FFDC_ID_1);
            Tr.error(tc, "CWSAD0002E", iOException);
            throw iOException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "write, return code is " + n);
        }
        return n;
    }

    private static int writeWebService(OutputStreamWriter outputStreamWriter, WebServiceBean webServiceBean) throws IOException {
        int n = webServiceBean.validate(true);
        String string = webServiceBean.toXML(INDENT_SPACE);
        outputStreamWriter.write(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeWebService, web service " + webServiceBean.getServiceName() + " xml string: " + string);
        }
        return n;
    }
}

