/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.serviceindex.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.admin.serviceindex.impl.EndpointBean;
import com.ibm.ws.webservices.admin.serviceindex.impl.WebServiceBean;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ServiceIndexReader
extends DefaultHandler {
    public static final String ROOT_ELEMENT = "services";
    public static final String WEBSERVICE_ELEMENT = "webservice";
    public static final String WEBSERVICE_CLIENT_ELEMENT = "webserviceClient";
    public static final String ENDPOINT_ELEMENT = "endpoint";
    public static final String OPERATION_ELEMENT = "operation";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String IMPLCLASS_ATTRIBUTE = "implClass";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String PROTOCOL_ATTRIBUTE = "protocol";
    private InputStream istream = null;
    private XMLReader reader = null;
    private HashMap wsProviderMap = new HashMap();
    private HashMap wsClientMap = new HashMap();
    private WebServiceBean wsInfo = null;
    private EndpointBean endpointInfo = null;
    boolean readAll = false;
    private static final String SOURCE_FILE = "com.ibm.ws.webservices.admin.serviceindex.impl.ServerIndexReader";
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static TraceComponent tc = Tr.register(ServiceIndexReader.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");

    public ServiceIndexReader(InputStream inputStream) {
        this.istream = inputStream;
    }

    public Map[] read(boolean bl) throws SAXException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "read");
        }
        try {
            this.readAll = bl;
            this.reader = XMLReaderFactory.createXMLReader();
            this.reader.setContentHandler(this);
            this.reader.setErrorHandler(this);
            this.reader.parse(new InputSource(this.istream));
        }
        catch (SAXException sAXException) {
            FFDCFilter.processException(sAXException, "com.ibm.ws.webservices.admin.serviceindex.impl.ServerIndexReader.read", FFDC_ID_1);
            Tr.error(tc, "CWSAD0001E", sAXException);
            throw sAXException;
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.webservices.admin.serviceindex.impl.ServerIndexReader.read", FFDC_ID_2);
            Tr.error(tc, "CWSAD0001E", iOException);
            throw iOException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "read: wsProviderMap=" + this.wsProviderMap.toString() + ", wsClientMap=" + this.wsClientMap.toString());
        }
        return new Map[]{this.wsProviderMap, this.wsClientMap};
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "startElement, qName=" + string3 + ", uri=" + string + ", localName=" + string2);
        }
        if (ROOT_ELEMENT.equals(string3)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "startElement, get root element");
            }
        } else if (WEBSERVICE_ELEMENT.equals(string3)) {
            this.wsInfo = new WebServiceBean();
            this.wsInfo.setServiceName(attributes.getValue(NAME_ATTRIBUTE));
            this.wsInfo.setType(attributes.getValue(TYPE_ATTRIBUTE));
            this.wsProviderMap.put(this.wsInfo.getServiceName(), this.wsInfo);
        } else if (WEBSERVICE_CLIENT_ELEMENT.equals(string3)) {
            this.wsInfo = new WebServiceBean();
            this.wsInfo.setServiceName(attributes.getValue(NAME_ATTRIBUTE));
            this.wsInfo.setType(attributes.getValue(TYPE_ATTRIBUTE));
            this.wsInfo.setClient(true);
            this.wsClientMap.put(this.wsInfo.getServiceName(), this.wsInfo);
        } else if (this.readAll) {
            if (ENDPOINT_ELEMENT.equals(string3)) {
                this.endpointInfo = new EndpointBean();
                this.endpointInfo.setName(attributes.getValue(NAME_ATTRIBUTE));
                this.wsInfo.addEndpoint(this.endpointInfo);
            } else if (OPERATION_ELEMENT.equals(string3)) {
                this.endpointInfo.addOperation(attributes.getValue(NAME_ATTRIBUTE));
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "startElement, unexpected qName " + string3);
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
    }
}

