/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.serviceindex.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.admin.WebServiceAdminConstants;
import com.ibm.ws.webservices.admin.commands.WebServiceUtils;
import com.ibm.ws.webservices.admin.exceptions.NoItemFoundException;
import com.ibm.ws.webservices.admin.serviceindex.Endpoint;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelper;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelperFactory;
import com.ibm.ws.webservices.admin.serviceindex.WebService;
import com.ibm.ws.webservices.admin.serviceindex.impl.EndpointBean;
import com.ibm.ws.webservices.admin.serviceindex.impl.ServiceIndexReader;
import com.ibm.ws.webservices.admin.serviceindex.impl.ServiceIndexWriter;
import com.ibm.ws.webservices.admin.serviceindex.impl.WebServiceBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import org.xml.sax.SAXException;

public class ServiceIndexHelperImpl
implements ServiceIndexHelper,
WebServiceAdminConstants {
    public static int SERVICE_PROVIDER_INDEX = 0;
    public static int SERVICE_CLIENT_INDEX = 1;
    private Map wsProviderMap = new HashMap();
    private Map wsClientMap = new HashMap();
    private InputStream instream = null;
    private String fileName = null;
    private String appName = null;
    private String moduleName = null;
    private boolean fileLoaded = false;
    private static TraceComponent tc = Tr.register(ServiceIndexHelperImpl.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.webservices.admin.resources.websvcsAdmin", Locale.getDefault());

    public ServiceIndexHelperImpl(String string, String string2, String string3) {
        this.appName = string;
        this.moduleName = string2;
        this.fileName = string3;
    }

    public ServiceIndexHelperImpl(String string, String string2, InputStream inputStream) {
        this.appName = string;
        this.moduleName = string2;
        this.instream = inputStream;
    }

    private synchronized void loadData(InputStream inputStream, boolean bl) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadData");
        }
        if (inputStream == null) {
            inputStream = this.instream;
        }
        boolean bl2 = false;
        if (inputStream == null && this.fileName != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadData: new FileInputStream for fileName=" + this.fileName);
            }
            inputStream = new FileInputStream(this.fileName);
            bl2 = true;
        }
        if (inputStream == null) {
            throw new IOException(WebServiceUtils.getFormattedMessage(resourceBundle, "CWSAD0001E", new Object[]{"InputStream is null, fileName=" + this.fileName}, "InputStream is null"));
        }
        ServiceIndexReader serviceIndexReader = new ServiceIndexReader(inputStream);
        Map[] mapArray = serviceIndexReader.read(true);
        this.wsProviderMap = mapArray[SERVICE_PROVIDER_INDEX];
        this.wsClientMap = mapArray[SERVICE_CLIENT_INDEX];
        if (bl2) {
            inputStream.close();
            inputStream = null;
        }
        this.fileLoaded = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadData");
        }
    }

    public int saveData() throws FileNotFoundException, IOException, NoItemFoundException {
        return this.saveData(null);
    }

    public int saveData(OutputStream outputStream) throws FileNotFoundException, IOException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveData");
        }
        if (this.wsProviderMap.isEmpty() && this.wsClientMap.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData, no web service provider or client exists in ServiceIndexHelper");
            }
            return -3;
        }
        boolean bl = false;
        if (outputStream == null && this.fileName != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData: new FileOutputStream for fileName=" + this.fileName);
            }
            outputStream = new FileOutputStream(new File(this.fileName));
            bl = true;
        }
        if (outputStream == null) {
            throw new IOException(WebServiceUtils.getFormattedMessage(resourceBundle, "CWSAD0002E", new Object[]{"OutputStream is null"}, "OutputStream is null"));
        }
        int n = ServiceIndexWriter.write(outputStream, this.wsProviderMap, this.wsClientMap);
        if (bl) {
            outputStream.close();
            outputStream = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveData");
        }
        return n;
    }

    public boolean contains(String string, String string2, String string3, boolean bl) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "contains ", new Object[]{string, string2, string3});
        }
        if (string == null) {
            return false;
        }
        WebService webService = this.getWebServiceObject2(string, bl);
        if (webService == null) {
            return false;
        }
        if (string2 == null) {
            return true;
        }
        if (webService.contains(string2)) {
            if (string3 == null) {
                return true;
            }
            Endpoint endpoint = webService.getEndpoint(string2);
            return endpoint.contains(string3);
        }
        return false;
    }

    public boolean contains(String string, String string2, String string3) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        return this.contains(string, string2, string3, false);
    }

    public String getApplicationName() {
        return this.appName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public List listWebServiceObjects() throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        return this.listWebServiceObjects(false);
    }

    public List listWebServiceObjects(boolean bl) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        if (!this.fileLoaded) {
            this.loadData(null, true);
        }
        Map map = null;
        map = bl ? this.wsClientMap : this.wsProviderMap;
        ArrayList arrayList = new ArrayList(map.size());
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public List listWebServices(boolean bl) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        if (!this.fileLoaded) {
            this.loadData(null, true);
        }
        Map map = null;
        map = bl ? this.wsClientMap : this.wsProviderMap;
        if (map == null || map.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "listWebServices, no web services is found for " + (bl ? "service client" : "serviceProvider"));
            }
            return new ArrayList();
        }
        ArrayList<AttributeList> arrayList = new ArrayList<AttributeList>(map.size());
        Attribute attribute = new Attribute("application", this.appName);
        Attribute attribute2 = new Attribute("module", this.moduleName);
        WebService webService2 = null;
        for (WebService webService2 : map.values()) {
            arrayList.add(this.getAttributesFromService(attribute, attribute2, webService2));
        }
        return arrayList;
    }

    public AttributeList getWebService(String string, boolean bl) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        WebService webService = this.getWebServiceObject(string, bl);
        return this.getAttributesFromService(webService);
    }

    public AttributeList getWebService(String string) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        return this.getWebService(string, false);
    }

    public WebService getWebServiceObject(String string, boolean bl) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        WebService webService = this.getWebServiceObject2(string, bl);
        if (webService == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getWebServiceObject, cannot find service ", new Object[]{this.appName, this.moduleName, string});
            }
            throw new NoItemFoundException(WebServiceUtils.getFormattedMessage(resourceBundle, "CWSAD0005E", new Object[]{string}, "No web service is found: "));
        }
        return webService;
    }

    private WebService getWebServiceObject2(String string, boolean bl) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        if (!this.fileLoaded) {
            this.loadData(null, true);
        }
        Map map = null;
        map = bl ? this.wsClientMap : this.wsProviderMap;
        if (map == null || map.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getWebServiceObject, no web services is found for " + (bl ? "service client" : "serviceProvider"));
            }
            return null;
        }
        Object v = map.get(string);
        return (WebService)v;
    }

    public List listEndpoints(String string, boolean bl) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        WebService webService = this.getWebServiceObject(string, bl);
        List list = webService.listEndpoints();
        if (list == null || list.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "listEndpoints, no endpoint is found for service " + string);
            }
            return new ArrayList(0);
        }
        ArrayList<AttributeList> arrayList = new ArrayList<AttributeList>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(this.getAttributesFromEndpoint((Endpoint)list.get(i)));
        }
        return arrayList;
    }

    public AttributeList getEndpoint(String string, String string2, boolean bl) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        Endpoint endpoint = this.getEndpointObject(string, string2, bl);
        return this.getAttributesFromEndpoint(endpoint);
    }

    public AttributeList getEndpoint(String string, String string2) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        return this.getEndpoint(string, string2, false);
    }

    public Endpoint getEndpointObject(String string, String string2, boolean bl) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        WebService webService = this.getWebServiceObject(string, bl);
        if (webService == null) {
            return null;
        }
        Endpoint endpoint = webService.getEndpoint(string2);
        if (endpoint == null) {
            throw new NoItemFoundException(WebServiceUtils.getFormattedMessage(resourceBundle, "CWSAD0006E", new Object[]{string2}, "No endpoint is found: "));
        }
        return endpoint;
    }

    public List listOperations(String string, String string2, boolean bl) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        if (string == null || string2 == null) {
            return new ArrayList(0);
        }
        Endpoint endpoint = this.getEndpointObject(string, string2, bl);
        List list = endpoint.listOperations();
        if (list == null || list.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "listOperations, no operation is found for logical endpoint (port name) " + string2);
            }
            return new ArrayList(0);
        }
        ArrayList<AttributeList> arrayList = new ArrayList<AttributeList>(list.size());
        Attribute attribute = null;
        AttributeList attributeList = null;
        for (int i = 0; i < list.size(); ++i) {
            attribute = new Attribute("operation", list.get(i));
            attributeList = new AttributeList(1);
            attributeList.add(attribute);
            arrayList.add(attributeList);
        }
        return arrayList;
    }

    public List listOperations(String string, String string2) throws FileNotFoundException, IOException, SAXException, NoItemFoundException {
        return this.listOperations(string, string2, false);
    }

    public synchronized boolean addWebService(WebService webService) {
        if (webService == null || webService.getServiceName() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addWebService, wsInfo is null or wsInfo.getServiceName is null");
            }
            return false;
        }
        if (webService.isClient()) {
            this.wsClientMap.put(webService.getServiceName(), webService);
        } else {
            this.wsProviderMap.put(webService.getServiceName(), webService);
        }
        return true;
    }

    public boolean addWebService(WebService webService, boolean bl) {
        return this.addWebService(webService);
    }

    public int validate(boolean bl) throws NoItemFoundException {
        if (this.wsProviderMap.isEmpty() && this.wsClientMap.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validate, no service provider or client exists in module " + this.getFullyQualifiedModuleName());
            }
            return -3;
        }
        Iterator iterator = this.wsProviderMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            n = ((WebServiceBean)iterator.next()).validate(bl);
            if (n >= 0) continue;
            return n;
        }
        iterator = this.wsClientMap.values().iterator();
        while (iterator.hasNext()) {
            n = ((WebServiceBean)iterator.next()).validate(bl);
            if (n >= 0) continue;
            return n;
        }
        return 0;
    }

    private String getFullyQualifiedModuleName() {
        if (this.appName == null || this.moduleName == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/application:").append(this.appName).append("/module:").append(this.moduleName);
        return stringBuffer.toString();
    }

    private String getFullyQualifiedServiceName(String string) {
        if (this.appName == null || this.moduleName == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/application:").append(this.appName).append("/module:").append(this.moduleName).append("/service:").append(string);
        return stringBuffer.toString();
    }

    private AttributeList getAttributesFromService(Attribute attribute, Attribute attribute2, WebService webService) {
        AttributeList attributeList = new AttributeList();
        if (webService == null) {
            return attributeList;
        }
        attributeList.add(attribute);
        attributeList.add(attribute2);
        attributeList.add(new Attribute("service", webService.getServiceName()));
        attributeList.add(new Attribute("client", webService.isClient()));
        if (!webService.isClient()) {
            attributeList.add(new Attribute("type", webService.getType()));
        }
        return attributeList;
    }

    private AttributeList getAttributesFromService(WebService webService) {
        AttributeList attributeList = new AttributeList();
        if (webService == null) {
            return attributeList;
        }
        attributeList.add(new Attribute("service", webService.getServiceName()));
        attributeList.add(new Attribute("client", webService.isClient()));
        if (!webService.isClient()) {
            attributeList.add(new Attribute("type", webService.getType()));
        }
        return attributeList;
    }

    private AttributeList getAttributesFromEndpoint(Endpoint endpoint) {
        AttributeList attributeList = new AttributeList();
        if (endpoint == null) {
            return attributeList;
        }
        attributeList.add(new Attribute("logicalEndpoint", endpoint.getName()));
        return attributeList;
    }

    public static void main(String[] stringArray) {
        ServiceIndexHelperImpl.unit_test_create_indexfile(stringArray);
    }

    private static void unit_test1(String[] stringArray) {
        try {
            Object object;
            System.out.println("\n\n Start unit test 1");
            ServiceIndexHelper serviceIndexHelper = ServiceIndexHelperFactory.createHelper(null, null, stringArray[2]);
            WebService webService = null;
            AttributeList attributeList = null;
            Object var4_5 = null;
            Object var5_6 = null;
            HashMap<Object, WebService> hashMap = new HashMap<Object, WebService>();
            Attribute attribute = null;
            System.out.println("test listWebServices and create a new HashMap:");
            List list = serviceIndexHelper.listWebServiceObjects(false);
            for (int i = 0; i < list.size(); ++i) {
                WebService webService2 = (WebService)list.get(i);
                System.out.println("get WebService " + i + ": " + webService2.toXML(""));
            }
            List list2 = serviceIndexHelper.listWebServices(true);
            System.out.println("listWebServices returns " + list2);
            for (int i = 0; i < list2.size(); ++i) {
                attributeList = (AttributeList)list2.get(i);
                attribute = (Attribute)attributeList.get(0);
                System.out.println("\napp: name=" + attribute.getName() + " value=" + attribute.getValue());
                attribute = (Attribute)attributeList.get(1);
                System.out.println("module: name=" + attribute.getName() + " value=" + attribute.getValue());
                attribute = (Attribute)attributeList.get(2);
                System.out.println("service: name=" + attribute.getName() + " value=" + attribute.getValue());
                attribute = (Attribute)attributeList.get(4);
                System.out.println("type: name=" + attribute.getName() + " value=" + attribute.getValue());
                attribute = (Attribute)attributeList.get(2);
                object = (String)attribute.getValue();
                webService = ((ServiceIndexHelperImpl)serviceIndexHelper).getWebServiceObject((String)object, false);
                hashMap.put(object, webService);
            }
            WebServiceBean webServiceBean = new WebServiceBean(stringArray[3]);
            object = new EndpointBean(stringArray[4]);
            EndpointBean endpointBean = new EndpointBean("myEndpoint2");
            webServiceBean.setType("JAX-WS");
            webServiceBean.addEndpoint((Endpoint)object);
            webServiceBean.addEndpoint(endpointBean);
            ((EndpointBean)object).addOperation("operation11");
            ((EndpointBean)object).addOperation("operation12");
            endpointBean.addOperation("operation2");
            if (!hashMap.containsKey(webServiceBean.getServiceName())) {
                hashMap.put(webServiceBean.getServiceName(), webServiceBean);
            }
            System.out.println("call helper.saveData");
            int n = ServiceIndexWriter.write(new FileOutputStream(stringArray[2]), hashMap, null);
            if (n < 0) {
                System.out.println("Something is wrong: saveData return errCode=" + n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void unit_test2(String[] stringArray) {
        try {
            System.out.println("\n\n Start unit test 2");
            ServiceIndexHelper serviceIndexHelper = ServiceIndexHelperFactory.createHelper(stringArray[0], stringArray[1], new FileInputStream(stringArray[2]));
            String string = stringArray[3];
            String string2 = stringArray[4];
            String string3 = stringArray[5];
            if (string2.equals("no")) {
                string2 = null;
            }
            if (string3.equals("no")) {
                string3 = null;
            }
            System.out.println("contains returns " + serviceIndexHelper.contains(string, string2, string3, false));
            AttributeList attributeList = null;
            List list = null;
            AttributeList attributeList2 = null;
            HashMap hashMap = new HashMap();
            String string4 = stringArray[3];
            attributeList = serviceIndexHelper.getWebService(string4, false);
            if (attributeList == null) {
                System.out.println("Cannot find the service " + string4);
                return;
            }
            System.out.println("fina service " + string4);
            Attribute attribute = (Attribute)attributeList.get(2);
            System.out.println("\n\ngetWebService return attrbuteList: type=" + attribute.getName() + ", value=" + (String)attribute.getValue() + ", size=" + attributeList.size());
            System.out.println("\n\n ----- test listEndpoints");
            list = serviceIndexHelper.listEndpoints(string4, false);
            for (int i = 0; i < list.size(); ++i) {
                attributeList2 = (AttributeList)list.get(i);
                attribute = (Attribute)attributeList2.get(0);
                System.out.println("endpoint: name=" + attribute.getName() + " value=" + attribute.getValue() + ", sizing=" + attributeList2.size());
            }
            System.out.println("\n\n ----- test listOperations");
            List list2 = serviceIndexHelper.listOperations(string4, stringArray[4], false);
            AttributeList attributeList3 = null;
            if (list2 != null) {
                for (int i = 0; i < list2.size(); ++i) {
                    attributeList3 = (AttributeList)list2.get(i);
                    attribute = (Attribute)attributeList3.get(0);
                    System.out.println("operation: name=" + attribute.getName() + " value=" + attribute.getValue() + ", size=" + attributeList3.size());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void unit_test3(String[] stringArray) {
        try {
            System.out.println("\n\n Start unit test 3 - test listWebServices");
            ServiceIndexHelper serviceIndexHelper = ServiceIndexHelperFactory.createHelper(stringArray[0], stringArray[1], new FileInputStream(stringArray[2]));
            AttributeList attributeList = null;
            Attribute attribute = null;
            List list = serviceIndexHelper.listWebServices(false);
            System.out.println("listWebServices returns " + list);
            for (int i = 0; i < list.size(); ++i) {
                attributeList = (AttributeList)list.get(i);
                System.out.println("\n\n");
                attribute = (Attribute)attributeList.get(0);
                System.out.println("app: name=" + attribute.getName() + " value=" + attribute.getValue());
                attribute = (Attribute)attributeList.get(1);
                System.out.println("module: name=" + attribute.getName() + " value=" + attribute.getValue());
                attribute = (Attribute)attributeList.get(2);
                System.out.println("service: name=" + attribute.getName() + " value=" + attribute.getValue());
                attribute = (Attribute)attributeList.get(4);
                System.out.println("type: name=" + attribute.getName() + " value=" + attribute.getValue());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void unit_test_create_indexfile(String[] stringArray) {
        try {
            System.out.println("\n\n Start unit test create_indexfile");
            ServiceIndexHelper serviceIndexHelper = ServiceIndexHelperFactory.createHelper(null, null, stringArray[2]);
            WebService webService = ServiceIndexHelperFactory.createWebService("{namespaceURI1}service1");
            webService.setType("JAX-WS");
            Endpoint endpoint = ServiceIndexHelperFactory.createEndpoint("endpointA");
            endpoint.addOperation("opA1");
            endpoint.addOperation("opA2");
            Endpoint endpoint2 = ServiceIndexHelperFactory.createEndpoint("endpointB");
            endpoint2.addOperation("opB1");
            webService.addEndpoint(endpoint);
            webService.addEndpoint(endpoint2);
            WebService webService2 = ServiceIndexHelperFactory.createWebService("{namespaceURI2}service2");
            webService2.setType("JAX-WS");
            webService2.setClient(true);
            endpoint = ServiceIndexHelperFactory.createEndpoint("endpointC");
            endpoint.addOperation("opC1");
            webService2.addEndpoint(endpoint);
            serviceIndexHelper.addWebService(webService);
            serviceIndexHelper.addWebService(webService2);
            serviceIndexHelper.saveData(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

