/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.webservices.admin.deploy.ServiceIndexDataBuilder;
import com.ibm.ws.webservices.admin.serviceindex.impl.ServiceIndexReader;
import com.ibm.ws.webservices.admin.serviceindex.impl.ServiceIndexWriter;
import com.ibm.ws.webservices.admin.serviceindex.impl.WebServiceBean;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

class ServiceIndexServerTaskImpl {
    private static TraceComponent tc = Tr.register(ServiceIndexServerTaskImpl.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private static final String FFDC_ID_1 = "FFDC-1";
    protected String SOURCE_FILE = this.getClass().getName();
    private ResourceBundle _resourceBundle = null;
    private RepositoryContext _deployContext = null;
    private int _operation = 0;
    private Map _existingIndex = new Hashtable();

    ServiceIndexServerTaskImpl() {
    }

    ResourceBundle getResourceBundle() {
        return this._resourceBundle;
    }

    void setResourceBundle(ResourceBundle resourceBundle) {
        this._resourceBundle = resourceBundle;
    }

    void setDeployContext(RepositoryContext repositoryContext) {
        this._deployContext = repositoryContext;
    }

    void setOperation(int n) {
        this._operation = n;
    }

    void setExistingIndex(Map map) {
        this._existingIndex = map == null ? new Hashtable() : map;
    }

    void listWebServices(EARFile eARFile) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServiceIndexServerTaskImpl.listWebServices(EARFile)");
        }
        List list = eARFile.getModuleFiles();
        for (ModuleFile moduleFile : list) {
            this.listWebServices(moduleFile);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ServiceIndexServerTaskImpl.listWebServices(EARFile)");
        }
    }

    private String getMetaDirectory(ModuleFile moduleFile) {
        return moduleFile.isWARFile() ? "WEB-INF" : "META-INF";
    }

    void listWebServices(ModuleFile moduleFile) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServiceIndexServerTaskImpl.listWebServices(ModuleFile)");
        }
        String string = moduleFile.getName() + File.separator + this.getMetaDirectory(moduleFile) + File.separator + "servicesIndex.xml";
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        this.getExistingIndexes(moduleFile.getName(), string, hashMap, hashMap2);
        this.removeAllJAXWS(hashMap, hashMap2);
        ServiceIndexDataBuilder.getWSData(moduleFile, hashMap, hashMap2);
        if (!hashMap.isEmpty() || !hashMap2.isEmpty()) {
            OutputStream outputStream = this._deployContext.getOutputStream(string);
            ServiceIndexWriter.write(outputStream, hashMap, hashMap2);
            outputStream.close();
            this._deployContext.notifyChanged(this._operation, string);
        } else {
            this._deployContext.delete(string);
            this._deployContext.notifyChanged(2, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ServiceIndexServerTaskImpl.listWebServices(ModuleFile)");
        }
    }

    private void getExistingIndexes(String string, String string2, Map map, Map map2) {
        try {
            InputStream inputStream = this._deployContext.getInputStream(string2);
            if (inputStream != null) {
                ServiceIndexReader serviceIndexReader = new ServiceIndexReader(inputStream);
                Map[] mapArray = serviceIndexReader.read(true);
                inputStream.close();
                if (mapArray != null && mapArray[0] != null) {
                    map.putAll(mapArray[0]);
                }
                if (mapArray != null && mapArray[1] != null) {
                    map2.putAll(mapArray[1]);
                }
            } else {
                Map[] mapArray = (Map[])this._existingIndex.get(string);
                if (mapArray != null && mapArray[0] != null) {
                    map.putAll(mapArray[0]);
                }
                if (mapArray != null && mapArray[1] != null) {
                    map2.putAll(mapArray[1]);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, this.SOURCE_FILE + ".getExistingIndexes", FFDC_ID_1);
        }
    }

    private void removeAllJAXWS(Map map, Map map2) {
        WebServiceBean webServiceBean;
        String string;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            webServiceBean = (WebServiceBean)map.get(string);
            if (!"JAX-WS".equals(webServiceBean.getType())) continue;
            iterator.remove();
        }
        iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            webServiceBean = (WebServiceBean)map2.get(string);
            if (!"JAX-WS".equals(webServiceBean.getType())) continue;
            iterator.remove();
        }
    }
}

