/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.EditSchedulerImpl;
import com.ibm.ws.management.application.UpdateSchedulerImpl;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.webservices.admin.deploy.ServiceIndexServerTaskImpl;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;

public class ServiceIndexServerTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(ServiceIndexServerTask.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private EARFile _localear = null;

    private EARFile getEar() throws Exception {
        if (this._localear != null) {
            return this._localear;
        }
        EARFile eARFile = null;
        if (this.scheduler instanceof InstallScheduler) {
            eARFile = ((InstallScheduler)this.scheduler).getEarFile(false, true);
            EList eList = eARFile.getModuleRefs();
            boolean bl = false;
            for (int i = 0; i < eList.size(); ++i) {
                ModuleRef moduleRef = (ModuleRef)eList.get(i);
                if (!moduleRef.isConnector()) continue;
                bl = true;
                break;
            }
            if (bl) {
                eARFile = ((InstallScheduler)this.scheduler).getEarFile(true, true);
                eList = eARFile.getModuleRefs();
            }
        } else if (this.scheduler instanceof UpdateScheduler) {
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig((String)this.scheduler.getAppName(), (WorkSpace)this.scheduler.getWorkSpace(), (Hashtable)this.scheduler.getProperties());
            if (!ConfigRepoHelper.getAppDeploymentForApp((RepositoryContext)repositoryContext).isZeroBinaryCopy() && !ConfigRepoHelper.getAppDeploymentForApp((RepositoryContext)repositoryContext).isZeroEarCopy()) {
                this._localear = ConfigRepoHelper.getEarFileFromBinaries((RepositoryContext)repositoryContext, (WorkSpace)this.scheduler.getWorkSpace(), (ResourceBundle)this.getResourceBundle(), (boolean)true);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "zero bin copy so get ear from source");
                }
                this._localear = (EARFile)((UpdateSchedulerImpl)this.scheduler).getContentAsArchive(false, true);
            }
            eARFile = this._localear;
        } else if (this.scheduler instanceof EditSchedulerImpl) {
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig((String)this.scheduler.getAppName(), (WorkSpace)this.scheduler.getWorkSpace(), (Hashtable)this.scheduler.getProperties());
            eARFile = this._localear = ConfigRepoHelper.getEarFileFromDeployment((WorkSpace)this.scheduler.getWorkSpace(), (RepositoryContext)repositoryContext);
        }
        return eARFile;
    }

    private void closeEar(EARFile eARFile) throws Exception {
        if (this.scheduler instanceof UpdateScheduler) {
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig((String)this.scheduler.getAppName(), (WorkSpace)this.scheduler.getWorkSpace(), (Hashtable)this.scheduler.getProperties());
            if (!ConfigRepoHelper.getAppDeploymentForApp((RepositoryContext)repositoryContext).isZeroBinaryCopy() && !ConfigRepoHelper.getAppDeploymentForApp((RepositoryContext)repositoryContext).isZeroEarCopy()) {
                eARFile.close();
            }
        } else if (this.scheduler instanceof EditSchedulerImpl) {
            eARFile.close();
        }
    }

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServiceIndexServerTask.performTask()");
        }
        try {
            Object object;
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig((String)this.scheduler.getAppName(), (WorkSpace)this.scheduler.getWorkSpace(), (Hashtable)this.scheduler.getProperties());
            ServiceIndexServerTaskImpl serviceIndexServerTaskImpl = new ServiceIndexServerTaskImpl();
            serviceIndexServerTaskImpl.setResourceBundle(this.getResourceBundle());
            serviceIndexServerTaskImpl.setDeployContext(repositoryContext);
            serviceIndexServerTaskImpl.setOperation(this.scheduler instanceof InstallScheduler ? 0 : 1);
            serviceIndexServerTaskImpl.setExistingIndex((Map)this.scheduler.getProperties().get("ServiceIndexTask.ServiceIndexMap"));
            if (this.scheduler instanceof InstallScheduler) {
                serviceIndexServerTaskImpl.listWebServices(((InstallScheduler)this.scheduler).getEarFile(true, true));
            } else if (this.scheduler instanceof UpdateScheduler) {
                object = (UpdateScheduler)this.scheduler;
                if (("add".equals(object.getOperation()) || "update".equals(object.getOperation())) && object.getContentType().equals("modulefile")) {
                    ModuleFile moduleFile = (ModuleFile)object.getContentAsArchive(true, true);
                    serviceIndexServerTaskImpl.listWebServices(moduleFile);
                } else if (!"delete".equals(object.getOperation())) {
                    EARFile eARFile = this.getEar();
                    if (eARFile != null) {
                        eARFile.getOptions().setUseJavaReflection(true);
                        serviceIndexServerTaskImpl.listWebServices(eARFile);
                        this.closeEar(eARFile);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ServiceIndexServerTask was unable to obtain EARFile for update of application, " + this.scheduler.getAppName() + ", perhaps due to using zeroEarCopy or zeroBinaryCopy options during the install");
                    }
                }
            }
            object = this.createNotification("Completed", "ADMA5005I", new String[]{this.scheduler.getAppName()});
            this.scheduler.propagateTaskEvent((AppNotification)object);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask");
            }
            return true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.webservices.admin.deploy.ServiceIndexServerTask.performTask", "309", (Object)this);
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), throwable.toString()}));
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, AppUtils.getMessage((ResourceBundle)this.getResourceBundle(), (String)"ADMA0066E"));
        }
    }
}

